unit Utriplefilt; {unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  GlOBALS, Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TFtriplefilt }

    TFtriplefilt = class(TForm)
    BtnRETURN: TButton;
    BtnCONTINUE: TButton;
    Edtlambda: TEdit;
    EdtLs60: TEdit;
    EdtLs90: TEdit;
    EdtLs120: TEdit;
    EdtLs150: TEdit;
    EdtLs180: TEdit;
    EdtUq90: TEdit;
    EdtUq180: TEdit;
    EdtLq90: TEdit;
    EdtLq180: TEdit;
    Edtrho: TEdit;
    EdtUs30: TEdit;
    EdtUs60: TEdit;
    EdtUs90: TEdit;
    EdtUs120: TEdit;
    EdtUs150: TEdit;
    EdtUs180: TEdit;
    EdtLs30: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Lbldegrees: TLabel;
    StaticText1: TStaticText;
    procedure BtnCONTINUEClick(Sender: TObject);
    procedure BtnRETURNClick(Sender: TObject);
    procedure EdtlambdaChange(Sender: TObject);
    procedure EdtlambdaKeyPress(Sender: TObject; var Key: char);
    procedure EdtLq180Change(Sender: TObject);
    procedure EdtLq180KeyPress(Sender: TObject; var Key: char);
    procedure EdtLq90Change(Sender: TObject);
    procedure EdtLq90KeyPress(Sender: TObject; var Key: char);
    procedure EdtLs120Change(Sender: TObject);
    procedure EdtLs120KeyPress(Sender: TObject; var Key: char);
    procedure EdtLs150Change(Sender: TObject);
    procedure EdtLs150KeyPress(Sender: TObject; var Key: char);
    procedure EdtLs180Change(Sender: TObject);
    procedure EdtLs180KeyPress(Sender: TObject; var Key: char);
    procedure EdtLs30Change(Sender: TObject);
    procedure EdtLs30KeyPress(Sender: TObject; var Key: char);
    procedure EdtLs60Change(Sender: TObject);
    procedure EdtLs60KeyPress(Sender: TObject; var Key: char);
    procedure EdtLs90Change(Sender: TObject);
    procedure EdtLs90KeyPress(Sender: TObject; var Key: char);
    procedure EdtrhoChange(Sender: TObject);
    procedure EdtrhoKeyPress(Sender: TObject; var Key: char);
    procedure EdtUq180Change(Sender: TObject);
    procedure EdtUq180KeyPress(Sender: TObject; var Key: char);
    procedure EdtUq90Change(Sender: TObject);
    procedure EdtUq90KeyPress(Sender: TObject; var Key: char);
    procedure EdtUs120Change(Sender: TObject);
    procedure EdtUs120KeyPress(Sender: TObject; var Key: char);
    procedure EdtUs150Change(Sender: TObject);
    procedure EdtUs150KeyPress(Sender: TObject; var Key: char);
    procedure EdtUs180Change(Sender: TObject);
    procedure EdtUs180KeyPress(Sender: TObject; var Key: char);
    procedure EdtUs30Change(Sender: TObject);
    procedure EdtUs30KeyPress(Sender: TObject; var Key: char);
    procedure EdtUs60Change(Sender: TObject);
    procedure EdtUs60KeyPress(Sender: TObject; var Key: char);
    procedure EdtUs90Change(Sender: TObject);
    procedure EdtUs90KeyPress(Sender: TObject; var Key: char);
    procedure FormActivate(Sender: TObject);
   private

  public

  end;

function InRange (x, a, b: real): boolean;

procedure CheckTheParameters(var filterSpec: filterRecord;
                          var  zetaSub, zetaSup: vector;
                          var proceed: boolean);

procedure FillTheBoxes(zetaSub, zetaSup: vector);

var
  Ftriplefilt: TFtriplefilt;
  {zetaSub, zetaSup: vector;}  {These variables should be global}
  proceed: boolean;

implementation

uses
  UTILS, RESPONSE, DATASEG, TIMEFILT, LEGENDS, Uplotscreen;

{$R *.lfm}

{ TFtriplefilt }

{______________________________________________________________________________}

procedure TFtriplefilt.FormActivate(Sender: TObject);

var
  i: integer;

begin

  filterSpec.seasonality:= dataBox.dataFrequency;
  filterSpec.rho := StrToFloat(Edtrho.text);
  filterSpec.lambda := StrToFloat(Edtlambda.text);

  if (dataBox.dataFrequency = Monthly) or (filterSpec.seasonality = Monthly) then
    begin
     {ShowMessage('We are disabling the Quarterly boxes'); }
      EdtUq90.Enabled := false;
      EdtUq90.text := '';
      EdtLq90.Enabled := false;
      EdtLq90.text := '';

      EdtUq180.Enabled := false;
      EdtUq180.text := '';
      EdtLq180.Enabled := false;
      EdtLq180.text := '';

      for i := 1 to 6 do
        begin
          zetaSub[i] := -3.0;
          zetaSup[i] := 3.0;
        end;
    end;

if (dataBox.dataFrequency = Quarterly) or (filterSpec.seasonality = Quarterly) then
  begin
    {ShowMessage('We are disabling the Monthly boxes');}
    EdtUs30.Enabled := false;
    EdtUs30.text := '';
    EdtLs30.Enabled := false;
    EdtLs30.text := '';

    EdtUs60.Enabled := false;
    EdtUs60.text := '';
    EdtLs60.Enabled := false;
    EdtLs60.text := '';

    EdtUs90.Enabled := false;
    EdtUs90.text := '';
    EdtLs90.Enabled := false;
    EdtLs90.text := '';

    EdtUs120.Enabled := false;
    EdtUs120.text := '';
    EdtLs120.Enabled := false;
    EdtLs120.text := '';

    EdtUs150.Enabled := false;
    EdtUs150.text := '';
    EdtLs150.Enabled := false;
    EdtLs150.text := '';

    EdtUs180.Enabled := false;
    EdtUs180.text := '';
    EdtLs180.Enabled := false;
    EdtLs180.text := '';

    for i := 1 to 2 do
      begin
        zetaSub[i] := 3.0;
        zetaSup[i] := 3.0;
      end;

  end;

  if (dataBox.dataFrequency = Monthly) or (filterSpec.seasonality = Monthly) then
    begin  {if}
      EdtLs30.text := '3.0';
      EdtUs30.text := '3.0';

      EdtLs60.text := '3.0';
      EdtUs60.text := '3.0';

      EdtLs90.text := '3.0';
      EdtUs90.text := '3.0';

      EdtLs120.text := '3.0';
      EdtUs120.text := '3.0';

      EdtLs150.text := '3.0';
      EdtUs150.text := '3.0';

      EdtLs180.text := '3.0';
      EdtUs180.text := '3.0';
    end;

  if (dataBox.dataFrequency = Quarterly) or (filterSpec.seasonality = Quarterly) then
    begin {if};
       EdtUq90.text := '3.0';
       EdtLq90.text := '3.0';

       EdtUq180.text := '3.0';
       EdtLq180.text := '3.0';
    end; {if}

end;  {FormActivate}
{______________________________________________________________________________}

procedure FillTheBoxes(zetaSub, zetaSup: vector);

{THIS IS REDUNDANT: The boxes are file on activating the form}

var
  i, s: integer;

begin

  if (dataBox.dataFrequency = Monthly) or (filterSpec.seasonality = Monthly) then
      s := 6;
   if (dataBox.dataFrequency = Quarterly) or (filterSpec.seasonality = Quarterly) then
       s := 2;

    for i := 1 to s do
      begin
       zetaSub[i] := 3.0;
       zetaSup[i] := 3.0;
      end;

end;  {FillTheBoxes}

{______________________________________________________________________________}

function InRange (x, a, b: real): boolean;
  begin
    InRange := false;
    if (x >= a) and (x <= b) then
      InRange := true;
  end; {InRange}

{______________________________________________________________________________}

procedure CheckTheParameters(var filterSpec: filterRecord;
                          var  zetaSub, zetaSup: vector;
                          var proceed: boolean);
var
  i, s: integer;

begin
  proceed := true;

  if (dataBox.dataFrequency = Quarterly) or (filterSpec.seasonality = Quarterly) then
    s := 2;
   if (dataBox.dataFrequency = Monthly) or (filterSpec.seasonality = Monthly) then
   s := 6;
   for i:= 1 to s  do
     begin
       if not InRange(zetaSup[i], 0.0, 7.0) then
         proceed := false;
       if  not InRange(Abs(zetaSub[i]), 0.0, 7.0) then
         proceed := false;
     end;

   if proceed = false   then
     ShowMessage('The maximum offset is 7 degrees. Check all values.');

   if not InRange(filterSpec.rho, 0.0, 1.0) then
     begin
       ShowMessage('The pole parameter must be in the interval (0.0, 1.0)');
       proceed := false;
     end;

   if not InRange(filterSpec.lambda, 0.0, 1.0) then
       begin
         ShowMessage('The smoothing parameter must be in the interval (0.0, 1.0)');
         proceed := false;
       end;

end;  {CheckTheParameters}

{______________________________________________________________________________}

procedure TFtriplefilt.EdtrhoKeyPress(Sender: TObject; var Key: char);
begin
   if not (key in [#0, '0'..'9', '.',#8])then
     begin
       ShowMessage('Enter an real value in (0.0, 1.0)');
       key := #0;
    end;
end;  {EdtrhoKeyPress}

{______________________________________________________________________________}

procedure TFtriplefilt.EdtlambdaKeyPress(Sender: TObject; var Key: char);
begin
   if not (key in [#0, '0'..'9', '.',#8])then
     begin
       ShowMessage('Enter an real value in (0.0, 1.0)');
       key := #0;
    end;
end;   {EdtlambdaKeyPress}

{______________________________________________________________________________}

procedure TFtriplefilt.EdtrhoChange(Sender: TObject);
begin
   if (Edtrho.text <> '')then
    filterSpec.rho :=  StrToFloat(Edtrho.text);
end;  {EdtrhoChange}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtlambdaChange(Sender: TObject);
begin
   if (Edtlambda.text <> '')then
    filterSpec.lambda :=  StrToFloat(Edtlambda.text);
end;  {EdtlambdaChange}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUs30KeyPress(Sender: TObject; var Key: char);
begin
 if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;   {EdtUs30KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLs30KeyPress(Sender: TObject; var Key: char);
begin
 if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;   {EdtLs30KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUs60KeyPress(Sender: TObject; var Key: char);
begin
 if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtUs60KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLs60KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLs60KeyPress}

{______________________________________________________________________________}

procedure TFtriplefilt.EdtUs90KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
 begin
   ShowMessage('Enter integer values only');
   key := #0;
 end;
end;   {EdtUs90KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLs90KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
 begin
   ShowMessage('Enter integer values only');
   key := #0;
 end;
end;  {EdtLs90KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUs120KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
   ShowMessage('Enter integer values only');
   key := #0;
  end;
end;  {EdtUs120KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLs120KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
   ShowMessage('Enter integer values only');
   key := #0;
  end;
end;   {EdtLs120KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUs150KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
   ShowMessage('Enter integer values only');
   key := #0;
  end;
end;  {EdtUs150KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLs150KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
   ShowMessage('Enter integer values only');
   key := #0;
  end;
end;  {EdtLs150KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUs180KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
   ShowMessage('Enter integer values only');
    key := #0;
 end;
end;  {EdtUs180KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLs180KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
 begin
   ShowMessage('Enter integer values only');
   key := #0;
 end;
end;   {EdtLs180KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUq90KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
   begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtUq90KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLq90KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
 begin
   ShowMessage('Enter integer values only');
   key := #0;
 end;
end; {EdtLq90KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUq180KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
   begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtUq180KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLq180KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
   ShowMessage('Enter integer values only');
   key := #0;
  end;
end; {EdtLq180KeyPress}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUs30Change(Sender: TObject);
begin
  if EdtUs30.Enabled and (EdtUs30.text <> '')then
   zetaSup[1] :=  StrToFloat(EdtUs30.text);

end; {EdtUs30Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLs30Change(Sender: TObject);
begin
  if EdtLs30.Enabled and (EdtLs30.text <> '')then
    zetaSub[1] :=  - StrToFloat(EdtLs30.text);
end;  {EdtLs30Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUs60Change(Sender: TObject);
begin
  if EdtUs60.Enabled and (EdtUs60.text <> '')then
    zetaSup[2] :=  StrToFloat(EdtUs60.text);

end;  {EdtUs60Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLs60Change(Sender: TObject);
begin
  if EdtLs60.Enabled and (EdtLs60.text <> '')then
    zetaSub[2] := - StrToFloat(EdtLs60.text);

end;   {EdtLs60Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUs90Change(Sender: TObject);
begin
  if EdtUs90.Enabled and (EdtUs90.text <> '')then
    zetaSup[3] :=  StrToFloat(EdtUs90.text);

end;  {EdtUs90Change}
 {______________________________________________________________________________}

procedure TFtriplefilt.EdtLs90Change(Sender: TObject);
begin
  if EdtLs90.Enabled and (EdtLs90.text <> '')then
    zetaSub[3] := - StrToFloat(EdtLs90.text);

end; {EdtLs90Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUs120Change(Sender: TObject);
begin
  if EdtUs120.Enabled and (EdtUs120.text <> '')then
    zetaSup[4] :=  StrToFloat(EdtUs120.text);

end;  {EdtUs120Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLs120Change(Sender: TObject);
begin
   if EdtLs120.Enabled and (EdtLs120.text <> '')then
    zetaSub[4] := - StrToFloat(EdtLs120.text);

end;  {EdtLs120Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUs150Change(Sender: TObject);
begin
   if EdtUs150.Enabled and (EdtUs150.text <> '')then
     zetaSup[5] :=  StrToFloat(EdtUs150.text);

end; {EdtUs150Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLs150Change(Sender: TObject);
begin
   if EdtLs150.Enabled and (EdtLs150.text <> '')then
     zetaSub[5] := - StrToFloat(EdtLs150.text);

end;  {EdtLs150Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUs180Change(Sender: TObject);
begin
   if EdtUs180.Enabled and (EdtUs180.text <> '')then
     zetaSup[6] :=  StrToFloat(EdtUs180.text);

end; {EdtUs180Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLs180Change(Sender: TObject);
begin
   if EdtLs180.Enabled and (EdtLs180.text <> '')then
     zetaSub[6] := - StrToFloat(EdtLs180.text);

end; {EdtLs180Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUq90Change(Sender: TObject);
begin
  if EdtUq90.Enabled and (EdtUq90.text <> '')then
    zetaSup[1] :=  StrToFloat(EdtUq90.text);

end;  {EdtUq90Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLq90Change(Sender: TObject);
begin
  if EdtLq90.Enabled and (EdtLq90.text <> '')then
    zetaSub[1] :=  - StrToFloat(EdtLq90.text);

  {SHOWMESSAGE(' EdLq90Change  --> zetaSub[1] = '  + FloatToStr(zetaSub[1]));}

end;  {EdtLq90Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtUq180Change(Sender: TObject);
begin
  if EdtUq180.Enabled and (EdtUq180.text <> '')then
    zetaSup[2] :=  StrToFloat(EdtUq180.text);

end;  {EdtUq180Change}
{______________________________________________________________________________}

procedure TFtriplefilt.EdtLq180Change(Sender: TObject);
begin
  if EdtLq180.Enabled and (EdtLq180.text <> '')then
    zetaSub[2] := - StrToFloat(EdtLq180.text);
end;  {EdtLq180Change}
{______________________________________________________________________________}

procedure TFtriplefilt.BtnCONTINUEClick(Sender: TObject);

var
  s, Tcap: integer;
  alpha, beta: fourierVec;

begin
  filterSpec.seasonality := dataBox.dataFrequency;
  filterSpec.filterType := tripleFilter;
  s :=filterSpec.seasonality;
  Tcap := dataBOX.NOPUNCT;


  CheckTheParameters(filterSpec, zetaSub, zetaSup, proceed);

  {SHOWMESSAGE(' zetaSub[1] = ' + FloatToStr(zetaSub[1]));}

  if proceed  then
    begin
     TripleFilterSpec (filterSpec, rhoVec, sigmaVec, sigmaVec1, sigmaVec2, phi, theta, phi1, theta1, phi2, theta2);
     GetFilterGainVector(filterSpec, SCREENBOX, spectraVec, spectraBOX, phi, theta, phi1, theta1, phi2, theta2);
      residueBOX.NOPUNCT := dataBOX.NOPUNCT;
      SlowFourier (residueBOX, residueVec, alpha, beta);
      MakeThePeriodogram (residueBOX, plotBOX, plotVector, alpha, beta);
      legend := TripleFilterGain (filterSpec);
      graphType :=  backgroundPlot;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);

      seasonVec := residueVec;
      adjustedVec := residueVec;
      ApplyTripleSeasonalFilter (s, Tcap, phi, phi1, phi2, sigmaVec, sigmaVec1, sigmaVec2, seasonVec, adjustedVec);
      seasonBOX.NOPUNCT := dataBOX.NOPUNCT;
      MakeDataBox (seasonBOX, seasonVec);
      {+++++++++++++++++++++++++++++++++++++++++}
      legend := SeasonalComponent (dataBOX,dataName);
      plotVector := seasonVec;
      plotBOX := seasonBOX;
      graphType  :=  dataGraph;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
      weHaveSeasonalComponent := true;
      {+++++++++++++++++++++++++++++++++++++++++}
      SubtractComponent (dataBOX, adjustedBOX, dataVector, seasonVec, adjustedVec);
      legend := DeSeasonalisedOverlay (dataBOX, dataName);
      graphType := seasonsGraph;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
      weHaveSeasonallyAdjustedData := true;
    end;  {proceed}

end;  {BtnCONTINUEClick}

{______________________________________________________________________________}

procedure TFtriplefilt.BtnRETURNClick(Sender: TObject);
begin
  Close;
end;  {BtnRETURNClick}
{______________________________________________________________________________}


end. {Utriplefilt: Unit of SEASCAPE.PAS}

