unit Uvarismoooth;  {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  GLOBALS, Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Menus;

type

  { TFvarismoooth }

  TFvarismoooth = class(TForm)
    BtnCLOSE: TButton;
    EdtFirstL: TEdit;
    EdtThirdC: TEdit;
    EdtReguLamb: TEdit;
    EdtThirdLamb: TEdit;
    EdtFirstC: TEdit;
    EdtFirstLamb: TEdit;
    EdtSecondL: TEdit;
    EdtSecondC: TEdit;
    EdtSecondLamb: TEdit;
    EdtThirdL: TEdit;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    ListBox: TListBox;
    RadioBtnTriang: TRadioButton;
    RadioBtnSquare: TRadioButton;
    RadioBtnBell: TRadioButton;
    StaticText1: TStaticText;
    procedure BtnCLOSEClick(Sender: TObject);
    procedure EdtFirstCKeyPress(Sender: TObject; var Key: char);
    procedure EdtFirstLambKeyPress(Sender: TObject; var Key: char);
    procedure EdtFirstLKeyPress(Sender: TObject; var Key: char);
    procedure EdtReguLambChange(Sender: TObject);
    procedure EdtReguLambKeyPress(Sender: TObject; var Key: char);
    procedure EdtSecondCKeyPress(Sender: TObject; var Key: char);
    procedure EdtSecondLambKeyPress(Sender: TObject; var Key: char);
    procedure EdtSecondLChange(Sender: TObject);
    procedure EdtFirstCChange(Sender: TObject);
    procedure EdtFirstLambChange(Sender: TObject);
    procedure EdtFirstLChange(Sender: TObject);
    procedure EdtSecondCChange(Sender: TObject);
    procedure EdtSecondLambChange(Sender: TObject);
    procedure EdtSecondLKeyPress(Sender: TObject; var Key: char);
    procedure EdtThirdCChange(Sender: TObject);
    procedure EdtThirdCKeyPress(Sender: TObject; var Key: char);
    procedure EdtThirdLambChange(Sender: TObject);
    procedure EdtThirdLambKeyPress(Sender: TObject; var Key: char);
    procedure EdtThirdLChange(Sender: TObject);
    procedure EdtThirdLKeyPress(Sender: TObject; var Key: char);
    procedure FormActivate(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
    procedure RadioBtnTriangChange(Sender: TObject);
    procedure RadioBtnSquareChange(Sender: TObject);
    procedure RadioBtnBellChange(Sender: TObject);
  private

  public

  end;

function InRealRange (var x: real;
                      a, b: real): boolean;

function InIntegerRange (var x: integer;
                      a, b: integer): boolean;

procedure CheckForOverLap(var sBandCentre, sBandWidth: triIntVec);

procedure CheckforViewing(var sBandCentre, sBandWidth: triIntVec);

{var
  smoothLambda: triRealVec;
  proceed: boolean = true;}

   var
   Fvarismoooth: TFvarismoooth;
    lowerBound, upperBound: triIntVec;
    smoothLambda: triRealVec;
    bandLimit: integer;
    proceed: boolean = true;

implementation

uses
  LCLType, UplotScreen, SMOOTHER, {UTILS, DATASEG,} LEGENDS;


{$R *.lfm}

{ TFvarismoooth }

{______________________________________________________________________________}

procedure TFvarismoooth.FormActivate(Sender: TObject);
begin



  EdtFirstC.text := '';
  EdtFirstL.text := '';
  EdtFirstLamb.text := '';

  EdtSecondC.text := '';
  EdtSecondL.text := '';
  EdtSecondLamb.text := '';

  EdtThirdC.text := '';
  EdtThirdL.text := '';
  EdtThirdLamb.text := '';

  EdtReguLamb.text := '';
  EdtReguLamb.text := '';

  FillTheVariCells( sBandCentre, sBandWidth, lowerBound, upperBound,smoothLambda);
  proceed := true;

end;  {FormActivate}


{______________________________________________________________________________}

function InRealRange (var x: real;
                      a, b: real): boolean;
  begin
    InRealRange := false;
    if (x >= a) and (x <= b) then
      InRealRange := true;
  end; {InRealRange}
{______________________________________________________________________________}

function InIntegerRange (var x: integer;
                      a, b: integer): boolean;
  begin
    InIntegerRange := false;
    if (x >= a) and (x <= b) then
      InIntegerRange := true;
  end; {InIntegerRange}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtFirstLKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtFirstLKeyPress}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtFirstCKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtFirstCKeyPress}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtSecondLKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;   {EdtSecondLKeyPress}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtSecondCKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtSecondCKeyPress}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtThirdLKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtThirdLKeyPress}
 {______________________________________________________________________________}

procedure TFvarismoooth.EdtThirdCKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;   {EdtThirdCKeyPress}

{______________________________________________________________________________}

procedure TFvarismoooth.EdtFirstLambKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtFirstLambdaKeyPress}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtSecondLambKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtSecondLambdKeyPress}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtThirdLambKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;   {EdtThirdLambdKeyPress}

{______________________________________________________________________________}

procedure TFvarismoooth.EdtReguLambKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtRegulLambdKeyPress}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtFirstLChange(Sender: TObject);
begin
  if EdtFirstL.Text <> '' then
    begin
       sBandWidth[1] := StrToInt(EdtFirstL.text);
       proceed := true;
    end
  else
     sBandWidth[1] := -10;
end;  {EdtFirstLChange}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtFirstCChange(Sender: TObject);
begin
   if EdtFirstC.Text <> '' then
     begin
      sBandCentre[1] := StrToInt(EdtFirstC.text);
      proceed := true;
     end
   else
     sBandCentre[1] := -10;
end;  {EdtFirstCChange}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtSecondLChange(Sender: TObject);
begin
   if EdtSecondL.Text <> '' then
     begin
      sBandWidth[2] := StrToInt(EdtSecondL.text);
      proceed := true;
     end
   else
     sBandWidth[2] := -10;
 end;  {EdtSecondLChange}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtSecondCChange(Sender: TObject);
begin
   if EdtSecondC.Text <> '' then
     begin
       sBandCentre[2] := StrToInt(EdtSecondC.text);
       proceed := true;
     end
   else
     sBandCentre[2] := -10;
end;  {EdtSecondCChange}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtThirdLChange(Sender: TObject);
begin
   if EdtThirdL.Text <> '' then
     begin
      sBandWidth[3] := StrToInt(EdtThirdL.text);
      proceed := true;
     end
   else
     sBandWidth[3] := -10;
 end;  {EdtThirdLChange}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtThirdCChange(Sender: TObject);
begin
   if EdtThirdC.Text <> '' then
     begin
      sBandCentre[3] := StrToInt(EdtThirdC.text);
      proceed := true;
     end
   else
    sBandCentre[3] := -10;
end;  {EdtThirdCChange}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtFirstLambChange(Sender: TObject);
begin
   if EdtFirstLamb.Text <> '' then
     begin
      smoothLambda[1] := StrToInt(EdtFirstLamb.text);
      proceed := true;
     end
   else
    smoothLambda[1] := -10;
end;  {EdtFirstLambdaChange}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtSecondLambChange(Sender: TObject);
begin
   if EdtSecondLamb.Text <> '' then
     begin
       smoothLambda[2] := StrToInt(EdtSecondLamb.text);
       proceed := true;
     end
   else
    smoothLambda[2] := -10;
end;  {EdtSecondLambdChange}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtThirdLambChange(Sender: TObject);
begin
   if EdtThirdLamb.Text <> '' then
     begin
       smoothLambda[3] := StrToInt(EdtThirdLamb.text);
       proceed := true;
     end
   else
    smoothLambda[3] := -10;
end;  {EdtThirdLambdChange}
{______________________________________________________________________________}

procedure TFvarismoooth.EdtReguLambChange(Sender: TObject);
begin
   if EdtReguLamb.Text <> '' then
     begin
       smoothLambda[0] := StrToInt(EdtReguLamb.text);
       proceed := true;
     end
   else
    smoothLambda[0] := -10;
end;  {EdtRegulLambdChange}
{______________________________________________________________________________}

procedure TFvarismoooth.RadioBtnTriangChange(Sender: TObject);
begin
 sProfile :=  Triangle;
 proceed := true;
end; {RadioBtnTriangChange}
{______________________________________________________________________________}

procedure TFvarismoooth.RadioBtnSquareChange(Sender: TObject);
begin
  sProfile :=  Square;
  proceed := true;
end; {RadioBrnSquareChange}
{______________________________________________________________________________}

procedure TFvarismoooth.RadioBtnBellChange(Sender: TObject);
begin
 sProfile :=  Bell;
 proceed := true;
end; {RadioBtnBellChange}
{______________________________________________________________________________}

procedure CheckForOverLap(var sBandCentre, sBandWidth: triIntVec);

var
  i, j : integer;
  lowerBound, upperBound : triIntVec;
  insert, insert2: string;

begin

  proceed := true;

  for i := 1 to 3 do
    begin {i: Establish bounds}
      if i = 1 then
       insert := 'first ';
      if i = 2 then
       insert := 'second ';
      if i = 3 then
       insert := 'third ';

      if  (sBandCentre[i] >= 0) and (sBandWidth[i] >= 0) then
        begin {if}
          lowerBound[i] := sBandCentre[i] - sBandWidth[i];
          upperBound[i] := sBandCentre[i] + sBandWidth[i];
        if (not InIntegerRange (lowerBound[i], 0,  dataBOX.NOPUNCT)) then
          begin
            ShowMessage('The lower bound of the ' + insert + 'interval falls beyond the limits of the data');
            proceed := false;
          end;
        if  (not InIntegerRange (upperBound[i], 0,  dataBOX.NOPUNCT)) then
          begin
           ShowMessage('The upper bound of the ' + insert + 'interval falls beyond the limits of the data');
             proceed := false;
          end;
        end; {if}
    end; {i}

  for i := 1 to 3 do
    begin
    for j := 1 to 3 do
      begin {j}  {Check for overlapping bands}
        if i = 1 then
          insert := 'first ';
        if i = 2 then
          insert := 'second ';
        if i = 3 then
          insert := 'third ';

        if j = 1 then
          insert2 := 'first ';
        if j = 2 then
          insert2 := 'second ';
        if j = 3 then
          insert2 := 'third ';


        if (i <> j) and  (sbandCentre[i] >= 0) and (sbandCentre[j] >= 0) then
          begin  {1 <> j}
          if (sbandCentre[i] <= sbandCentre[j]) and (upperBound[i] >lowerBound[j]) then
            begin {if}
              ShowMessage(' The ' + insert + 'band overlaps with the ' + insert2 + 'band');
              proceed := false;
            end;  {if}
          end; {i <> j}
        end; {j}
      end; {i}

end;  { CheckForOverLap}

{______________________________________________________________________________}


procedure CheckforViewing(var sBandCentre, sBandWidth: triIntVec);

var
  bandLimit: integer;

begin
   bandLimit := dataBox.NOPUNCT div 4;

  if (sBandWidth[1] > 0) and (not  InIntegerRange (sBandWidth[1], 0, bandLimit)) then
    begin
      ShowMessage('The width of the first band is excessive. It exceeds half the span of the data.');
      proceed := false
    end;

  if (sBandWidth[2] > 0) and (not  InIntegerRange (sBandWidth[2], 0, bandLimit)) then
    begin
      ShowMessage('The width of the second band is excessive. It exceeds half the span of the data.');
      proceed := false
    end;

    if (sBandWidth[3] > 0) and (not  InIntegerRange (sBandWidth[3], 0, bandLimit)) then
      begin
        ShowMessage('The width of the second band is excessive. It exceeds half the span of the data.');
        proceed := false
      end;
 {-----------------------------------------------------------------------------}
    if (sBandCentre[1] > 0) and (not  InIntegerRange (sBandCentre[1], 0, dataBox.NOPUNCT)) then
    begin
      ShowMessage('The centre of the first band is beyond the limit of the data.');
      proceed := false
    end;

  if (sBandCentre[2] > 0) and (not  InIntegerRange (sBandCentre[2], 0, dataBox.NOPUNCT)) then
    begin
       ShowMessage('The centre of the second band is beyond the limit of the data.');
      proceed := false
    end;

    if (sBandCentre[3] > 0) and (not  InIntegerRange (sBandCentre[3], 0, dataBox.NOPUNCT)) then
      begin
        ShowMessage('The centre of the third band is beyond the limit of the data.');
        proceed := false
      end;
  {-----------------------------------------------------------------------------}


end;  {CheckforViewing}

{______________________________________________________________________________}

procedure CheckForFiltering(var sBandCentre, sBandWidth: triIntVec;
                      var smoothLambda: triRealVec;
                      var filterBand: triBooleanVec);
var
  k: integer;
  STR1, STR2, STR3: string;

begin

  if smoothLambda[0] >= 0 then
    filterBand[0] := true
  else
    begin
      filterBand[0] := false;
      ShowMessage('You must select a value for the regular smoothing parameter.');
      proceed := false;
    end;

  {if no other filter bands are defined then, if filterBand[0] := true,}
  {we shall apply a conventional H-P filter}

  for k := 1 to 3 do
    begin
      if (sBandCentre[k] >= 0) and (sBandWidth[k] >= 0) and  (smoothLambda[k] >= 0) then
        filterBand[k] := true
      else
       filterBand[k] := false;
    end;

  if not (sProfile in [Triangle, Square, Bell])  then
    begin
     ShowMessage('You must select a Smoothing Profile');
     proceed := false;
    end;

     for k := 1 to 3 do
      begin
      STR1 := 'The smoothing parameter should be a minimal value. ';
      STR2 := 'Zero is allowable. Do you wish to  proceed with ';

        if (filterBand[1] = true) then
        STR3 := 'the first smoothing break?';
        if (filterBand[2] = true) then
        STR3 := 'the second smoothing break?';
        if (filterBand[3] = true) then
        STR3 := 'the third smoothing break?';

        if (filterBand[k] = true) and (smoothLambda[k] >= 15) then
         if MessageDlg(STR1 + STR2 + STR3, mtConfirmation, [mbYes, mbNo], 0) = mrNo then
          proceed := false;
       end;

  if (dataBOX.dataFrequency = Quarterly) and (filterBand[0] = true)  then
    begin
     STR1 := 'For Quarterly data, the regular smoothing parameter should be no less than 14400. ';
     STR2  := 'Do you wish to proceed?';

     if (filterBand[0] = true) and (smoothLambda[0] < 14400 ) then
       if MessageDlg(STR1 + STR2, mtConfirmation, [mbYes, mbNo], 0) = mrNo then
         proceed := false;
    end;

  if (dataBOX.dataFrequency = Monthly) and (filterBand[0] = true) then
    begin
      STR1 := 'For Monthly data, the regular smoothing parameter should be no less than 1600. ';
      STR2  := 'Do you wish to  proceed?';

      if (filterBand[0] = true) and (smoothLambda[0] < 1600 ) then
        if MessageDlg(STR1 + STR2, mtConfirmation, [mbYes, mbNo], 0) = mrNo then
          proceed := false;
    end;

  if (dataBOX.dataFrequency =  Annual) and (filterBand[0] = true)  then
    begin
      STR1 := 'For Annual data, the regular smoothing parameter should be no less than 100.';
      STR2  := 'Do you wish to  proceed?';

      if (filterBand[0] = true) and (smoothLambda[0] < 1600 ) then
        if MessageDlg(STR1 + STR2, mtConfirmation, [mbYes, mbNo], 0) = mrNo then
          proceed := false;
    end;


end; {CheckForFiltering}

{______________________________________________________________________________}

procedure TFvarismoooth.ListBoxClick(Sender: TObject);

var index: integer;

begin
  index := ListBox.ItemIndex;
  doSmoothingBands := true;
  {-----------------------------}
  if index = 0 then
   begin
     CheckforViewing(sBandCentre, sBandWidth);
     CheckForOverLap(sBandCentre, sBandWidth);
     if proceed then
       begin
         legend := DataLegend(dataBOX, dataName);
         graphType := dataGraph;
          plotBOX := dataBOX;
          plotVector := dataVector;
          Fplotscreen :=TFplotScreen.Create(Nil);
          Fplotscreen.ShowModal;
          FreeAndNil(Fplotscreen);
       end;
   end; {ViewData}
  {-----------------------------}
  if index = 2 then
   begin
      CheckforViewing(sBandCentre, sBandWidth);
      CheckForOverLap(sBandCentre, sBandWidth);
      CheckForFiltering(sBandCentre, sBandWidth, smoothLambda, filterBand);
      MakeSmoothVector (smoothLambda, sBandWidth, sBandCentre, dataBOX, trendBOX, residueBOX, dataVector, trendVector, residueVec);
      legend := VariSmoothTrend (dataBOX, dataName);
      graphType := dataOverPlotGraph;
     if proceed then
        begin
        Fplotscreen := TFplotscreen.Create(Nil);
        Fplotscreen.ShowModal;
        FreeAndNil(Fplotscreen);

        doSmoothingBands := false;
        legend := VariSmoothResiduals (dataBOX, dataName);
        graphType := dataGraph;
        plotBOX :=residueBOX;
        plotVector := residueVec;
        Fplotscreen := TFplotscreen.Create(Nil);
        Fplotscreen.ShowModal;
        FreeAndNil(Fplotscreen);
        weHavePolyResiduals := true;
        end;
    end; {ApplyFilter}
  {-----------------------------}
   doSmoothingBands := false;
end;  {ListBoxClick}
{______________________________________________________________________________}

procedure TFvarismoooth.BtnCLOSEClick(Sender: TObject);
begin
 Close;
end;  {BtnCLOSEClick}

{______________________________________________________________________________}

end.   {Uvarismoooth: Unit of SEASCAPE.PAS}

