unit Utimeseafilt;  {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TFtimeseafilt }

  TFtimeseafilt = class(TForm)
    BtnRETURN: TButton;
    BtnCONTINUE: TButton;
    GroupBox: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    RadioBtnOrdinary: TRadioButton;
    RadioBtnSmoothing: TRadioButton;
    RadioBtnTwopass: TRadioButton;
    RadioBtnTriple: TRadioButton;
    StaticText1: TStaticText;
    procedure BtnRETURNClick(Sender: TObject);
    procedure BtnCONTINUEClick(Sender: TObject);
    procedure RadioBtnOrdinaryChange(Sender: TObject);
    procedure RadioBtnSmoothingChange(Sender: TObject);
    procedure RadioBtnTripleChange(Sender: TObject);
    procedure RadioBtnTwopassChange(Sender: TObject);
  private

  public

  end;

var
  Ftimeseafilt: TFtimeseafilt;

implementation

uses
  GLOBALS, Ucentralfilt, Usmoothfilt, Udoublefilter, Utriplefilt;

{$R *.lfm}


{ TFtimeseafilt }

{______________________________________________________________________________}

procedure TFtimeseafilt.RadioBtnOrdinaryChange(Sender: TObject);
begin
  filterSpec.filterType := singleFilter;

end;  {RadioBtnOrdinaryChange}
{______________________________________________________________________________}

procedure TFtimeseafilt.RadioBtnSmoothingChange(Sender: TObject);
begin
  filterSpec.filterType := TaperedFilter;
end;  {RadioBtnSmoothingChange}
{______________________________________________________________________________}

procedure TFtimeseafilt.RadioBtnTripleChange(Sender: TObject);
begin
  filterSpec.filterType := tripleFilter ;
end; {RadioBtnTripleChange}
{______________________________________________________________________________}

procedure TFtimeseafilt.RadioBtnTwopassChange(Sender: TObject);
begin
  filterSpec.filterType := doubleFilter ;
end;   {RadioBtnTwopassChange}
{______________________________________________________________________________}

procedure TFtimeseafilt.BtnRETURNClick(Sender: TObject);
begin
  Close;
end; {BtnRETURNClick}

{______________________________________________________________________________}

procedure TFtimeseafilt.BtnCONTINUEClick(Sender: TObject);
begin

  if filterSpec.filterType = singleFilter then
    begin
      Fcentralfilt := TFcentralfilt.Create(nil);
      Fcentralfilt.ShowModal;
      FreeAndNil(Fcentralfilt);
    end;

  if filterSpec.filterType = TaperedFilter then
    begin
      Fsmoothfilt := TFsmoothfilt.Create(nil);
      Fsmoothfilt.ShowModal;
      FreeAndNil(Fsmoothfilt);
    end;

  if filterSpec.filterType = tripleFilter then
    begin
      Ftriplefilt := TFtriplefilt.Create(nil);
      Ftriplefilt.ShowModal;
      FreeAndNil(Ftriplefilt);
    end;

  if filterSpec.filterType = doubleFilter then
    begin
      Fdoublefilt := TFdoublefilt.Create(nil);
      Fdoublefilt.ShowModal;
      FreeAndNil(Fdoublefilt);
    end;

end;

{______________________________________________________________________________}

end.   {Utimeseafilt: unit of SEASCAPE.PAS}

