unit Usmoothfilt;  {unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  GLOBALS, Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TFsmoothfilt }

  TFsmoothfilt = class(TForm)
    BtnRETURN: TButton;
    BtnCONTINUE: TButton;
    Edtrho: TEdit;
    Edtlambda: TEdit;
    Edtfilterspan: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    RadioButton1: TRadioButton;
    StaticText1: TStaticText;
    StaticText2: TStaticText;
    procedure BtnCONTINUEClick(Sender: TObject);
    procedure BtnRETURNClick(Sender: TObject);
    procedure EdtlambdaChange(Sender: TObject);
    procedure EdtlambdaKeyPress(Sender: TObject; var Key: char);
    procedure EdtfilterspanChange(Sender: TObject);
    procedure EdtfilterspanKeyPress(Sender: TObject; var Key: char);
    procedure EdtrhoChange(Sender: TObject);
    procedure EdtrhoKeyPress(Sender: TObject; var Key: char);
    procedure FormActivate(Sender: TObject);
  private

  public

  end;

function InRange (var x: real;
                      a, b: real): boolean;

procedure CheckFilterParameters(var Edtrho, Edtlambda, Edtfilterspan: TEdit;
                        var filterSpec: filterRecord;
                        var proceed: boolean);


procedure CheckBinomial(var EdtFilterSpan: TEdit;
                        var proceed: boolean);

var
  Fsmoothfilt: TFsmoothfilt;
  proceed: boolean = false;

implementation

uses
  UTILS, RESPONSE, DATASEG, TIMEFILT, LEGENDS, Uplotscreen;

{$R *.lfm}

{ TFsmoothfilt }

{______________________________________________________________________________}

procedure TFsmoothfilt.FormActivate(Sender: TObject);
begin
  filterSpec.rho := StrToFloat(Edtrho.text);
  filterSpec.lambda := StrToFloat(Edtlambda.text);
end;   {FormActivate}
{______________________________________________________________________________}

procedure TFsmoothfilt.EdtrhoKeyPress(Sender: TObject; var Key: char);
begin
   if not (key in [#0, '0'..'9', '.',#8])then
     begin
       ShowMessage('Enter an real value in [0.0, 1.0]');
       key := #0;
       end;
end;  {EdtrhoKeyPress}
{______________________________________________________________________________}

 procedure TFsmoothfilt.EdtlambdaKeyPress(Sender: TObject; var Key: char);
 begin
   if not (key in [#0, '0'..'9', '.',#8])then
    begin
      ShowMessage('Enter an real value in [0.0, 1.0]');
      key := #0;
      end;
 end;  {EdtlambdaKeyPress}
 {______________________________________________________________________________}

 procedure TFsmoothfilt.EdtfilterspanKeyPress(Sender: TObject; var Key: char);
 begin
   if not (key in [#0, '0'..'9', #8])then
    begin
      ShowMessage('Enter an integer value in the interval [3, 23]');
      key := #0;
      end;
 end; {EdtorderKeyPress}
{______________________________________________________________________________}

 procedure TFsmoothfilt.EdtrhoChange(Sender: TObject);
 begin
   if not (Edtrho.text = '') then
    filterSpec.rho := StrToFloat(Edtrho.text);
 end;

 {______________________________________________________________________________}

procedure TFsmoothfilt.EdtlambdaChange(Sender: TObject);
begin
  if not (Edtlambda.text = '') then
    filterSpec.lambda := StrToFloat(Edtlambda.text);

end; {EdtlambdaChange}
{______________________________________________________________________________}

procedure TFsmoothfilt.EdtfilterspanChange(Sender: TObject);
begin
   if not (Edtfilterspan.text = '') then
    filterSpec.filterOrder := StrToInt(Edtfilterspan.text);
end;   {EdtorderChange}
{______________________________________________________________________________}

function InRange (var x: real;
                      a, b: real): boolean;
  begin
    InRange := false;
    if (x >= a) and (x <= b) then
      InRange := true;
  end; {InRange}
{______________________________________________________________________________}

procedure CheckFilterParameters(var Edtrho, Edtlambda, Edtfilterspan: TEdit;
                        var filterSpec: filterRecord;
                        var proceed: boolean);
begin

  if Edtrho.text = '' then
    ShowMessage('You have yet to specify the pole parameter')
  else if Edtlambda.text = '' then
    ShowMessage('You have yet to specify the smoothing parameter')
  else if Edtfilterspan.text = '' then
    ShowMessage('You have yet to specify the offset parameter')

  else if not InRange(filterSpec.rho, 0.0, 1.0) then
    ShowMessage('The pole parameter must lie in the interval (0.0, 1.0)')
  else if not InRange(filterSpec.lambda, 0.0, 1.0) then
    ShowMessage('The smoothing parameter must lie in the interval (0.0, 1.0)')
  else
    proceed := true;

end; {CheckFilterParameters}

{______________________________________________________________________________}

procedure CheckBinomial(var EdtFilterSpan: TEdit;
                        var proceed: boolean);
var
  n: integer;

begin
  proceed := false;

   if EdtFilterSpan.Text = '' then
      ShowMessage('You have yet to specify the filterSpan')
    else
      begin {else}
       n := StrToInt(EdtFilterSpan.Text);
        if (n <= 3) or  (n > 23) then
          ShowMessage('The span of the Binomial filter, which must be an odd number from 3 to 23')
        else
          begin
            n := 2* (n div 2);
            filterSpec.filterOrder := n;
            filterSpec.filterSpan := n + 1;
            proceed := true;
          end;
      end; {else}

     filterSpec.filterOrder :=  filterSpec.filterSpan -1

end; {CheckBinomial}
{______________________________________________________________________________}

procedure TFsmoothfilt.BtnRETURNClick(Sender: TObject);
begin
  Close;
end; {BtnRETURNClick}
{______________________________________________________________________________}

procedure TFsmoothfilt.BtnCONTINUEClick(Sender: TObject);

var
  s, q, Tcap: integer;
  alpha, beta: fourierVec;

begin
  filterSpec.seasonality := dataBox.dataFrequency;
  s :=filterSpec.seasonality;
  Tcap := dataBOX.NOPUNCT;

  CheckFilterParameters(Edtrho, Edtlambda, Edtfilterspan, filterSpec, proceed);
  CheckBinomial(EdtFilterSpan, proceed);

  SmoothingFilterSpec (filterSpec, rhoVec, sigmaVec, phi, theta, theta2, firVec, spectraVec, spectraBOX, SCREENBOX);

  if proceed then
    begin
       CentralFilterVec (filterSpec, rhoVec, sigmaVec, phi, theta);

      {filterSpec.filterType := singleFilter;}
      filterSpec.filterType := TaperFunction;
      GetFilterGainVector (filterSpec, SCREENBOX, spectraVec, spectraBOX, phi, theta, phi1, theta1, phi2, theta2);
      legend := ('The frequency response of the smoothing filter for trend-cycle estimation');
      graphtype := PeriodoGraph;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);

      filterSpec.filterType := TaperedFilter;
      GetFilterGainVector (filterSpec, SCREENBOX, spectraVec, spectraBOX, phi, theta, phi1, theta1, phi2, theta2);

      SlowFourier (residueBOX, residueVec, alpha, beta);
      MakeThePeriodogram (residueBOX, plotBOX, plotVector, alpha, beta);

      legend := ('The frequency response of the tapered filter for trend-cycle estimation');
      graphType :=  backgroundPlot;
      {graphtype := PeriodoGraph;}
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);

      seasonVec := residueVec;
      adjustedVec := residueVec;
      {ApplySingleSeasonalFilter (s, Tcap, phi, sigmaVec, seasonVec, adjustedVec); }
      q := (filterSpec.filterSpan - 1) div 2;
      ApplySmoothingFilter (s, q, Tcap, phi, sigmaVec, firVec, seasonVec, adjustedVec);
      seasonBOX.NOPUNCT := dataBOX.NOPUNCT;
      MakeDataBox (seasonBOX, seasonVec);
      {+++++++++++++++++++++++++++++++++++++++++}
      legend := SmoothCycleOverlay(dataBOX, dataName);
      cycleVec := adjustedVec;
      graphType := cycleGraph;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
      {+++++++++++++++++++++++++++++++++++++++++}
      {legend := SeasonalComponent (dataBOX,dataName);}
      legend := TrendCycleResidue (dataBOX,dataName);
      plotVector := seasonVec;
      plotBOX := seasonBOX;
      graphType  :=  dataGraph;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
      weHaveSeasonalComponent := true;
      {+++++++++++++++++++++++++++++++++++++++++}
      {A inflate the seasonally adjusted residuals}
      SubtractComponent (dataBOX, adjustedBOX, dataVector, seasonVec, adjustedVec);
      legend := TrendAndCycle(dataBOX, dataName);
      graphType := seasonsGraph;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
      weHaveSeasonallyAdjustedData := true;
    end;  {proceed}

  {Now compound the frequenct rsponse functions}

end;  {BtnCONTINUEClick}

{______________________________________________________________________________}

end.  {Usmoothfilt: unit of SEASCAPE.PAS}

