unit Uquadstop; {unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  GLOBALS;

type

  { TFquadstop }

  TFquadstop = class(TForm)
    BtnRETURN: TButton;
    BtnCONTINUE: TButton;
    {--------------}
    EdtUt90: TEdit;
    EdtUt180: TEdit;
    EdtUs90: TEdit;
    EdtUs180: TEdit;
    EdtLs90: TEdit;
    EdtLs180: TEdit;
    EdtLt90: TEdit;
    EdtLt180: TEdit;
    {--------------}
    LblSeasonalFreq: TLabel;
    LblUpperTransition: TLabel;
    Lblupperhalfstop: TLabel;
    Lbllowerhalfstop: TLabel;
    Lblowertransition: TLabel;
    Lblpagetitle: TLabel;
    StaticText1: TStaticText;
    procedure BtnCONTINUEClick(Sender: TObject);
    procedure BtnRETURNClick(Sender: TObject);
    {---------------------------------------------}
    procedure EdtUt180KeyPress(Sender: TObject; var Key: char);
    procedure EdtUt90KeyPress(Sender: TObject; var Key: char);
    procedure EdtUs180KeyPress(Sender: TObject; var Key: char);
    procedure EdtUs90KeyPress(Sender: TObject; var Key: char);
    procedure EdtLs180KeyPress(Sender: TObject; var Key: char);
    procedure EdtLs90KeyPress(Sender: TObject; var Key: char);
    procedure EdtLt180KeyPress(Sender: TObject; var Key: char);
    procedure EdtLt90KeyPress(Sender: TObject; var Key: char);
    {---------------------------------------------}
    procedure EdtUt180Change(Sender: TObject);
    procedure EdtUt90Change(Sender: TObject);
   {procedure EdtUs180Change(Sender: TObject);}
    procedure EdtUs90Change(Sender: TObject);
    procedure EdtLs180Change(Sender: TObject);
    procedure EdtLs90Change(Sender: TObject);
    procedure EdtLt180Change(Sender: TObject);
    procedure EdtLt90Change(Sender: TObject);
    {---------------------------------------------}

    procedure FormActivate(Sender: TObject);
   private

  public

  end;

var
  Fquadstop: TFquadstop;
  alpha, beta: fourierVec;

implementation
  uses
    UTILS, FREQFILT,DATASEG, LEGENDS, uplotscreen;

{$R *.lfm}

{ TFquadstop }

{______________________________________________________________________________}

procedure TFquadstop.FormActivate(Sender: TObject);

begin
     filterSpec.seasonality := Quarterly;   {REDUNDANT}

  if seasChange then
  MakeCleftArray (seaCleft, seaFreq, filterSpec);
  seasChange := false;

  EdtUt180.Enabled := False;
  EdtUs180.Enabled := False;

  EdtUt180.text := '';

  if filterSpec.profile = Notransition then
    begin
      EdtUt90.text := '';
      EdtLt90.text := '';
      EdtLt180.text := '';
      EdtUt90.Enabled := False;
      EdtLt90.Enabled := False;
      EdtLt180.Enabled := False;
     end;

  EdtUs180.Enabled := False;
  EdtUt180.Enabled := False;
  EdtUs180.text := '';
  EdtUt180.text := '';

  EdtLt90.text := IntToStr(seaCleft[1].Lt);
  EdtLs90.text := IntToStr(seaCleft[1].Ls);
  EdtUs90.text := IntToStr(seaCleft[1].Us);
  EdtUt90.text := IntToStr(seaCleft[1].Ut);

  EdtLt180.text := IntToStr(seaCleft[2].Lt);
  EdtLs180.text := IntToStr(seaCleft[2].Ls);

  {if filterSpec.profile = Notransition then
  begin
    EdtUt90.Enabled := False;
    EdtLt90.Enabled := False;
    EdtLt180.Enabled := False;
    EdtUt90.text := '';
    EdtLt90.text := '';
    EdtLt180.text := '';
  end; }

end; {FormActivate}

{______________________________________________________________________________}

procedure TFquadstop.BtnRETURNClick(Sender: TObject);
begin
  Close;
end; {BtnRETURNClick}
{______________________________________________________________________________}

procedure TFquadstop.EdtUt180KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtUt180KeyPress}
{______________________________________________________________________________}

procedure TFquadstop.EdtUt90KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtUt90KeyPress}
{______________________________________________________________________________}

procedure TFquadstop.EdtUs180KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtUs180KeyPress}
{______________________________________________________________________________}

procedure TFquadstop.EdtUs90KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end; {EdtUs90KeyPress}
{______________________________________________________________________________}

procedure TFquadstop.EdtLs180KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLs180KeyPress}
{______________________________________________________________________________}

procedure TFquadstop.EdtLs90KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end; {EdtLs90KeyPress}
{______________________________________________________________________________}

procedure TFquadstop.EdtLt180KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLt180KeyPress}
{______________________________________________________________________________}

procedure TFquadstop.EdtLt90KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLt90KeyPress}
{______________________________________________________________________________}

procedure TFquadstop.EdtUt180Change(Sender: TObject);
begin
  if EdtUt180.Text <> '' then
    begin
      seaCleft[2].Ut := StrToInt(EdtUt180.text);
      seasChange := true;
    end;
end;   {EdtUt180Change}
{______________________________________________________________________________}

procedure TFquadstop.EdtUt90Change(Sender: TObject);
begin
  if  EdtUt90.text <> '' then
    begin
      seaCleft[1].Ut  := StrToInt(EdtUt90.text);
     seasChange := true;
   end;
end; {EdtUt90Change}
{______________________________________________________________________________}

procedure TFquadstop.EdtUs90Change(Sender: TObject);
begin
  if EdtUs90.text <> '' then
    begin
      seaCleft[1].Us  := StrToInt(EdtUs90.text);
      seasChange := true;
    end;
end;  {EdtUs90Change}
{______________________________________________________________________________}

procedure TFquadstop.EdtLs180Change(Sender: TObject);
begin
  if EdtLs180.text <> '' then
    begin
      seaCleft[2].Ls  := StrToInt(EdtLs180.text);
      seasChange := true;
    end;
end;  {EdtLs180Change}
{______________________________________________________________________________}

procedure TFquadstop.EdtLs90Change(Sender: TObject);
begin
  if EdtLs90.text <> '' then
    begin
      seaCleft[1].Ls := StrToInt(EdtLs90.text);
      seasChange := true;
    end;
end; {EdtLs90Change}
{______________________________________________________________________________}

procedure TFquadstop.EdtLt180Change(Sender: TObject);
begin
  if EdtLt180.text <> '' then
    begin
      seaCleft[2].Lt  := StrToInt(EdtLt180.text);
      seasChange := true;
    end;
end; {EdtLt180Change}
{______________________________________________________________________________}

procedure TFquadstop.EdtLt90Change(Sender: TObject);
begin
  if EdtLt90.text <> '' then
    begin
      seaCleft[1].Lt  := StrToInt(EdtLt90.text);
      seasChange := true;
    end;
end;  {EdtLt90Change}
{______________________________________________________________________________}

procedure BandConversions(var seaCleft, seaFreq : cleftArray);

  var j : integer;
    pi, radiansPerDegree, seasHarmonic: real;

begin

    pi := 4.0 * ArcTan(1.0);
    radiansPerDegree := pi / 180.0;

  for j := 1 to 2 do
    begin
      seasHarmonic := 90 * j;
      seaCleft[j].Ma := seasHarmonic - seaCleft[j].Ls - seaCleft[j].Lt;
      seaCleft[j].Mb := seaCleft[j].Ma + seaCleft[j].Lt;
      seaCleft[j].Mc := seaCleft[j].Mb + seaCleft[j].Ls + seaCleft[j].Us;
      seaCleft[j].Md := seaCleft[j].Mc + seaCleft[j].Ut;
      end;

  for j := 1 to 6 do
    begin
      seaFreq[j].Ma := seaCleft[j].Ma * radiansPerDegree;
      seaFreq[j].Mb := seaCleft[j].Mb * radiansPerDegree;
      seaFreq[j].Mc := seaCleft[j].Mc * radiansPerDegree;
      seaFreq[j].Md := seaCleft[j].Md * radiansPerDegree;
    end;

end; {BandConversions}
{______________________________________________________________________________}
{THIS COULD GO into FREQFILTS to serve both Monthly and Quarterly}

procedure TFquadstop.BtnCONTINUEClick(Sender: TObject);

var
  t:integer;

begin

  if seasChange = true then
    BandConversions(seaCleft, seaFreq);

  if filterSpec.profile = noTransition then
    NoTransitionsResponse(seaCleft, filterSpec, spectraBOX, spectraVec, SCREENBOX, POSTBOX);

  if filterSpec.profile = upperHalfCosine then
    UpperCosineResponse(seaCleft, filterSpec, spectraBOX, spectraVec, SCREENBOX, POSTBOX);

  if filterSpec.profile = lowerHalfCosine then
    LowerCosineResponse(seaCleft, filterSpec, spectraBOX, spectraVec, SCREENBOX, POSTBOX);

  if filterSpec.profile = Sigmoid then
    SigmoidResponse(seaCleft, filterSpec, spectraBOX, spectraVec, SCREENBOX, POSTBOX);

  if  doSeasonalAdjustment then
    begin
      SlowFourier (residueBOX, residueVec, alpha, beta);
      MakeThePeriodogram (residueBOX, plotBOX, plotVector, alpha, beta);
    end;

  if  doSeasonalAdjustment = true then
    begin
      legend := PdgramAndResponse (filterSpec);
      graphType :=  backgroundPlot;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
    end
  else
    begin      {THIS IS NOW INACTIVE}
     legend := SeasFreqFiltGain(filterSpec);
     graphType := spectraGraph;
      plotBOX := spectraBOX;
      plotVector := spectraVec;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
    end;

     if  (doSeasonalAdjustment = true) then
       begin {Seasonal Component}
         ScaleTheFourierOrdinates (filterSpec, residueBOX, alpha, beta);  {in FREQFILTS}
         FourierSynthesis(residueBOX, adjustedVec, alpha, beta);   {inDATASEG}
         for t := 0 to residueBOX.NOPUNCT-1 do
           seasonVec[t] := residueVec[t] - adjustedVec[t];
         seasonBOX := residueBOX;
         MakeDataBox(seasonBOX, seasonVec);
         {+++++++++++++++++++++++++++++++++++++++++}
         legend := SeasonalComponent (dataBOX,dataName);
         plotVector := seasonVec;
         plotBOX := seasonBOX;
         graphType  :=  dataGraph;
         Fplotscreen := TFplotscreen.Create(Nil);
         Fplotscreen.ShowModal;
         FreeAndNil(Fplotscreen);
         {Seasonal Component}
         weHaveSeasonalComponent := true;
         {+++++++++++++++++++++++++++++++++++++++++}
         SubtractComponent (dataBOX, adjustedBOX, dataVector, seasonVec, adjustedVec);
         if weHavePolyResiduals or weHaveTrendCycleResiduals then
           begin {Seasonally Adjusted Data: Twofold and Threefold Decomposition}
             legend := DeSeasonalisedOverlay (dataBOX, dataName);
             graphType := seasonsGraph;
             Fplotscreen := TFplotscreen.Create(Nil);
             Fplotscreen.ShowModal;
             FreeAndNil(Fplotscreen);
             weHaveSeasonallyAdjustedData := true;
           end;  {Seasonally Adjusted Data: Twofold and Threefold Decomposition}
           {+++++++++++++++++++++++++++++++++++++++++}

         if weHaveATrendCycle then
           begin  {ThreefoldDecomposition}
             {legend := TrendAndCycle (dataBOX, dataName);}
             legend := TrendCycleInThree;
             graphType :=  dataOverPlotGraph;
             Fplotscreen := TFplotscreen.Create(Nil);
             Fplotscreen.ShowModal;
             FreeAndNil(Fplotscreen);
             {----------------------}
             {legend := AdjustedTrendResiduals;}
             legend := ResidualsInThree;
             graphType := dataGraph;
             plotBOX := dataBOX;
             SubtractComponent (dataBOX, plotBOX, adjustedVec, trendVector, plotVector);
             Fplotscreen :=TFplotScreen.Create(Nil);
             Fplotscreen.ShowModal;
             FreeAndNil(Fplotscreen);
           end; {ThreefoldDecomposition}
       end;

  end; {BtnPROCEEDClick}
{______________________________________________________________________________}

end. {Uquadstop: unit of SEASCAPE.PAS}

