unit Ugetdata; {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  GLOBALS;

type

  { TFgetdata }

  TFgetdata = class(TForm)
    BtnRETURN: TButton;
    Label1: TLabel;
    ListData: TListBox;
    OpenDialog: TOpenDialog;
    StaticText: TStaticText;
    procedure BtnRETURNClick(Sender: TObject);
    procedure ListDataClick(Sender: TObject);
  private

  public

  end;

var
  Fgetdata: TFgetdata;
  alpha, beta: fourierVec;

implementation
  uses
    LCLType, UTILS, DATASEG, LEGENDS, Ureaddata, Usegmentation, Udeletedata, Udatatransforms, Upolyregress, Ufreqfiltspec,Uplotscreen;


{$R *.lfm}

{ TFgetdata }
{______________________________________________________________________________}

procedure TFgetdata.BtnRETURNClick(Sender: TObject);
begin
  Close;
end;   {BtnRETURNClick}

{______________________________________________________________________________}

procedure TFgetdata.ListDataClick(Sender: TObject);
var
   ListBox : TlistBox;
   index :   Integer;
   dataFileName: string;

begin
 listBox := TListBox(Sender);
 index := listBox.ItemIndex;

 {----------------------------------}

  if index = 0  then
     begin  {Read the data}
       if  noPageParameters then
         begin
           ShowMessage('There are no page parameters. These are required before the data can be read');
           Close;
         end
     else
       begin
         OpenDialog := TOpenDialog.Create(self);
         OpenDialog.Filter := 'Text files only|*.txt';
         if OpenDialog.Execute then
           begin
             dataFileName := OpenDialog.FileName;
             ReadDataSafely (dataFileName, dataBOX, dataVector, maxArray);
             FreadData := TFreaddata.Create(Nil);
             FreadData.ShowModal;
           if (dataBOX.NOPUNCT > 0) then
             thereIsData := true;
             FreeAndNil(Freaddata);
             openDialog.Free;
           end
         else
           Showmessage('You have chosen not to read the data!');
       end;
    end; {Read the data}

  {----------------------------------}

     if index = 2  then
       begin  {Plot the Data}
         if  (thereIsData = false) then
           ShowMessage('First you must read the data')
         else
         begin
           legend := DataLegend (dataBOX, dataName);
           graphType := dataGraph;
           plotBOX := dataBOX;
           plotVector := dataVector;
           Fplotscreen := TFplotscreen.Create(Nil);
           Fplotscreen.ShowModal;
           FreeAndNil(Fplotscreen);
         end;

         if weHavePolyResiduals then
           begin
             legend := PolynomialResiduals (polyParas, dataBOX, dataName);
             graphType := dataGraph;
             plotBOX := residueBOX;
             plotVector := residueVec;
             Fplotscreen := TFplotscreen.Create(Nil);
             Fplotscreen.ShowModal;
             FreeAndNil(Fplotscreen);
           end;
     end; {index = 2: Plot the Data}

  {----------------------------------}

  if index = 4  then
    begin
      if  (thereIsData = false) then
        ShowMessage('First you must read the data')
      else
        begin
         Fdatatransforms := TFdatatransforms.Create(Nil);
         Fdatatransforms.ShowModal;
         FreeAndNil(Fdatatransforms);
        end;
     end;  {index = 4: Transform the Data}

  {----------------------------------}

  if index = 6  then
    begin
      if  (thereIsData = false) then
        ShowMessage('First you must read the data')
      else
        begin
          Fsegmentation := TFsegmentation.Create(nil);
          Fsegmentation.ShowModal;
          FreeAndNil(Fsegmentation);
        end;
    end; {index = 6: Segment the Data}

  {----------------------------------}

  if index = 8  then
    begin
      if  (thereIsData = false) then
        ShowMessage('First you must read the data')
      else
        begin
          Fdeletedata := TFdeletedata.Create(nil);
          Fdeletedata.ShowModal;
          FreeAndNil(Fdeletedata);
        end;

    end; {index = 8: Discard Some Data}

 {----------------------------------}
  if index = 10 then
    begin
      FpolyRegress := TFpolyRegress.Create(nil);
      FpolyRegress.ShowModal;
      FreeAndNil(FpolyRegress);
    end;  {index = 10: Polynomial Regression}
  {----------------------------------}

   if index = 12 then
     begin
        filterSpec.seasonality := dataBOX.dataFrequency;

       if  (thereIsData = false) then
         ShowMessage('First you must read the data')
       else
         SlowFourier (dataBOX, dataVector, alpha, beta);
         MakeThePeriodogram (dataBOX, spectraBOX, spectraVec, alpha, beta); {in dATASEG}
         legend := 'The periodogram of ' + dataName;
         graphtype := PeriodoGraph;
         Fplotscreen := TFplotscreen.Create(Nil);
         Fplotscreen.ShowModal;
         FreeAndNil(Fplotscreen);

         if weHavePolyResiduals then
           begin
             SlowFourier (residueBOX, residueVec, alpha, beta);
             MakeThePeriodogram (dataBOX, spectraBOX, spectraVec, alpha, beta); {in dATASEG}
             legend := 'The periodogram of the residual deviations from a polynomial trend interpolated into ' + dataName;
             graphtype := PeriodoGraph;
             Fplotscreen := TFplotscreen.Create(Nil);
             Fplotscreen.ShowModal;
             FreeAndNil(Fplotscreen);
           end;

     end; {index = 12: Plot the Periodogram}

  {----------------------------------}

 end;  {ListBox1Click}
{______________________________________________________________________________}

end. {Ugetdata: Unit of SEASCAPE.PAS}





