unit Uextrapolate;  {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,GLOBALS;

type

  { TFextrapolate }

  TFextrapolate = class(TForm)
    BtnRETURN: TButton;
    BtnCONTINUE: TButton;
    EdtLength: TEdit;
    GroupBoxTrendRemoval: TGroupBox;
    GroupBoxExtrapolations: TGroupBox;
    Label1: TLabel;
    LblPercentOrPts: TLabel;
    LblTrendAlert: TLabel;
    LblLength: TLabel;
    RadioBtnPolynome: TRadioButton;
    RadioBtnTaper: TRadioButton;
    RadioBtnLogistic: TRadioButton;
    StaticText1: TStaticText;
    StaticText2: TStaticText;
    procedure BtnCONTINUEClick(Sender: TObject);
    procedure BtnRETURNClick(Sender: TObject);
    procedure EdtLengthChange(Sender: TObject);
    procedure EdtLengthKeyPress(Sender: TObject; var Key: char);
    procedure FormActivate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure RadioBtnPolynomeChange(Sender: TObject);
    procedure RadioBtnTaperChange(Sender: TObject);
    procedure RadioBtnLogisticChange(Sender: TObject);
  private

  public

  end;


procedure CheckExtensionLength(var  EdtLength: TEdit;
                       var proceed: boolean);

var
  Fextrapolate: TFextrapolate;
  STR:string;
  tapered, logistic: boolean;
  extraLength, extraPoints, extraYears: integer;
  proceed: boolean = false;

implementation
  uses
    upolyregress, TAPER, Ulowfreqfilts; {trigonom;}

{$R *.lfm}

{ TFextrapolate }
{______________________________________________________________________________}

procedure TFextrapolate.FormActivate(Sender: TObject);
 var
   STR1, STR2, STR3: string;
begin

  {nextForm :=true;}
  EdtLength.Enabled := false;
  EdtLength.Visible := false;
  lBlLength.Visible := false;
  LblPercentOrPts.Visible := false;
  if dataAreTrended and (not weHavePolyResiduals) then
    begin
      EdtLength.Enabled := false;
      EdtLength.Visible := false;
      lBlLength.Visible := false;
      STR := 'There is a trend in the data, which must be removed';
      LblTrendAlert.Caption :=STR;
      GroupBoxExtrapolations.Enabled := false;
      GroupBoxTrendRemoval.Enabled := true;
      {proceed := true;}
      STR1 := 'The data, which have a trend, must be subjected to a polynomial';
      STR2 := 'regression before they can be filtered. Thereafter, a synthetic';
      STR3 := 'segment may be inserted into the data sequence.';
      StaticText2.Caption := STR1 + Chr(13) + STR2 + Chr(13) + STR3;
    end
  else
    begin
      STR :='The data are free of trend';
      LblTrendAlert.Caption :=STR;
      GroupBoxTrendRemoval.Enabled := false;
      proceed := true;
      STR1 := 'The data are are already free of trend in consequence of a prior';
      STR2 := 'polynomial regression. Nevertheless, you may wish to repeat the';
      STR3 := 'detrending with a weighted polynomial regression.';
      StaticText2.Caption := STR1 + Chr(13) + STR2 + Chr(13) + STR3;
    end;
end; {FormActivate}

{______________________________________________________________________________}

procedure TFextrapolate.FormShow(Sender: TObject);

var
  STR1, STR2, STR3: string;

begin
  STR :='The data are free of trend';
  LblTrendAlert.Caption :=STR;
  GroupBoxTrendRemoval.Enabled := false;
  GroupBoxExtrapolations.Enabled := true;
  proceed := true;
  STR1 := 'The data are are already free of trend in consequence of a prior';
  STR2 := 'polynomial regression. You may now wish to extrapolate the data';
  STR3 := 'or to interpolate a synthetic segment into the circular sequence.';
  StaticText2.Caption := STR1 + Chr(13) + STR2 + Chr(13) + STR3;
end;   {FormShow}

{______________________________________________________________________________}

procedure TFextrapolate.EdtLengthKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9',#8])  then
    begin
      ShowMessage('Enter integer values only');
      key := #0;
    end;
end;   {EdtLengthKeyPress}

{______________________________________________________________________________}

procedure TFextrapolate.EdtLengthChange(Sender: TObject);
begin
  if  EdtLength.text <> '' then
    extraLength := StrToInt(EdtLength.text);
end;  {EdtLengthKeyPress}

{______________________________________________________________________________}

procedure TFextrapolate.RadioBtnPolynomeChange(Sender: TObject);
begin
  Fpolyregress := TFpolyregress.Create(nil);
  Fpolyregress.ShowModal;
  Fextrapolate.Hide;
  FreeAndNil(Fpolyregress);
  Fextrapolate.Show;
  proceed := true; {this provides the option to proceed}

end;  {RadioBtnPolynome}

{______________________________________________________________________________}

procedure TFextrapolate.RadioBtnTaperChange(Sender: TObject);
   var
    STR1,STR2: string;
begin
  tapered := true;
  logistic := false;

  EdtLength.Enabled := true;
  EdtLength.Visible := true;
  lBlLength.Visible := true;    {their combined lengths or their lengths?}
  STR1 :='The extrapolations are at both ends of the data sequence. Specify their';
  STR2 := 'individual lengths as a percentage of that of the original data:';
  StaticText2.Caption := STR1 + Chr(13) + STR2;
  LblPercentOrPts.Visible := true;
  LblPercentOrPts.Caption := 'Percent';

end;  {RadioBtnTaperChange}

{______________________________________________________________________________}

procedure TFextrapolate.RadioBtnLogisticChange(Sender: TObject);

  var
    STR3, STR4, STR5: string;
begin
  logistic := true;
  tapered := false;

  EdtLength.Enabled := true;
  EdtLength.Visible := true;
  lBlLength.Visible := true;
  LblPercentOrPts.Visible := true;
  if dataBOX.dataFrequency in [Monthly, Quarterly] then
    begin
      STR3 := 'The interpolation transforms the seasonal pattern of the final';
      STR4 := 'year into that of the initial year. Specify its length in years:';
      StaticText2.Caption := STR3 + Chr(13) + STR4;
      LblPercentOrPts.Caption := 'Years';
    end;
  if dataBOX.dataFrequency in [Annual, Other] then
    begin
      STR3 := 'The interpolation transforms the final segment of the data into';
      STR4 := 'the initial segment. Specify the length of the interpolation as';
      STR5 := 'as a percentage of the length of the data';
      StaticText2.Caption := STR3 + Chr(13) + STR4 + Chr(13) + STR5;
      LblPercentOrPts.Caption := 'Percent';
    end;

end; {RadioBtnLogisticChange}

{______________________________________________________________________________}

procedure CheckExtensionLength(var  EdtLength: TEdit;
                       var proceed: boolean);

  var percentage: real;    {where is points declared?}

begin
   proceed := false;

  if EdtLength.Text = '' then
    ShowMessage('You have yet to specify the length of the data extension')
  else
    begin {else}
      if tapered then
        begin
          {percentage := StrToFloat(EdtLength.Text);}
          percentage := extraLength;
          extraPoints := Round(dataBOX.NOPUNCT*(percentage/100));

          if percentage > 25 then
            ShowMessage('The length of each extension should not exceed a quarter of the length of the original data')
          else
            proceed := true;
        end; {tapered}

      if logistic then
        begin

        if dataBox.dataFrequency  in [Annual, Other] then
          begin
            extraPoints := extraLength;
            percentage := (extraPoints/dataBOX.NOPUNCT) * 100;
          end; {Annual, Other}

        if  dataBox.dataFrequency = Monthly then
          begin
            extraYears := extraLength;
            extraPoints := extraYears * 12;
            percentage := (extraPoints/dataBOX.NOPUNCT) * 100;
          end;  {Monthly}

        if dataBox.dataFrequency = Quarterly then
          begin
            extraYears := extraLength;
            extraPoints := extraYears * 4;
            percentage := (extraPoints/dataBOX.NOPUNCT) * 100;
          end; {Quarterly}

{SHOWMESSAGE(' pecentage addition = ' + FloatToStr(extraPoints));}

        if percentage > 50 then
          ShowMessage('The length of the extension should not exceed half the length of the original data')
        else
          proceed := true;

        end; {logistic}
      end; {else}

{SHOWMESSAGE(' EdtLength.Text = ' + EdtLength.Text);
SHOWMESSAGE(' extraYears = ' + IntToStr(extraYears));
SHOWMESSAGE(' extraPoints = ' + IntToStr(extraPoints));}


end; {CheckExtraDataLength}

{______________________________________________________________________________}

procedure TFextrapolate.BtnRETURNClick(Sender: TObject);
begin
  {nextForm := false;}
  Close;
end; {BtnRETURNClick}
{______________________________________________________________________________}

procedure TFextrapolate.BtnCONTINUEClick(Sender: TObject);

begin


  if RadioBtnLogistic.Checked = true then
    begin
      if dataExtrapolated then
        proceed := true
      else
        begin
          CheckExtensionLength(EdtLength, proceed);
          if proceed then
            CircularMorphing (extraPoints, shadedBOX, SCREENBOX, POSTBOX, residueBOX, cycleBOX, residueVec, cycleVec);    {in TAPER}
        end;
    end;

   if RadioBtnTaper.Checked = true then
    begin
      if dataExtrapolated then
        proceed := true
      else
        begin
          CheckExtensionLength(EdtLength, proceed);
          ExtrapolateAndTaper (extraPoints, SCREENBOX, POSTBOX, residueBOX, cycleBOX, residueVec, cycleVec);    {in TAPER}
        end;
    end;

  if  (not weHavePolyResiduals) and  (not weHaveATrendCycle) then
    begin
      proceed := false;
      ShowMessage('To proceed you need first to detrend the data');
    end;

    {SHOWMESSAGE(' Exiting uExtrapolate: residueBOX.NOPUNCT = ' + IntToStr(residueBOX.NOPUNCT) + ' residueBOX.EXTRA = ' + IntToStr(residueBOX.EXTRA));}


  if proceed then
    begin    {on completion we return to the callint unit}
      Close;
      Flowfreqfilts := TFlowfreqfilts.Create(nil);
      Flowfreqfilts.ShowModal;
      FreeAndNil(Flowfreqfilts);
    end;

end;  {BtnCONTINUEClick}

{______________________________________________________________________________}

end.  {Uextrapolate: Unit of SEASCAPE.PAS}

