unit Udoublefilter;  {unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  GLOBALS, Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TFdoublefilt }

  TFdoublefilt = class(TForm)
    BtnRETURN: TButton;
    BtnCONTINUE: TButton;
    Edtlambda: TEdit;
    Edtrho: TEdit;
    EdtOffset: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    StaticText1: TStaticText;
    procedure BtnCONTINUEClick(Sender: TObject);
    procedure BtnRETURNClick(Sender: TObject);
    procedure EdtrhoKeyPress(Sender: TObject; var Key: char);
    procedure EdtlambdaKeyPress(Sender: TObject; var Key: char);
    procedure EdtOffsetKeyPress(Sender: TObject; var Key: char);
    procedure EdtrhoChange(Sender: TObject);
    procedure EdtlambdaChange(Sender: TObject);
    procedure EdtOffsetChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);

   private

  public

  end;

function InRange (var x: real): boolean;

procedure CheckFilterParameters(var Edtrho, Edtlambda, Edtoffset: TEdit;
                        var filterSpec: filterRecord;
                        var proceed: boolean);
var
  Fdoublefilt: TFdoublefilt;
  proceed: boolean = false;

implementation

uses
UTILS, RESPONSE, DATASEG, TIMEFILT, LEGENDS, Uplotscreen;


{$R *.lfm}

{ TFdoublefilt }
{______________________________________________________________________________}

procedure TFdoublefilt.FormActivate(Sender: TObject);
begin
  filterSpec.rho := StrToFloat(Edtrho.text);
  filterSpec.lambda := StrToFloat(Edtlambda.text);

end;   {FormActivate}
{______________________________________________________________________________}

procedure TFdoublefilt.EdtrhoKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', '.',#8])then
    begin
      ShowMessage('Enter an real value in [0.0, 1.0]');
      key := #0;
    end;
end;   {EdtrhoKeyPress}

{______________________________________________________________________________}

procedure TFdoublefilt.EdtlambdaKeyPress(Sender: TObject; var Key: char);
begin
 if not (key in [#0, '0'..'9', '.',#8])then
   begin
     ShowMessage('Enter an real value in [0.0, 1.0]');
     key := #0;
   end;
end;   {EdtlambdaKeyPress}
{______________________________________________________________________________}

procedure TFdoublefilt.EdtOffsetKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', '.',#8])then
    begin
      ShowMessage('Enter an real value in [0.0, 1.0]');
      key := #0;
    end;
end; {EdtOffsetKeyPress}
{______________________________________________________________________________}

procedure TFdoublefilt.EdtlambdaChange(Sender: TObject);
begin
  if not (Edtlambda.text = '') then
    filterSpec.lambda := StrToFloat(Edtlambda.text);
end;  {EdtlambdaChange}
{______________________________________________________________________________}

procedure TFdoublefilt.EdtrhoChange(Sender: TObject);
begin
  if not (Edtrho.text = '') then
    filterSpec.rho := StrToFloat(Edtrho.text);
end; {EdtrhoChange}
{______________________________________________________________________________}

procedure TFdoublefilt.EdtOffsetChange(Sender: TObject);
begin
   if not (Edtoffset.text = '') then
    filterSpec.zeta := StrToFloat(Edtoffset.text);
end; {EdtOffsetChange}
{______________________________________________________________________________}

function InRange (var x: real): boolean;
  begin
    InRange := false;
    if (x >= 0.0) and (x <= 1.0) then
      InRange := true;
  end; {InRange}
{______________________________________________________________________________}
 function OffsetInRange (var x: real): boolean;
  begin
    OffsetInRange := false;
    if (x >= 0.0) and (x <= 4.0) then
      OffsetInRange := true;
  end; {InRange}
{______________________________________________________________________________}

procedure CheckFilterParameters(var Edtrho, Edtlambda, Edtoffset: TEdit;
                        var filterSpec: filterRecord;
                        var proceed: boolean);
begin

  if Edtrho.text = '' then
    ShowMessage('You have yet to specify the pole parameter')
  else if Edtlambda.text = '' then
    ShowMessage('You have yet to specify the smoothing parameter')
  else if Edtoffset.text = '' then
    ShowMessage('You have yet to specify the offset parameter')
  else if not InRange(filterSpec.rho) then
    ShowMessage('The pole parameter must lie in the interval (0.0, 1.0)')
  else if not InRange(filterSpec.lambda) then
    ShowMessage('The smoothing parameter must lie in the interval (0.0, 1.0)')
  else if not  OffsetInRange (filterSpec.zeta) then
    ShowMessage('The offset must be no more that 4 degrees')
  else
    proceed := true;

end; {CheckFilterParameters}
{______________________________________________________________________________}

procedure TFdoublefilt.BtnRETURNClick(Sender: TObject);
begin
  Close;
end;  {BtnRETURNClick}
{______________________________________________________________________________}

procedure TFdoublefilt.BtnCONTINUEClick(Sender: TObject);

var
  s, Tcap: integer;
  alpha, beta: fourierVec;

begin
  filterSpec.seasonality := dataBox.dataFrequency;
  s :=filterSpec.seasonality;
  Tcap := dataBOX.NOPUNCT;

  CheckFilterParameters(Edtrho, Edtlambda, Edtoffset,filterSpec, proceed);

  if proceed then
    begin

      TwoPassFilterSpec (filterSpec, rhoVec, sigmaVec1, sigmaVec2, phi1, theta1, phi2, theta2);
      GetFilterGainVector (filterSpec, SCREENBOX, spectraVec, spectraBOX, phi, theta, phi1, theta1, phi2, theta2);
      residueBOX.NOPUNCT := dataBOX.NOPUNCT;
      SlowFourier (residueBOX, residueVec, alpha, beta);
      MakeThePeriodogram (residueBOX, plotBOX, plotVector, alpha, beta);
      legend := DoubleFilterGain (filterSpec);
      graphType :=  backgroundPlot;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);

      seasonVec := residueVec;
      adjustedVec := residueVec;
      ApplyDoubleSeasonalFilter (s, Tcap, phi1, phi2, sigmaVec1, sigmaVec2, seasonVec, adjustedVec);
      seasonBOX.NOPUNCT := dataBOX.NOPUNCT;
      MakeDataBox (seasonBOX, seasonVec);
      {+++++++++++++++++++++++++++++++++++++++++}
      legend := SeasonalComponent (dataBOX,dataName);
      plotVector := seasonVec;
      plotBOX := seasonBOX;
      graphType  :=  dataGraph;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
      weHaveSeasonalComponent := true;
      {+++++++++++++++++++++++++++++++++++++++++}
      SubtractComponent (dataBOX, adjustedBOX, dataVector, seasonVec, adjustedVec);
      legend := DeSeasonalisedOverlay (dataBOX, dataName);
      graphType := seasonsGraph;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
      weHaveSeasonallyAdjustedData := true;
     end; {procees}


end; {BtnCONTINUEClick}

{______________________________________________________________________________}


end.  {Udoublefilt: Unit of SEASCAPE.PAS}

