unit Udetrend;   {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TFdetrend }

  TFdetrend = class(TForm)
    BtnRETURN: TButton;
    PageTitle: TLabel;
    ListDetrend: TListBox;
    StaticText: TStaticText;
    procedure BtnRETURNClick(Sender: TObject);
    procedure ListDetrendClick(Sender: TObject);
  private

  public

  end;

var
  Fdetrend: TFdetrend;

implementation
 uses
   GLOBALS,  Ulowfreqfilts, UpolyRegress, Uwienerfilts, Uextrapolate, Uvarismoooth; {Ulowfreqfilts;}

{$R *.lfm}

{ TFdetrend }

{______________________________________________________________________________}

procedure TFdetrend.BtnRETURNClick(Sender: TObject);
begin
  Close;
end;  {BtnRETURNClick}
{______________________________________________________________________________}


procedure TFdetrend.ListDetrendClick(Sender: TObject);

  var index: integer;
    STR1, STR2: string;

begin
  index := ListDetrend.ItemIndex;

{----------------------------------}

  if index = 1 then
    begin
      FpolyRegress := TFpolyRegress.Create(nil);
      FpolyRegress.ShowModal;
      FreeAndNil(FpolyRegress);
    end;  {Polynomial Regression}
{----------------------------------}

  if index = 3 then
    begin
      Fwienerfilts := TFwienerfilts.Create(nil);
      Fwienerfilts.ShowModal;
      FreeAndNil(Fwienerfilts);
    end;  {Time-Domain Filters}
{----------------------------------}

  if index = 5 then
    begin
      Fvarismoooth := TFvarismoooth.Create(nil);
      Fvarismoooth.ShowModal;
      FreeAndNil(Fvarismoooth);
    end;  {Variable Smoothing}
{----------------------------------}

  if index = 7 then
    begin
      if  dataAreTrended then
        ShowMessage('To proceed, you must first detend the data by a polynomial regression')
      else if weHaveATrendCycle then
        begin
          STR1 := 'The current residuals are deviations from a trend-cycle function. To apply';
          STR2 := ' a frequency-domain filter, you must regenerate the polynomial residuals';
          ShowMessage(STR1 + STR2);
          end
      else if weHavePolyResiduals and  dataExtrapolated then
        begin
          Flowfreqfilts := TFlowfreqfilts.Create(nil);
          Flowfreqfilts.ShowModal;
          FreeAndNil(Flowfreqfilts);
        end
      else
        begin
          Fextrapolate := TFextrapolate.Create(nil);
          Fextrapolate.ShowModal;
          FreeAndNil(Fextrapolate)
        end;
    end;  {Frequency Domain Filter}
{----------------------------------}

  {if index = 9 then
    begin
      FpolyRegress := TFpolyRegress.Create(nil);
      FpolyRegress.ShowModal;
      FreeAndNil(FpolyRegress);
    end;}  {ExtraPolate and/or Detrend}
{----------------------------------}

end;  {ListBox1Click}
{______________________________________________________________________________}

end. {Udetrend: unit of SEASCAPE.PAS}

