unit Ucentralfilt; {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  GLOBALS, Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TFcentralfilt }

  TFcentralfilt = class(TForm)
    BtnRETURN: TButton;
    BtnCONTINUE: TButton;
    Edtrho: TEdit;
    Edtlambda: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Lblpagetitle: TLabel;
    StaticText1: TStaticText;
    procedure BtnCONTINUEClick(Sender: TObject);
    procedure BtnRETURNClick(Sender: TObject);
    procedure EdtrhoChange(Sender: TObject);
    procedure EdtrhoKeyPress(Sender: TObject; var Key: char);
    procedure EdtlambdaChange(Sender: TObject);
    procedure EdtlambdaKeyPress(Sender: TObject; var Key: char);
    procedure FormActivate(Sender: TObject);
  private

  public

  end;

  function InRange (var x: real): boolean;

  procedure CheckFilterParameters(var Edtrho, Edtlambda: TEdit;
                        var filterSpec: filterRecord;
                        var proceed: boolean);

var
  Fcentralfilt: TFcentralfilt;
  proceed: boolean = false;

implementation

uses
  UTILS, RESPONSE, DATASEG, TIMEFILT, LEGENDS, Uplotscreen;

{$R *.lfm}

{ TFcentralfilt }

{______________________________________________________________________________}

procedure TFcentralfilt.FormActivate(Sender: TObject);
begin
    filterSpec.rho := StrToFloat(Edtrho.text);
  filterSpec.lambda := StrToFloat(Edtlambda.text);

end;   {FormActivate}
{______________________________________________________________________________}

procedure TFcentralfilt.EdtrhoKeyPress(Sender: TObject; var Key: char);
begin
   if not (key in [#0, '0'..'9', '.',#8])then
 begin
   ShowMessage('Enter an real value in [0.0, 1.0]');
   key := #0;
  end;
end;   {EdtpoleKeyPress}

{______________________________________________________________________________}

procedure TFcentralfilt.EdtrhoChange(Sender: TObject);
begin
    if not (Edtrho.text = '') then
    filterSpec.rho := StrToFloat(Edtrho.text);
end;  {EdtpoleChange}
{______________________________________________________________________________}

procedure TFcentralfilt.EdtlambdaChange(Sender: TObject);
begin
    if not (Edtlambda.text = '') then
    filterSpec.lambda := StrToFloat(Edtlambda.text);
end;   {EdtsmoothingChange}

{______________________________________________________________________________}

procedure TFcentralfilt.EdtlambdaKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', '.',#8])then
    begin
      ShowMessage('Enter an real value in [0.0, 1.0]');
      key := #0;
   end;
end;   {EdtsmoothingKeyPress}

{______________________________________________________________________________}

function InRange (var x: real): boolean;
  begin
    InRange := false;
    if (x >= 0.0) and (x <= 1.0) then
      InRange := true;
  end; {InRange}
{______________________________________________________________________________}

 procedure CheckFilterParameters(var Edtrho, Edtlambda: TEdit;
                        var filterSpec: filterRecord;
                        var proceed: boolean);

 begin
   if Edtrho.text = '' then
       ShowMessage('You have yet to specify the pole parameter')
     else if Edtlambda.text = '' then
       ShowMessage('You have yet to specify the smoothing parameter')
     else if not InRange(filterSpec.rho) then
       ShowMessage('The pole parameter must lie in the interval (0.0, 1.0)')
     else if not InRange(filterSpec.lambda) then
       ShowMessage('The smoothing parameter must lie in the interval (0.0, 1.0)')
     else
       proceed := true;

 end; {CheckFilterParameters}
{______________________________________________________________________________}

procedure TFcentralfilt.BtnCONTINUEClick(Sender: TObject);

var
  s,Tcap: integer;
  alpha, beta: fourierVec;

begin
  filterSpec.seasonality := dataBox.dataFrequency;
  s :=filterSpec.seasonality;
  Tcap := dataBOX.NOPUNCT;
  {q:= s-1;}   {GLOBAL}
  {sPlus := s;}

  CheckFilterParameters(Edtrho, Edtlambda, filterSpec, proceed);

  if proceed then
    begin                 {GetFilterGainVector should contain filterSpec, also the phi and thetas shoidn be gathered}
      CentralFilterVec (filterSpec, rhoVec, sigmaVec, phi, theta);
      GetFilterGainVector (filterSpec, SCREENBOX, spectraVec, spectraBOX, phi, theta, phi1, theta1, phi2, theta2);
      residueBOX.NOPUNCT := dataBOX.NOPUNCT;
      SlowFourier (residueBOX, residueVec, alpha, beta);
      MakeThePeriodogram (residueBOX, plotBOX, plotVector, alpha, beta);
      legend := SeasonalFilterGain (filterSpec);
      graphType :=  backgroundPlot;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);

       seasonVec := residueVec;
       adjustedVec := residueVec;
       ApplySingleSeasonalFilter (s, Tcap, phi, sigmaVec, seasonVec, adjustedVec);
       seasonBOX.NOPUNCT := dataBOX.NOPUNCT;
       MakeDataBox (seasonBOX, seasonVec);
       {+++++++++++++++++++++++++++++++++++++++++}
         legend := SeasonalComponent (dataBOX,dataName);
         plotVector := seasonVec;
         plotBOX := seasonBOX;
         graphType  :=  dataGraph;
         Fplotscreen := TFplotscreen.Create(Nil);
         Fplotscreen.ShowModal;
         FreeAndNil(Fplotscreen);
         weHaveSeasonalComponent := true;
         {+++++++++++++++++++++++++++++++++++++++++}
         SubtractComponent (dataBOX, adjustedBOX, dataVector, seasonVec, adjustedVec);
         legend := DeSeasonalisedOverlay (dataBOX, dataName);
         graphType := seasonsGraph;
         Fplotscreen := TFplotscreen.Create(Nil);
         Fplotscreen.ShowModal;
         FreeAndNil(Fplotscreen);
         weHaveSeasonallyAdjustedData := true;
    end; {proceed}
end; {BtnCONTINUEClick}
{______________________________________________________________________________}

procedure TFcentralfilt.BtnRETURNClick(Sender: TObject);
begin
 Close;
end;  {BtnRETURNClick}
{______________________________________________________________________________}


end.  {Ucentralfilt: Uit of SEASCAPE.PAS}

