unit TAPER; {Unit of SEASCAPE.PAS}

interface


  uses
    Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
    GLOBALS,utils;


  procedure AddExtensions (var Tadd: integer;
                  var residueBOX: rBOX;
                  var residueVec: longVector);

   procedure ExtrapolateAndTaper (var extraPoints: integer;
                  var SCREENBOX, POSTBOX: IBOX;
                  var residueBOX, cycleBOX: rBOX;
                  var ResidueVec, cycleVec: longVector);

  procedure RotateData (RoteNo: integer;
                  var residueBOX: rBOX;
                  var ResidueVec: longVector);

  procedure AntiRotateData (RoteNo: integer;
                  var residueBOX: rBOX;
                  var residueVec: longVector);

  procedure CircularMorphing (var extraPoints: integer;
                  var shadedBOX: integerRect;
                  var SCREENBOX, POSTBOX: IBOX;
                  var residueBOX, cycleBOX: rBOX;
                  var ResidueVec, cycleVec: longVector);


implementation

  uses
    uplotscreen;

  {______________________________________________________________________________}

    procedure AddExtensions (var Tadd: integer;
                  var residueBOX: rBOX;
                  var residueVec: longVector);
     var
       pi, omega, inc, weight: real;
       t, Tcap, Mcap: integer;

     {Add reflected extensions to the end of the vector}

   begin
     pi := 4.0 * ArcTan(1.0);
     omega := 0;

     Tcap := residueBOX.NOPUNCT;
     Mcap := 2 * Tadd;
     inc := (2 * pi) / (Mcap);

      for t := 1 to Mcap - 1 do
        begin
         omega := omega + inc;
         weight := 0.5 * (Cos(omega) + 1);
         if t < Tadd then
           ResidueVec[Tcap - 1 + t] := weight * ResidueVec[Tcap - t - 2];
         if t = Tadd then
           ResidueVec[Tcap - 1 + t] := 0.0;
         if t > Tadd then
           ResidueVec[Tcap - 1 + t] := weight * ResidueVec[Mcap - t];
        end;
     residueBOX.NOPUNCT := residueBOX.NOPUNCT + Mcap -1;
     residueBOX.EXTRA :=  Mcap -1

   end; {AddExtensions}

{________________________________________________}

  procedure ExtrapolateAndTaper (var extraPoints: integer;
                  var SCREENBOX, POSTBOX: IBOX;
                  var residueBOX, cycleBOX: rBOX;
                  var ResidueVec, cycleVec: longVector);

  {We are Using CycleBOX and cyelVec for the purposes of the display}

  {uses AddExtensions}

    var
      theMenuItem, Tcap, Mcap, Tadd, t: integer;
      inc, pi, omega, weight: real;

  begin
    pi := 4.0 * Arctan(1.0);
    Tcap := residueBOX.NOPUNCT;
    cycleVec := residueVec;
    cycleBOX := residueBOX;
    Tadd := extraPoints;
    {Tadd = Round(points) is the number of elements to be added at each end}

   {Shift the data by Tadd points}
   for t := Tcap - 1 downto 0 do
     cycleVec[t + Tadd] := cycleVec[t];

     inc := pi / (Tadd + 1);
   {Lower extension by reflection}
   omega := 0;
   for t := 0 to Tadd - 1 do
     begin
       omega := omega + inc;
       weight := 1 - 0.5 * (Cos(omega) + 1);
       cycleVec[t] := weight * cycleVec[2 * Tadd - t];
     end;

   {Upper extension by reflection}
   omega := 0;
   Mcap := Tcap + Tadd - 1;
   for t := 1 to Tadd do
     begin
       omega := omega + inc;
       weight := 0.5 * (Cos(omega) + 1);
       cycleVec[Mcap + t] := weight * cycleVec[Mcap - t];
     end;

   CycleBOX.NOPUNCT := Tcap + 2 * Tadd;
   {SHOWMESSAGE('   residueBOX.NOPUNCT = ' + IntToStr(residueBOX.NOPUNCT));}
   CycleBOX.EXTRA := Tadd;  {The ammount added to each end}
   MakeDataBox(cycleBOX, cycleVec);

   legend := 'A sequence of ' + IntToStr(Tcap) + ' points, extended at both ends by ';
   legend := legend + IntToStr(Tadd) + ' points, tapered  to zero by a cosine ';
   legend := legend  +  'decrement to reduce their extremities to zero';

   Tvert := Tadd;
   Tvert2 := Tcap + Tadd;
   Rotated := true;     {WHERE? we have put this in globals}

   graphType := extensionsGraph;
   Fplotscreen := TFplotscreen.Create(Nil);
   Fplotscreen.ShowModal;
   FreeAndNil(Fplotscreen);

   AddExtensions (Tadd, residueBOX, residueVec);

   dataExtrapolated := true;

  end; {ExtapolateAndTaper}

{______________________________________________________________________________}

  procedure RotateData (RoteNo: integer;
                  var residueBOX: rBOX;
                  var ResidueVec: longVector);

{This procedure subtracts a segment from the top}
{of the data and places is at the bottom end.}

    var
      storeVector: vector; {limited to 100 elements}
      t, Tcap, rotaCount, rotaTask: integer;

  begin
    Tcap := residueBOX.NOPUNCT;
    rotaCount := RoteNo;

    repeat
      if (rotaCount > 50) then
        rotaTask := 50
      else
        rotaTask := rotaCount;

      {copy}
      for t := 0 to rotaTask - 1 do
        storeVector[t] := ResidueVec[Tcap - rotaTask + t];

      {displace}
      for t := 1 to Tcap - rotaTask do
        ResidueVec[Tcap - t] := ResidueVec[Tcap - t - rotaTask];

     {deposit}
      for t := 0 to rotaTask - 1 do
        ResidueVec[t] := storeVector[t];

      rotaCount := rotaCount - rotaTask;
    until (rotaCount = 0);

  end; {RotateData}

{________________________________________________}

  procedure AntiRotateData (RoteNo: integer;
                  var residueBOX: rBOX;
                  var ResidueVec: longVector);

{This procedure subtracts a segment from the }
{bottom of the data and places is at the top end.}
  {THIS DOES NOT  SEEM TO BE USED}

    var
      storeVector: vector; {limited to 100 elements}
      t, Tcap, rotaCount, rotaTask: integer;

  begin
    Tcap := residueBOX.NOPUNCT;
    rotaCount := RoteNo;

    repeat
      if (rotaCount > 50) then
        rotaTask := 50
      else
        rotaTask := rotaCount;

     {copy}
      for t := 0 to rotaTask - 1 do
        storeVector[t] := ResidueVec[t];

     {displace}
      for t := 0 to Tcap - 1 - rotaTask do
        ResidueVec[t] := ResidueVec[t + rotaTask];

     {deposit at the top}
      for t := 0 to RoteNo - 1 do
        ResidueVec[Tcap - rotaTask + t] := storeVector[t];

      rotaCount := rotaCount - rotaTask;
    until (rotaCount = 0);

  end; {AntiRotateData}

{______________________________________________________________________________}

  procedure CircularMorphing (var extraPoints: integer;
                  var shadedBOX: integerRect;
                  var SCREENBOX, POSTBOX: IBOX;
                  var residueBOX, cycleBOX: rBOX;
                  var ResidueVec, cycleVec: longVector);

    var
      Tcap, Tadd, Tplus, RoteNo, t, r, s: integer;
      inc, pi, phi, lambda: real;

  begin
    Rotated := false;
    pi := 4.0 * Arctan(1.0);
    Tcap := residueBOX.NOPUNCT;
    Tadd := extraPoints;  {the total number of additional points}

        if (dataBOX.dataFrequency = Monthly) then
          s := 12;
        if (dataBOX.dataFrequency = Quarterly) then
          s := 4;
        if (dataBOX.dataFrequency in [Annual, Other]) then
          s := Tadd div 6;

        r := Tadd div s;
        if Odd(r) then
          r := r + 1;
        Tadd := r * s;

        inc := pi / Tadd;
        phi := 0;
        for t := 0 to Tadd - 1 do
          begin
            Tplus := TCap + t;
            lambda := 0.5 * (Cos(phi) + 1);
            residueVec[Tplus] := (1.0 - lambda) * residueVec[(t mod s)];
            residueVec[Tplus] := residueVec[Tplus] + lambda * residueVec[Tcap - s + (t mod s)];
            phi := phi + inc;
          end;

        residueBOX.NOPUNCT := Tcap + Tadd;
        residueBOX.EXTRA := Tadd;
        {SHOWMESSAGE(' In TAPER residueBOX.NOPUNCT = ' + IntToStr(residueBOX.NOPUNCT) + ' residueBOX.EXTRA = ' + IntToStr(residueBOX.EXTRA));}
        {EXTRA is the total number of points added to the end.}

        MakeDataBox(residueBOX, residueVec);
        Tvert := Tcap - 1;

       {Now rotate the data to put the extension into the middle }
       {We transfer the data to the cycleVec}
        cycleVec := residueVec;
        cycleBOX := residueBOX;

        RoteNo := Tadd + (Tcap div 2);
        Tvert := Tcap div 2;
        Tvert2 := Tvert + Tadd;
        RotateData(RoteNo, cycleBOX, cycleVec);
        Rotated := true;

        legend := 'The data rotated to place the interpolated segment in the middle.';
        legend := Concat(legend, ' The segment assists the transition between the two ends.');

        graphType := extensionsGraph;
        Fplotscreen := TFplotscreen.Create(Nil);
        Fplotscreen.ShowModal;
        FreeAndNil(Fplotscreen);

        dataExtrapolated := true;

        {Is this where we should restore cycleBOX and residueBOX to normality ?}
        {SHOWMESSAGE(' Exiting TAPER: residueBOX.NOPUNCT = ' + IntToStr(residueBOX.NOPUNCT) + ' residueBOX.EXTRA = ' + IntToStr(residueBOX.EXTRA));}


  end; {CircularMorphing}

{______________________________________________________________________________}

end. {TAPER: Unit of SEASCAPE.PAS}


{______________________________________________________________________________}

procedure  ShadedRectangle(var Form1: TForm;
                  var shadedBOX: integerRect);
 begin
   Form1.Csnvas.penColor := clBlack;
   Form1.Csnvas.brushColor := clSilver;
   with shadeBOX do
     Form1.Csnvas.Rectangle(HRS, VTS, HRF. VTF)
 end; {ShadedRectangle}

{Transfer the shadedBOX definition to uscreenplot and determine its parameters}
 {within  taper}


 {______________________________________________________________________________}




