unit SMOOTHER; {Unit of SEASCAPE.PAS}

interface

  uses
    GLOBALS, UTILS, {MATHS,} WIENER, {DATASEG,} Dialogs;

  procedure FillTheVariCells( var sBandCentre, sBandWidth, lowerBound, upperBound: triIntVec;
                            var smoothLambda: triRealVec);


  procedure AdaptiveSmoothing (var sBandCentre, sBandWidth: triIntVec;
                  var sProfile: integer;
                  var smoothLambda: triRealVec;
                  var filterBand: triBooleanVec;
                  var dataBOX: rBOX;
                  var residueVec: longVector);


  procedure MakeSmoothVector (var smoothLambda: triRealVec;
                  var sBandWidth, sBandCentre: triIntVec;
                  var dataBOX, trendBOX, residueBOX: rBOX;
                  var dataVector, trendVector, residueVec: longVector);


implementation

{_____________________________________________________________________________}

  procedure FillTheVariCells( var sBandCentre, sBandWidth, lowerBound, upperBound: triIntVec;
                            var smoothLambda: triRealVec);
  begin

  sBandCentre[0] := -10;
  sBandWidth[0] := -10;
  smoothLambda[0] := -10;

  sBandCentre[1] := -10;
  sBandWidth[1] := -10;
  smoothLambda[1] := -10;

  sBandCentre[2] := -10;
  sBandWidth[2] := -10;
  smoothLambda[2] := -10;


  sBandCentre[3] := -10;;
  sBandWidth[3] := -10;;
  smoothLambda[3] := -10;
  end;  {FillTheVariCells}

{______________________________________________________________________________}

  procedure AdaptiveSmoothing (var sBandCentre, sBandWidth: triIntVec;
                  var sProfile: integer;
                  var smoothLambda: triRealVec;
                  var filterBand: triBooleanVec;
                  var dataBOX: rBOX;
                  var residueVec: longVector);

    var
      d, s, q: longVector;
      trip, trap: triIntVec;    {lowerBound and UpperBound}
      omega, span, lambda, amplitude, increment: real;
      t, j, k, Tcap: smallInt;

  begin
    Tcap := dataBox.NOPUNCT;

   {We need to make an adjustment to the location of the sBands}
   {in view of the second differencing}

    for t := 0 to Tcap - 3 do      {Is second differencing is a fearure og the HP filter ?}
      begin
        d[t] := 6.0 + 1 / smoothLambda[0];     {central diagonal}
        s[t] := -4.0;                          {first off diagonals}
        q[t] := 1.0;                           {second off diagonals}
      end; {t}    {z^{-2} -4^z^{-1} + 6 - 4z + z^2 = (1-z)^2(1 -z^{-1}^2 }

    for k := 1 to 3 do
      begin {k}
        if filterBand[k] = true then
          begin  {filterBand}

            if smoothLambda[k] = 0 then
              smoothLambda[k] := 0.001;

        trip[k] := sBandCentre[k] - sBandWidth[k];    {leftBound}
        trap[k] := sBandCentre[k] + sBandWidth[k];    {RightBund}
        span := trap[k] - trip[k];
        amplitude := smoothLambda[0] - smoothLambda[k];

        lambda := smoothLambda[0];

        if sBandCentre[k] > 0 then
          for t := trip[k] to trap[k] do
            begin {t: sBandCentre >  0}

              if sProfile = bell then
                begin {bell}
                  j := t - trip[k];
                  omega := 2 * pi * j / span;
                  increment := amplitude * 0.5 * (cos(omega) - 1.0);
                  lambda := smoothLambda[0] + increment;
                  d[t] := 6.0 + 1 / lambda;
                end; {bell}

              if sProfile = square then
                begin {square}
                  lambda := smoothLambda[k];
                  d[t] := 6.0 + 1 / lambda;
                end; {square}

              if sProfile = triangle then
                begin {triangle}
                  increment := amplitude / (sBandWidth[k] + 1);{The case of a trianglar trough}
                  if t <= sBandCentre[k] then
                    lambda := lambda - increment;
                  if t > sBandCentre[k] then
                    lambda := lambda + increment;
                  d[t] := 6.0 + 1 / lambda;
                end; {triangle}

            end; {t: sBandCentre >  0}
         end; {filterBand}
      end;{k}

    VariQinDiag(Tcap - 3, d, s, q, residueVec);    {Forward and back substitution}

  end;{AdaptiveSmoothing}

{________________________________________________}

  procedure MakeSmoothVector (var smoothLambda: triRealVec;
                  var sBandWidth, sBandCentre: triIntVec;
                  var dataBOX, trendBOX, residueBOX: rBOX;
                  var dataVector, trendVector, residueVec: longVector);
    var
      Tcap, t: smallInt;
      replace, highLights: boolean;
      legend: string;
      postFileName: string;

  begin
    Tcap := dataBox.NOPUNCT;
   {x := y - Q(Q'Q +  Lambda^[-1])^[-1]Q'y = y - QW^[-1]Q'y = y - Qz}
    residueVec := dataVector;
    QprimeY(residueVec, Tcap); {SecondDiffernces}
    AdaptiveSmoothing (sBandCentre, sBandWidth, sProfile, smoothLambda, filterBand, dataBOX, residueVec);
    FormQy(residueVec, Tcap);  {Form Qz}

    for t := 0 to Tcap - 1 do
      trendVector[t] := dataVector[t] - residueVec[t];

    trendBOX := dataBOX;
    residueBOX := dataBOX;
    MakeDataBox(residueBOX, residueVec);


    weHaveTrendResiduals := true;
    weHaveATrendCycle := true;


  end;{MakeSmoothVector}

   {________________________________________________}

end. {SMOOTHER: Unit of SEASCAPE.PAS}

