unit POSTSCRIPT;   {Unit of SEASCAPE.PAS}

interface

  uses
    SCREEN, Dialogs, Controls, SysUtils, Graph, Dos, Crt, globals, utils;

  procedure PostHeader (var F: textFile;
                  var POSTBOX: IBOX;
                  TeXFormat: boolean);

  procedure PostFooter (var F: textFile;
                  var POSTBOX: IBOX;
                  legend: string;
                  TexFormat: boolean);

  procedure PostMarks (var F: textFile;
                  XSTART, YSTART: real;
                  taly, firstMark, farBound, STEP: real;
                  Axis: string);

  procedure PostFrame (var F: textFile;
                  var dataBOX: rBOX;
                  var POSTBOX: IBOX);

  procedure PostVertAxis (var F: textFile;
                  XSTART, YSTART: integer;
                  taly, firstMark, farBound, VSTEP: real);

  procedure PostZeroPiAxis (var F: textFile;
                  var POSTBOX: IBOX);

  procedure PostDoDecAxis (var F: textFile;
                  var POSTBOX: IBOX);

  procedure PostFrameLite (var F: textFile;
                  var realBOX: rBOX;
                  var POSTBOX: IBOX);

  procedure PostPlot (var F: textFile;
                  var realBOX: rBOX;
                  var POSTBOX: IBOX;
                  var dataVector: longVector);

   procedure PostPlotMod (var F: textFile;
                  var realBOX: rBOX;
                  var POSTBOX: IBOX;
                  var dataVector: longVector);

  procedure PostBiPlot (var F: textFile;
                  var realBOX: rBOX;
                  var POSTBOX: IBOX;
                  var dataVector: pointsVector);

  procedure PostDataPlot (var F: textFile;
                  var plotBOX: rBOX;
                  var plotVector: longVector;
                  var POSTBOX: IBOX;
                  var legend: string);

  procedure PostSpectraPlot (var F: textFile;
                  var plotBOX: rBOX;
                  var plotVector: longVector;
                  var POSTBOX: IBOX;
                  var legend: string);

  procedure PostOverPlot (var F: textFile;
                  var dataBox: rBOX;
                  var dataVector, trendVector: longVector;
                  var POSTBOX: IBOX;
                  var legend: string);

  procedure PostDashedLine(var F: textFile;
                  var TVert: integer;
                  var POSTBOX: IBOX);

implementation

{________________________________________________}

  procedure PostHeader (var F: textFile;
                  var POSTBOX: IBOX;
                  TeXFormat: boolean);
    var
      BOXHGT, BOXWDT, INDENT: integer;
      LLx, LLy, URx, URy: integer;
      xOrigin, yOrigin: integer;

  begin
     {xOrigin := 160;}
     {yOrigin := 560;}

    BOXWDT := POSTBOX.X2 - POSTBOX.X1;
    BOXHGT := POSTBOX.Y2 - POSTBOX.Y1;

    xOrigin := (595 - BOXWDT) div 2;
    yOrigin := 730 - BOXHGT;

    if TeXFormat then
      Writeln(F, '\special{postscript')
    else
      begin
        LLx := xOrigin - 40;
        LLy := yOrigin - 30;
        URx := xOrigin + BOXWDT + 40;
        URy := yOrigin + BOXHGT + 10;
        Writeln(F, '%!PS-Adobe-2.0');
        Writeln(F, '%%Creator: SigmaPi');
        Writeln(F, '%%BoundingBox:', LLx : 3, '  ', LLy : 3, '  ', URx : 3, '  ', URy : 3);
      end;

    Writeln(F, '/showxhatch');
    Writeln(F, '{/label exch def');
    Writeln(F, '/y exch def');
    Writeln(F, '/x exch def');
    Writeln(F, 'x  y  moveto');
    Writeln(F, '0  5 rlineto');
    Writeln(F, 'stroke');
    Writeln(F, 'x  y  moveto');
    Writeln(F, '0 -20 rmoveto');
    Writeln(F, 'label dup stringwidth pop 2 div neg 0 rmoveto show} def');

    Writeln(F, '/showyhatch');
    Writeln(F, '{/label exch def');
    Writeln(F, '/y exch def');
    Writeln(F, '/x exch def');
    Writeln(F, 'x  y  moveto');
    Writeln(F, ' 5 0 rlineto');
    Writeln(F, 'stroke');
    Writeln(F, 'x  y  moveto');
    Writeln(F, '-15 -2 rmoveto');
    Writeln(F, 'label dup stringwidth pop neg 0 rmoveto show} def');

    {Writeln(F, '/showqhatch');
    Writeln(F, '{/label exch def');
    Writeln(F, '/y exch def');
    Writeln(F, '/x exch def');
    Writeln(F, 'x  y moveto');
    Writeln(F, ' -5 0 rlineto');
    Writeln(F, 'stroke');
    Writeln(F, 'x  y  moveto');
    Writeln(F, '30 -2 rmoveto');
    Writeln(F, 'label dup stringwidth pop neg 0 rmoveto show} def');}

    if TeXFormat then
      begin {TeXFormat}
        INDENT := Round(((12 * 72) / 2.54 - BOXWDT) / 2);
        Writeln(F, INDENT : 2, '  ', -(BOXHGT + 15) : 2, '  translate');
      end {TeXFormat}
    else
      Writeln(F, xOrigin : 3, '  ', yOrigin : 3, ' translate ');

    Writeln(F, 'newpath');
    Writeln(F, '0.5 setlinewidth');

  end; {PostHeader}

{_________________________________________________}

  procedure PostFooter (var F: textFile;
                  var POSTBOX: IBOX;
                  legend: string;
                  TexFormat: boolean);

    var
      BOXHGT: integer;
      figNumberString: string;

  begin
  {Writeln(F, 'stroke');}
    figNumberString := IntegerToString(figNumber);
    if TexFormat then
      begin
        Writeln(F, 'showpage}');
        BOXHGT := POSTBOX.Y2 - POSTBOX.Y1;
        Writeln(F, '\vbox to ', BOXHGT + 35 : 3, ' pt');
        Writeln(F, ' {\hrule width 12cm height 0cm depth 0cm \vfill}');
        Writeln(F, '\medskip');
        Writeln(F, '{\par\noindent{\bf Figure ', figNumber : 1, '.} ');
        Write(F, legend);
        Writeln(F, '\par}');
        Writeln(F, '\medskip');
      end
    else
      begin
        Writeln(F, 'showpage');
        Writeln(F, '%%Trailer');
        Writeln(F, '%%EOF');
        Writeln(F, '%% Figure ', fignumber : 1, '. ', legend);
      end;

    figNumber := figNumber + 1;

  end; {PostFooter}

{_________________________________________________}

  procedure PostMarks (var F: textFile;
                  XSTART, YSTART: real;
                  taly, firstMark, farBound, STEP: real;
                  Axis: string);

    var
      toly, HR, VT: real;
      tolyString: string;

  begin {PostMarks}

    toly := firstMark;
    HR := XSTART;
    VT := YSTART;

    while Abs(toly) <= Abs(farBound) do

      begin {while toly}
        tolyString := TalyToString(toly);
        if Axis = 'xScale' then
          begin
            Writeln(F, HR : 5 : 2, '  ', VT : 5 : 2, '  (', tolyString, ') showxhatch');
            HR := HR + STEP;
          end;

        if Axis = 'yScale' then
          begin
            Writeln(F, HR : 5 : 2, '  ', VT : 5 : 2, '  (', tolyString, ') showyhatch');
            VT := VT + STEP;
          end;

        toly := toly + taly;
      end; {while TOLY}

  end; {PostMarks: Marks and Numbers}

{_________________________________________________}

  procedure PostFrame (var F: textFile;
                  var dataBOX: rBOX;
                  var POSTBOX: IBOX);

{This is the revised version of PostFrame}

    var
      sign, Ycap: integer;
      firstHATCH, vSTEP, hSTEP: real;
      rxPos, rxNeg, ryPos, ryNeg, taly, increment: real;
      nearBound, farBound, boundRange, startMark: real;
      {Q: textFile;}

  begin{PostFrame}
    {ShowMessage(' We ARE IN POSTFRAME');}
    with POSTBOX, dataBOX do
      begin
        yUB := yMax;
        yLB := yMin;

        yRange := yMax - yMin; {This will become YUB - yLB}
        xRange := xMax - xMin;

{(X1,  Y1) is the bottom left of the IBOX}
{(X2,  Y2) is the top lright of the IBOX}

        X0 := X1; {Default for Graphics Origin. integer}
        Y0 := Y1; {Default for Graphics Origin. integer}

{BOXWDT := X2 - X1;}
 {Width of Bounding Box: real valued entity}
{BOXHGT := Y2 - Y1; }
 {Height of Bounding Box: : real valued entity}

        if doMarks then
          begin
            Writeln(F, '/Symbol findfont');
            Writeln(F, '10 scalefont  setfont');
          end;
        if doFrame then
          begin
            Writeln(F, X1 : 3, '  ', Y1 : 3, '  moveto');
            Writeln(F, X1 : 3, '  ', Y2 : 3, '  lineto');
            Writeln(F, X2 : 3, '  ', Y2 : 3, '  lineto');
            Writeln(F, X2 : 3, '  ', Y1 : 3, '  lineto');
            Writeln(F, 'closepath');
            Writeln(F, 'stroke');
            Writeln(F, 'newpath');
          end;

        if yScale = true then
          begin {Do the yScale}
 {...............................................................................................}

            if yMin * yMax >= 0 then
              begin {yMin, yMax > or yMin, yMax < 0}

                if yMax < 0 then
                  begin
                    sign := -1;
                    nearBound := yMax;
                    farBound := yMin;
                  end
                else
                  begin
                    sign := 1;
                    nearBound := yMin;
                    farBound := yMax
                  end;

                if ((farBound - nearBound) / farBound) < 0.3 then
                  begin {small boundRange}

                    nearBound := nearBound - sign * (0.2 * yRange);
                    farBound := farBound + sign * (0.2 * yRange);
                    if sign = 1 then
                      begin
                        yUB := farBound;
                        yLB := nearBound
                      end
                    else
                      begin
                        yLB := farBound;
                        yUB := nearBound
                      end;

                    boundRange := Abs(farBound - nearBound);

                    TallyPoints(boundRange, taly);
                    startMark := Trunc(nearBound / taly) * taly;
                    if (Abs((startMark - nearBound) / nearBound) > 0.0001) then
                      startMark := startMark + sign * taly;

                    if sign = 1 then
                      Ycap := Y1
                    else
                      Ycap := Y2;

                    FIRSTHATCH := Ycap + (startMark - nearBound) * BOXHGT / boundRange;
                  end {small boundRange}
                else{large boundRange}
                  begin {yMin = 0.0}

                    if yMax > 0 then
                      begin
                        farBound := 1.2 * yMax;
                        yUB := farBound;
                        yLB := 0.0;
                      end
                    else
                      begin
                        farBound := 1.2 * yMin;
                        yUB := 0.0;
                        yLB := farbound;
                      end;

                     if sign = 1 then
                       YCap := Y1
                     else
                       Ycap := Y2;

                    boundRange := Abs(farBound);
                    TallyPoints(boundRange, taly);
                    startMark := 0.0;
                    FIRSTHATCH := Ycap;
                  end; {large boundRange}

                vSTEP := taly * (BOXHGT / boundRange);
                hSTEP := 0.0;
                if doMarks then
                  PostMarks(F, X1, firstHATCH, sign * taly, startMark, farBound, sign * vSTEP, 'yScale')

              end;{yMin, yMax > or yMin, yMax < 0}
{...............................................................................................}

            if (yMin < 0.0) and (yMax > 0.0) then
              begin {yMin < 0.0}
                ryPos := yMax;
                ryNeg := yMin;

                increment := 0.1 * (yMax - yMin);
                if yMax > Abs(yMin) then
                  begin
                    ryPos := 1.2 * yMax;
                    ryNeg := yMin - increment;
                  end
                else
                  begin
                    ryNeg := 1.2 * yMin;
                    ryPos := yMax + increment
                  end;
                yUB := ryPos;
                yLB := ryNeg;

                Y0 := Y1 - Round(BOXHGT * ryNeg / (ryPos - ryNeg));
{this draws the horizontal axis through y = 0}

                if (xScale = true) or (xAxis = true) then
                  begin
                    Writeln(F, X1 : 3, '  ', Y0 : 3, '  moveto');
                    Writeln(F, X2 : 3, '  ', Y0 : 3, '  lineto');
                    Writeln(F, 'stroke');
                    Writeln(F, 'newpath');
                  end;

                if ryPos > Abs(ryNeg) then
                  begin
                    TallyPoints(ryPos, taly);
                    vSTEP := (Y2 - Y0) * (taly / ryPos);
                  end
                else {if ryPos < Abs(ryNeg)}
                  begin
                    TallyPoints(-ryNeg, taly);
                    vSTEP := (Y1 - Y0) * taly / ryNeg;
                  end;

                hSTEP := 0.0;
                if doMarks then
                  begin {doMarks}
                    PostMarks(F, X1, Y0, taly, 0.0, ryPos, vSTEP, 'yScale');
                    PostMarks(F, X1, Y0, -taly, 0.0, ryNeg, -vSTEP, 'yScale');
                  end; {doMarks}

              end; {yMin < 0.0 and yMax > 0.0}
  {...............................................................................................}
            {yRange := yUB - LB;}

            Writeln(F, 'stroke');
            Writeln(F, 'newpath')

          end; {Do the yScale}
{------------------------------------------------------}

        if xScale then
          begin {Do the xScale}

  {...............................................................................................}

            if (xMin <= 0.0) and (xMax >= 0) then
              begin {xMin <= 0.0}
                rxPos := xMax;
                rxNeg := xMin;

                if (xMin < 0.0) then
                  X0 := X1 - Round(BOXWDT * rxNeg / (rxPos - rxNeg))
                else
                  X0 := X1;

                if (xMin < 0.0) and (yScale = true) then
                  begin  {This provides the vertical axis through x =0}
                    Writeln(F, X0 : 3, '  ', Y1 : 3, '  moveto');
                    Writeln(F, X0 : 3, '  ', Y2 : 3, '  lineto');
                    Writeln(F, 'stroke');
                    Writeln(F, 'newpath');
                  end;

                if rxPos > Abs(rxNeg) then
                  begin
                    TallyPoints(rxPos, taly);
                    hSTEP := (X2 - X0) * (taly / rxPos);
                  end
                else
                  begin
                    TallyPoints(-rxNeg, taly);
                    hSTEP := (X1 - X0) * (taly / rxNeg);
                  end;

                vSTEP := 0;
                if doMarks then
                  begin
                    PostMarks(F, X0, Y1, taly, 0, rxPos, hSTEP, 'xScale');
                    PostMarks(F, X0, Y1, -taly, 0, rxNeg, -hSTEP, 'xScale');
                  end;

              end; {xMin <= 0.0 and xMax >= 0}

  {...............................................................................................}

            if xMin * xMax > 0.0 then
              begin {xMin, xMax < 0 or xMin, xMax >0}
                sign := 1;
                if xMax < 0 then
                  sign := -1;

                TallyPoints(xRange, taly);
                if xMin > 0 then
                  begin
                    farBound := xMax;
                    nearBound := xMin;
                  end;
                if xMax < 0 then
                  begin
                    farBound := xMin;
                    nearBound := xMax;
                  end;

                startMark := Trunc(nearBound / taly) * taly;
                if (Abs((startMark - nearBound) / nearBound) > 0.001) then
                  startMark := startMark + sign * taly;
                hSTEP := (BOXWDT) * (taly / xRange);
                vSTEP := 0.0;
                if sign = 1 then
                  firstHATCH := X1 + ((startMark - xMin) * BOXWDT) / xRange
                else
                  firstHATCH := X2 - ((xMax - startMark) * BOXWDT) / xRange;
                PostMarks(F, firstHATCH, Y1, sign * taly, startMark, farBound, sign * hSTEP, 'xScale');
              end;

  {...............................................................................................}

            Writeln(F, 'stroke');
            Writeln(F, 'newpath');


          end; {Do the xScale}

{------------------------------------------------------}

        xRange := xMax - xMin;
        yRange := yUB - xLB;

      end; {with POSTBOX, dataBOX}

  end; {PostFrame: PostScript Framework}

{________________________________________________}

  procedure PostVertAxis (var F: textFile;
                  XSTART, YSTART: integer;
                  taly, firstMark, farBound, VSTEP: real);

    var
      toly, HR, VT: real;
      tolyString: string;

  begin {PostVertAxis}

    toly := firstMark;
    HR := XSTART;
    VT := YSTART;

    while Abs(toly) <= Abs(farBound) do
      begin
        tolyString := TalyToString(toly);
        Writeln(F, HR : 3 : 2, '  ', VT : 3 : 2, '  (', tolyString, ') showyhatch');
        VT := VT + VSTEP;
        toly := toly + taly;
      end;

  end; {PostVertAxis}

{_________________________________________________}

  procedure PostZeroPiAxis (var F: textFile;
                  var POSTBOX: IBOX);

    var
      XR, YT, BOXWDT: real;

  begin{ZeroPiAxis}
    BOXWDT := POSTBOX.X2 - POSTBOX.X1;

    XR := POSTBOX.X1;
    YT := POSTBOX.Y1; {type conversion}
    Writeln(F, XR : 5 : 2, '  ', YT : 5 : 2, '  (0) showxhatch');

    XR := POSTBOX.X1 + BOXWDT / 4;
    Writeln(F, XR : 5 : 2, '  ', YT : 5 : 2, '  (p/4) showxhatch');

    XR := POSTBOX.X1 + BOXWDT / 2;
    Writeln(F, XR : 5 : 2, '  ', YT : 5 : 2, '  (p/2) showxhatch');

    XR := POSTBOX.X2 - BOXWDT / 4;
    Writeln(F, XR : 5 : 2, '  ', YT : 5 : 2, '  (3p/4) showxhatch');

    XR := POSTBOX.X2;
    Writeln(F, XR : 5 : 2, '  ', YT : 5 : 2, '  (p) showxhatch');
    Writeln(F, 'stroke');
    Writeln(F, 'newpath');

  end;{PostZeroPiAxis}

{______________________________________________________________________________}

      procedure PostDoDecAxis (var F: textFile;
                      var POSTBOX: IBOX);

        var
          XR, YT, BOXWDT: real;

      begin{ZeroPiAxis}
        BOXWDT := POSTBOX.X2 - POSTBOX.X1;

        XR := POSTBOX.X1;
        YT := POSTBOX.Y1; {type conversion}
        Writeln(F, XR : 5 : 2, '  ', YT : 5 : 2, '  (0) showxhatch');

        XR := POSTBOX.X1 + BOXWDT / 6;
        Writeln(F, XR : 5 : 2, '  ', YT : 5 : 2, '  (p/6) showxhatch');

        XR := POSTBOX.X1 + BOXWDT / 3;
        Writeln(F, XR : 5 : 2, '  ', YT : 5 : 2, '  (p/3) showxhatch');

        XR := POSTBOX.X2 - BOXWDT / 2;
        Writeln(F, XR : 5 : 2, '  ', YT : 5 : 2, '  (p/2) showxhatch');

        XR := POSTBOX.X2 - BOXWDT / 3;
        Writeln(F, XR : 5 : 2, '  ', YT : 5 : 2, '  (2p/3) showxhatch');

        XR := POSTBOX.X2 - BOXWDT / 6;
        Writeln(F, XR : 5 : 2, '  ', YT : 5 : 2, '  (5p/6) showxhatch');

        XR := POSTBOX.X2;
        Writeln(F, XR : 5 : 2, '  ', YT : 5 : 2, '  (p) showxhatch');
        Writeln(F, 'stroke');
        Writeln(F, 'newpath');

      end;{PostPostDoDecAxis}

     {_________________________________________________}

  procedure PostFrameLite (var F: textFile;
                  var realBOX: rBOX;
                  var POSTBOX: IBOX);

    var
      VSTEP, taly: real;

  begin{PostFrameLite}

    with POSTBOX, realBOX do
      begin {with}
        Writeln(F, '/Symbol findfont');
        Writeln(F, '10 scalefont  setfont');
        Writeln(F, X1 : 2, '  ', Y1 : 2, ' moveto ');
        Writeln(F, X1 : 2, '  ', Y2 : 3, '  lineto');
        Writeln(F, X2 : 3, '  ', Y2 : 3, '  lineto');
        Writeln(F, X2 : 2, '  ', Y1 : 3, '  lineto');
        Writeln(F, 'closepath');
        Writeln(F, 'stroke');
        Writeln(F, 'newpath');

        yLB := 0.0;
        yUB := 1.2 * yMax;

        Tallypoints(yUB, taly);
        VSTEP := taly * (BOXHGT / yUB);

        X0 := X1;
        Y0 := Y1;

        PostVertAxis(F, X0, Y1, taly, yLB, yUB, VSTEP);
        Writeln(F, 'stroke');
        Writeln(F, 'newpath');

        xRange := xMax - xMin;
        yRange := yUB - yLB;

      end; {with POSTBOX, realBOX}

  end; {PostFrameLite}

{______________________________________________________________________________}

 procedure PostPlot (var F: textFile;
                  var realBOX: rBOX;
                  var POSTBOX: IBOX;
                  var dataVector: longVector);
  {This procedure is for plotting a sequence of NOPUNCT data points}

    var
      i: integer;
      HR, VT, xFactor, yFactor: real;

  begin
    with POSTBOX, realBOX do
      begin {with}
        yRange :=  yUB - yLB;
        yFactor := BOXHGT / yRange;
        {xFactor := BOXWDT / xRange;}
        xFactor := BOXWDT/(NOPUNCT-1);

        for i := 0 to NOPUNCT - 1 do
          begin {i}
            HR := X1 + i * xFactor;
            VT := Y1 + yFactor * (dataVector[i] - yLB);
            if i = 0 then
              Writeln(F, HR : 3 : 2, '  ', VT : 3 : 2, '   moveto')
            else
              Writeln(F, HR : 3 : 2, '  ', VT : 3 : 2, '   lineto');
          end; {i}

        Writeln(F, 'stroke');
        Writeln(F, 'newpath');

      end; {with POSTBOX, dataBOX}

  end; {PostPlot}

{_________________________________________________}

  procedure PostPlotMod (var F: textFile;
                  var realBOX: rBOX;
                  var POSTBOX: IBOX;
                  var dataVector: longVector);

 {This procedure is for plotting a sequence of BOXWDT data points}

    var
      i: integer;
      HR, VT, yFactor : real;

  begin

  with POSTBOX, realBOX do
    begin {with}
      yRange := yUB - yLB;
      yFactor := BOXHGT/yRange;

      for i := 0 to BOXWDT do
        begin {i}
          HR := X0 + i;
          VT := Y1 + (dataVector[i] - yLB) * yFactor;
          if i = 0 then
            Writeln(F, HR : 5 : 2, '  ', VT : 5 : 2, '  moveto')
          else
            Writeln(F, HR : 5 : 2, '  ', VT : 5 : 2, '  lineto');
        end; {i}
      Writeln(F, 'stroke');

   end; {with POSTBOX, dataBOX}

  end; {PostPlotMod}

{_________________________________________________}

   procedure PostBiPlot (var F: textFile;
                   var realBOX: rBOX;
                   var POSTBOX: IBOX;
                   var dataVector: pointsVector);
     var
       i: integer;
       HR, VT, xFactor, yFactor: real;

   begin
     with POSTBOX, realBOX do
       begin {with}
         yRange := yUB - yLB;
         xFactor := BOXWDT / xRange;
         yFactor := BOXHGT / yRange;

         for i := 0 to realBOX.NOPUNCT - 1 do
         begin {i}
           HR := X1 +  dataVector[i].x * xFactor;
           VT := Y1 + (dataVector[i].y - yLB)* yFactor;
           if i = 0 then
             Writeln(F, HR : 3 : 2, '  ', VT : 3 : 2, '   moveto')
           else
             Writeln(F, HR : 3 : 2, '  ', VT : 3 : 2, '   lineto');
         end; {i}
      Writeln(F, 'stroke');
      Writeln(F, 'newpath');
    end; {with}

   end; {PostBiPlot}

{_________________________________________________________________}

  procedure PostDataPlot (var F: textFile;
                  var plotBOX: rBOX;
                  var plotVector: longVector;
                  var POSTBOX: IBOX;
                  var legend: string);
  begin
    PostHeader(F, POSTBOX, TeXFormat);
    PostFrame(F, plotBOX, POSTBOX);
    PostPlot(F, plotBOX, POSTBOX, plotVector);
    PostFooter(F, POSTBOX, legend, TexFormat);
  end; {PostDataPlot}

{_______________________________________________________________________}

  procedure PostSpectraPlot (var F: textFile;
                  var plotBOX: rBOX;
                  var plotVector: longVector;
                  var POSTBOX: IBOX;
                  var legend: string);

  begin

    PostHeader(F, POSTBOX, TeXFormat);
    POSTBOX.xScale := false;
    PostFrame(F, plotBOX, POSTBOX);
    PostZeroPiAxis (F, POSTBOX);
    PostPlotMod(F, plotBOX, POSTBOX, plotVector);
    PostFooter(F, POSTBOX, legend, TexFormat);
    POSTBOX.xScale := true;

  end; {PostSpectra}

{_________________________________________________________________}

  procedure PostOverPlot (var F: textFile;
                  var dataBox: rBOX;
                  var dataVector, trendVector: longVector;
                  var POSTBOX: IBOX;
                  var legend: string);
  begin
    PostHeader(F, POSTBOX, TeXFormat);
    PostFrame(F, dataBOX, POSTBOX);
    PostPlot(F, dataBOX, POSTBOX, dataVector);
    PostPlot(F, dataBOX, POSTBOX, trendVector);
    PostFooter(F, POSTBOX, legend, TexFormat);
  end; {PostOverPlot}

{_________________________________________________________________}

  procedure PostDashedLine(var F: textFile;
                  var TVert: integer;
                  var POSTBOX: IBOX);
  var
    HR, VT1, VT2: integer;

  begin
   Writeln(F, '[3 3] 0 setdash');
   HR := POSTBOX.X1 +Round(Tvert * POSTBOX.BOXWDT/180.0);
   VT1 := POSTBOX.Y1;
   VT2 := POSTBOX.Y2;
   Writeln(F, HR : 3, '  ', VT1 : 3, '   moveto');
   Writeln(F, HR : 3, '  ', VT2 : 3, '   lineto');
   Writeln(F, 'stroke');
   Writeln(F, 'newpath');
   Writeln(F, '[] 0 setdash');


  end;  {PostDashedLine}

{_________________________________________________________________}

end. {POSTSCRIPT: Unit of SEASCAPE.PAS}

