unit Ustopbands; {unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  GLOBALS;

type

  { TFstopbands }

  TFstopbands = class(TForm)
    BtnRETURN: TButton;
    BtnPROCEED: TButton;
    {--------------}
    EdtUt30: TEdit;
    EdtUt60: TEdit;
    EdtUt90: TEdit;
    EdtUt120: TEdit;
    EdtUt150: TEdit;
    EdtUt180: TEdit;
    {--------------}
    EdtUs30: TEdit;
    EdtUs60: TEdit;
    EdtUs90: TEdit;
    EdtUs120: TEdit;
    EdtUs150: TEdit;
    EdtUs180: TEdit;
    {--------------}
    EdtLs30: TEdit;
    EdtLs60: TEdit;
    EdtLs90: TEdit;
    EdtLs120: TEdit;
    EdtLs150: TEdit;
    EdtLs180: TEdit;
    {--------------}
    EdtLt30: TEdit;
    EdtLt60: TEdit;
    EdtLt90: TEdit;
    EdtLt120: TEdit;
    EdtLt150: TEdit;
    EdtLt180: TEdit;
    {--------------}
    LblSeasonalFreq: TLabel;
    LblUpperTransition: TLabel;
    LblRightSideStopS: TLabel;
    LblLeftSideStop: TLabel;
    LblLowerTransition: TLabel;
    StaticText1: TStaticText;
    TitleLabel: TLabel;
    procedure BtnPROCEEDClick(Sender: TObject);
    procedure BtnRETURNClick(Sender: TObject);
    {-------------------------------------------------------}
    procedure EdtLs30KeyPress(Sender: TObject; var Key: char);
    procedure EdtLs60KeyPress(Sender: TObject; var Key: char);
    procedure EdtLs90KeyPress(Sender: TObject; var Key: char);
    procedure EdtLs120KeyPress(Sender: TObject; var Key: char);
    procedure EdtLs150KeyPress(Sender: TObject; var Key: char);
    procedure EdtLs180KeyPress(Sender: TObject; var Key: char);
    {-------------------------------------------------------}
    procedure EdtLt30KeyPress(Sender: TObject; var Key: char);
    procedure EdtLt60KeyPress(Sender: TObject; var Key: char);
    procedure EdtLt90KeyPress(Sender: TObject; var Key: char);
    procedure EdtLt120KeyPress(Sender: TObject; var Key: char);
    procedure EdtLt150KeyPress(Sender: TObject; var Key: char);
    procedure EdtLt180KeyPress(Sender: TObject; var Key: char);
    {--------------------------------------------------------}
    procedure EdtUs30KeyPress(Sender: TObject; var Key: char);
    procedure EdtUs60KeyPress(Sender: TObject; var Key: char);
    procedure EdtUs90KeyPress(Sender: TObject; var Key: char);
    procedure EdtUs120KeyPress(Sender: TObject; var Key: char);
    procedure EdtUs150KeyPress(Sender: TObject; var Key: char);
    procedure EdtUs180KeyPress(Sender: TObject; var Key: char);
    {---------------------------------------------------------}
    procedure EdtUt30KeyPress(Sender: TObject; var Key: char);
    procedure EdtUt60KeyPress(Sender: TObject; var Key: char);
    procedure EdtUt90KeyPress(Sender: TObject; var Key: char);
    procedure EdtUt120KeyPress(Sender: TObject; var Key: char);
    procedure EdtUt150KeyPress(Sender: TObject; var Key: char);
    procedure EdtUt180KeyPress(Sender: TObject; var Key: char);
    {---------------------------------------------------------}
    procedure EdtUt30Change(Sender: TObject);
    procedure EdtUt60Change(Sender: TObject);
    procedure EdtUt90Change(Sender: TObject);
    procedure EdtUt120Change(Sender: TObject);
    procedure EdtUt150Change(Sender: TObject);
    procedure EdtUt180Change(Sender: TObject);
    {---------------------------------------------------------}
    procedure EdtUs30Change(Sender: TObject);
    procedure EdtUs60Change(Sender: TObject);
    procedure EdtUs90Change(Sender: TObject);
    procedure EdtUs120Change(Sender: TObject);
    procedure EdtUs150Change(Sender: TObject);
    procedure EdtUs180Change(Sender: TObject);
    {---------------------------------------------------------}
    procedure EdtLs30Change(Sender: TObject);
    procedure EdtLs60Change(Sender: TObject);
    procedure EdtLs90Change(Sender: TObject);
    procedure EdtLs120Change(Sender: TObject);
    procedure EdtLs150Change(Sender: TObject);
    procedure EdtLs180Change(Sender: TObject);
    {---------------------------------------------------------}
    procedure EdtLt30Change(Sender: TObject);
    procedure EdtLt60Change(Sender: TObject);
    procedure EdtLt90Change(Sender: TObject);
    procedure EdtLt120Change(Sender: TObject);
    procedure EdtLt150Change(Sender: TObject);
    procedure EdtLt180Change(Sender: TObject);
    {---------------------------------------------------------}
    procedure FormActivate(Sender: TObject);
  private

  public

  end;

var
  Fstopbands: TFstopbands;
  alpha, beta: FourierVec;


implementation
 uses
   UTILS, FREQFILT, DATASEG, LEGENDS, uplotscreen, LCLType;

{$R *.lfm}

{ TFstopbands }

{______________________________________________________________________________}

procedure TFstopbands.FormActivate(Sender: TObject);

begin

  monthStopVisit := true;

  if seasChange then
  MakeCleftArray (seaCleft, seaFreq, filterSpec);
  seasChange := false;

  EdtUt180.Enabled := False;
  EdtUs180.Enabled := False;


  {filterSpec.seasonality := Monthly;}  {REDUNDANT}

  {if (monthStopVisit = false)  then
    begin
      MakeCleftArray (seaCleft, seaFreq, filterSpec); {on the first visit only}
      monthStopVisit := true;
    end;}

  EdtLt30.text := intToStr(seaCleft[1].Lt);
  EdtLs30.text := intToStr(seaCleft[1].Ls);
  EdtUs30.text := intToStr(seaCleft[1].Us);
  EdtUt30.text := intToStr(seaCleft[1].Ut);

  EdtLt60.text := intToStr(seaCleft[2].Lt);
  EdtLs60.text := intToStr(seaCleft[2].Ls);
  EdtUs60.text := intToStr(seaCleft[2].Us);
  EdtUt60.text := intToStr(seaCleft[2].Ut);

  EdtLt90.text := intToStr(seaCleft[3].Lt);
  EdtLs90.text := intToStr(seaCleft[3].Ls);
  EdtUs90.text := intToStr(seaCleft[3].Us);
  EdtUt90.text := intToStr(seaCleft[3].Ut);

  EdtLt120.text := intToStr(seaCleft[4].Lt);
  EdtLs120.text := intToStr(seaCleft[4].Ls);
  EdtUs120.text := intToStr(seaCleft[4].Us);
  EdtUt120.text := intToStr(seaCleft[4].Ut);

  EdtLt150.text := intToStr(seaCleft[5].Lt);
  EdtLs150.text := intToStr(seaCleft[5].Ls);
  EdtUs150.text := intToStr(seaCleft[5].Us);
  EdtUt150.text := intToStr(seaCleft[5].Ut);

  EdtLt180.text := intToStr(seaCleft[6].Lt);
  EdtLs180.text := intToStr(seaCleft[6].Ls);
  {EdtUs180.text := intToStr(seaCleft[6].Mc);}
  {EdtUt180.text := intToStr(seaCleft[6].Md);}

  if filterSpec.profile = Notransition then
  begin
    EdtUt30.text := '';
    EdtUt60.text := '';
    EdtUt90.text := '';
    EdtUt120.text := '';
    EdtUt150.text := '';
    EdtUt180.text := '';
    EdtLt30.text := '';
    EdtLt60.text := '';
    EdtLt90.text := '';
    EdtLt120.text := '';
    EdtLt150.text := '';
    EdtLt180.text := '';
    {-------------------------}
    EdtUt30.Enabled := False;
    EdtUt60.Enabled := False;
    EdtUt90.Enabled := False;
    EdtUt120.Enabled := False;
    EdtUt150.Enabled := False;
    EdtUt180.Enabled := False;
    EdtLt30.Enabled := False;
    EdtLt60.Enabled := False;
    EdtLt90.Enabled := False;
    EdtLt120.Enabled := False;
    EdtLt150.Enabled := False;
    EdtLt180.Enabled := False;
  end;

end;  {FormActivate}

{______________________________________________________________________________}

procedure TFstopbands.BtnRETURNClick(Sender: TObject);
begin
  Close;
end; {BtnRETURNClick}
{______________________________________________________________________________}
 
procedure TFstopbands.EdtLt30KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLt30KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtLt60KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLt60KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtLt90KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end; {EdtLt90KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtLt120KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLt120KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtLt150KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLt150KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtLt180KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLt180KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtLs30KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLs30KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtLs60KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLs60KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtLs90KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLs90KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtLs120KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLs120KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtLs150KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLs150KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtLs180KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtLs180KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtUs30KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end; {EdtUs30KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtUs60KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end; {EdtUs60KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtUs90KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end; {EdtUs90KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtUs120KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end; {EdtUs120KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtUs150KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end; {EdtUs150KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtUs180KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end; {EdtUs180KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtUt30KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end; {EdtUt30KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtUt60KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end; {EdtUt60KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtUt90KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;   {EdtUt90KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtUt120KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end; {EdtUt120KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtUt150KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end; {EdtUt150KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtUt180KeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8]) then
  begin
    ShowMessage('Enter integer values only');
    key := #0;
  end;
end;  {EdtUt180KeyPress}
{______________________________________________________________________________}

procedure TFstopbands.EdtUt30Change(Sender: TObject);
begin
  if EdtUt30.Enabled and (EdtUt30.text <> '')then
   seaCleft[1].Ut :=  StrToInt(EdtUt30.text);
  seasChange := true;
end;  {EdtUt30Change}

{______________________________________________________________________________}

procedure TFstopbands.EdtUt60Change(Sender: TObject);
begin
  if EdtUt60.Enabled and (EdtUt60.text <> '')then
    seaCleft[2].Ut :=  StrToInt(EdtUt60.text);
  seasChange := true;
end;  {EdtUt60Change}

{______________________________________________________________________________}

procedure TFstopbands.EdtUt90Change(Sender: TObject);
begin
  if EdtUt90.Enabled and (EdtUt90.text <> '')then
    seaCleft[3].Ut :=  StrToInt(EdtUt90.text);
  seasChange := true;
end;  {EdtUt90Change}

{______________________________________________________________________________}


procedure TFstopbands.EdtUt120Change(Sender: TObject);
begin
  if EdtUt120.Enabled and (EdtUt120.text <> '')then
    seaCleft[3].Ut :=  StrToInt(EdtUt120.text);
  seasChange := true;
end;
{EdtUt120Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtUt150Change(Sender: TObject);
begin
  if EdtUt150.Enabled and (EdtUt150.text <> '')then
  seaCleft[5].Ut := StrToInt(EdtUt150.text);
  seasChange := true;
end;
{EdtUt150Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtUt180Change(Sender: TObject);
begin
  {EdtUt180.text := StrToInt(seaCleft[6].Md);}
end;
{EdtUt180Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtUs30Change(Sender: TObject);
begin
 seaCleft[1].Us :=  StrToInt(EdtUs30.text);
 seasChange := true;

end; {EdtUs30Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtUs60Change(Sender: TObject);
begin
  seaCleft[2].Us :=  StrToInt(EdtUs60.text);
  seasChange := true;
end;  {EdtUs60Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtUs90Change(Sender: TObject);
begin
  seaCleft[3].Us :=  StrToInt(EdtUs90.text);
  seasChange := true;
end;  {EdtUs90Change}

{______________________________________________________________________________}

procedure TFstopbands.EdtUs120Change(Sender: TObject);
begin
  seaCleft[4].Us :=  StrToInt(EdtUs120.text);
  seasChange := true;
end;  {EdtUs120Change}

{______________________________________________________________________________}

procedure TFstopbands.EdtUs150Change(Sender: TObject);
begin
 seaCleft[5].Us :=  StrToInt(EdtUs150.text);
 seasChange := true;
end;
{EdtUs150Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtUs180Change(Sender: TObject);
begin
 {seaCleft[6].Mc :=  StrToFloat(EdtUs180.text);}
end;
{EdtUs180Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtLs30Change(Sender: TObject);
begin
  seaCleft[1].Ls :=  StrToInt(EdtLs30.text);
  seasChange := true;
end;  {EdtLs30Change}

{______________________________________________________________________________}

procedure TFstopbands.EdtLs60Change(Sender: TObject);
begin
  seaCleft[2].Ls :=  StrToInt(EdtLs60.text);
  seasChange := true;
end;  {EdtLs60Change}

{______________________________________________________________________________}

procedure TFstopbands.EdtLs90Change(Sender: TObject);
begin
  seaCleft[3].Ls :=  StrToInt(EdtLs90.text);
  seasChange := true;
end;  {EdtLs90Change}

{______________________________________________________________________________}

procedure TFstopbands.EdtLs120Change(Sender: TObject);
begin
  seaCleft[4].Ls :=  StrToInt(EdtLs120.text);
  seasChange := true;
end;  {EdtLs120Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtLs150Change(Sender: TObject);
begin
 seaCleft[5].Ls :=  StrToInt(EdtLs150.text);
 seasChange := true;
end; {EdtLs150Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtLs180Change(Sender: TObject);
begin
 seaCleft[6].Ls :=  StrToInt(EdtLs180.text);
 seasChange := true;
end;  {EdtLs180Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtLt30Change(Sender: TObject);
begin
 if EdtLt30.Enabled and (EdtLt30.text <> '') then
   seaCleft[1].Lt := StrToInt(EdtLt30.text);
 seasChange := true;
end;  {EdtLt30Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtLt60Change(Sender: TObject);
begin
  if EdtLt60.Enabled and (EdtLt60.text <> '') then
    seaCleft[2].Lt :=  StrToInt(EdtLt60.text);
 seasChange := true;
end; {EdtLt60Change}

{______________________________________________________________________________}

procedure TFstopbands.EdtLt90Change(Sender: TObject);
begin
  if EdtLt90.Enabled and (EdtLt90.text <> '')then
    seaCleft[3].Lt :=  StrToInt(EdtLt90.text);
 seasChange := true;
end; {EdtLt90Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtLt120Change(Sender: TObject);
begin
  if EdtLt120.Enabled and (EdtLt120.text <> '') then
    seaCleft[4].Lt :=  StrToInt(EdtLt120.text);
  seasChange := true;
end;  {EdtLt120Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtLt150Change(Sender: TObject);
begin
  if EdtLt150.Enabled and (EdtLt150.text <> '') then
    seaCleft[5].Lt :=  StrToInt(EdtLt150.text);
  seasChange := true;
end;  {EdtLt150Change}
{______________________________________________________________________________}

procedure TFstopbands.EdtLt180Change(Sender: TObject);
begin
  if EdtLt180.Enabled and (EdtLt180.text <> '') then
  seaCleft[6].Lt :=  StrToInt(EdtLt180.text);
  seasChange := true;
end;  {EdtLt180Change}
{______________________________________________________________________________}

procedure BandConversions(var seaCleft, seaFreq : cleftArray);

  var j : integer;
    pi, radiansPerDegree, seasHarmonic: real;

begin

   {SHOWMESSAGE('  WE ARE WITHIN BandConversions ');}

    pi := 4.0 * ArcTan(1.0);
    radiansPerDegree := pi / 180.0;

    {SHOWMESSAGE(' seaCleft[3].Ls = ' + IntToStr(seaCleft[3].Ls));}

  for j := 1 to 6 do
    begin
      seasHarmonic := 30 * j;
      seaCleft[j].Ma := seasHarmonic - seaCleft[j].Ls - seaCleft[j].Lt;
      seaCleft[j].Mb := seaCleft[j].Ma + seaCleft[j].Lt;
      seaCleft[j].Mc := seaCleft[j].Mb  + seaCleft[j].Ls + seaCleft[j].Us;
      seaCleft[j].Md := seaCleft[j].Mc + seaCleft[j].Ut;
      end;

  for j := 1 to 6 do
    begin
      seaFreq[j].Ma := seaCleft[j].Ma * radiansPerDegree;
      seaFreq[j].Mb := seaCleft[j].Mb * radiansPerDegree;
      seaFreq[j].Mc := seaCleft[j].Mc * radiansPerDegree;
      seaFreq[j].Md := seaCleft[j].Md * radiansPerDegree;
    end;

end; {BandConversions}
{______________________________________________________________________________}

{THIS COULD GO into FREQFILTS to serve both Monthly and Quarterly}

procedure TFstopbands.BtnPROCEEDClick(Sender: TObject);

var
  t:integer;

begin
  if seasChange = true then
    BandConversions(seaCleft, seaFreq);

  {if seasChange = true then
    SHOWMESSAGE('  seasChange = true'); }


  if filterSpec.profile = noTransition then    {in FREQFILT}
    NoTransitionsResponse(seaCleft, filterSpec, spectraBOX, spectraVec, SCREENBOX, POSTBOX);

  if filterSpec.profile = upperHalfCosine then  {in FREQFILT}
    UpperCosineResponse(seaCleft, filterSpec, spectraBOX, spectraVec, SCREENBOX, POSTBOX);

  if filterSpec.profile = lowerHalfCosine then  {in FREQFILT}
    LowerCosineResponse(seaCleft, filterSpec, spectraBOX, spectraVec, SCREENBOX, POSTBOX);

  if filterSpec.profile = Sigmoid then   {in FREQFILT}
    SigmoidResponse(seaCleft, filterSpec, spectraBOX, spectraVec, SCREENBOX, POSTBOX);

  if  doSeasonalAdjustment then
    begin
      SlowFourier (residueBOX, residueVec, alpha, beta);
      MakeThePeriodogram (residueBOX, plotBOX, plotVector, alpha, beta);
   end;


    if  (doSeasonalAdjustment = true) then
    begin
      legend := PdgramAndResponse(filterSpec);
      graphType :=  backgroundPlot;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
     end
  else
    begin
      legend := SeasFreqFiltGain(filterSpec);
      graphType := spectraGraph;
      plotBOX := spectraBOX;
      plotVector := spectraVec;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
    end;

    if  (doSeasonalAdjustment = true) then
       begin {Seasonal Component}
         ScaleTheFourierOrdinates (filterSpec, residueBOX, alpha, beta);
         FourierSynthesis(residueBOX, adjustedVec, alpha, beta);
         for t := 0 to residueBOX.NOPUNCT-1 do
           seasonVec[t] := residueVec[t] - adjustedVec[t];
         seasonBOX := residueBOX;
         MakeDataBox(seasonBOX, seasonVec);
         {+++++++++++++++++++++++++++++++++++++++++}
         plotVector := seasonVec;
         plotBOX := seasonBOX;
         legend := SeasonalComponent (dataBOX,dataName);
         graphType :=  dataGraph;
         Fplotscreen := TFplotscreen.Create(Nil);
         Fplotscreen.ShowModal;
         FreeAndNil(Fplotscreen);
         {Seasonal Component}
         weHaveSeasonalComponent := true;
         {+++++++++++++++++++++++++++++++++++++++++}
         SubtractComponent (dataBOX, adjustedBOX, dataVector, seasonVec, adjustedVec);
         if weHavePolyResiduals or weHaveTrendCycleResiduals then
           begin {Seasonally Adjusted Data: Twofold or Threefold Decomposition}
             legend := DeSeasonalisedOverlay (dataBOX, dataName);
             graphType := seasonsGraph;
             Fplotscreen := TFplotscreen.Create(Nil);
             Fplotscreen.ShowModal;
             FreeAndNil(Fplotscreen);
             weHaveSeasonallyAdjustedData := true;
           end;  {Seasonally Adjusted Data: Twofold or Threefold Decomposition}

         if weHaveATrendCycle then
           begin  {ThreefoldDecomposition}
             {legend := TrendAndCycle (dataBOX, dataName);}
             legend := TrendCycleInThree;
             graphType :=  dataOverPlotGraph;
             Fplotscreen := TFplotscreen.Create(Nil);
             Fplotscreen.ShowModal;
             FreeAndNil(Fplotscreen);
             {----------------------}
             {legend := AdjustedTrendResiduals;}
             legend := ResidualsInThree;
             graphType := dataGraph;
             plotBOX := dataBOX;
             SubtractComponent (dataBOX, plotBOX, adjustedVec, trendVector, plotVector);
             Fplotscreen :=TFplotScreen.Create(Nil);
             Fplotscreen.ShowModal;
             FreeAndNil(Fplotscreen);
           end;  {ThreefoldDecomposition}

       end;

  end; {BtnPROCEEDClick}
{______________________________________________________________________________}

end.   {Ustopbands: unit of SEASCAPE.PAS}
