unit Usaveandexit;  {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls, GLOBALS;

type

  { TFsaveandexit }

  TFsaveandexit = class(TForm)
    BtnRETURN: TButton;
    BtnCLOSE: TButton;
    Lblpagetitle: TLabel;
    ListBox: TListBox;
    SaveDialog: TSaveDialog;
    StaticText: TStaticText;
    procedure BtnCLOSEClick(Sender: TObject);
    procedure BtnRETURNClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
  private

  public

  end;

var
  Fsaveandexit: TFsaveandexit;
  dataItem, trendItem, cycleItem, seasonalItem, adjustedItem, residualsItem, adjustedResidualsItem: integer;
  proceed: boolean = false;
  F:textFile;


implementation

uses
  UTILS, DATASEG;

  {procedure TFsaveandexit.FormActivate(Sender: TObject);}

  {procedure TFsaveandexit.ListBoxClick(Sender: TObject);}

{$R *.lfm}

{ TFsaveandexit }

{______________________________________________________________________________}

procedure TFsaveandexit.FormActivate(Sender: TObject);

 begin
   dataItem := 99;
   trendItem := 99;
   cycleItem := 99;
   seasonalItem := 99;
   residualsItem := 99;
   adjustedResidualsItem := 99;
   ListBox.ItemIndex := -1;


  if thereIsData then
   begin
     ListBox.Items.Add('d. Save the Data');
     ListBox.Items.Add('');
     ListBox.ItemIndex := 0;
     dataItem :=  ListBox.ItemIndex;
     {SHOWMESSAGE(' THERE iS DATA');}
   end;
  {elseS SHOWMESSAGE(' THERE iS NO DATA');}

  if weHaveATrendCycle then
   begin
     ListBox.Items.Add('t. Save the Trend-Cycle');
     ListBox.Items.Add('');
     ListBox.ItemIndex := ListBox.ItemIndex +2;
     trendItem :=  ListBox.ItemIndex;
   end;

  if weHaveACycle then
    begin
      ListBox.Items.Add('c. Save the Cycle');
      ListBox.Items.Add('');
      ListBox.ItemIndex := ListBox.ItemIndex +2;
      cycleItem :=  ListBox.ItemIndex;
    end;

  if weHaveSeasonalComponent then
   begin
     ListBox.Items.Add('s. Save the Seasonal Component');
     ListBox.Items.Add('');
     ListBox.ItemIndex := ListBox.ItemIndex +2;
     seasonalItem :=  ListBox.ItemIndex;
   end;

  if weHavePolyResiduals then
    begin
        Listbox.Items.Add('r. Save the Polynomial Residuals');
        Listbox.Items.Add('');
        Listbox.ItemIndex := Listbox.ItemIndex +2;
        residualsItem := ListBox.ItemIndex;
    end
  else if weHaveACycle then
    begin
        Listbox.Items.Add('r. Save the Trend-cycle Residuals');
        Listbox.Items.Add('');
        Listbox.ItemIndex := Listbox.ItemIndex +2;
        residualsItem := ListBox.ItemIndex;
    end;

   if weHaveSeasonallyAdjustedData then
    begin
      ListBox.Items.Add('a. Save the Seasonally-Adjusted Data');
      ListBox.Items.Add('');
      ListBox.ItemIndex := ListBox.ItemIndex +2;
      adjustedItem :=  ListBox.ItemIndex;
    end;

  if weHaveSeasonallyAdjustedData and  weHaveATrendCycle then
    begin
      ListBox.Items.Add('e. Save the Seasonally-Adjusted Trend Residuals');
      ListBox.Items.Add('');
      ListBox.ItemIndex := ListBox.ItemIndex +2;
      adjustedResidualsItem :=  ListBox.ItemIndex;
    end;

 end;   {FormActivate}

{______________________________________________________________________________}

procedure TFsaveandexit.ListBoxClick(Sender: TObject);

var
  dataFileName: string;
  index : integer;
  i: integer; {TEMP}

  begin
   ListBox := TListBox(Sender);
   index := ListBox.ItemIndex;

   SaveDialog := TsaveDialog.Create(self);
   if saveDialog.Execute  then
     proceed := true
   else
     begin
       ShowMessage('You have opted not to save the file');
       SaveDialog.Free;
     end;


  {------------------------------}

 if (index = dataItem) and proceed then
  begin
    {SHOWMESSAGE('WE ARE SAVING DATA, Tcap = ' + IntToStr(dataBOX.NOPUNCT));}
    {AssignFile(F, 'PERPLEXITY');
     ReWrite(F);
     WRITELN(F, 'IS THER ANYTHING HERE?');
     for i := 1 to 10 do
      WRITELN(F, dataVector[i] : 6:4);
    CloseFile(F);}
    {SaveDialog.Execute;}
    dataFileName := SaveDialog.Filename;
    {SHOWMESSAGE(' the datafileName = ' +  datafileName); }
    SaveDataVector(dataBOX, dataVector, dataFileName);
  end;  {dataItem}

 {------------------------------}

 if (index = trendItem) and proceed then
  begin

    {SaveDialog.Execute; }
    dataFileName := SaveDialog.Filename;
    SaveDataVector(trendBOX, trendVector, dataFileName);
  end;  {trendItem}

 {------------------------------}

 if (index = cycleItem) and proceed then
  begin
    {SaveDialog.Execute;}
    dataFileName := SaveDialog.Filename;
    SaveDataVector(cycleBOX , cycleVec, dataFileName );
  end;  {cycleItem}

 {------------------------------}

 if (index = seasonalItem) and proceed then
  begin
    {SaveDialog.Execute;}
    dataFileName := SaveDialog.Filename;
    SaveDataVector(seasonBOX  , seasonVec, dataFileName);  {in UTILD}
  end;  {seasonalItem}

 {------------------------------}
 if (index = adjustedItem) and proceed then
    begin
      {SaveDialog.Execute;}
      dataFileName := SaveDialog.Filename;
      SaveDataVector(seasonBOX, adjustedVec, dataFileName);
    end;  {seasonalItem}

 {------------------------------}

  if (index = residualsItem) and proceed then
  begin
    {SaveDialog.Execute;}
    dataFileName := SaveDialog.Filename;
    SaveDataVector(residueBOX, residueVec, dataFileName);
  end;   {residualsItem}

  {------------------------------}

  if (index = adjustedResidualsItem) and proceed then
  begin
    SubtractComponent (dataBOX, plotBOX, adjustedVec, trendVector, plotVector);
    {SaveDialog.Execute;}
    dataFileName := SaveDialog.Filename;
    SaveDataVector(residueBOX, plotVector, dataFileName);
  end;   {adjustedResidualsItem}

  {------------------------------}
end;
{______________________________________________________________________________}

procedure TFsaveandexit.BtnRETURNClick(Sender: TObject);
begin
  SaveDialog.Free;
  Close;
end;

{______________________________________________________________________________}

procedure TFsaveandexit.BtnCLOSEClick(Sender: TObject);
begin
  Application.Terminate;
end;
{______________________________________________________________________________}

  {procedure SaveDataVector(dataBOX: rBOX;
                   var dataVector: longvector;
                   var dataFileName: string);

 var
   Q: textFile;
   Tcap, i:integer;

begin
 AssignFile(Q, dataFileName);
 ReWrite(Q);
 SHOWMESSAGE(' the datafileName = ' +  datafileName + '    dataBOX.NOPUNCT =' + IntToStr(dataBOX.NOPUNCT));
 for i := 0 to dataBOX.NOPUNCT -1 do
   Writeln(Q, dataVector[i]: 6:4);

 CloseFile(Q);
end; }

{______________________________________________________________________________}


end.  {Usaveandexit: Unit of SEASCAPE.PAS}





