unit Ureaddata;   {Unit of SEASCAPE.PAS}      {this should be rennamed udataspecs}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  utils, globals;

type

  { TFreaddata }

  TFreaddata = class(TForm)
    BtnRETURN: TButton;
    EditYear: TEdit;
    EditNOPUNCT: TEdit;
    EditDataName: TEdit;
    EditMonthOrQuarter: TEdit;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    LblYearEg: TLabel;
    LblQuartOrMonthEg: TLabel;
    LblMonthOrQuarter: TLabel;
    LblBeginYear: TLabel;
    LblStartDate: TLabel;
    LblNOPUNCT: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    RadioBtnAnnual: TRadioButton;
    RadioBtnMonthly: TRadioButton;
    RadioBtnOther: TRadioButton;
    RadioBtnQuarter: TRadioButton;
    StaticText1: TStaticText;
    procedure BtnRETURNClick(Sender: TObject);
    procedure EditDataNameChange(Sender: TObject);
    procedure EditYearKeyPress(Sender: TObject; var Key: char);
    procedure FormActivate(Sender: TObject);
    procedure RadioBtnAnnualChange(Sender: TObject);
    procedure RadioBtnMonthlyChange(Sender: TObject);
    procedure RadioBtnOtherChange(Sender: TObject);
    procedure RadioBtnQuarterChange(Sender: TObject);
  private

  public

  end;

var
  Freaddata: TFreaddata;
  proceed: boolean;

  procedure CheckTheYear(var startDate: dateRecord;
                   var EditYear: TEdit;
                   var proceed: boolean);

  procedure CheckTheQuarters(var startDate: dateRecord;
                      var EditMonthOrQuarter: TEdit;
                      var proceed: boolean);

  procedure CheckTheMonths(var startDate: dateRecord;
                      var EditMonthOrQuarter: TEdit;
                      var proceed: boolean);

implementation

{$R *.lfm}

{ TFreaddata }
{______________________________________________________________________________}

procedure TFreaddata.BtnRETURNClick(Sender: TObject);
begin

  if dataBOX.dataFrequency  = Other then
    proceed := true;
  if dataBOX.dataFrequency  = Annual then
    CheckTheYear(startDate, EditYear, proceed);
  if dataBOX.dataFrequency  = Quarterly then
    begin
      CheckTheQuarters(startDate, EditMonthOrQuarter, proceed);
      CheckTheYear(startDate, EditYear, proceed);
    end;
   if dataBOX.dataFrequency  = Monthly then
     begin
       CheckTheMonths(startDate, EditMonthOrQuarter, proceed);
       CheckTheYear(startDate, EditYear, proceed);
     end;

   if proceed = true then
      Close;

end;   {BtnRETURNClick}

{______________________________________________________________________________}


procedure TFreaddata.EditDataNameChange(Sender: TObject);
begin
  dataName := EditDataName.text;
  nameStore := dataName;
end;  {EditDataNameChange}

{______________________________________________________________________________}

procedure TFreaddata.EditYearKeyPress(Sender: TObject; var Key: char);
begin
 if not (key in [#0, '0'..'9',#8])  then
    begin
      ShowMessage('Enter numeric values only');
      key := #0;
    end;
end; {EditYearKeyPress}

{______________________________________________________________________________}

procedure TFreaddata.FormActivate(Sender: TObject);
begin
  EditNOPUNCT.Text := IntToStr(dataBOX.NOPUNCT);

  LblStartDate.Enabled := false;
  LblBeginYear.Enabled := false;
  LblYearEg.Enabled := false;
  LblQuartOrMonthEg.Enabled := false;
  LblMonthOrQuarter.Enabled := false;
  LblBeginYear.Enabled := false;
  LblStartDate.Enabled := false;

  LblStartDate.Caption := '';
  LblBeginYear.Caption := '';
  LblYearEg.Caption :=  '';
  lblMonthOrQuarter.Caption := '';
  LblQuartOrMonthEg.Caption := '';
  EditYear.Enabled := false;
  EditMonthorQuarter.Enabled := false;

  dataBOX.dataFrequency := Other;

end;   {FormActivate}

{______________________________________________________________________________}


procedure TFreaddata.RadioBtnAnnualChange(Sender: TObject);
begin
  dataBOX.dataFrequency := Annual;

  LblStartDate.Enabled := true;
  LblBeginYear.Enabled := true;
  dataBOX.dataFrequency := Annual;
  LblYearEg.Enabled := true;
  LblQuartOrMonthEg.Enabled := false;
  LblMonthOrQuarter.Enabled := false;

  LblStartDate.Caption := 'Specify the Start Date';
  LblBeginYear.Caption := 'Beginning Year';
  LblYearEg.Caption :=  'For example, 1984';
  lblMonthOrQuarter.Caption := '';
  LblQuartOrMonthEg.Caption := '';
  EditYear.Enabled := true;
  EditMonthorQuarter.Enabled := false;
  EditMonthorQuarter.text := '';
end;  {RadioBtnAnnualChange}

{______________________________________________________________________________}

procedure TFreaddata.RadioBtnMonthlyChange(Sender: TObject);
begin
   dataBOX.dataFrequency := Monthly;

   LblStartDate.Enabled := true;
   LblBeginYear.Enabled := true;
   LblYearEg.Enabled := true;
   lblMonthOrQuarter.Enabled := true;
   LblQuartOrMonthEg.Enabled := true;

   LblStartDate.Caption := 'Specify the Start Date';
   LblBeginYear.Caption := 'Beginning Year';
   LblYearEg.Caption :=  'For example, 1984';
   lblMonthOrQuarter.Caption := 'Beginning Month';
   LblQuartOrMonthEg.Caption := 'January to December';
   EditYear.Enabled := true;
   EditMonthorQuarter.Enabled := true;
   {EditYear.Text := '';}
end;  {RadioBtnMonthlyChange}
{______________________________________________________________________________}

procedure TFreaddata.RadioBtnOtherChange(Sender: TObject);
begin
  dataBOX.dataFrequency := Other;

  LblStartDate.Enabled := false;
  LblBeginYear.Enabled := false;
  LblYearEg.Enabled := false;
  LblQuartOrMonthEg.Enabled := false;
  LblMonthOrQuarter.Enabled := false;
  LblBeginYear.Enabled := false;
  LblStartDate.Enabled := false;

  LblStartDate.Caption := '';
  LblBeginYear.Caption := '';
  LblYearEg.Caption :=  '';
  lblMonthOrQuarter.Caption := '';
  LblQuartOrMonthEg.Caption := '';

  EditYear.Enabled := false;
  EditMonthorQuarter.Enabled := false;
  EditYear.Text := '';
  EditMonthorQuarter.text :='';
end;   {RadioBtnOtherChange}
{______________________________________________________________________________}

procedure TFreaddata.RadioBtnQuarterChange(Sender: TObject);
begin
  dataBOX.dataFrequency := Quarterly;

   LblStartDate.Enabled := true;
   LblBeginYear.Enabled := true;
   LblYearEg.Enabled := true;
   lblMonthOrQuarter.Enabled := true;
   LblQuartOrMonthEg.Enabled := true;

   LblStartDate.Caption := 'Specify the Start Date';
   LblBeginYear.Caption := 'Beginning Year';
   LblYearEg.Caption :=  'For example, 1984';
   lblMonthOrQuarter.Caption := 'Beginning Quarter';
   LblQuartOrMonthEg.Caption := '   Q1, Q2, Q3 or Q4';

   EditYear.Enabled := true;
   EditMonthorQuarter.Enabled := true

end; {RadioBtnQuarterChange}
{______________________________________________________________________________}

procedure CheckTheMonths(var startDate: dateRecord;
                       var EditMonthOrQuarter: TEdit;
                       var proceed: boolean);

var
  monthString, STR1, STR2: string;

  begin
     startDate.monthInt := 99;
     proceed := false;

    with startDate do
      begin  {Monthly}
        monthString := LowerCase(EditMonthOrQuarter.text);
        if TheStringContains(monthString, 'january') then
        monthInt := 1;
        if TheStringContains(monthString, 'february') then
        monthInt := 2;
        if TheStringContains(monthString, 'march') then
        monthInt :=  3;
        if TheStringContains(monthString, 'april') then
        monthInt := 4;
        if TheStringContains(monthString, 'may') then
        monthInt := 5;
        if TheStringContains(monthString, 'june') then
        monthInt := 6;
        if TheStringContains(monthString, 'july') then
        monthInt := 7;
        if TheStringContains(monthString, 'august') then
        monthInt := 8;
        if TheStringContains(monthString, 'september') then
        monthInt := 9;
        if TheStringContains(monthString, 'october') then
        monthInt := 10;
        if TheStringContains(monthString, 'november') then
        monthInt := 11;
        if TheStringContains(monthString, 'december') then
        monthInt := 12;

        if monthInt in [1..12] then
        proceed := True
        else if  monthString = '' then
         begin
           proceed := true;
           monthInt:= 0;
         end
        else
          begin
          STR1 :='Enter a month from January to December or some abbreviation ';
          STR2 := 'thereof to signify the beginning date, or else clear the edit box';
          STR1 := STR1 + STR2;
          ShowMessage(STR1);
          end;
          {decimalStart := yearInt + (MonthInt - 1) / 12.0;}
        end; {Monthly}

  end;  {CheckTheMonths}

{______________________________________________________________________________}

procedure CheckTheQuarters(var startDate: dateRecord;
                      var EditMonthOrQuarter: TEdit;
                      var proceed: boolean);

var quartString: string;

  begin
     proceed := false;
     with startdate do
       begin {Quarters}
     quartInt := 99;

    quartString := LowerCase(EditMonthOrQuarter.text);
      if quartString = 'q1' then
        quartInt := 1;
      if quartString = 'q2' then
        quartInt := 2;
      if quartString = 'q3' then
        quartInt := 3;
      if quartString = 'q4' then
        quartInt := 4;

      if quartInt in [1..4] then
        proceed := True
        else if  quartString = '' then
          begin
            proceed := true;
            quartInt := 0;
          end
      else
        ShowMessage('Enter Q1, Q2, Q3, or Q4 to signify a start date, or else clear the edit box');
     end;  {Quarters}

  end;  {CheckTheMonths}

{______________________________________________________________________________}

procedure CheckTheYear(var startDate: dateRecord;
                   var EditYear: TEdit;
                   var proceed: boolean);

var
 earliestYear, latestYear: integer;

 begin
   proceed := false;
   earliestYear:= 1066;
   latestYear := 2020;


   with startdate do
     begin {The Year}
       if  EditYear.text = '' then
         begin
           proceed := true;
           yearInt := 0;
         end
       else
         begin  {else}
           yearInt := StrToInt(EditYear.text);
           if (yearInt >= earliestYear) and  (yearInt <= latestYear) then
             proceed := true
           else
             ShowMessage('The beginning year is implausible. Please enter another year, or else clear the edit box');
         end; {else}
     end; {The Year}

 end; {CheckTheYear}

{______________________________________________________________________________}

end.   {Ureaddata: Unit of SEASCAPE.PAS}








