unit Upolyweights;  {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  GLOBALS, LEGENDS;

const
   constantWgts =1;
   cosineWgts = 2;
   QuadWgts = 3;
   CastleWgts = 4;
type

  { TFpolyweights }

  TFpolyweights = class(TForm)
    BtnCONTINUE: TButton;
    BtnRETURN: TButton;
    EdtMaxWgt: TEdit;
    EdtMidSegment: TEdit;
    EdtMinWgt: TEdit;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    RadioBtnUniformWgts: TRadioButton;
    RadioBtnCosineWgts: TRadioButton;
    RadioBtnQuadraticWgts: TRadioButton;
    RadioBtnCastleWeights: TRadioButton;
    StaticText1: TStaticText;
    procedure BtnCONTINUEClick(Sender: TObject);
    procedure BtnRETURNClick(Sender: TObject);
    procedure EdtMaxWgtChange(Sender: TObject);
    procedure EdtMaxWgtKeyPress(Sender: TObject; var Key: char);
    procedure EdtMidSegmentChange(Sender: TObject);
    procedure EdtMidSegmentKeyPress(Sender: TObject; var Key: char);
    procedure EdtMinWgtChange(Sender: TObject);
    procedure EdtMinWgtKeyPress(Sender: TObject; var Key: char);
    procedure FormActivate(Sender: TObject);
    procedure RadioBtnCastleWeightsChange(Sender: TObject);
    procedure RadioBtnCosineWgtsChange(Sender: TObject);
    procedure RadioBtnQuadraticWgtsChange(Sender: TObject);
    procedure RadioBtnUniformWgtsChange(Sender: TObject);
  private

  public

  end;

var
  Fpolyweights: TFpolyweights;
  polyWgts: longVector;
  minWgt, maxWgt, midRange: real;
  MinWgtSpecified, MaxWgtSpecified, SegmentSpecified: boolean;
  weightScheme: integer;


implementation
  uses DATASEG, uplotscreen, lcltype;

{$R *.lfm}

{ TFpolyweights }
{______________________________________________________________________________}

procedure TFpolyweights.FormActivate(Sender: TObject);
begin
  {MinWgtSpecified := true;
  MaxWgtSpecified := true;
  SegmentSpecified := true;}

  minWgt := -10;
  maxWgt := -10;
  midRange := -10;

  EdtMinWgt.Text := '';
  EdtMaxWgt.Text := '';
  EdtMidSegment.Text := '';
end;  {FormActivate}
{______________________________________________________________________________}

procedure TFpolyweights.EdtMinWgtKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', '.',#8])then
begin
  ShowMessage('Enter a real value not less than 1.0');
  key := #0;
 end;
end;  {EdtMinWgtKeyPress}
{______________________________________________________________________________}

procedure TFpolyweights.EdtMaxWgtKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', '.',#8])then
begin
  ShowMessage('Enter a real value not less than one');
  key := #0;
 end;
end; {EdtMaxWgtKeyPress}
{______________________________________________________________________________}

procedure TFpolyweights.EdtMidSegmentKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', '.',#8])then
begin
  ShowMessage('Enter a pecentage value in the range (0, 80)');
  key := #0;
 end;
end; {EdtMidSegmentKeyPress}
{______________________________________________________________________________}

procedure TFpolyweights.RadioBtnUniformWgtsChange(Sender: TObject);
begin
  EdtMinWgt.Text := '1.0';
  minWgt := 1.0;
  MinWgtSpecified := true;

  EdtMaxWgt.Text := '1.0';
  maxWgt := 1.0;
  MaxWgtSpecified := true;

  EdtMidSegment.Text := '0.0';
  midRange := 0.0;
  SegmentSpecified := true;

  weightScheme :=constantWgts;

end; {RadioBtnUniformWgtsChange}

{______________________________________________________________________________}

procedure TFpolyweights.RadioBtnCosineWgtsChange(Sender: TObject);
begin
  EdtMinWgt.Text := '1.0';
  minWgt := 1.0;
  MinWgtSpecified := true;

  EdtMaxWgt.Text := '';
  MaxWgtSpecified := false;

  EdtMidSegment.Text := '0.0';
  midRange := 0.0;
  SegmentSpecified := true;

  weightScheme := cosineWgts;

end; {RadioBtnCosineWgtsChange}

{______________________________________________________________________________}

procedure TFpolyweights.RadioBtnQuadraticWgtsChange(Sender: TObject);
begin
  EdtMinWgt.Text := '1.0';
  minWgt := 1.0;
  MinWgtSpecified := true;

  EdtMaxWgt.Text := '';
  MaxWgtSpecified := false;

  EdtMidSegment.Text := '0.0';
  midRange := 0.0;
  SegmentSpecified := true;

  weightScheme := QuadWgts;

end;  {RadioBtnQuadraticWgtsChange}

{______________________________________________________________________________}

procedure TFpolyweights.RadioBtnCastleWeightsChange(Sender: TObject);
begin
  EdtMinWgt.Text := '1.0';
  minWgt := 1.0;
  MinWgtSpecified := true;

  EdtMaxWgt.Text := '';
  MaxWgtSpecified := false;

  EdtMidSegment.Text := '50.0';
  midRange := 50.0;
  SegmentSpecified := true;

  weightScheme := CastleWgts;

end; {RadioBtnCastleWeightsChange}
{______________________________________________________________________________}

procedure TFpolyweights.EdtMinWgtChange(Sender: TObject);

begin
  if not (EdtMinWgt.Text = '') then
   begin
     minWgt := StrToFloat(EdtMinWgt.Text);
     if (minWgt >= 0.0) and (minWgt <= 80.0) then
       MinWgtSpecified := true
     else
       begin
         ShowMessage('The minumum weight must be no less than unity');
         EdtMinWgt.Text := '';
       end;
   end;

end; {EdtMinWgtChange}
{______________________________________________________________________________}

procedure TFpolyweights.EdtMaxWgtChange(Sender: TObject);

 begin
  if  not (EdtMaxWgt.Text = '') then
    begin {else}
      MaxWgt := StrToFloat(EdtMaxWgt.Text);
      if (MaxWgt >= 0.0) then
        MaxWgtSpecified := true
      else
        begin
          ShowMessage('The maximum weight must be no less than unity');
          EdtMaxWgt.Text := '';
        end;
      end; {else}

end; {EdtMaxWgtChange}
{______________________________________________________________________________}

procedure TFpolyweights.EdtMidSegmentChange(Sender: TObject);

begin
  if not (EdtMidSegment.Text = '')  then
    begin
      midRange := StrToFloat(EdtMidSegment.Text);
      if (midRange >= 0.0) and (midRange <= 80.0) then
        SegmentSpecified := true
      else
        begin {else}
          ShowMessage('The percentage of the segment must be  the range (0, 80)');
          EdtMidSegment.Text := '';
        end; {else}
    end;

end; {EdtMidSegmentChange}
{______________________________________________________________________________}

function SpecTested: boolean;

  begin
    SpecTested := false;

    if  MinWgt = -10 then
      ShowMessage('You have yet to specify the mimimum weight');
    if  MaxWgt = -10 then
      ShowMessage('You have yet to specify the maximum weight');
    if  midRange = -10 then
      ShowMessage('You have yet to specify the pecdntage of a middle segment');

    If  (weightScheme = constantWgts) and (not (minWgt = maxWgt)) or (not (minWgt = 1.0)) then
      begin
      ShowMessage('The uniform weights are unity over the entire range, and there is no middle segment');
      minWgt := 1.0;
      maxWgt := 1.0;
      midRange :=  0.0;
       end;


    if  (weightScheme = constantWgts) and MinWgtSpecified and MaxWgtSpecified and SegmentSpecified then
      SpecTested := true;
    if  (weightScheme = cosineWgts) and MinWgtSpecified and MaxWgtSpecified and SegmentSpecified then
      SpecTested := true;
    if  (weightScheme = QuadWgts) and MinWgtSpecified and MaxWgtSpecified and SegmentSpecified then
      SpecTested := true;
    if  (weightScheme = CastleWgts) and MinWgtSpecified and MaxWgtSpecified and SegmentSpecified then
      SpecTested := true;
    if  (minWgt > maxWgt) then
      begin
        SpecTested := false;
        ShowMessage('The maximum weight cannot be less than the minimum!');
      end;

  end; {SpecTested}
{______________________________________________________________________________}

procedure TFpolyweights.BtnCONTINUEClick(Sender: TObject);

begin
 if   SpecTested = true then
   begin {SpecTested}
   if WeightScheme = constantWgts then
      begin
        UniformWgts (PolyWgts, dataBOX);
      end {We do not plot the weight function}
    else
      begin
        plotBOX := dataBOX;
        if WeightScheme = cosineWgts then
          CosBellWgts (PolyWgts, minWgt, maxWgt, midRange, plotBOX);
        if WeightScheme = QuadWgts then
          QuadraticWgts (PolyWgts, minWgt, maxWgt, midRange,plotBOX);
        if WeightScheme = CastleWgts then
         CrenellatedWgts (PolyWgts, minWgt, maxWgt, midRange, plotBOX);

       {Now we plot the weight function}
        legend := PolynomialWeights;

        graphType := dataGraph;
        plotVector := PolyWgts;
        Fplotscreen := TFplotscreen.Create(Nil);
        Fplotscreen.ShowModal;
        FreeAndNil(Fplotscreen);
      end;

  {Now we do the plotting as normal: Since the polyParas are global we could }
  {do the plotting in upolyregress, but we would need to make polyWgts global}

        trendBOX := dataBOX;
        trendBoX.xMin := 0.0;
        residueBOX := dataBOX;
        MakePolyTrend (polyParas, dataBOX, trendBox, residueBOX, dataVector, trendVector, residueVec, PolyWgts);

        graphType := dataOverPlotGraph;
        Fplotscreen := TFplotscreen.Create(Nil);
        Fplotscreen.ShowModal;
        FreeAndNil(Fplotscreen);

        graphType := dataGraph;
        plotBOX :=residueBOX;
        plotVector := residueVec;
        Fplotscreen := TFplotscreen.Create(Nil);
        Fplotscreen.ShowModal;
        FreeAndNil(Fplotscreen);
   end {SpecTested = true}
 else
   ShowMessage('The specificaton is in error. Please check it.')


end; {BtnCONTINUEClick}
{______________________________________________________________________________}

procedure TFpolyweights.BtnRETURNClick(Sender: TObject);
begin
  Close;
end;  {BtnRETURNClick}
{______________________________________________________________________________}

end.  {Upolyweights: Unit of SEASCAPE.PAS}

