unit Upolyregress;  {unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  globals,utils;

type

  { TFpolyregress }

  TFpolyregress = class(TForm)
    BtnCONTINUE: TButton;
    BtnRETURN: TButton;
    EdtDegree: TEdit;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Memo1: TMemo;
    RadioBtnOLS: TRadioButton;
    RadioBtnWLS: TRadioButton;
    StaticText1: TStaticText;
    procedure BtnCONTINUEClick(Sender: TObject);
    procedure BtnRETURNClick(Sender: TObject);
    procedure EdtDegreeChange(Sender: TObject);
    procedure EdtDegreeKeyPress(Sender: TObject; var Key: char);
    procedure FormActivate(Sender: TObject);
    procedure RadioBtnOLSChange(Sender: TObject);
    procedure RadioBtnWLSChange(Sender: TObject);
  private

  public

  end;

var
  Fpolyregress: TFpolyregress;
  fitByOLS, fitByWLS,degreeSpecified : boolean;
  polyWgts: longVector;

implementation
  uses
    DATASEG, LEGENDS, upolyweights, uplotscreen; {ufreqfilters;}

{$R *.lfm}

{ TFpolyregress }
{______________________________________________________________________________}

procedure TFpolyregress.FormActivate(Sender: TObject);
begin
  degreeSpecified := false;
  fitByOLS := false;
  fitByWLS := false;
end;  {FormActivate}

{______________________________________________________________________________}

procedure TFpolyregress.EdtDegreeKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8])then
begin
  ShowMessage('Enter an positive integer value no greater than 15');
  key := #0;
 end;
end;  {EdtDegreeKeyPress}

{______________________________________________________________________________}

procedure TFpolyregress.EdtDegreeChange(Sender: TObject);
  var
    theInteger: integer;
    integerValue: boolean;

begin
  integerValue := IntegerString(EdtDegree.text);
  if integerValue = false then
    begin  {if}
      EdtDegree.Font.Color := clRed;
      ShowMessage('You must enter an integer number from 1 to 15');
      EdtDegree.text := '';
      EdtDegree.Font.Color := clBlack;
    end  {if}
  else
    begin {else}
      theInteger := StrToInt(EdtDegree.text);
      if  (theInteger >= 1) and (theInteger <= 15) then
        begin
          polyParas.polyDegree := theInteger;
          DegreeSpecified := true;
        end
      else
        ShowMessage('You must enter an integer number from 1 to 15');
    end; {else}

end;  {EdtDegreeChange}

{______________________________________________________________________________}

procedure TFpolyregress.RadioBtnOLSChange(Sender: TObject);
begin
  fitByOLS := true;
  fitByWLS := false;
  UniformWgts (PolyWgts, dataBOX); {in POLYNOME}
end; {RadioBtnOLSChange}
{______________________________________________________________________________}

procedure TFpolyregress.RadioBtnWLSChange(Sender: TObject);
begin
  fitByWLS := true;
  fitByOLS := false;
end;   {RadioBtnWLSChange}

{______________________________________________________________________________}

procedure TFpolyregress.BtnCONTINUEClick(Sender: TObject);

var
  i: integer;
  betaString: string;

begin
  if  degreeSpecified = false then
    ShowMessage('You have yet to specify the degree of the polynomial');

  if  degreeSpecified and FitByWLS then
    begin
      Fpolyweights := TFpolyweights.Create(nil);
      Fpolyweights.ShowModal;
      FreeAndNil(Fpolyweights);
      weHavePolyResiduals := true;
    end;
 {Thr poly parameters are global}

    if degreeSpecified and FitByOLS then
      begin
        trendBOX := dataBOX;
        trendBoX.xMin := 0.0;
        residueBOX := dataBOX;
        MakePolyTrend (polyParas, dataBOX, trendBox, residueBOX, dataVector, trendVector, residueVec, PolyWgts);

        legend := PolynomialTrend (polyParas, dataBOX, dataName);
        graphType := dataOverPlotGraph;
        Fplotscreen := TFplotscreen.Create(Nil);
        Fplotscreen.ShowModal;
        FreeAndNil(Fplotscreen);

        legend := PolynomialResiduals (polyParas, dataBOX, dataName);
        graphType := dataGraph;
        plotBOX :=residueBOX;
        plotVector := residueVec;
        Fplotscreen := TFplotscreen.Create(Nil);
        Fplotscreen.ShowModal;
        FreeAndNil(Fplotscreen);
        weHavePolyResiduals := true;
      end;

   if degreeSpecified then
     begin {specified}
       with PolyParas do
         begin  {with}
           Memo1.Lines.Clear;
           for i := 0 to polyDegree do
             begin {i}
               Memo1.Lines.Add(' ');
               betaString := '  beta[' + IntToStr(i) + '] = ';
               Memo1.Lines.Add(betaString + FloatToStrf(beta[i], ffGeneral, 10 , 5));
             end; {i}
         end; {with}
     end; {specified}


end; {BtnCONTINUEClick}

{______________________________________________________________________________}

procedure TFpolyregress.BtnRETURNClick(Sender: TObject);
begin
  weHavePolyResiduals := true;    {Check with MakePolyTrend}
  dataAreTrended := false;
  dataExtrapolated:= false;
  {if ReopenExtra polate
    then
      begin
        Fextrapolate := TFextrapolate.Create(nil);
        Fextrapolate.ShowModal;
        FreeAndNil(Fextrapolate)

      end;}
  Close;
end;   {BtnRETURNClick}

{______________________________________________________________________________}


end.  {Upolyregress: unit of SEASCAPE.PAS}

