unit Uperiodgram;  {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls, GLOBALS;

type

  { TFperiodgram }

  TFperiodgram = class(TForm)
    BtnCLOSE: TButton;
    Label1: TLabel;
    ListBox: TListBox;
    StaticText: TStaticText;
    procedure BtnCLOSEClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
  private

  public

  end;

procedure PlotThePeriodogram(var dataBOX, spectraBOX: rBOX;
                       var dataVector : longVector;
                       var spectraVec: longVector);

var
  Fperiodgram: TFperiodgram;
  dataItem, trendItem, cycleItem, seasonalItem, adjustedItem, residualsItem, adjustedResidualsItem: integer;


implementation

  uses
    DATASEG, UplotScreen;

{$R *.lfm}

{ TFperiodgram }

{______________________________________________________________________________}

procedure PlotThePeriodogram(var dataBOX, spectraBOX: rBOX;
                      var dataVector : longVector;
                      var spectraVec: longVector);
  var
    alpha, beta: FourierVec;
    STR1, STR2: string;

    {SlowFourier and MakeThePeriodogram are in DATASEG}

begin

  SlowFourier (dataBOX, dataVector, alpha, beta);
  MakeThePeriodogram (dataBOX, spectraBOX, spectraVec, alpha, beta); {in dATASEG}

   if enoughData = false then
    begin
      STR1 := 'There are '+ IntToStr(dataBOX.NOPUNCT)+ ' data points. ';
      STR2 := 'More points are needed for calculating the periodogram';
      ShowMessage(STR1 + STR2);
      enoughData := false;
    end
  else
    begin
      filterSpec.seasonality := dataBOX.dataFrequency;
      graphType := periodoGraph;
      Fplotscreen := TFplotscreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
    end;

end; {PlotThePeriodogram}
{______________________________________________________________________________}

procedure TFperiodgram.FormActivate(Sender: TObject);

begin
   dataItem := 99;
   trendItem := 99;
   cycleItem := 99;
   seasonalItem := 99;
   residualsItem := 99;
   adjustedResidualsItem := 99;
   ListBox.ItemIndex := -1;

  if thereIsData then
   begin
     ListBox.Items.Add('d. Plot the Periodogram of the Data');
     ListBox.Items.Add('');
     ListBox.ItemIndex := 0;
     dataItem :=  ListBox.ItemIndex;
   end;

  if weHaveATrendCycle then
   begin
     ListBox.Items.Add('t. Plot the Periodogram of the Trend-Cycle');
     ListBox.Items.Add('');
     ListBox.ItemIndex := ListBox.ItemIndex +2;
     trendItem :=  ListBox.ItemIndex;
   end;

  if weHaveACycle then
    begin
      ListBox.Items.Add('c. Plot the Periodogram of the Cycle');
      ListBox.Items.Add('');
      ListBox.ItemIndex := ListBox.ItemIndex +2;
      cycleItem :=  ListBox.ItemIndex;
    end;

  if weHaveSeasonalComponent then
   begin
     ListBox.Items.Add('s. Plot the Periodogram of the Seasonal Component');
     ListBox.Items.Add('');
     ListBox.ItemIndex := ListBox.ItemIndex +2;
     seasonalItem :=  ListBox.ItemIndex;
   end;

  if weHavePolyResiduals then
    begin
      Listbox.Items.Add('r. Plot the Periodogram of the Polynomial Residuals');
      Listbox.Items.Add('');
      Listbox.ItemIndex := Listbox.ItemIndex +2;
      residualsItem := ListBox.ItemIndex;
    end
  else if weHaveTrendCycleResiduals then
    begin
      Listbox.Items.Add('r. Plot the Periodogram of the Trend-cycle Residuals');
      Listbox.Items.Add('');
      Listbox.ItemIndex := Listbox.ItemIndex +2;
      residualsItem := ListBox.ItemIndex;
    end;

   if weHaveSeasonallyAdjustedData  then
    begin
      ListBox.Items.Add('a. Plot the Periodogram of the Seasonally-Adjusted Data');
      ListBox.Items.Add('');
      ListBox.ItemIndex := ListBox.ItemIndex +2;
      adjustedItem :=  ListBox.ItemIndex;
    end;

   if weHaveSeasonallyAdjustedData and  weHaveATrendCycle then
    begin
      ListBox.Items.Add('e. Plot the Periodogram of the Seasonally-Adjusted Trend Residuals');
      ListBox.Items.Add('');
      ListBox.ItemIndex := ListBox.ItemIndex +2;
      adjustedResidualsItem :=  ListBox.ItemIndex;
    end;

end;  {FormActivate}

{______________________________________________________________________________}

procedure TFperiodgram.ListBoxClick(Sender: TObject);

 var
  index : Integer;
  {F: text;} {TEMP}

 begin
  ListBox := TListBox(Sender);
  index := ListBox.ItemIndex;

 {------------------------------}

 if (index = dataItem) and (thereIsData  ) then
  begin
    {SHOWMESSAGE('dataItem');}
     legend := 'The periodogram of ' + dataName;
     PlotThePeriodogram(dataBOX, spectraBOX, dataVector,spectraVec);
   end;  {dataItem}

 {------------------------------}

 if (index = trendItem) and (weHaveATrendCycle) then
  begin
     {SHOWMESSAGE('trendItem');}
    legend := 'The periodogram of a trend extracted from ' + dataName;
    PlotThePeriodogram(trendBOX, spectraBOX, trendVector, spectraVec);
  end;  {trendItem}

 {------------------------------}

 if (index = cycleItem) and (weHaveACycle) then
  begin
    {SHOWMESSAGE('cycleItem');}
    legend := 'The periodogram of a cyclical component extracted from a detrended version of ' + dataName;
    PlotThePeriodogram(cycleBOX, spectraBOX, cycleVec,spectraVec);
  end;  {bicycleItem}

 {------------------------------}

 if (index = seasonalItem) and (weHaveSeasonalComponent) then
  begin
     {SHOWMESSAGE('seasonalItem');}
    legend := 'The periodogram of a seasonal component extracted from the detrended version of' + dataName;
    PlotThePeriodogram(seasonBOX, spectraBOX, seasonVec, spectraVec);
  end;  {seasonalItem}

 {------------------------------}
 if (index = adjustedItem)and (weHaveSeasonallyAdjustedData) then
    begin
       {SHOWMESSAGE('adjustedItem');}
    legend := 'The periodogram of a seasonally-adjusted version of ' + dataName;
    PlotThePeriodogram(seasonBOX, spectraBOX, adjustedVec, spectraVec);
  end;  {seasonalItem}


 {------------------------------}

  if (index = residualsItem) and (weHavePolyResiduals) then
    begin
      {SHOWMESSAGE('residualsItem');}
      legend := 'The periodogram of the residual deviations from a polynomial trend interpolated into ' + dataName;
      PlotThePeriodogram(residueBOX, spectraBOX, residueVec, spectraVec);
    end;

  if (index = residualsItem) and (weHaveTrendCycleResiduals)  then
    begin
      {SHOWMESSAGE('residualsItem');}
      legend := 'The periodogram of the residual deviations from the trend-cycle function of ' + dataName;
      PlotThePeriodogram(residueBOX, spectraBOX, residueVec, spectraVec);
    end;   {residualsItem}

  {------------------------------}

  if (index = adjustedResidualsItem)  and (weHaveSeasonallyAdjustedData) and (weHaveATrendCycle) then
  begin
     {SHOWMESSAGE('adjustedResiduals =' + (IntToStr(index);}
    legend := 'The periodogram of the seasonally-adjusted residual deviations from the trend-cycle function of ' + dataName;
    plotBOX := dataBOX;
    SubtractComponent (dataBOX, plotBOX, adjustedVec, trendVector, plotVector);

    Fplotscreen :=TFplotScreen.Create(Nil);
    PlotThePeriodogram(dataBOX, spectraBOX, plotVector, spectraVec);

  end;   {adjustedResidualsItem}

  {-------------------------------}

end;  {ListBoxClick}

{______________________________________________________________________________}

procedure TFperiodgram.BtnCLOSEClick(Sender: TObject);
begin
  Close;
end; {BtnCLOSEClick}

{______________________________________________________________________________}

end.  {Uperiodgram: unit of SEASCAPE.PAS}

