unit UTILS;  {Unit of SEASCAPE.PAS}

interface

  uses
    Dialogs, Controls, SysUtils, Graph, Dos, Crt,
    GLOBALS, MATHS;

  procedure DummyProcedure;

  procedure YesOrNo (question: string;
                  var decision: boolean);

  procedure CallForReturn;

  procedure Caption (theBlurb: string);

  procedure SysBeep (pause: integer);

  function UpCase (character: char): char;

  function DownCase (character: char): char;

  function TheStringContains (subString, theString: string): boolean;

  function MenuChar (alpha, omega: char): char;

  procedure PageParameters (var SCREENBOX, POSTBOX: IBOX;
                   var boxWidth, boxHeight:real);

  procedure PageSetUp (var SCREENBOX, POSTBOX: IBOX;
                  var PSPict, TeXFormat: boolean);

  procedure DeleteTheInvisibles (var theString: string);

  procedure StripLeadingBlanks (var theString: string);

  procedure StripTrailingBlanks (var theString: string);

  procedure ReplaceEveryCaseOf (deletion, replacement: string;
                  var theString: string);

 {procedure TallyPoints (range: real;
                  var taly: real); }

  function IntegerToString (theInteger: integer): string;

  function TalyToString (theNumber: real): string;

  function IntegerString (theString: string): boolean;

  function DecimalString (theString: string): boolean;

  function StringToInteger (theString: string): longint;

  procedure GetBoundedInteger (lowerBound, upperBound: integer;
                  var theInteger: integer);

  procedure ReadAChar (var theCharacter: char);

  procedure ReadANumber (var theNumber: real);

  procedure ReadBoundedNumber (lowerBound, upperBound: real;
                  var theNumber: real);

  procedure RemoveCommas(var theLine: string);

  function LineStatus (theLine: string): smallInt;

  function StringToDecimal (theString: string): real;


  procedure ReadANumericLine (theLine: string;
                  var foundNo: integer;
                  var numberVec: vector);

  procedure TestTheSlope (var y: longVector;
                var dataBOX: rBOX);

  procedure ReadDataSafely (var dataFileName: string;
                   var dataBOX: rBOX;
                   var dataVector: longVector;
                   maxArray: integer);

  procedure WriteData (var dataBOX: rBOX;
                  var dataVector: longVector);

  procedure MakeDataBox (var dataBOX: rBOX;
                  var dataVector: longVector);


  procedure SaveDataVector(realBOX: rBOX;
                     var realVector: longvector;
                     var dataFileName: string);

implementation


  {________________________________________________}

  procedure DummyProcedure;
  begin
  end; {DummyProcedure}

  {________________________________________________}

  procedure YesOrNo (question: string;
                  var decision: boolean);

    var
      contrary: boolean;
      answer: char;

  begin
    repeat
      Writeln(question, ' Y/N?');
      Read(Answer);
      Readln;
      decision := (answer = 'Y') or (answer = 'y');
      contrary := (answer = 'N') or (answer = 'n');
    until (decision <> contrary);
  end; {YesOrNo}

   {__________________________________________________}

  procedure CallForReturn;
     {This routine is specific to Turbo Pascal}

    var
      message: string;
      width, XS, YS: integer;
  begin
      {message := 'To Continue, Press <RETURN>';}
    message := 'To Continue, Close the Graph Window and Press <RETURN>';
    width := TextWidth(message);
    XS := (GetMaxX div 2) - (width div 2);
    YS := 10;
    MoveTo(XS, YS);
    OutText(message);
  end; {CallForReturn}

  {_________________________________________________}

  procedure Caption (theBlurb: string);
    var
      width, XS, YS: integer;
  begin
    width := TextWidth(theBlurb);
    XS := (GetMaxX div 2) - (width div 2);
    YS := (GetMaxY) - 60;
    MoveTo(XS, YS);
    OutText(theBlurb);
  end;{Caption}

  {_________________________________________________}

  procedure SysBeep (pause: integer);

  begin
    Sound(220);
    Delay(pause * 30);
    NoSound;
  end; {SysBeep}

  {________________________________________________}

  function UpCase (character: char): char;

  begin
    if character in ['a'..'z'] then
      UpCase := Chr(Ord(character) - Ord('a') + Ord('A'))
    else
      UpCase := character;
  end; {UpCase}

  {_________________________________________________}

  function DownCase (character: char): char;

  begin
    if character in ['A'..'Z'] then
      DownCase := Chr(Ord(character) - Ord('A') + Ord('a'))
    else
      DownCase := character;
  end; {DownCase}

   {_________________________________________________}

  function TheStringContains (subString, theString: string): boolean;

    var
      p: smallInt;

  begin
    theStringContains := False;
    p := Pos(subString, theString);
    if p <> 0 then
      theStringContains := True;

  end; {TheStringContains}

   {_________________________________________________}

  function MenuChar (alpha, omega: char): char;

    var
      theChoice, alphaCap, omegaCap: char;
      inc: integer;
      goodChoice, capitals: boolean;

  begin
    capitals := false;
    if alpha in ['A'..'Z'] then
      begin
        capitals := true;
        alpha := DownCase(alpha);
        omega := DownCase(omega);
      end;

    goodChoice := false;
    inc := Ord('A') - Ord('a');
    alphaCap := Chr(Ord(alpha) + inc);
    omegaCap := Chr(Ord(omega) + inc);
    repeat
      if capitals then
        Writeln('    Choose a letter in the set [', alphaCap, '..', omegaCap, ']')
      else
        Writeln('    Choose a letter in the set [', alpha, '..', omega, ']');

      Readln(theChoice);
      if (theChoice in [alpha..omega]) or (theChoice in [alphaCap..omegaCap]) then
        goodChoice := true
      else
        SysBeep(3);
    until goodChoice;
    if theChoice in [alphaCap..omegaCap] then
      theChoice := Chr(Ord(theChoice) - inc);
    MenuChar := theChoice;
  end; {MenuChar}

  {___________________________________________________________________________}

  procedure PageParameters (var SCREENBOX, POSTBOX: IBOX;
                  var boxWidth, boxHeight:real);

    var
      CTX, CTY: integer; {these parameters repesent the centre of the screen}


  begin {GraphParametersMod}

    if boxHeight > 12.0 then
      boxHeight := 12.0;
    if boxHeight < 4 then
      boxHeight := 4;
    if boxWidth > 18.0 then
      boxWidth := 18.0;
    if boxWidth < 6 then
      boxWidth := 6;

    CTX := 450;{this is initally set to zero}
    CTY := 340; {this is initally set to zero}
    SCREENBOX.X0 := CTX;
    SCREENBOX.Y0 := CTY;
    SCREENBOX.X1 := CTX - Round((boxWidth * 36) / 2.54); {= HRS}
    SCREENBOX.Y1 := CTY - Round(boxHeight * 14.5); {= VTS}
    SCREENBOX.X2 := CTX + Round((boxWidth * 36) / 2.54); {= HRF}
    SCREENBOX.Y2 := CTY + Round(boxHeight * 14.5); {= VTF}
    SCREENBOX.BOXWDT := SCREENBOX.X2 - SCREENBOX.X1; {Width of Bounding Box}
    SCREENBOX.BOXHGT := SCREENBOX.Y2 - SCREENBOX.Y1; { Height of Bounding}


    POSTBOX.X1 := 0; {=XS}
    POSTBOX.Y1 := 0; {=YS}
    POSTBOX.X2 := 2 * Round((boxWidth * 36) / 2.54); {= XF}
    POSTBOX.Y2 := 2 * Round((boxHeight * 36) / 2.54); {= YF}
    POSTBOX.BOXWDT := POSTBOX.X2 - POSTBOX.X1; {Width of Bounding Box}
    POSTBOX.BOXHGT := POSTBOX.Y2 - POSTBOX.Y1; { Height of Bounding}


    noPageParameters := false;
  end; {Page Parameters}

{_____________________________________________________________________________}

  procedure PageSetUp (var SCREENBOX, POSTBOX: IBOX;
                  var PSPict, TeXFormat: boolean);

  begin

    {ageParameters(SCREENBOX, POSTBOX);}
    SCREENBOX.xScale := true;
    SCREENBOX.yScale := true;

    SCREENBOX.xAxis := true;
    SCREENBOX.yAxis := true;
    SCREENBOX.doFrame := true;
    SCREENBOX.doMarks := true;

    POSTBOX.xScale := true;
    POSTBOX.yScale := true;

    POSTBOX.xAxis := true;
    POSTBOX.yAxis := true;
    POSTBOX.doFrame := true;
    POSTBOX.doMarks := true;

    noPageParameters := false;
  end; {Page SetUp}

{________________________________________________}

procedure DeleteTheInvisibles (var theString: string);

  var
    i, j, n: integer;

begin
  n := Length(theString);
  i := 1;
  j := 1;
  if Length(theString) <> 0 then
    repeat
      if (Ord(theString[i]) in [0..31]) or (Ord(theString[i]) in [128..255]) then
        Delete(theString, i, 1)
      else
        i := i + 1;
      j := j + 1;
    until j = n + 1;

end; {DeleteTheInvisibles}

{________________________________________________}

  procedure StripLeadingBlanks (var theString: string);

    const {ASCII Codes}
      TAB = 9;
      LINEFEED = 10;
      SPACE = 32;

    var
      exeat: boolean;

  begin
    exeat := false;
    repeat
      if Length(theString) <> 0 then
        begin
          if (Ord(theString[1]) in [SPACE, TAB, LINEFEED]) then
            Delete(theString, 1, 1)
          else
            exeat := true;
        end;
    until (Length(theString) = 0) or exeat;
  end; {StripLeadingBlanks}

  {_________________________________________________}

  procedure StripTrailingBlanks (var theString: string);

    const {ASCII Codes}
      TAB = 9;
      SPACE = 32;

    var
      n, m: integer;

  begin {StripTrailingBlanks}
    n := Length(theString);
    if n <> 0 then
      begin {if n<>0}
        repeat
          m := n;
          if (Ord(theString[n]) = SPACE) or (Ord(theString[n]) = TAB) then
            begin
              Delete(theString, n, 1);
              m := n - 1;
            end;
          n := n - 1;
        until (m <> n);
      end; {if n<>0}
  end; {StripTrailingBlanks}

  {_________________________________________________}

  procedure ReplaceEveryCaseOf (deletion, replacement: string;
                  var theString: string);

    var
      a, n: integer;
      newString, tempString: string;

  begin
    newString := '';
    n := Length(deletion);
    repeat
      a := Pos(deletion, theString);
      if a <> 0 then
        begin
          tempString := Copy(theString, 1, a - 1);
          tempString := Concat(tempString, replacement);
          Delete(theString, 1, a + n - 1);
          newString := Concat(newString, tempString);
        end;
    until a = 0;
    theString := Concat(newString, theString);

  end; {ReplaceEveryCaseOf}

  {_________________________________________________}

 { procedure TallyPoints (range: real;
                  var taly: real);

    var
      PWR, TRNC: integer;
      FACT, LogBaseTen: real;
      F:text; {TEMP}

  begin} {TallyPoints}

{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
    {AssignFile(F, 'TALLYPROBLEM.txt');
    Rewrite(F);
    Writeln(F, ' range = ', range: 6:4);

    Writeln(F, '  dataBOX.NOSPUNCT = ',  dataBOX.NOPUNCT: 3);
    Writeln(F, '  dataBOX.yMax = ',  dataBOX.yMax: 6: 4);
    Writeln(F, '  dataBOX.yMin = ',  dataBOX.yMin: 6: 4);

    Writeln(F, '  SpectraBOX.NOPUNCT = ',  dataBOX.NOPUNCT: 3);
    Writeln(F, '  spectraBOX.yMax = ',  spectraBOX.yMax: 6: 4);
    Writeln(F, '  spectraBOX.yMin = ',  spectraBOX.yMin: 6: 4);

    CloseFile(F);}
{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

   { logBaseTen := Ln(range) / Ln(10);
    if logBaseTen > 0 then
      begin
        PWR := Trunc(logBaseTen) - 1;
        FACT := Exp(PWR * Ln(10));
        TRNC := Round(range / FACT)
      end;
    if logBaseTen = 0 then
      begin
        FACT := 0.1;
        TRNC := 10
      end;
    if logBaseTen < 0 then
      begin
        PWR := Trunc(Abs(logBaseTen)) + 2;
        FACT := Exp(PWR * Ln(10));
        TRNC := Round(range * FACT);
        FACT := 1 / FACT;
      end;
    if (TRNC >= 10) and (TRNC < 15) then
      TALY := 2.5 * FACT;
    if (TRNC >= 15) and (TRNC < 30) then
      TALY := 5 * FACT;
    if (TRNC >= 30) and (TRNC < 60) then
      TALY := 10 * FACT;
    if (TRNC >= 60) and (TRNC <= 100) then
      TALY := 20 * FACT;}

  {end;} {TallyPoints}

  {_________________________________________________}

  function IntegerToString (theInteger: integer): string;

    var
      i, n, digit: integer;
      theString, signChar: string;

  begin
    theString := '';
    signchar := '';
    if theInteger < 0 then
      begin
        signchar := '-';
        theInteger := -theInteger;
      end;

    if theInteger = 0 then
      theString := '0'
    else if (theInteger > 0) then
      begin {The Integer > 0}
        n := Trunc(Ln(theInteger) / Ln(10)) + 1;
        for i := 1 to n do
          begin {i}
            digit := theinteger mod 10;
            insert(Chr(digit + 48), thestring, 1);
            theinteger := theInteger div 10;
          end; {i}
      end; {The Integer > 0}
    theString := Concat(signChar, theString);
    IntegerToString := theString;
  end; {IntegerToString}

  {_________________________________________________}

  function TalyToString (theNumber: real): string;

    var
      scientific, decimal: boolean;
      sign, leadingDigits, digits, divisor: integer;
      i, p, q, r: integer;
      realNumber, log10: real;
      headString, powerString, numbString: string;

  begin
     {0. Determine the sign of the number and take the modulus}
    p := 0;
    sign := 1;
    if theNumber < 0 then
      begin
        theNumber := -theNumber;
        sign := -1;
      end;

     {1.Extract leading digits and determine the value of the exponent p}
    if theNumber <> 0 then
      begin {theNumber <>0}
        digits := 4;
        log10 := Ln(theNumber) / Ln(10.0);
        p := Trunc(log10);
        if theNumber < 1 then
          p := p - 1;
        realNumber := theNumber / Exp((p - digits) * Ln(10));
        leadingDigits := Round(realNumber / 10);
        if leadingDigits = 10000 then
          begin
            p := p + 1;
            leadingDigits := 1000;
          end;

     {2.Determine the number of nonzero digits}
        divisor := 10;
        q := 4;
        while leadingDigits mod divisor = 0 do
          begin
            divisor := divisor * 10;
            q := q - 1;
          end;
        r := q; {the original number of nonzero digits}
        if (p > 0) and (q < p + 1) then {not if p >4}
          q := Min(4, p + 1); {We need to count the integer zeros}
   {We need to count the integer zeros}

     {3. Determine whether or not to use Scientific notation}
        scientific := true;
        decimal := false;
        if (6 > (q - p)) and ((q - p) > 0) then
          begin
            scientific := false;
            decimal := true;
          end;
      end; {theNumber <>0}

     {4. Construct the Scientific  notation}
    if scientific and (theNumber <> 0) then
      begin {Scientific Notation}
        q := r;
        while ((leadingDigits mod 10) = 0) do
          leadingDigits := leadingDigits div 10;
        numbString := IntegerToString(leadingDigits);
        if q > 1 then
          Insert('.', numbString, 2)
        else if q = 1 then
          numbString := Concat(numbString, '.0');
        if p <> 0 then
          begin {Scientific Notation}
            powerString := IntegerToString(p);
            if p > 0 then
              powerString := Concat('+', powerString);
            numbString := Concat(numbString, 'e', powerString);
          end;{Scientific Notation}
      end; {Scientific Notation}

     {5. Construct the Decimal  notation}
    if Decimal and (theNumber <> 0) then
      begin
        for i := 1 to 4 - q do
          begin
            if (leadingDigits mod 10 = 0) then
              leadingDigits := leadingDigits div 10;
          end;
        numbString := IntegerToString(leadingDigits);
        ;
        if (p >= 0) and (p <= 2) and (q > p + 1) then
          Insert('.', numbString, p + 2);
        if p < 0 then
          begin {p <0}
            headString := '0.';
            for i := 2 to -p do
              headString := Concat(headString, '0');
            numbString := Concat(headString, numbString);
          end; {p <0}
      end; {Decimal}

    if sign = -1 then
      numbString := Concat('-', numbString);
    if theNumber = 0 then
      numbString := '0';

    TalyToString := numbString;

  end; {TalyToString}

{______________________________________________________________________________}

  function IntegerString (theString: string): boolean;

    var
      numeric: boolean;
      i, n: integer;

  begin {IntegerString}
    numeric := true;
    n := Length(theString);
    if (n = 0) or (n>5)  then
      numeric := false
    else
      begin {else}
        if not (theString[1] in ['0'..'9', '-']) then
          numeric := false;
        for i := 2 to n do
          begin {i}
            if not (theString[i] in ['0'..'9']) then
              numeric := false;
            end; {i}
      end;{else}
    IntegerString := numeric;
  end; {IntegerString}

{______________________________________________________________________________}

  function DecimalString (theString: string): boolean;

    var
      numeric: boolean;
      i, n, points: integer;

  begin {DecimalString}
    points := 0;
    numeric := true;
    n := length(theString);
    if n <= 0 then
      numeric := false
    else
      begin {n>0}
        if not (theString[1] in ['0'..'9', '.', '-']) then
          numeric := false;
        if theString[1] = '.' then
          points := points + 1;
        for i := 2 to n do
          begin {i}
            if not (theString[i] in ['0'..'9', '.']) then
              numeric := false;
            if theString[i] = '.' then
              points := points + 1;
          end; {i}
      end; {n>0}
    if points > 1 then
      numeric := false;
    DecimalString := numeric;
  end; {DecimalString: Is it a Decimal String?}

{______________________________________________________________________________}

  function StringToInteger (theString: string): longint;

    var
      i, n, start: integer;
      thenumber: longint;
      negative: boolean;

  begin
    start := 1;
    negative := false;
    if theString[1] = '-' then
      begin
        negative := true;
        start := 2;
      end;
    n := Length(theString);
    theNumber := 0;
    for i := start to n do
      theNumber := theNumber * 10 + Ord(theString[i]) - Ord('0');
     {Usually Ord('0') = 48}
    StringToInteger := theNumber;
    if negative then
      StringToInteger := -theNumber;
  end; {StringToInteger}

  {_________________________________________________}

  function StringToDecimal (theString: string): real;

    var
      i, n, p, d: integer;
      theNumber, denominator: real;
      negative: boolean;

  begin{StringToDecimal}
    negative := false;
    if theString[1] = '-' then
      begin
        negative := true;
        ;
        delete(theString, 1, 1);
      end;

    n := length(theString);
    p := pos('.', theString);
    if p = 0 then
      p := n;
    d := n - p;

    theNumber := 0;
    if p <> n then
      begin
        delete(theString, p, 1);
        n := n - 1
      end;

    for i := 1 to n do
      theNumber := theNumber * 10 + Ord(thestring[i]) - Ord('0');
         {Usually ord('0') = 48}
    denominator := 1;

    for i := 1 to d do
      denominator := denominator * 10;

    StringToDecimal := theNumber / denominator;
    if negative then
      StringToDecimal := -theNumber / denominator;

  end; {StringToDecimal}

  {_________________________________________________}

  procedure GetBoundedInteger (lowerBound, upperBound: integer;
                  var theInteger: integer);

    var
      theString: string;
      theLongint: longint;
      itsAnInteger, withinBounds: boolean;

  begin
     {Writeln('    Type an integer in the interval [', lowerBound : 1, ', ', upperBound : 3, '] ');}
    itsAnInteger := false;
    repeat {until itsAnInteger;}
      repeat
        Readln(theString);
      until theString <> '';
      itsAnInteger := IntegerString(theString);
      if itsAnInteger = false then
        begin {this is a rubbish string}
          Sysbeep(3);
          Writeln('    Type an integer in the interval [', lowerBound : 1, ', ', upperBound : 1, '] ');
          Writeln;
        end {this is a rubbish string}

      else {it is an integer String}

        begin {Convert the IntegerString}
          withinBounds := false;
          theLongint := StringToInteger(theString);
          if theLongint > upperBound then
            begin
              Sysbeep(3);
              Writeln('    This integer exceeds ', upperBound : 1, '! (Try again).');
            end
          else if theLongint < lowerBound then
            begin
              Sysbeep(3);
              Writeln('    This integer is less than ', lowerBound : 1, '! (Try again).');
            end
          else
            begin
              theInteger := theLongint;
              withinBounds := true;
            end;
        end; {Convert the IntegerString}
    until withinBounds;
  end; {GetBoundedInt}

  {_________________________________________________}

  procedure ReadAChar (var theCharacter: char);
    var
      charString: string;
  begin
    charString := '';
    repeat
      Readln(charString);
      StripLeadingBlanks(charString);
      StripTrailingBlanks(charString);
      if Length(CharString) <> 1 then
        begin
          Sysbeep(3);
          Writeln('    Type a single character!');
        end;
    until Length(CharString) = 1;
    theCharacter := charString[1];
  end; {ReadAChar}

  {_________________________________________________}

  procedure ReadANumber (var theNumber: real);

    var
      theString: string;
      itsANumber: boolean;

  begin
    itsANumber := false;
    repeat
      Readln(theString);
      StripLeadingBlanks(theString);
      StripTrailingBlanks(theString);
      itsANumber := DecimalString(theString);
      if itsANumber = false then
        begin
          Sysbeep(3);
          Write('Type a number ! ');
        end;
    until itsANumber;
    theNumber := StringToDecimal(theString)
  end; {ReadANumber}

  {_________________________________________________}

  procedure ReadBoundedNumber (lowerBound, upperBound: real;
                  var theNumber: real);

    var
      accepted: boolean;

  begin

    repeat
      ReadANumber(theNumber);

      accepted := false;
      if (theNumber < lowerBound) then
        begin
          Sysbeep(3);
          if lowerbound = 0.0 then
            Writeln('    The number should be positive!')
          else
            Writeln('    This number is less that the minimum value ', lowerBound : 5 : 2);
          Writeln('    Input another number');
        end
      else if (theNumber > upperBound) then
        begin
          Sysbeep(3);
          Writeln('    This number is greater that the maximum value ', upperBound : 5 : 2);
          Writeln('    Input another number');
        end
      else
        accepted := true;
    until accepted;

  end;{ReadBoundedNumber}

{______________________________________________________________________________}

  procedure RemoveCommas(var theLine: string);

  var
    p: integer;

    begin
      repeat
        p := Pos(',', theLine);
        if p <> 0 then
          Delete(theLine, p, 1);
      until p = 0;
    end; {RemoveCommas}

{______________________________________________________________________________}

  function LineStatus (theLine: string): smallInt;

    const
      numericLine = 1;
      commaSeparated = 2;
      nonNumeric = 3;
      blankLine = 4;

    var
      i, n: integer;
      alphaChar, numericChar, signChar, blankChar: boolean;
      commaChar,periodChar, otherChar: boolean;

  begin
    alphaChar := false;
    numericChar := false;
    blankChar := false;
    commaChar := false;
    periodChar := false;
    signChar := false;
    otherChar := false;

    i := 1;
    n := length(theLine);

    if n = 0 then
      begin
        LineStatus := blankLine;
        {otherChar := true;}
      end
    else
    repeat
      if theLine[i] in ['A'..'Z'] then
        alphaChar := true
      else if theLine[i] in ['a'..'z'] then
        alphaChar := true
      else if theLine[i] in ['0'..'9'] then
        numericChar := true
      else if theLine[i] in ['+'..'-'] then
        signChar := true
      else if theLine[i] = '.' then
        periodChar := true
      else if Ord(theLine[i]) in [SPACE, TAB] then
        blankChar := true
      else if theLine[i] = ',' then
        commaChar := true
      else
        otherChar := true;
      i := i + 1;
    until alphaChar or (i = n + 1);

    if n <> 0 then
      begin
        if alphaChar or otherChar then
          LineStatus := nonNumeric
        else {if (alphaChar = false) and (otherChar = false) then}
          begin
            if numericChar and commaChar then
              LineStatus := commaSeparated
            else if numericChar and (not alphaChar) then
              LineStatus := numericLine
            else
             LineStatus := nonNumeric;
          end;
      end; {n <> 0}

  end; {LineStatus}

  {_________________________________________________}


  {_________________________________________________}

    procedure XReadANumericLine (theLine: string;
                    var foundNo: integer;
                    var numberVec: vector);

      const {ASCII Codes}
        TAB = 9;
        SPACE = 32;

      var
        i: integer;
        theNumber: real;
        numberString: string;
    begin
      i := 0;
      repeat
        ReplaceEveryCaseOf(',', ' ', theLine);
        StripLeadingBlanks(theLine);
        StripTrailingBlanks(theLine);
        numberString := '';
        repeat
          numberString := Concat(numberString, theLine[1]);
          Delete(theLine, 1, 1);
        until (Ord(theline[1]) in [SPACE, TAB]) or (Length(theLine) = 0);

        theNumber := StringToDecimal(numberString);
        i := i + 1;
        numberVec[i] := theNumber;
      until (Length(theLine) = 0) or (i = 50);
      foundNo := i;
    end; {XReadANumericLIne}

  {_________________________________________________}

{_____________________________________________________________________________}

  procedure ReadANumericLine (theLine: string;
                  var foundNo: integer;
                  var numberVec: vector);
  var
    numberString: string;
    n: integer;

  begin
  {SHOWMESSAGE(theLine);}
   ReplaceEveryCaseOf(',', ' ', theLine);
   StripTrailingBlanks(theLine);
   theLine := Concat(theLine, ' ');
   foundNo:= 0;

   {SHOWMESSAGE(theLine + ' and FoundNo = ' + IntToStr(foundNo)); }

   repeat
     StripLeadingBlanks(theLine);
     n := Pos(' ', theLine);

   {SHOWMESSAGE(' strip leadind Blanks ' + theLine);}


     if n > 0 then
       begin
       numberString := Copy(theLine, 1, n - 1);

       Delete(theLine, 1, n);
       foundNo := foundNo + 1;
       numberVec[foundNo] := StrToFloat(numberString)
       end;
   until (n = 0);

   {SHOWMESSAGE(theLine + ' and FoundNo = ' + IntToStr(foundNo));}

  end; {ReadANumericLIne}

{______________________________________________________________________________}

procedure TestTheSlope (var y: longVector;
                var dataBOX: rBOX);
  var
    numer, denom, dev, ySum, yMean: real;
    yVar, epSS, slope, degrees: real;
    t, Tcap: integer;

begin
  Tcap := dataBOX.NOPUNCT;
  yMean := 0.0;
  ySum := 0.0;
  numer := 0.0;
  yVar := 0.0;

  for t := 0 to Tcap - 1 do
    ySum := ySum + y[t];

  if Tcap > 0 then
    yMean := ySum / Tcap;

  for t := 0 to Tcap - 1 do
    begin
      dev := y[t] - yMean;
      yVar := dev * dev;
      numer := numer + t * dev;
    end;

  yVar := yVar / (Tcap - 1);
  denom := (Tcap - 1) * Tcap * (Tcap + 1);
  denom := denom / 12.0;
  slope := numer / denom;
  degrees := Arctan(slope);
  degrees := degrees * 45 / Arctan(1.0);
  dataBOX.slopeDegrees := degrees;

  {Writeln('    The slope parameter of the data = ', slope : 6 : 4);}
  {Writeln('    The slope parameter in degrees = ', degrees : 6 : 4);}

  if degrees < 2.0 then
    begin
      {ResidualsInData := true;}
      {weHaveATrend := false;}
      dataAreTrended := false;
    end
  else
    begin
      {ResidualsInData := false;}
      {weHaveATrend := true;}
      dataAreTrended := true;
    end;
 {if dataAreTrended then
   ShowMessage('The data ARE trended')
 else
   ShowMessage('The data trend has NOT been detected'); }


end; {TestTheSlope}

{______________________________________________________________________________}

  procedure ReadDataSafely (var dataFileName: string;
                  var dataBOX: rBOX;
                  var dataVector: longVector;
                  maxArray: integer);

    const
      numericLine = 1;
      commaSeparated = 2;
      nonNumeric = 3;
      blankLine = 4;

    var
      dataSeries: pointsVector;
      quit, alphaAlert, goForIt: boolean;
      univariate, indexed, joinLines: boolean;
      monotonicity, linearity: boolean;
      i, j, statusOfLine, lineNumber: integer;
      foundNo: integer;
      yStore, startSlope, increment: real;
      numberVec: vector;
      theLine: string;
      STR1, STR2, STR3, STR4: string;
      Q: textFile;
      F: textFile;{TEMP}


      {i denotes the number of numeric lines}
      {linenumber denotes the numder of lines in the .txt file}

  begin
    quit := false;
    goForIt := false;
    alphaAlert := false;
    indexed := false;

    dataBOX.NOPUNCT := -1;
    i := -1;  {i will become NOPUNCT -1 on exit}
    lineNumber := 0;
    yStore := 0.0;

    AssignFile(Q, dataFileName);
    Reset(Q);

        while (not quit) do
          begin {while not quit}
            Readln(Q, theLine );
            DeleteTheInvisibles (theLine);
            lineNumber := lineNumber + 1;
            statusOfLine := LineStatus(theLine);
            RemoveCommas(theLine);

            if statusOfLine = nonNumeric then
              begin {nonNumeric}
                   if (alphaAlert = false) and (lineNumber <= 5) then
                  begin {lineNumber <= 5}
                    STR1 := 'ALERT!';
                    STR2 := 'This file contains non-numeric symbols. Unless these are confined';
                    STR3 := ' to the top of the file, the attempt to read it will be discontinued.';
                    ShowMessage(STR1 + Chr(13)+ STR2 + STR3);
                    alphaAlert := true;
                  end; {lineNumber <= 5}

                if (lineNumber > 5) then
                  begin {lineNumber > 5}
                     STR1 := 'ABORT!';
                    STR2 := 'This  file contains non-numeric symbols, which are not confined to';
                    STR3 := ' the top of the file. The attempt to read it has been discontinued.';
                    ShowMessage(STR1 + Chr(13) + STR2 + STR3);
                    quit := true;
                    goForIt := false;
                    foundNo := 0;
                  end; {lineNumber > 5}
              end; {nonNumeric}

            if (statusOfLine = numericLine) or (statusOfLine = commaSeparated) then
              begin {Numeric or Comma Separated}
                ReadANumericLine(theLine, foundNo, numberVec);

                if (i + foundNo > maxArray) then
                  quit := true;

                if (goForIt = false) then
                  begin {Testing}
                    univariate := false;
                    indexed := false;
                    joinLines := false;

                    if foundNo = 1 then
                      begin   {single number}
                        STR1 := 'The line which  has just been read contains a single number. This';
                        STR2 := ' will be regarded as an observation on a univariate  series which';
                        STR3 := ' will be associated with an index sequence starting at zero and';
                        STR4 := ' increasing by one with each new observation.';
                        MessageDlg(STR1 + STR2 + STR3 + STR4, mtInformation, [mbOK], 0);
                        univariate := true;
                        goForIt := true;
                      end;   {single number}

                    if foundNo = 2 then
                      begin   {two numbers}
                        STR1 := 'The line which  has been read contains two numbers. The requirement';
                        STR2 := ' is for a univariate series  which may be accompanied by a serial or';
                        STR3 := ' index number which must preceed the observation. The first number';
                        STR4 := ' will be regarded as the index. It will be checked for consistency.';
                        MessageDlg(STR1 + STR2 + STR3 + STR4, mtInformation, [mbOK], 0);
                        indexed := true;
                        goForIt := true;
                      end;  {two numbers}

                    if not (foundNo in [1, 2]) then
                      begin {multiple numbers}
                        STR1 := 'The line which has been read contains '+ IntToStr(foundNo) + ' numbers. The requirement';
                        STR2 := ' is for a univariate series, which may be accompanied by a serial';
                        STR3 := ' or index number that must preceed the observation. Do you wish';
                        STR4 := ' to construct a univariate series by joining the lines.';
                        if MessageDlg(STR1 + STR2 + STR3 + STR4, mtConfirmation, [mbYes, mbNo], 0) = mrYes then
                          begin
                            goForIt := true;
                            joinLines := true;
                          end
                        else
                          begin {ABORT}
                            STR1 := 'ABORT!';
                            STR2 := ' The attempt to read the file has been discontinued.';
                            MessageDlg(STR1 + Chr(13) + STR2, mtInformation, [mbOK], 0);
                            quit := true;
                            goForIt := false;
                          end; {ABORT}
                      end; {multiple numbers}

                  end; {Testing}
              end;{Numeric or Comma Separated}

            if goForIt and (statusOfLine <> blankLine) then
              begin {goForit}

                if univariate then
                  begin {univariate}
                    i := i + 1;
                    dataSeries[i].x := i;
                    dataSeries[i].y := numberVec[1];
                  end; {univariate}

                if indexed then
                  begin {indexed}
                    i := i + 1;
                    dataSeries[i].x := numberVec[1];
                    dataSeries[i].y := numberVec[2];
                  end; {indexed}

                if (joinLines and not quit) then
                  begin {joinLines: if i + foundNo < maxArray}
                    for j := 1 to foundNo do
                      begin {j}
                        dataSeries[i + j].x := i + j;
                        dataSeries[i + j].y := numberVec[j];
                      end; {j}
                    i := i + foundNo;
                    end; {joinLines}

              end; {goForIt}

            if EOF(Q) or (i = 510) then
              quit := true;
            If (i = 510) then
              ShowMessage('The number of datapoints has reached the limit of 510. No further points can be read.');
          end; {while not quit}

         CloseFile(Q);
         dataBOX.NOPUNCT := i + 1;

         {ShowMessage(' NOPUNCT = ' + IntToStr(dataBOX.NOPUNCT));}

    monotonicity := true;
    linearity := true;
    startSlope := dataSeries[1].x - dataSeries[0].x;

    for i := 0 to dataBOX.NOPUNCT - 1 do
      begin {i}
        if i = 0 then
          begin {i = 0}
            dataBOX.yMax := dataSeries[0].y;
            dataBOX.yMin := dataSeries[0].y;
            dataBOX.xMax := dataSeries[0].x;
            dataBOX.xMin := dataSeries[0].x;
          end {i = 0}
        else
          begin {i <> 0}
            increment := dataSeries[i].x - dataSeries[i - 1].x;
            if (increment < 0) then
              monotonicity := false;
            if (increment <> startSlope) then
              linearity := false;
            dataBOX.xMax := Rmax(dataSeries[i].x, dataBOX.xMax);
            dataBOX.xMin := Rmin(dataSeries[i].x, dataBOX.xMin);
            dataBOX.yMax := Rmax(dataSeries[i].y, dataBOX.yMax);
            dataBOX.yMin := Rmin(dataSeries[i].y, dataBOX.yMin);
          end; {i <> 0}
        yStore := yStore + dataSeries[i].y;
        dataVector[i] := dataSeries[i].y;
      end;{i}

    if indexed then
      begin {indexed series}
        if (linearity) then
          begin {linearity}
            STR1 := ' The index which accompanies the series is linear';
            STR2 := ' (i.e. it has a constant increment). ';
            ShowMessage(STR1 + STR2 );
          end {linearity}
        else if monotonicity then
          begin {nonlinearity}
            STR1 := ' The index which accompanies the series is monotonic';
            STR2 := ' (i.e. it increases with each observation), but it';
            STR3 := ' is nonlinear i.e. it contains unequal increments).';
            ShowMessage(STR1 + STR2 + STR3);
          end {nonlinearity}
        else
          begin {non-monotonicity}
            STR1 := ' The index which accompanies the series is non-monotonic';
            STR2 := ' (i.e. it both increases and decreases.) This will cause';
            STR3 := ' problems in plotting the series.';
            ShowMessage(STR1 + STR2 + STR3);
          end; {non-monotonicity}
        end; {indexed series}

    if dataBOX.NOPUNCT > 0 then
      begin
        thereIsData := true;
        MakeDataBox (dataBOX, dataVector);
        PUNCTSTORE := dataBOX.NOPUNCT;
        dataBOX.xLB := dataBOX.xMin;
        dataBOX.xRB := dataBOX.xMax;
        dataBOX.yMean := yStore / dataBOX.NOPUNCT;
      end;


    {MakeDataBox (dataBOX, dataVector); }

  {----------------------------------------------}

    dataBOx.EXTRA := 0;
    {thereIsData := true;}
    enoughData := false;
    logsTaken := false;
    badElements:= false;
    dataExtrapolated := false;

    weHavePolyResiduals := false;
    weHaveTrendResiduals := false;
    weHaveSeasonalComponent := false;
    weHaveATrendCycle := false;
    weHaveACycle := false;
    weHaveSeasonallyAdjustedData := false;
    dataAreTrended := true;
    dataName := 'an unnamed series';

  {----------------------------------------------}

  if (dataBOX.NOPUNCT >= 10) then
    begin
      enoughData := true;
      TestTheSlope (dataVector, dataBOX);
    end
  else
    ShowMessage(' You have read ' + IntToStr(dataBOX.NOPUNCT)+ ' points, whick is an insufficient number');



  end; {ReadDataSafely}

{______________________________________________________________________________}

  procedure WriteData (var dataBOX: rBOX;
                  var dataVector: longVector);

    var
      i, Tcap: integer;
      serials: boolean;
      dataFileName: string;
      F: textFile;

  begin {WriteData}
    Tcap := dataBOX.NOPUNCT;
    YesOrNo('    Do you want to have serial numbers', serials);
    Write('    Name the new data file = ');
    Readln(dataFileName);
    if dataFileName <> '' then
      begin {if}
        Assign(F, dataFileName);
        Rewrite(F);
        Writeln(F);
        for i := 0 to Tcap - 1 do
          begin {i}
            if serials then
              Writeln(F, i : 3, '  ', dataVector[i] : 10 : 5)
            else
              Writeln(F, '  ', dataVector[i] : 10 : 5)
          end; {i}
        Close(F);
      end; {if}
  end; {WriteData}

{______________________________________________________________________________}

  procedure MakeDataBox (var dataBOX: rBOX;
                  var dataVector: longVector);

    var
      dataMean, minValue, maxValue: real;
      t: integer;

  begin
    dataMean := 0.0;
    for t := 0 to dataBOX.NOPUNCT - 1 do
      begin {t}
        dataMean := dataMean + dataVector[t];
        if t = 0 then
          begin {if}
            minValue := dataVector[0];
            maxValue := dataVector[0];
          end {if}
        else
          begin {else}
            maxValue := Rmax(maxValue, dataVector[t]);
            minValue := Rmin(minValue, dataVector[t]);
          end; {else}
      end; {t}
    {SHOWMESSAGE(' dataBOX.NOPUNCT = ' + IntToStr(dataBOX.NOPUNCT));}
    if (dataBOX.NOPUNCT > 0) then
      dataMean := dataMean / dataBOX.NOPUNCT;

    with dataBOX do
      begin
        {EXTRA := 0};
        xMin := 0.0;
        xMax := NOPUNCT - 1;
        xLB := 0.0;
        xRB := NOPUNCT - 1;
        yMin := minValue;
        yMax := maxValue;
        yMean := dataMean;
        yUB := yMax;
        yLB := yMin;
        yRange :=  yMax - yMin;
      end;

{yRange := yMax - yMin}
{dataBOX.yUB := dataBOX.yUB + 0.2 * yRange;}
{dataBOX.yLB := dataBOX.yUB - 0.2 * yRange;}

  end; {MakeDataBox}

{______________________________________________________________________________}


  procedure SaveDataVector(realBOX: rBOX;
                   var realVector: longvector;
                   var dataFileName: string);

  {This is a tentative replacement for WriteData}
 var
   Q: textFile;
   Tcap, i:integer;

begin
 {SaveDialog.Execute;}
 {i :=0;}
 {Tcap := dataBOX.NOPUNCT;}
 {dataFileName := SaveDialog.FileName;}
 {ShowMessage(dataFileName);}
 {SHOWMESSAGE(' the datafileName = ' +  datafileName);}
 AssignFile(Q, dataFileName);
 ReWrite(Q);
 {SHOWMESSAGE(' the datafileName = ' +  datafileName + '    dataBOX.NOPUNCT =' + IntToStr(dataBOX.NOPUNCT)); }
 for i := 0 to realBOX.NOPUNCT -1 do
   Writeln(Q, realVector[i]: 6:4);

 CloseFile(Q);
end;
 {______________________________________________________________________________}


end.  {UTILS: Unit of SEASCAPE.PAS}

{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
 {SHOWMESSAGE('ABOUT TO WRITE 2DATATEST.txt'); }
 dataFileName :=  'DATATEST.txt';
  AssignFile(F, dataFileName);
  ReWrite(F);
  {SHOWMESSAGE('WHERE IS ' + dataFileName);}
  for i := 0 to dataBOX.NOPUNCT do
    begin
      WRITE(F, 'index = ', dataSeries[i].x :6:4);
      WRITELN(F, '    number = ', dataSeries[i].y :6:4)
    end;
  CloseFile(F);
 {++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

