unit TIMEFILT; {Unit of SEASCAPE.PAS}

interface

  uses
    dialogs, GLOBALS, UTILS, MATHS, LEGENDS, DATASEG, SCREEN;

  procedure Convolution (var alpha, beta: seasVector;
                  p, k: integer);

  procedure Laurent (var mu, gamma: seasVector;
                  q: integer);

  procedure Minit (var mu: vector;          {REDUNDANT ?}
                  var varEpsilon: real;
                  gamma: vector;
                  q: integer);

  procedure SeasonalPoles (var s: integer;    {REDUNDANT ?}
                  var rho: real;
                  var poles: complexVector);

  procedure SeasonalZeros (var s: integer;     {REDUNDANT ?}
                  var zeros: complexVector);

  procedure Toeplitz (gamma: seasVector;    {Toeplitz is already in WIENER}
                  var y: longVector;
                  n, q: integer);

  procedure SprimeY (var y: longVector;
                  s, Tcap: integer);

  procedure FormkappaSy (var s, Tcap: integer;
                  var factor: real;
                  var y: longVector);

  procedure SprimeY2 (q, n: integer;
                  var alpha: seasVector;
                  var y: longVector);

  procedure Sy2 (q, n: integer;
                  var alpha: seasVector;
                  var y: longVector);

  procedure ApplySingleSeasonalFilter (var s, Tcap: integer;
                  var phi, sigmaVec: seasVector;
                  var seasonVec, adjustedVec: longVector);

  procedure ApplySmoothingFilter (var s, q, Tcap: integer;
                  var phi, sigmaVec, firVec: seasVector;
                  var seasonVec, adjustedVec: longVector);

  procedure ApplyDoubleSeasonalFilter (var s, Tcap: integer;
                  var phi1, phi2, sigmaVec1, sigmaVec2: seasVector;
                  var seasonVec, adjustedVec: longVector);

  procedure ApplyTripleSeasonalFilter (var s, Tcap: integer;
                  var phi, phi1, phi2, sigmaVec, sigmaVec1, sigmaVec2: seasVector;
                  var seasonVec, adjustedVec: longVector);

implementation

{_________________________________________________}

  procedure Convolution (var alpha, beta: seasVector;
                  p, k: integer);
    var
      gamma: real;
      i, j, r, s: integer;

  begin

    for j := p + k downto 0 do
      begin {j}
        s := Min(j, p);
        r := Max(0, j - k);
        gamma := 0.0;
        for i := r to s do
          gamma := gamma + alpha[i] * beta[j - i];
        beta[j] := gamma;
      end; {j}

  end; {Convolution}

{_________________________________________________}

  procedure Laurent (var mu, gamma: seasVector;
                  q: integer);

    var
      i, j: integer;

  begin
    for i := 0 to q do
      begin {i}
        gamma[i] := 0.0;
        for j := 0 to q - i do
          gamma[i] := gamma[i] + mu[j] * mu[j + i];
      end; {i}
  end; {Laurent}

{________________________________________________}

  procedure Minit (var mu: vector;
                  var varEpsilon: real;
                  gamma: vector;
                  q: integer);

    var
      D: matrix;
      delta, f: vector;
      i, j, iterations: integer;
      convergence: boolean;

  {-------------------------------------------}

    function CheckDelta (q: integer;
                    var delta, mu: vector): boolean;

      var
        i: integer;
        muNorm, deltaNorm: real;

    begin
      muNorm := 0.0;
      deltaNorm := 0.0;
      for i := 0 to q do
        begin
          muNorm := muNorm + sqr(mu[i]);
          deltaNorm := deltaNorm + Sqr(delta[i])
        end;
      if (deltaNorm / muNorm) > 1.0E-20 then
        CheckDelta := false
      else
        CheckDelta := true;

    end; {Checkdelta}

  {------------------------------------------}

  begin {PROCEDURE Minit}

  {initialise the vector mu }
    for i := 0 to q do
      mu[i] := 0.0;
    mu[0] := Sqrt(gamma[0]);
    convergence := false;
    iterations := 0;

    while (convergence = false) and (iterations < 25) do
      begin

  {Form the matrix of derivatives}
        for i := 0 to q do
          for j := 0 to q do
            begin
              D[i, j] := 0.0;
              if (j - i) >= 0 then
                D[i, j] := mu[j - i];
              if (i + j) <= q then
                D[i, j] := D[i, j] + mu[i + j];
            end;

  {Find the function value}
        for j := 0 to q do
          begin
            f[j] := gamma[j];
            for i := 0 to q - j do
              f[j] := f[j] - mu[i] * mu[i + j]
          end;

  {Find the updating vector}
        LUsolve(0, q + 1, D, delta, f);

  {Update the value of mu}
        for i := 0 to q do
          mu[i] := mu[i] + delta[i];
        iterations := iterations + 1;

  {Check for convergence}
        convergence := CheckDelta(q, delta, mu);
      end; {while}

  {Renomalise the results}
    varEpsilon := 1.0;
    for i := 1 to q do
      begin {i}
        mu[i] := mu[i] / mu[0];
        varEpsilon := varEpsilon + mu[i] * mu[i];
      end; {i}
    mu[0] := 1;
    varEpsilon := gamma[0] / varEpsilon;

  end; {Minit}


{_________________________________________________}

  procedure SeasonalPoles (var s: integer;
                  var rho: real;
                  var poles: complexVector);

    var
      theta: real;

  begin
    if (s = 12) then
      begin
        theta := (2.0 * Arctan(1.0)) / 3.0;

        poles[1].re := rho * Cos(theta);
        poles[1].im := rho * Sin(theta);

        poles[5].re := -poles[1].re;
        poles[5].im := poles[1].im;

        poles[7].re := -poles[1].re;
        poles[7].im := -poles[1].im;

        poles[11].re := poles[1].re;
        poles[11].im := -poles[1].im;

        poles[2].re := rho * Cos(2.0 * theta);
        poles[2].im := rho * Sin(2.0 * theta);

        poles[4].re := -poles[2].re;
        poles[4].im := poles[2].im;

        poles[8].re := -poles[2].re;
        poles[8].im := -poles[2].im;

        poles[10].re := poles[2].re;
        poles[10].im := -poles[2].im;

        poles[3].re := 0.0;
        poles[3].im := rho;

        poles[6].re := rho;
        poles[6].im := 0.0;

        poles[9].re := 0.0;
        poles[9].im := -rho;
      end;

    if (s = 4) then
      begin
        poles[1].re := 0.0;
        poles[1].im := rho;

        poles[2].re := -rho;
        poles[2].im := 0.0;

        poles[3].re := 0.0;
        poles[3].im := -rho;
      end;

  end; {SeasonalPoles}

{_________________________________________________}

  procedure SeasonalZeros (var s: integer;
                  var zeros: complexVector);

    var
      theta: real;

  begin
    if s = 12 then
      begin
        theta := (2.0 * Arctan(1.0)) / 3.0; {30 degrees}

        zeros[1].re := Cos(theta);
        zeros[1].im := Sin(theta);

        zeros[5].re := -zeros[1].re;
        zeros[5].im := zeros[1].im;

        zeros[7].re := -zeros[1].re;
        zeros[7].im := -zeros[1].im;

        zeros[11].re := zeros[1].re;
        zeros[11].im := -zeros[1].im;

        zeros[2].re := Cos(2.0 * theta);
        zeros[2].im := Sin(2.0 * theta);

        zeros[4].re := -zeros[2].re;
        zeros[4].im := zeros[2].im;

        zeros[8].re := -zeros[2].re;
        zeros[8].im := -zeros[2].im;

        zeros[10].re := zeros[2].re;
        zeros[10].im := -zeros[2].im;

        zeros[3].re := 0.0;
        zeros[3].im := 1.0;

        zeros[6].re := -1.0;
        zeros[6].im := 0.0;

        zeros[9].re := 0.0;
        zeros[9].im := -1.0;
      end;

    if (s = 4) then
      begin
        zeros[1].re := 0.0;
        zeros[1].im := 1.0;

        zeros[2].re := -1.0;
        zeros[2].im := 0.0;

        zeros[3].re := 0.0;
        zeros[3].im := -1.0;
      end;

  end; {SeasonalZeros}

{_________________________________________________}

  procedure Toeplitz (gamma: seasVector;
                  var y: longVector;
                  n, q: integer);

  {This procedure uses a Cholesky decomposition to find the solution of}
  {the equation Gx = y,  where  G is a symmetric Toeplitz matrix of order}
  {n with q supra-diagonal and q sub-diagonal bands . The coefficients of}
  {G are contained in gamma. The RHS vector y contains the elements of}
  {the solution vector x on completion.}

{gamma has been formed already as phi via <WKCoefficients>}
{MaxOrder = 12 to accompdate monthly seasonal adjustment MaxArray = 500}

    var
      t, j, k: integer;
      mu: array[-12..maxOrder, -maxOrder..maxArray] of real; {wideMatrix}
       {mu:  wideMatrix;}

  begin {Toeplitz}

  {Factorise}
    for t := -q to q - 1 do
      begin
      for j := t + 1 to q do
        mu[j, t] := 0.0;
      end;

    for t := 0 to n do
      begin {t}
        for k := Min(q, t) downto 0 do
          begin {k}
            mu[k, t] := gamma[k];
            for j := 1 to q - k do
              mu[k, t] := mu[k, t] - mu[j, t - k] * mu[j + k, t] * mu[0, t - k - j];
            if k > 0 then
              mu[k, t] := mu[k, t] / mu[0, t - k];
          end;{k}
      end; {t}

  {ForwardSolve;}
    for t := 0 to n do
      for j := 1 to Min(t, q) do
        y[t] := y[t] - mu[j, t] * y[t - j];

  {Divide by the diagonal}
    for t := 0 to n do
      y[t] := y[t] / mu[0, t];

  {BackSolve;}
    for t := n downto 0 do
      for j := 1 to Min(q, n - t) do
        y[t] := y[t] - mu[j, t + j] * y[t + j];

  end; {Toeplitz}

{_________________________________________________}

  procedure SprimeTheta (var theta: vector;
                  var y: longVector;
                  q, Tcap: integer);

{THIS IS NOW REDUNDANT}

{This is a subroutine of ApplySeasonalFilter}
{is this seasonal cumulation? }
{q is the number of elements in theta}
    var
      t, j: integer;
  begin
    for t := 0 to Tcap - 1 - q do
      for j := 1 to q do
        y[t] := y[t] + theta[j] * y[t + j];

  end; {SprimeTheta}

{_________________________________________________}

  procedure SprimeY (var y: longVector;
                  s, Tcap: integer);

{THIS IS NOW REDUNDANT}
{This is a subroutine of ApplySeasonalFilter}
{is this seasonal cumulation? }

    var
      t, j: integer;
  begin
    for t := 0 to Tcap - s do
      for j := 1 to s - 1 do
        y[t] := y[t] + y[t + j];
  end; {SprimeY}

{_________________________________________________}

  procedure FormkappaSy (var s, Tcap: integer;
                  var factor: real;
                  var y: longVector);

{THIS IS NOW REDUNDANT}
{This is a subroutine of ApplySeasonalFilter}

    var
      p, q, t, j: integer;
  begin
    for t := Tcap - 1 downto 0 do
      begin {t}
        p := 1;
        q := s - 1;

        if t < s - 1 then
          q := t;

        if (t > (Tcap - s)) then
          begin
            y[t] := 0.0;
            p := s + t - Tcap;
          end;

        for j := p to q do
          y[t] := y[t] + y[t - j];

        y[t] := y[t] * factor;
      end; {t}

  end; {FormkappaSy}

{_________________________________________________}

  procedure Sy2 (q, n: integer;
                  var alpha: seasVector;
                  var y: longVector);

{We need to introduce Sigmavec. What sort of strucyure does it have?}
    var
      t, j, r, s: integer;
      store: real;

  begin
    for t := n downto 0 do
      begin
        r := Max(0, q - t);
        s := Min(q, n - t);
        store := 0.0;
        for j := r to s do
          store := store + alpha[j] * y[t - q + j];
        y[t] := store;
      end;
  end; {Sy2}

{_________________________________________________}

  procedure SprimeY2 (q, n: integer;
                  var alpha: seasVector;
                  var y: longVector);

{We need to introduce Sigmavec. What sort of structure does it have?}

    var
      t, j: integer;
      store: real;

  begin
    for t := 0 to n - q do
      begin {t}
        store := 0.0;
        for j := 0 to q do
          store := store + alpha[q - j] * y[t + j];
        y[t] := store;
      end; {t}
  end; {SPrimeY2}

{_________________________________________________}

  procedure ApplySingleSeasonalFilter (var s, Tcap: integer;
                  var phi, sigmaVec: seasVector;
                  var seasonVec, adjustedVec: longVector);

{To be called by <ApplyTimeDomainFilters> in ORGANISE}

{adjustedVec is a copy of residueVec--the residue from a polynonial detrending.}
{It will eventually contain the seasonaly adjusted data. SeasonalVec, which is }
{also a copy of residueVec, will eventually contain the seasonal fluctuations,}

    var
      t: integer;

  begin
    Sprimey2(s - 1, Tcap - 1, sigmaVec, adjustedVec);

    Toeplitz(phi, adjustedVec, Tcap - s, s - 1);
    Sy2(s - 1, Tcap - 1, sigmaVec, adjustedVec);

    for t := 0 to Tcap - 1 do
      seasonVec[t] := seasonVec[t] - adjustedVec[t];

    weHaveSeasonalComponent := true;
    weHaveATrendCycle := false;
    weHaveACycle := false;

  end;{ApplySingleSeasonalFilter}

{_________________________________________________}

  procedure ApplySmoothingFilter (var s, q, Tcap: integer;
                  var phi, sigmaVec, fIRVec: seasVector;
                  var seasonVec, adjustedVec: longVector);
    var
      t: integer;
      F: text;{TEMP}

  begin
    Sprimey2(s - 1, Tcap - 1, sigmaVec, adjustedVec);
    Toeplitz(phi, adjustedVec, Tcap - s, s - 1);
    Sy2(s - 1, Tcap - 1, sigmaVec, adjustedVec);

    Sprimey2(q, Tcap - 1, fIRVec, adjustedVec);
    Sy2(q, Tcap - 1, fIRVec, adjustedVec);

    for t := 0 to Tcap - 1 do
      seasonVec[t] := seasonVec[t] - adjustedVec[t];

    weHaveSeasonalComponent := false;
    weHaveATrendCycle := false;
    weHaveSeasonallyAdjustedData := false;
    weHaveACycle := true;

    {+++++++++++++++++++++++++++++++++++++++++++++++}
    {AssignFile(F, 'BINOMILALWGT,txt');
    Rewrite(F);
    Writeln(F, ' q = ', q:4);
    for t := 0 to q do
      Writeln(F, '  mu[',t:1,']= ', firVec[t]: 6:4);
    CloseFile(F) }
    {+++++++++++++++++++++++++++++++++++++++++++++++}


  end; {ApplySmoothingFilter}

{_________________________________________________}

  procedure ApplyDoubleSeasonalFilter (var s, Tcap: integer;
                  var phi1, phi2, sigmaVec1, sigmaVec2: seasVector;
                  var seasonVec, adjustedVec: longVector);

    var
      t: integer;

  begin

    Sprimey2(s - 2, Tcap - 1, sigmaVec1, adjustedVec);
    Toeplitz(phi1, adjustedVec, Tcap - s + 1, s - 2);
    Sy2(s - 2, Tcap - 1, sigmaVec1, adjustedVec);

    Sprimey2(s, Tcap - 1, sigmaVec2, adjustedVec);
    Toeplitz(phi2, adjustedVec, Tcap - s - 1, s);
    Sy2(s, Tcap - 1, sigmaVec2, adjustedVec);

    for t := 0 to Tcap - 1 do
      seasonVec[t] := seasonVec[t] - adjustedVec[t];

    weHaveSeasonalComponent := true;
    weHaveSeasonallyAdjustedData := false;
    weHaveATrendCycle := false;
    weHaveACycle := false;

  end;{ApplyDoubleSeasonalFilter}

{_________________________________________________}

  procedure ApplyTripleSeasonalFilter (var s, Tcap: integer;
                  var phi, phi1, phi2, sigmaVec, sigmaVec1, sigmaVec2: seasVector;
                  var seasonVec, adjustedVec: longVector);

    var
      t: integer;
      F: text;

  begin

    Sprimey2(s - 1, Tcap - 1, sigmaVec, adjustedVec);
    Toeplitz(phi, adjustedVec, Tcap - s, s - 1);
    Sy2(s - 1, Tcap - 1, sigmaVec, adjustedVec);

    Sprimey2(s - 2, Tcap - 1, sigmaVec1, adjustedVec);
    Toeplitz(phi1, adjustedVec, Tcap - s + 1, s - 2);
    Sy2(s - 2, Tcap - 1, sigmaVec1, adjustedVec);

    Sprimey2(s, Tcap - 1, sigmaVec2, adjustedVec);
    Toeplitz(phi2, adjustedVec, Tcap - 1 - s, s);
    Sy2(s, Tcap - 1, sigmaVec2, adjustedVec);

    for t := 0 to Tcap - 1 do
      seasonVec[t] := seasonVec[t] - adjustedVec[t];

    weHaveSeasonalComponent := true;
    weHaveTrendResiduals := false;
    weHaveATrendCycle := false;
    weHaveACycle := false;

  end;{ApplyTripleSeasonalFilter}

{______________________________________________________________________________}


end. {TIMEFILT: Unit of SEASCAPE.PAS}

