unit SCREEN; {Unit of SEASCAPE.PAS}

interface

  uses
    GLOBALS, UTILS, LEGENDS,
    Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs;

  procedure TallyPoints (range: real;
                  var taly: real);

  procedure MarksAndNumbers (var FplotScreen: TForm;
                  XSTART, YSTART: integer;
                  taly, firstMark, farBound, STEP: real;
                  Axis: string);

  procedure ScreenFrame (var FplotScreen: TForm;
                  var dataBOX: rBOX;
                  var SCREENBOX: IBOX);

  procedure ScreenFrameLite (var Form1: TForm;
                  var realBOX: rBOX;
                  var SCREENBOX: IBOX);

  procedure InvisibleFrame (var realBOX: rBOX);

  procedure VertAxis (var Form1: TForm;
                  XSTART, YSTART: integer;
                  taly, firstMark, farBound, VSTEP: real);

  procedure ZeroPiAxis (var Form1: TForm;
                  var SCREENBOX: IBOX);

  procedure DoDecAxis (var Form1: TForm;
                  var SCREENBOX: IBOX);

  procedure ScreenPlot (var Form1: TForm;
                  var realBOX: rBOX;
                  var SCREENBOX: IBOX;
                  var dataVector: longVector);

  procedure ScreenBiPlot (var Form1: TForm;
                    var realBOX: rBOX;
                    var SCREENBOX: IBOX;
                    var dataVector: pointsVector);


  procedure ScreenPlotMod (var Form1: TForm;
                  var realBOX: rBOX;
                  var SCREENBOX: IBOX;
                  var dataVector: longVector);

  procedure ScreenOverplot (var Form1: TForm;
                  var dataBOX: rBOX;
                  var SCREENBOX: IBOX;
                  var dataVector, trendVector: longVector;
                  var legend: string);

  procedure ScreenZeroPiPlot (var Form1: TForm;
                  var filterSpec: filterRecord;
                  var dataBOX: rBOX;
                  var SCREENBOX: IBOX;
                  var dataVector: longVector;
                  var legend: string);

  procedure MakeDataLine (var Form1: TForm;
                  var Tvert: integer;
                  var SCREENBOX: IBOX;
                  var residueBOX: rBOX);

  procedure MakeDottedLine(var Form1: TForm;
                   var Tvert: integer;
                  var SCREENBOX: IBOX);

  procedure  ShadedRectangle(var Form1: TForm;
                  var shadedBOX: integerRect);

  procedure HighLightRegions (var Form1: TForm;
                  var sBandWidth, sBandCentre: triIntVec;
                  var SCREENBOX: IBOX);
implementation

{_________________________________________________}

  procedure TallyPoints (range: real;
                  var taly: real);

    var
      PWR, TRNC: integer;
      FACT, LogBaseTen: real;
      F:text; {TEMP}

  begin {TallyPoints}

    logBaseTen := Ln(range) / Ln(10);
    if logBaseTen > 0 then
      begin
        PWR := Trunc(logBaseTen) - 1;
        FACT := Exp(PWR * Ln(10));
        TRNC := Round(range / FACT)
      end;
    if logBaseTen = 0 then
      begin
        FACT := 0.1;
        TRNC := 10
      end;
    if logBaseTen < 0 then
      begin
        PWR := Trunc(Abs(logBaseTen)) + 2;
        FACT := Exp(PWR * Ln(10));
        TRNC := Round(range * FACT);
        FACT := 1 / FACT;
      end;
    if (TRNC >= 10) and (TRNC < 15) then
      TALY := 2.5 * FACT;
    if (TRNC >= 15) and (TRNC < 30) then
      TALY := 5 * FACT;
    if (TRNC >= 30) and (TRNC < 60) then
      TALY := 10 * FACT;
    if (TRNC >= 60) and (TRNC <= 100) then
      TALY := 20 * FACT;

  end; {TallyPoints}


{________________________________________________}

  procedure MarksAndNumbers (var FplotScreen: Tform;
                  XSTART, YSTART: integer;
                  taly, firstMark, farBound, STEP: real;
                  Axis: string);

    var
      toly, HRL, VRL: real;
      HR1, HR2, VT1, VT2, tolyWidth: integer;
      HINC, VINC, PENLEFT, PENDOWN: integer;
      tolyString: string;

  begin {MarksAndNumbers}
    {TextFont(4);
    TextSize(9);}

    if Axis = 'yScale' then
      begin {Pixel Parameters}
        HINC := 5;
        VINC := 0;
        PENDOWN := -(FplotScreen.Canvas.TextHeight('NUMBERS') div 2);
      end;
    if Axis = 'xScale' then
      begin
        HINC := 0;
        VINC := -5;
        PENDOWN := 20;
      end; {Pixel Parameters}

    toly := firstMark;
    HRL := XSTART;
    HR1 := XSTART;
    HR2 := HR1 + HINC;
    VRL := YSTART;
    VT1 := YSTART;
    VT2 := VT1 + VINC;

    while Abs(toly) <= Abs(farBound) do

      begin {while toly}
        tolyString := TalyToString(toly);
        tolyWidth := FplotScreen.Canvas.TextWidth(tolyString);
        if axis = 'xScale' then
          PENLEFT := Round(tolyWidth / 2.0);
        if axis = 'yScale' then
          PENLEFT := tolyWidth + 15;

 {Numbers}
        {MoveTo(HR1 - PENLEFT, VT1 + PENDOWN);
        DrawString(tolyString);}
        FplotScreen.Canvas.TextOut(HR1 - PENLEFT, VT1 + PENDOWN, tolyString);

  {Hatchmarks}
        FplotScreen.Canvas.MoveTo(HR1, VT1);
        FplotScreen.Canvas.LineTo(HR2, VT2);

  {Increments}
        if axis = 'xScale' then
          HRL := HRL + STEP;
        HR1 := Round(HRL);
        HR2 := HR1 + HINC;
        if axis = 'yScale' then
          VRL := VRL - STEP;
        VT1 := Round(VRL);
        VT2 := VT1 + VINC;

        toly := toly + taly;
      end; {while toly}

  end; {MarksAndNumbers}

{________________________________________________}

  procedure ScreenFrame (var FplotScreen: TForm;
                  var dataBOX: rBOX;
                  var SCREENBOX: IBOX);

    {This is the revised version of ScreenFrame}

    {Uses, MarksAndNumbers, TallyPoints, TalyToString}
    {Depends on prior application of InitialiseDataBOX }
    {and InitialiseAnIBOX}

    var
      FIRSTHATCH, XORIGIN, YORIGIN, YCap, sign: integer;
      rxPos, rxNeg, ryPos, ryNeg, vSTEP, hSTEP, taly: real;
      nearBound, farBound, boundRange, increment, startMark: real;

  begin
        {ShowMessage('We are in ScreenFrame');}
    with SCREENBOX, dataBOX do
      begin
        yUB := yMax;
        yLB := yMin;

        yRange := yMax - yMin;
        xRange := xMax - xMin;

    {(X1,  Y1) is the top left of the IBOX}
    {(X2,  Y2) is the botton lright of the IBOX}

        XORIGIN := X1;{ Default for  XORIGIN}
        YORIGIN := Y2;{ Default for  YORIGIN}

        if doFrame then
          FplotScreen.Canvas.Rectangle(X1, Y1, X2 + 1, Y2 + 1);

        if yScale = true then
          begin {Do the yScale}

    {...............................................................................................}

            if yMin * yMax >= 0 then
              begin {yMin, yMax > 0 or yMin, yMax < 0}

                if yMax < 0 then
                  begin
                    sign := -1;
                    nearBound := yMax;
                    farBound := yMin;
                  end
                else
                  begin
                    sign := 1;
                    nearBound := yMin;
                    farBound := yMax
                  end;

                if ((farBound - nearBound) / farBound) < 0.3 then
                  begin {small boundRange}

                    nearBound := nearBound - sign * (0.2 * yRange);
                    farBound := farBound + sign * (0.2 * yRange);
                    if sign = 1 then
                      begin
                        yUB := farBound;
                        yLB := nearBound
                      end
                    else
                      begin
                        yLB := farBound;
                        yUB := nearBound
                      end;

                    boundRange := Abs(farBound - nearBound);

                    {SHOWMESSAGAE(' TallyPoints in <ScreenFrame>');}

                    TallyPoints(boundRange, taly);
                    startMark := Trunc(nearBound / taly) * taly;
                    if (Abs((startMark - nearBound) / nearBound) > 0.0001) then
                      startMark := startMark + sign * taly;

                    if sign = 1 then
                      Ycap := Y2
                    else
                      Ycap := Y1;

                    FIRSTHATCH := Ycap + Round((nearBound - startMark) * BOXHGT / boundRange);
                  end {small boundRange}

                else{large boundRange}
                  begin {yMin = 0.0}

                    if yMax > 0 then
                      begin
                        farBound := 1.2 * yMax;
                        yUB := farBound;
                        yLB := 0.0;
                      end
                    else
                      begin
                        farBound := 1.2 * yMin;
                        yUB := 0.0;
                        yLB := farbound;
                      end;

                    if sign = 1 then
                      Ycap := Y2
                    else
                      Ycap := Y1;

                    boundRange := Abs(farBound);
                    TallyPoints(boundRange, taly);
                    startMark := 0.0;
                    FIRSTHATCH := Ycap;

                  end; {large boundRange}

                vSTEP := taly * (BOXHGT / boundRange);
                hSTEP := 0.0;
                MarksAndNumbers(FplotScreen, X1, FIRSTHATCH, sign * taly, startMark, farBound, sign * vSTEP, 'yScale');

              end;{yMin, yMax > 0 or yMin, yMax < 0}
    {...............................................................................................}
               {if ymax * ymin < 0}
            if (yMin < 0.0) and (yMax > 0.0) then
              begin {yMin < 0.0}
                ryPos := yMax;
                ryNeg := yMin;

                increment := 0.1 * (yMax - yMin);
                if yMax > Abs(yMin) then
                  begin
                    ryPos := 1.2 * yMax;
                    ryNeg := yMin - increment;
                  end
                else
                  begin
                    ryNeg := 1.2 * yMin;
                    ryPos := yMax + increment
                  end;
                yUB := ryPos;
                yLB := ryNeg;

                YORIGIN := Y2 + Round(BOXHGT * ryNeg / (ryPos - ryNeg));   {ryNeg / (yUB - yLB)}

                if (xScale = true) or (xAxis = true) then
                  begin {this draws the horizontal axis through y = 0}
                    FplotScreen.Canvas.MoveTo(X1, YORIGIN);
                    FplotScreen.Canvas.LineTo(X2, YORIGIN)
                  end;

                if ryPos >= Abs(ryNeg) then
                  begin
                    TallyPoints(ryPos, taly);
                    vSTEP := (YORIGIN - Y1) * (taly / ryPos);
                  end
                else {if ryPos < Abs(ryNeg)}
                  begin
                    TallyPoints(-ryNeg, taly);
                    vSTEP := (YORIGIN - Y2) * (taly / ryNeg);
                  end;

                hSTEP := 0.0;
                MarksAndNumbers(FplotScreen, X1, YORIGIN, taly, 0.0, ryPos, vSTEP, 'yScale');
                MarksAndNumbers(FplotScreen, X1, YORIGIN, -taly, 0.0, ryNeg, -vSTEP, 'yScale');

              end; {yMin < 0.0 and yMax > 0.0}
    {...............................................................................................}

          end; {Do the yScale}

    {-----------------------------------------------}

        if xScale then
          begin {Do the xScale}

    {...............................................................................................}

            if (xMin <= 0.0) and (xMax >= 0) then
              begin {xMin <= 0.0}
                rxPos := xMax;
                rxNeg := xMin;

                if (xMin < 0.0) then
                  XORIGIN := X1 - Round(BOXWDT * rxNeg / (rxPos - rxNeg))
                else
                  XORIGIN := X1;

                if (xMin < 0.0) and (yScale = true) then
                  begin  {This provides the vertical axis through x =0}
                    FplotScreen.Canvas.MoveTo(XORIGIN, Y1);
                    FplotScreen.Canvas.LineTo(XORIGIN, Y2)
                  end;

                if rxPos > Abs(rxNeg) then
                  begin
                    TallyPoints(rxPos, taly);
                    hSTEP := (X2 - XORIGIN) * (taly / rxPos);
                  end
                else
                  begin
                    TallyPoints(-rxNeg, taly);
                    hSTEP := (X1 - XORIGIN) * (taly / rxNeg);
                  end;

                VSTEP := 0;
                if xMax > 0.0 then
                  MarksAndNumbers(FplotScreen, XORIGIN, Y2, taly, 0, rxPos, hSTEP, 'xScale');
                if xMin < 0.0 then
                  MarksAndNumbers(FplotScreen, XORIGIN, Y2, -taly, 0, rxNeg, -hSTEP, 'xScale');
              end; {xMin <= 0.0}

    {...............................................................................................}

            if xMin * xMax > 0.0 then
              begin {xMin, xMax < 0 or xMin, xMax >0}

                sign := 1;
                if xMax < 0 then
                  sign := -1;

                TallyPoints(xRange, taly);
                if xMin > 0 then
                  begin
                    farBound := xMax;
                    nearBound := xMin;
                  end;
                if xMax < 0 then
                  begin
                    farBound := xMin;
                    nearBound := xMax;
                  end;

                startMark := Trunc(nearBound / taly) * taly;
                if (Abs((startMark - nearBound) / nearBound) > 0.0001) then
                  startMark := startMark + sign * taly;
                hSTEP := (BOXWDT) * (taly / xRange);
                vSTEP := 0.0;
                if sign = 1 then
                  FIRSTHATCH := X1 + Round((startMark - xMin) * BOXWDT / xRange)
                else
                  FIRSTHATCH := X2 - Round((xMax - startMark) * BOXWDT / xRange);
                MarksAndNumbers(FplotScreen, FIRSTHATCH, Y2, sign * taly, startMark, farBound, sign * hSTEP, 'xScale');
              end;
    {...............................................................................................}

          end; {Do the xScale}

    {-----------------------------------------------}
        X0 := XORIGIN;
        Y0 := YORIGIN;

      end; {with SCREENBOX and dataBOX}

  end; {ScreenFrame}

{________________________________________________}

  procedure ScreenFrameLite (var Form1: TForm;
                  var realBOX: rBOX;
                  var SCREENBOX: IBOX);

    var
      {BOXHGT: integer;}
      XSTART: integer;
      VSTEP, taly: real;
      yMax, yMin: real;
      lowerBound, upperBound: real;

  begin
    yMax := realBOX.yMax; {the maximum value of y in the Data vector}
    yMin := realBOX.yMin; {the minimum value of y in the Data vector}


    {BOXHGT := SCREENBOX.Y2 - SCREENBOX.Y1;} {Height of Bounding Box}

    Form1.Canvas.Rectangle(SCREENBOX.X1, SCREENBOX.Y1, SCREENBOX.X2 + 1, SCREENBOX.Y2 + 2);

    lowerBound := 0.0;
    upperBound := 1.2 * yMax;
    {ShowMessage('The value of upperBound is ' + FloatToStr(upperBound));}
    Tallypoints(upperBound, taly);

    XSTART := SCREENBOX.X1;
    VSTEP := taly * (SCREENBOX.BOXHGT / upperBound);
    VertAxis(Form1, XSTART, SCREENBOX.Y2, taly, lowerBound, upperBound, VSTEP);

    realBOX.yUB := upperBound;
    realBOX.yLB := lowerBound;
    realBOX.xLB := realBOX.xMin;
    realBOX.xRB := realBOX.xMax;

    SCREENBOX.X0 := SCREENBOX.X1;
    SCREENBOX.Y0 := SCREENBOX.Y2;

  end; {ScreenFrameLite}

{_________________________________________________}

procedure InvisibleFrame (var realBOX: rBOX);

  var
     yMax, yMin: real;
     lowerBound, upperBound: real;

     {This is establishing the upper bound of realBOX and setting the lower bound}
     {NB Form1 and SCREENBOX are irrelevant!}

  begin
    yMax := realBOX.yMax; {the maximum value of y in the Data vector}
    yMin := realBOX.yMin; {the minimum value of y in the Data vector}

     lowerBound := 0.0;
     upperBound := 1.2  * yMax;

     realBOX.yUB := upperBound;
     realBOX.yLB := lowerBound;
     realBOX.xLB := realBOX.xMin;
     realBOX.xRB := realBOX.xMax;


  end;   {InvisibleFrame}

{_________________________________________________}

  procedure VertAxis (var Form1: TForm;
                  XSTART, YSTART: integer;
                  taly, firstMark, farBound, VSTEP: real);

    var
      toly, HRL, VRL: real;
      HR1, HR2, VT, tolyWidth: integer;
      HINC, VINC, PENLEFT, PENDOWN: integer;
      tolyString: string;

  begin {VertAxis}

    {TextFont(Geneva);{23 Symbol Font}
    TextFace([]);
    TextSize(9); }

    HINC := 5;
    PENDOWN := -(Form1.Canvas.TextHeight('NUMBERS') div 2);

    toly := firstMark;
    HRL := XSTART;
    HR1 := XSTART;
    HR2 := HR1 + HINC;
    VRL := YSTART;
    VT := YSTART;

    while Abs(toly) <= Abs(farBound) do
      begin {while toly}

        tolyString := TalyToString(toly);
        tolyWidth := Form1.Canvas.TextWidth(tolyString);
        PENLEFT := tolyWidth + 15;

 {Numbers}
        {Form1.Canvas.MoveTo(HR1 - PENLEFT, VT + PENDOWN);}
        Form1.Canvas.TextOut(HR1 - PENLEFT, VT + PENDOWN, tolyString);

  {Hatchmarks}
        Form1.Canvas.MoveTo(HR1, VT);
        Form1.Canvas.LineTo(HR2, VT);

  {Increments}
        VRL := VRL - VSTEP;
        VT := Round(VRL);

        toly := toly + taly;
      end; {while toly}

  end; {VertAxis}

{_________________________________________________}

  procedure ZeroPiAxis (var Form1: TForm;
                  var SCREENBOX: IBOX);

    var
      HR, VT1, VT2, BOXWDT, PENDOWN: integer;

  begin{ZeroPiAxis}
    BOXWDT := SCREENBOX.X2 - SCREENBOX.X1;
    PENDOWN := 20;

    {TextFont(Symbol);{23 Symbol Font}
    TextFace([]);
    TextSize(12);}

    VT1 := SCREENBOX.Y2;
    VT2 := VT1 - 5;
    HR := SCREENBOX.X1;
    Form1.Canvas.TextOut(HR - 2, VT1 + PENDOWN, '0');
    {DrawString('0');}

    HR := SCREENBOX.X1 + Round(BOXWDT / 4.0);
    Form1.Canvas.MoveTo(HR, VT1);
    Form1.Canvas.LineTo(HR, VT2);
    {Form1.Canvas.MoveTo(HR - Round(StringWidth('p/4') / 2), VT1 + PENDOWN);}
    Form1.Canvas.TextOut(HR - 8, VT1 + PENDOWN, 'p/4');
    {DrawString('p/4');}

    HR := SCREENBOX.X1 + Round(BOXWDT / 2);
    Form1.Canvas.MoveTo(HR, VT1);
    Form1.Canvas.LineTo(HR, VT2);
    {Form1.Canvas.MoveTo(HR - Round(StringWidth('p/4') / 2), VT1 + PENDOWN);}
    Form1.Canvas.TextOut(HR - 8, VT1 + PENDOWN, 'p/2');
    {DrawString('p/2');}

    HR := SCREENBOX.X2 - Round(BOXWDT / 4);
    Form1.Canvas.MoveTo(HR, VT1);
    Form1.Canvas.LineTo(HR, VT2);
    {Form1.Canvas.MoveTo(HR - Round(StringWidth('3p/4') / 2), VT1 + PENDOWN);}
    Form1.Canvas.TextOut(HR - 12, VT1 + PENDOWN, '3p/4');
    {DrawString('3p/4');}

    HR := SCREENBOX.X2;
    {MoveTo(HR - Round(StringWidth('p') / 2), VT1 + PENDOWN);}
    Form1.Canvas.TextOut(HR - 2, VT1 + PENDOWN, 'p');
   { DrawString('p');}

    {TextFont(Geneva);{23 Symbol Font}
    TextFace([]);
    TextSize(9);}

  end;{ZeroPiAxis}

{_________________________________________________}

  procedure DoDecAxis (var Form1: TForm;
                  var SCREENBOX: IBOX);

    var
      HR, VT1, VT2, BOXWDT, PENDOWN: integer;

  begin{DoDecAxis}
    BOXWDT := SCREENBOX.X2 - SCREENBOX.X1;
    PENDOWN := 20;

    {TextFont(Symbol);{23 Symbol Font}
    TextFace([]);
    TextSize(12);}

    VT1 := SCREENBOX.Y2;
    VT2 := VT1 - 5;
    HR := SCREENBOX.X1;
    Form1.Canvas.TextOut(HR -2, VT1 + PENDOWN, '0');
    {MoveTo(HR - Round(StringWidth('0') / 2), VT1 + PENDOWN);
    DrawString('0');}

    HR := SCREENBOX.X1 + Round(BOXWDT / 6.0);
    Form1.Canvas.MoveTo(HR, VT1);
    Form1.Canvas.LineTo(HR, VT2);
    Form1.Canvas.TextOut(HR -8, VT1 + PENDOWN, 'p/6');
    {Form1.Canvas.MoveTo(HR - Round(StringWidth('p/6') / 2), VT1 + PENDOWN);
    DrawString('p/6');}

    HR := SCREENBOX.X1 + Round(BOXWDT / 3.0);
    Form1.Canvas.MoveTo(HR, VT1);
    Form1.Canvas.LineTo(HR, VT2);
    Form1.Canvas.TextOut(HR -8, VT1 + PENDOWN, 'p/3');
    {Form1.Canvas.MoveTo(HR - Round(StringWidth('p/3') / 2), VT1 + PENDOWN);
    DrawString('p/3');}

    HR := SCREENBOX.X2 - Round(BOXWDT / 2);
    Form1.Canvas.MoveTo(HR, VT1);
    Form1.Canvas.LineTo(HR, VT2);
    Form1.Canvas.TextOut(HR -8, VT1 + PENDOWN, 'p/2');
    {Form1.Canvas.MoveTo(HR - Round(StringWidth('p/2') / 2), VT1 + PENDOWN);
    DrawString('p/2');}

    HR := SCREENBOX.X2 - Round(BOXWDT / 3.0);
    Form1.Canvas.MoveTo(HR, VT1);
    Form1.Canvas.LineTo(HR, VT2);
    Form1.Canvas.TextOut(HR -12, VT1 + PENDOWN, '2p/3');
    {Form1.Canvas.MoveTo(HR - Round(StringWidth('2p/3') / 2), VT1 + PENDOWN);
    DrawString('2p/3');}

    HR := SCREENBOX.X2 - Round(BOXWDT / 6.0);
    Form1.Canvas.MoveTo(HR, VT1);
    Form1.Canvas.LineTo(HR, VT2);
    Form1.Canvas.TextOut(HR -12, VT1 + PENDOWN, '5p/6');
    {Form1.Canvas.MoveTo(HR - Round(StringWidth('5p/6') / 2), VT1 + PENDOWN);
    DrawString('5p/6');}

    HR := SCREENBOX.X2;
    Form1.Canvas.TextOut(HR -2, VT1 + PENDOWN, 'p');
    {MoveTo(HR - Round(StringWidth('p') / 2), VT1 + PENDOWN);
    DrawString('p');}


  end;{DoDecAxis}

{_________________________________________________}

  procedure ScreenPlot (var Form1: TForm;
                  var realBOX: rBOX;
                  var SCREENBOX: IBOX;
                  var dataVector: longVector);

{This is for plotting an arbitrary number of data points over}
{the range defined by the width of the bounding box}

    var
      i, HR, VT, BOXHGT: integer;
      yRange, BOXWDT: real;
      store: double;

  begin
    BOXWDT := SCREENBOX.X2 - SCREENBOX.X1;
    BOXHGT := SCREENBOX.Y2 - SCREENBOX.Y1;
    yRange := realBOX.yUB - realBOX.yLB;

    for i := 0 to realBOX.NOPUNCT - 1 do
      begin {i}
        store := i * BOXWDT;
        store := store / (realBOX.NOPUNCT - 1);
        HR := SCREENBOX.X1 + Round(store);

        store := (dataVector[i] - realBOX.yLB) / yRange;
        VT := Round(SCREENBOX.Y2 - store * BOXHGT);

        if i = 0 then
          Form1.Canvas.MoveTo(HR, VT)
        else
          Form1.Canvas.LineTo(HR, VT);
      end; {i}

  end; {ScreenPlot}

  {______________________________________________________________________________}

    procedure ScreenBiPlot (var Form1: TForm;
                    var realBOX: rBOX;
                    var SCREENBOX: IBOX;
                    var dataVector: pointsVector);

   {This procedure  is used when dataVector is of the pointsVector}
   {type as opposed to the usual longVector type}

      var
        i, HR, VT: integer;
        xFactor, yFactor, xboundRange, yboundRange: real;

    begin

      with realBOX, SCREENBOX do
        begin {with}
          xboundRange :=xRB - xLB;
          yboundRange := yUB - xLB;

          yFactor := BOXHGT / yboundRange;
          xFactor := BOXWDT / xboundRange;

          for i := 0 to NOPUNCT - 1 do
            begin {i}
              HR := X1 + Round(xFactor * (dataVector[i].x - xLB));
              VT := Y2 - Round(yFactor * (dataVector[i].y - yLB));
              if i = 0 then
                Form1.Canvas.MoveTo(HR, VT)
              else
                Form1.Canvas.LineTo(HR, VT);
            end; {i}

        end; {with realBOX, SCREENBOX}

    end; {ScreenBiPlot}

  {______________________________________________________________________________}

  procedure ScreenPlotMod (var Form1: TForm;
                  var realBOX: rBOX;
                  var SCREENBOX: IBOX;
                  var dataVector: longVector);

{This is for plotting a series of function evaluations that are equal}
{in number to the width to the bounding box measured in pixelpoints.}

    var
      i, HR, VT, XORIGIN, YORIGIN, BOXWDT, BOXHGT: integer;
      store, yRange: real;

  begin
    yRange := realBOX.yUB - realBOX.yLB;
    BOXWDT := SCREENBOX.X2 - SCREENBOX.X1;
    BOXHGT := SCREENBOX.Y2 - SCREENBOX.Y1;
    YORIGIN := Round(SCREENBOX.Y0);
    XORIGIN := Round(SCREENBOX.X0);

    for i := 0 to BOXWDT do
      begin {i}
        HR := XORIGIN + i;
        store := dataVector[i] * (BOXHGT / yRange);
        VT := YORIGIN - Round(store);
        if i = 0 then
          Form1.Canvas.MoveTo(HR, VT)
        else
          Form1.Canvas.LineTo(HR, VT);
      end; {i}
  end; {ScreenPlotMod}

{________________________________________________}

  procedure ScreenOverplot (var Form1: TForm;
                  var dataBOX: rBOX;
                  var SCREENBOX: IBOX;
                  var dataVector, trendVector: longVector;
                  var legend: string);

  begin

    ScreenFrame(Form1, dataBOX, SCREENBOX);
    ScreenPlot(Form1, dataBOX, SCREENBOX, dataVector);

    ScreenPlot(Form1, dataBOX, SCREENBOX, trendVector);

    ScreenCaption(Form1, SCREENBOX, legend);

  end; {ScreenOverplot}


{________________________________________________}

  procedure ScreenZeroPiPlot (var Form1: TForm;
                  var filterSpec: filterRecord;
                  var dataBOX: rBOX;
                  var SCREENBOX: IBOX;
                  var dataVector: longVector;
                  var legend: string);

  begin
    ScreenFrameLite(Form1, dataBOX, SCREENBOX);
    if filterSpec.seasonality = Monthly then
      DoDecAxis(Form1, SCREENBOX);
    if filterSpec.seasonality = Quarterly then
      ZeroPiAxis(Form1, SCREENBOX);

    ScreenPlot(Form1,dataBOX, SCREENBOX, dataVector);
    ScreenCaption(Form1, SCREENBOX, legend);


  end; {ScreenZeroPiPlot}

{______________________________________________________________________________}

  procedure MakeDataLine (var Form1: TForm;
                  var Tvert: integer;
                  var SCREENBOX: IBOX;
                  var residueBOX: rBOX);
    var
      HR, VT1, VT2: Integer;
      BOXWDT, store: real;

{This procedure marks a vertical line of the graph of a datplot at the point indexed by Tvert}
  begin
    BOXWDT := SCREENBOX.X2 - SCREENBOX.X1;              {Tvert/resdueBOX.NOPUNCY}

    store := Tvert * BOXWDT; {We have BOXWDT real to avoid overflow}
    store := store / (residueBOX.NOPUNCT - 1);
    HR := SCREENBOX.X1 + Round(store);

    VT1 := SCREENBOX.Y1;
    VT2 := SCREENBOX.Y2;
    {Form1.Canvas.Pen.Style := psDash;}
    Form1.Canvas.Pen.Style := psDot;

    Form1.Canvas.MoveTo(HR, VT1);
    Form1.Canvas.LineTo(HR, VT2);

    Form1.Canvas.Pen.Style := psSolid;

  end; {MakeDataLine}

{______________________________________________________________________________}

procedure MakeDottedLine(var Form1: TForm;
                   var Tvert: integer;
                  var SCREENBOX: IBOX);
var
   HR, VT1, VT2: Integer;

begin
  {Here Tvert is expessed in degrees}
  HR := SCREENBOX.X1 +Round(Tvert * SCREENBOX.BOXWDT/180.0);

  VT1 := SCREENBOX.Y1;
  VT2 := SCREENBOX.Y2;

  {Form1.Canvas.Pen.Style := psDash;}
  Form1.Canvas.Pen.Style := psDot;

  Form1.Canvas.MoveTo(HR, VT1);
  Form1.Canvas.LineTo(HR, VT2);

  Form1.Canvas.Pen.Style := psSolid;

end; {MakeDottedLine}

{______________________________________________________________________________}


  procedure  ShadedRectangle(var Form1: TForm;
                    var shadedBOX: integerRect);
   begin
     Form1.Canvas.Pen.Color := clBlack;
     Form1.Canvas.Brush.Color := clSilver;
     with shadedBOX do
       Form1.Canvas.Rectangle(HRS, VTS, HRF, VTF);
      Form1.Canvas.Brush.Color := clWindow;
   end; {ShadedRectangle}

  {Transfer the shdedBOX definition to uscreen plot and determine its parameters}
   {within  TAPER}

  {______________________________________________________________________________}
 
  procedure HighLightRegions (var Form1: TForm;
                  var sBandWidth, sBandCentre: triIntVec;
                  var SCREENBOX: IBOX);
    var
      k, BOXWDT, TOP, BOTM, LEFT, RGHT, CENTR, NPTM1: longInt;

  begin
    BOXWDT := SCREENBOX.X2 - SCREENBOX.X1;
    TOP := SCREENBOX.Y1;
    BOTM := SCREENBOX.Y2;
    NPTM1 := dataBOX.NOPUNCT - 1; {Number of Points Minus One}

    for k := 1 to 3 do   {The Number of bands}
    begin {k}
      if  (sBandCentre[k] >= 0) then
        CENTR := SCREENBOX.X1 + Round(sBandCentre[k] * BOXWDT / NPTM1);

      if  (sBandCentre[k] >= 0) and (sBandWidth[k] >= 0) then
        begin {if}
          RGHT := CENTR + Round(sBandWidth[k] * BOXWDT / NPTM1);
          LEFT := CENTR - Round(sBandWidth[k]* BOXWDT / NPTM1);
          Form1.Canvas.Brush.Style := bsBDiagonal;

          Form1.Canvas.Brush.Color  := clRed;
          Form1.Canvas.FillRect(LEFT, TOP, RGHT, BOTM);
          Form1.Canvas.Rectangle(LEFT, TOP, RGHT, BOTM);
        end; {if}

      if  (sBandCentre[k] >= 0) then
         begin {if}
          Form1.Canvas.MoveTo(CENTR, TOP);
          Form1.Canvas.LineTo(CENTR, BOTM);
         end;{if}
    end; {k}

  end; {HighLightRegions}

{______________________________________________________________________________}


end. {SCREEN: unit  of SEASCAPE.PAS}



