unit LEGENDS; {Unit of SEASCAPE.PAS}

interface

  uses
    GLOBALS, UTILS, Forms, SysUtils;

  function Sgn (number: real): char;

  procedure ScreenCaption (var Form1: TForm;
                  var SCREENBOX: IBOX;
                  var legend: string);

  function DataLegend (var dataBOX: rBOX;
                  var dataName: string): string;

  function DeSeasonalisedOverlay (var dataBOX: rBOX;
                  var dataName: string): string;

  function SmoothCycleOverlay (var dataBOX: rBOX;
                  var dataName: string): string;

  function SeasonallyAdjustedData (var dataBOX: rBOX;
                  var dataName: string): string;

  function SeasonalComponent (var dataBOX: rBOX;
                  var dataName: string): string;

  function TrendCycleResidue (var dataBOX: rBOX;
                  var dataName: string): string;

  function AdjustedTrendResiduals: string;

  function TrendCycleInThree: string;

  function ResidualsInThree: string;

  function DataPeriodogram (var dataBOX: rBOX;
                  var dataName: string): string;

  function PolynomialWeights: string;

  function PolynomialTrend (var polyParas: polyParameters;
                  var dataBOX: rBOX;
                  var dataName: string): string;

  function PolyWeightTrend (var polyOrder: integer;
                  var dataBOX: rBOX;
                  var dataName: string): string;

  function PolynomialResiduals (var polyParas: polyParameters;
                  var dataBOX: rBOX;
                  var dataName: string): string;

  function IdealLowPassCycle (var filterSpec: FilterRecord): string;

  function SigmoidLowPassCycle (var filterSpec: FilterRecord): string;

  function TrendAndCycle (var dataBOX: rBOX;
                   var dataName: string): string;

  function TrigonometricalTrend (var degrees: real;
                  var dataBOX: rBOX;
                  var dataName: string): string;

  function TrendResiduals (var dataBOX: rBOX;
                  var dataName: string): string;

  function SeasonalFilterGain (var filterSpec: FilterRecord): string;

  function DoubleFilterGain (var filterSpec: FilterRecord): string;

  function TripleFilterGain (var filterSpec: FilterRecord): string;

  function SeasFreqFiltGain (var filterSpec: FilterRecord): string;

  function SigmoidFilterGain (var filterSpec: FilterRecord): string;

  function GainOfButterworth (var filterSpec: FilterRecord): string;   {REDUNDANT}

  function LowpassSigmoidGain (var filterSpec: FilterRecord): string;

  function IdealLowpassGain (var filterSpec: FilterRecord): string;

  function FourierLowPass (var dataBOX: rBOX;
                  var dataName: string): string;

  function FourierBandPass (var dataBOX: rBOX;
                  var dataName: string): string;

  function SeasonallyAdjusted (var dataBOX: rBOX;
                  var dataName: string): string;

  function SpectralBand (var lowerCut, upperCut: real): string;

  function ButterworthGain (var filterSpec: FilterRecord): string;

  function HPFilterGain (var filterSpec: FilterRecord): string;

  function ButterworthTrend (var dataBOX: rBOX;
                  var dataName: string;
                  var filterSpec: FilterRecord): string;

  function HPtrend (var dataBOX: rBOX;
                  var filterSpec:FilterRecord;
                  var dataName: string): string;

  function ButterworthResiduals (var dataBOX: rBOX;
                  var dataName: string;
                  var filterSpec: FilterRecord): string;

  function HPresiduals (var dataBOX: rBOX;
                  var filterSpec:FilterRecord;
                  var dataName: string): string;

  function PdgramAndResponse (var filterSpec: FilterRecord): string;

  function VariSmoothTrend (var dataBOX: rBOX;
                  var dataName: string): string;

  function VariSmoothResiduals (var dataBOX: rBOX;
                    var dataName: string): string;

implementation

  {________________________________________________}

  function Sgn (number: real): char;
  begin
    if number >= 0 then
      Sgn := '+'
    else
      Sgn := ' ';
  end; {Sgn}

  {______________________________________________________________________________}

      procedure ScreenCaption (var Form1: TForm;
                      var SCREENBOX: IBOX;
                      var legend: string);

         var
           i, q, width, distance, breakPoint, XS, XQ, YS, WDT: integer;
           firstString, secondString: string;

       begin
         WDT := Form1.width;
         XS := WDT div 2;

         width := Length(legend);  {Length is the number of characters}

         if width > 65 then
           begin {Breakit }
             distance := width;
             for i := 0 to width do
               begin {i}
                 if legend[i] = ' ' then
                   begin {if legend}
                     q := Abs(width div 2 - i);
                     if distance > q then
                       begin {if distance}
                         breakPoint := i;
                         distance := q;
                       end; {if distance}
                   end; {if legend}
               end; {i}

             firstString := Copy(legend, 1, breakPoint);
             secondString := Copy(legend, breakPoint + 1, width);
             width := Form1.Canvas.TextWidth(firstString);
             XQ := XS - (width div 2);
             YS := SCREENBOX.Y2 + 60; {Alternative}
             Form1.Canvas.MoveTo(XQ, YS);
             Form1.Canvas.TextOut(XQ, YS, firstString);
             width := Form1.Canvas.TextWidth(secondString);
             XQ := XS - (width div 2);
             YS := YS + 20;
             Form1.Canvas.MoveTo(XQ, YS);
             Form1.Canvas.TextOut(XQ, YS, secondString);
           end {Breakit}
         else
           begin
             width := Form1.Canvas.TextWidth(legend);
             XS := XS - (width div 2);
             YS := SCREENBOX.Y2 + 60; {Alternative}
             Form1.Canvas.MoveTo(XS, YS);
             Form1.Canvas.TextOut(XS, YS, legend);
           end;

       end; {ScreenCaption}

  {______________________________________________________________________________}


  function DataLegend (var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, addString: string;

  begin
    legend := 'The plot of ';
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ');
    legend := Concat(legend, dataName);
    DataLegend := legend;
  end; {DataLegend}

{________________________________________________}

  function DeSeasonalisedOverlay (var dataBOX: rBOX;
                  var dataName: string): string;
    var
      legend, addString: string;

  begin
    legend := 'The plot of ';
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString);
    if (dataBOX.dataFrequency = Monthly) then
      addString := ' monthly ';
    if (dataBOX.dataFrequency = Quarterly) then
      addString := ' quarterly ';
    legend := Concat(legend, addstring, 'observations on ');
    legend := Concat(legend, dataName);
    addString := ' with a superimposed seasonally-adjusted sequence.';
    legend := Concat(legend, addstring);
    DeSeasonalisedOverlay := legend;
  end; {DeSeasonalisedOverlay}

{________________________________________________}

  function SmoothCycleOverlay (var dataBOX: rBOX;
                  var dataName: string): string;
    var
      legend, addString: string;

  begin
    legend := 'The plot of ';
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString);
    if (dataBOX.dataFrequency = Monthly) then
      addString := ' monthly ';
    if (dataBOX.dataFrequency = Quarterly) then
      addString := ' quarterly ';
    legend := Concat(legend, addstring, 'observations on ');
    legend := Concat(legend, dataName);
    addString := ' with a superimposed smoothed cycle.';
    legend := Concat(legend, addstring);
    SmoothCycleOverlay := legend;
  end; {SmoothCycleOverlay}

{________________________________________________}

  function SeasonallyAdjustedData (var dataBOX: rBOX;
                  var dataName: string): string;
    var
      legend, addString: string;

  begin
    legend := 'The plot of a seasonally adjusted sequence of ';
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString);
    if (dataBOX.dataFrequency = Monthly) then
      addString := ' monthly ';
    if (dataBOX.dataFrequency = Quarterly) then
      addString := ' quarterly ';
    legend := Concat(legend, addstring, 'observations on ');
    legend := Concat(legend, dataName);
    SeasonallyAdjustedData := legend;
  end; {SeasonallyAdjustedData}

{________________________________________________}

  function SeasonalComponent (var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, addString: string;

  begin
    legend := 'The seasonal component extracted from ';
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ');
    legend := Concat(legend, dataName);
    SeasonalComponent := legend;

  end; {SeasonalComponent}

 {________________________________________________}

  function TrendCycleResidue (var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, addString: string;

  begin
    legend := 'The residual sequence after the trend-cycle has been extracted from ';
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ');
    legend := Concat(legend, dataName);
    TrendCycleResidue := legend;

  end; {TrendCycleResidue}

 {________________________________________________}

 function AdjustedTrendResiduals: string;

 var
   legend, addString: string;

 begin
   legend := 'The sequence of seasonally-adjusted trend rediduals, which is the data ';
   addString := 'sequence minus the trend-cycle function and minus the seasonal component';
   legend := Concat(legend, addString);
   AdjustedTrendResiduals := legend;

 end; {AdjustedTrendResiduals}

{______________________________________________________________________________}

 function TrendCycleInThree: string;

    begin
      TrendCycleInThree := 'The trend cycle trajectory representing a component of a threefold decomposition of the seasonal data';

    end;  {TrendCycleOfThree}
{______________________________________________________________________________}

function ResidualsInThree: string;

   begin
     ResidualsInThree := 'The residual sequence representing a component of a threefold decomposition of the seasonal data';

   end;  {ResidualsInThree}
{______________________________________________________________________________}



  function DataPeriodogram (var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, addString: string;

  begin
    legend := 'The periodogram of ';
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName);
    DataPeriodogram := legend;
  end; {DataPeridogram}

  {________________________________________________}

  function PolynomialWeights: string;

    var
      legend: string;
  begin
    legend := 'The profile of the weights applied to the data points ';
    PolynomialWeights := Concat(legend, 'in the polynomial regression');
  end; {PolynomialWeights}

   {________________________________________________}

  function PolynomialTrend (var polyParas: polyParameters;
                  var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, addString: string;

  begin
    legend := 'A polynomial of degree ';
    addString := IntegerToString(polyParas.polyDegree);
    legend := Concat(legend, addString, ' interpolated through ');
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName);
    PolynomialTrend := legend;
  end; {PolynomialTrend}

  {________________________________________________}

  function PolyWeightTrend (var polyOrder: integer;
                  var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, addString: string;

  begin
    legend := 'A polynomial of degree ';
    addString := IntegerToString(polyOrder);
    legend := Concat(legend, addString, ' interpolated by weighted ');
    legend := Concat(legend, 'least-squares regression through ');
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName);
    PolyWeightTrend := legend;
  end; {PolynomialTrend}

 {________________________________________________}

  function PolynomialResiduals (var polyParas: polyParameters;
                  var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, addString: string;

  begin
    legend := 'The residual sequence from fitting a polynomial of degree ';
    addString := IntegerToString(polyParas.polyDegree);
    legend := Concat(legend, addString, ' to ');
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName);
    PolynomialResiduals := legend;
  end; {PolynomialResiduals}

{______________________________________________________________________________}

function IdealLowPassCycle (var filterSpec: FilterRecord): string;

    var
      legend, addString: string;

  begin
    legend := 'A low-frequency cyclical component extracted from detrended data ';
    addString:= 'by an ideal lowpass filter with a cut-off point of ';
    legend := Concat(legend, addString + FloatToStr(filterSpec.cutOff) + ' degrees' );
    IdealLowPassCycle := legend;

  end; {IdealLowPassCycle}

{______________________________________________________________________________}


  function SigmoidLowPassCycle(var filterSpec: FilterRecord): string;

    var
      legend, addString: string;

  begin
    legend := 'A low-frequency cyclical component extracted from detrended data ';
     addString:= 'by a lowpass sigmoid filter with a transition mid point of ';
     legend := Concat(legend, addString + FloatToStr(filterSpec.cutOff) + ' degrees');
     SigmoidLowPassCycle := legend;

  end; {SigmoidLowPassCycle}

{______________________________________________________________________________}

   function TrendAndCycle (var dataBOX: rBOX;
                   var dataName: string): string;

     var
       legend, addString: string;

   begin
     legend := 'The trend-cycle component derived by adding the interpolated ';
     addString := 'polynomial to the low-frequency components of the residual sequence';
     legend := Concat(legend, addString);
     TrendAndCycle := legend;

   end; {TrendAndCycle}

{______________________________________________________________________________}

  function HPtrend (var lambda: real;
                  var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, addString: string;

  begin
    legend := 'A trend determined by Hodrick-Prescott filter with a smoothing parameter of  ';
    addString := IntegerToString(Round(lambda));
    legend := Concat(legend, addString, ', interpolated through ');
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName);
    HPtrend := legend;
  end; {HPtrend}

  {________________________________________________}

  function HPresiduals (var lambda: real;
                  var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, paraString, addString: string;

  begin
    legend := 'The residual sequence from fitting a trend via a ';
    addString := 'Hodrick-Prescott filter with a smoothing parameter of ';
    paraString := IntegerToString(Round(lambda));
    legend := Concat(legend, addString, paraString, ' to ');
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName);
    HPresiduals := legend;
  end; {HPresiduals}

  {________________________________________________}

  function TrigonometricalTrend (var degrees: real;
                  var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, addString: string;

  begin
    legend := 'A trend comprising Fourier components of frequencies less than ';
    addString := TalyToString(degrees);
    legend := Concat(legend, addString, ' degrees per period interpolated through ');
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName);
    TrigonometricalTrend := legend;

  end; {TrigonometricalTrend}

  {________________________________________________}

  function TrendResiduals (var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, addString: string;

  begin
    legend := 'The residual sequence from detrending ';
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName, ' via the Fourier method');
    TrendResiduals := legend;
  end; {TrendResiduals}


{________________________________________________}

  function SeasonalFilterGain (var filterSpec: FilterRecord): string;

    var
      legend, addString: string;

  begin
    legend := 'The frequency response function of a time-domain filter ';
    addString := 'for the seasonal adjustment of a ';
    legend := Concat(legend, addString);
    if (filterSpec.seasonality = Monthly) then
      addString := 'monthly ';
    if (filterSpec.seasonality = Quarterly) then
      addString := 'quarterly ';
    legend := Concat(legend, addString, 'data sequence, superimposed on the periodogram');
    SeasonalFilterGain := legend;
  end; {SeasonalFilterGain}

  {________________________________________________}

  function DoubleFilterGain (var filterSpec: FilterRecord): string;

    var
      legend, addString: string;

  begin
    legend := 'The response function of a twofold time-domain filter for ';
    if (filterSpec.seasonality = Monthly) then
      addString := 'monthly ';
    if (filterSpec.seasonality = Quarterly) then
      addString := 'quarterly ';
    legend := Concat(legend, addString, 'seasonal adjustment, superimposed on the periodogram. ');
    addString := 'The zeros are at either side of the seasonal frequencies.';
    legend := Concat(legend, addString);
    DoubleFilterGain := legend;

  end; {DoubleFilterGain}

  {________________________________________________}

  function TripleFilterGain (var filterSpec: FilterRecord): string;

    var
      legend, addString: string;

  begin
    legend := 'The response function of a threefold  filter for ';
    if (filterSpec.seasonality = Monthly) then
      addString := 'monthly ';
    if (filterSpec.seasonality = Quarterly) then
      addString := 'quarterly ';
    legend := Concat(legend, addString, 'seasonal adjustment, superimposed on the periodogram. ');
    addString := 'The zeros are at the seasonal frequencies and at either side.';
    legend := Concat(legend, addString);
    TripleFilterGain := legend;

  end; {TripleFilterGain}

 {________________________________________________}

  function SeasFreqFiltGain (var filterSpec: FilterRecord): string;

    var
      legend, addString: string;

  begin
    legend := 'The response function of a ';
    if filterspec.seasonality = Monthly then
      addString := 'Monthly';
    if filterspec.seasonality = Quarterly then
      addString := 'Quarterly';
    legend := Concat(legend, addString, ' frequency-domain seasonal adjustment filter');
    if filterspec.profile = noTransition then
      addString := ' without transition bands.';
    if filterspec.profile = Sigmoid then
      addString := ' with composite cosine transition bands.';
    if filterspec.profile = upperHalfCosine then
      addString := ' with upper-half cosine transition bands.';
    if filterspec.profile = lowerHalfCosine then
      addString := ' with lower-half cosine transition bands.';
    legend := Concat(legend, addString);
    SeasFreqFiltGain := legend;

  end; {SeasFreqFiltGain}

{________________________________________________}

  function SigmoidFilterGain (var filterSpec: FilterRecord): string;

    var
      legend, addString: string;

  begin
    legend := 'The frequency response function of a sigmoid lowpass frequency domain filter';
    if (filterSpec.Mb = filterSpec.Mc) then
      begin
        addString := ' with a cutoff point at ';
        legend := Concat(legend, addString);
        addstring := TalyToString(filterSpec.Mb);
        legend := Concat(legend, addString, ' degrees.');
      end
    else
      begin
        addString := ' with a transition band bounded by ';
        legend := Concat(legend, addString);
        addstring := TalyToString(filterSpec.Mb);
        legend := Concat(legend, addString);
        addstring := TalyToString(filterSpec.Mc);
        legend := Concat(legend, ' and ', addString, ' degrees ');
      end;
    SigmoidFilterGain := legend;

  end; {SigmoidFilterGain}

  {________________________________________________}

  function GainOfButterworth (var filterSpec: FilterRecord): string;   {REDUNDANT}

    var
      legend, addString: string;
      pi, degrees: real;

  begin
    pi := 4.0 * Arctan(1.0);
    legend := 'The frequency response of the Butterworth lowpass';
    legend := Concat(legend, ' filter of order ');
    addString := IntegerToString(filterSpec.filterOrder);
    legend := Concat(legend, addString, ', with a nominal cut-off point at ');
    addString := TalyToString(filterSpec.cutOff);
    legend := Concat(legend, addString, ' degrees');
    GainOfButterworth := legend;

  end; {GainOfButterworth}

 {________________________________________________}

  function LowpassSigmoidGain (var filterSpec: FilterRecord): string;

    var
      legend, addString: string;

  begin
    legend := 'The frequency response function of a sigmoid lowpass frequency domain filter';
    if (filterSpec.Mb = filterSpec.Mc) then
      begin
        addString := ' with a cutoff point at ';
        legend := Concat(legend, addString);
        addstring := TalyToString(filterSpec.Mb);
        legend := Concat(legend, addString, ' degrees.');
      end
    else
      begin
        addString := ' with a transition band bounded by ';
        legend := Concat(legend, addString);
        addstring := TalyToString(filterSpec.Mb);
        legend := Concat(legend, addString);
        addstring := TalyToString(filterSpec.Mc);
        legend := Concat(legend, ' and ', addString, ' degrees, superimposed on the periodogram of the detrended data.');
      end;
    LowpassSigmoidGain := legend;

  end; {SigmoidFilterGain}

{______________________________________________________________________________}

  function IdealLowpassGain (var filterSpec: FilterRecord): string;

   var
     legend, addString: string;

  begin
    legend := 'The frequency response function of a ideal lowpass frequency domain filter';
    addString := ' with a cutoff point at ';
    legend := Concat(legend, addString);
    addstring := FloatToStr(filterSpec.CutOff);
    legend := Concat(legend, addString, ' degrees, superimposed on the periodogram of the detrended data.');
    IdealLowpassGain := legend;

  end;  {IdealLowpassGain}

{______________________________________________________________________________}

  function FourierLowPass (var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, addString: string;

  begin
    legend := 'A low-frequency trend/cycle component extracted from ';
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName, ' by a Fourier Method');
    FourierLowPass := legend;

  end; {FourierLowPass}

  {________________________________________________}

  function FourierBandPass (var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, addString: string;

  begin
    legend := 'Cyclical fluctations extracted from ';
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName, ' by a Fourier Bandpass Method');
    FourierBandPass := legend;

  end; {FourierBandPass}

 {________________________________________________}

  function SeasonallyAdjusted (var dataBOX: rBOX;
                  var dataName: string): string;

    var
      legend, addString: string;

  begin
    legend := 'A seasonally adjusted version of a sequence of ';
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ');
    legend := Concat(legend, dataName);
    SeasonallyAdjusted := legend;

  end; {SeasonallyAdjusted}

 {________________________________________________}

  function SpectralBand (var lowerCut, upperCut: real): string;

    var
      legend, addString: string;

  begin
    legend := 'A spectral band, with a lower bound of ';
    addString := TalyToString(lowerCut);
    legend := Concat(legend, addString, ' degrees and an upper bound of ');
    addString := TalyToString(upperCut);
    legend := Concat(legend, addString, ' degrees, masking the periodogram');
    SpectralBand := legend;
  end; {SpectralBand}

  {________________________________________________}

  function ButterworthGain(var filterSpec: FilterRecord): string;

    var
      legend, addString: string;
      pi, degrees: real;

  begin
    pi := 4.0 * Arctan(1.0);
    legend := 'The frequency response of the Butterworth lowpass';
    legend := Concat(legend, ' filter of order ');
    addString := IntegerToString(filterSpec.filterOrder);
    legend := Concat(legend, addString, ', with a nominal cut-off point at ');
    {degrees := 180.0 / pi;}
    degrees := filterSpec.cutOff;
    addString := FloatToStr(degrees);
    legend := Concat(legend, addString, ' degrees');
    addString := ', superimposed on the periodogram of the polynomial residuals';
    If weHavePolyResiduals then
     legend := Concat(legend, addString);
    ButterworthGain := legend;

  end; {ButterworthGain}

 {________________________________________________}

  function HPFilterGain (var filterSpec: FilterRecord): string;

    var
      legend, addString: string;

  begin
    legend := 'The frequency response of the Hodrick-Prescott lowpass';
    legend := Concat(legend, ' filter with a smoothing parameter of ');
    addString := IntegerToString(Round(filterSpec.smoothingParameter));
    legend := Concat(legend, addString);
    HPFilterGain := legend;

  end; {HPFilterGain}

  {________________________________________________}

  function ButterworthTrend (var dataBOX: rBOX;
                  var dataName: string;
                  var filterSpec: FilterRecord): string;

    var
      legend, addString: string;
  {pi, degrees: real;}

  begin
  {pi := 4.0 * Arctan(1.0);}
    legend := 'The trend estimated by a Butterworth lowpass filter of order ';
    addString := IntegerToString(filterSpec.filterOrder);
    legend := Concat(legend, addString, ' interpolated through ');
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName);

  {legend := Concat(legend, addString, ', with a nominal cut-off point at ');}
  {degrees := 180.0 / pi;}
  {degrees := degrees * filterSpec.cutOff;}
  {addString := IntegerToString(Round(degrees));}
  {legend := Concat(legend, addString, ' degrees');}
    ButterworthTrend := legend;

  end; {ButterworthTrend}

   {________________________________________________}

  function HPtrend (var dataBOX: rBOX;
                  var filterSpec:FilterRecord;
                  var dataName: string): string;

    var
      legend, addString: string;
      lambda: real;

  begin
    lambda := filterSpec.smoothingParameter;
    legend := 'A trend determined by Hodrick-Prescott filter with a smoothing parameter of  ';
    addString := IntegerToString(Round(lambda));
    legend := Concat(legend, addString, ', interpolated through ');
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName);
    HPtrend := legend;
  end; {HPtrend}

   {________________________________________________}

  function ButterworthResiduals (var dataBOX: rBOX;
                  var dataName: string;
                  var filterSpec: FilterRecord): string;

    var
      legend, addString: string;
  {pi, degrees: real;}

  begin
  {pi := 4.0 * Arctan(1.0);}
    legend := 'The residual sequence from detrending ';
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName);
    legend := Concat(legend, ' via a Butterworth lowpass filter of order ');
    addString := IntegerToString(filterSpec.filterOrder);
    legend := Concat(legend, addString);
  {legend := Concat(legend, addString, ', with a nominal cut-off point at ');}
  {degrees := 180.0 / pi;}
  {degrees := degrees * filterSpec.cutOff;}
  {addString := IntegerToString(Round(degrees));}
  {legend := Concat(legend, addString, ' degrees');}
    ButterworthResiduals := legend;

  end; {ButterworthResiduals}

 {________________________________________________}

 function HPresiduals (var dataBOX: rBOX;
                  var filterSpec:FilterRecord;
                  var dataName: string): string;

    var
      legend, paraString, addString: string;
      lambda: real;

  begin
    lambda := filterSpec.smoothingParameter;
    legend := 'The residual sequence from fitting a trend via a ';
    addString := 'Hodrick-Prescott filter with a smoothing parameter of ';
    paraString := IntegerToString(Round(lambda));
    legend := Concat(legend, addString, paraString, ' to ');
    addString := IntegerToString(dataBOX.NOPUNCT);
    legend := Concat(legend, addString, ' points of ', dataName);
    HPresiduals := legend;
  end; {HPresiduals}

  {________________________________________________}

  function PdgramAndResponse (var filterSpec: FilterRecord): string;

    var
      legend, addString: string;

  begin
    legend := 'The frequency response of the seasonal-adjustment filter ';
    addString := 'superimposed on the periodogram of the detrended data ';
    legend := Concat(legend, addString);
    PdgramAndResponse := legend;
  end; {PdgramAndResponse}

{______________________________________________________________________________}

    function VariSmoothTrend (var dataBOX: rBOX;
                    var dataName: string): string;

      var
        legend, addString, frequency: string;

    begin
      legend := 'A trend determined by a filter with a variable ';
      addString := 'smoothing parameter applied to ';
      legend := Concat(legend, addString);
      addString := IntegerToString(dataBOX.NOPUNCT);
      if dataBOX.dataFrequency = monthly then
        frequency := ' monthly ';
      if dataBOX.dataFrequency = Quarterly then
        frequency := ' quarterly ';
      if dataBOX.dataFrequency = Annual then
        frequency := ' annual ';
      legend := Concat(legend, addString, frequency, 'points of ', dataName);
      VariSmoothTrend := legend;

    end; {VariSmoothTrend}

{______________________________________________________________________________}

    function VariSmoothResiduals (var dataBOX: rBOX;
                    var dataName: string): string;

      var
        legend, addString: string;

    begin
      legend := 'The residual sequence from fitting a trend via a ';
      addString := 'filter with a variable smoothing parameter to ';
      legend := Concat(legend, addString);
      addString := IntegerToString(dataBOX.NOPUNCT);
      legend := Concat(legend, addString, ' points of ', dataName);
      VariSmoothResiduals := legend;
    end; {VariSmoothResiduals}

{______________________________________________________________________________}


end. {LEGENDS: Unit of SEASCAPE.PAS}

