unit GLOBALS; {Unit 1 of SEASCAPE.PAS}

interface

  const
    left = 0;
    right = 1;
    dim = 100;
    assumedZero = 0.00001;
    maxOrder = 12;
    maxArray = 520;


  const
    {-----------------}{ASCII Codes}
    TAB = 9;
    CR = 13;
    SPACE = 32;
   {------------------} {Data Frequency}
    Annual = 1;
    Quarterly = 4;
    Monthly = 12;
    Other = 9;
    {------------------} {FilterFamily}
    Butterworth = 1;
    HodrickPrescott = 2;
    IdealLowpass = 3;
    LowSigmoid = 4;
    {------------------} {FilterType}
    lowPass = 1;
    highPass = 2;
    {-seasonalFilterType-}
    singleFilter = 3;
    doubleFilter = 4;
    tripleFilter = 5;
    TaperedFilter = 6;
    TaperFunction = 7;
     {------------------}  {frequencyFilterProfile}
    noTransition = 6;
    Sigmoid = 7;
    upperHalfCosine = 8;
    lowerHalfCosine = 9;
    inversePower = 10;
    Triangle = 11;
    Square = 12;
    Bell = 13;
    {------------------} {Graph Type}
    dataGraph = 1;
    periodoGraph = 2;
    spectraGraph = 3;
    dataOverPlotGraph = 4;
    extensionsGraph = 5;
    backgroundPlot = 6;
    cycleGraph = 7;
    seasonsGraph = 8;


  type
    cleftParams = record
        Lt, Ls, Us, Ut: integer;
        Ma, Mb, Mc, Md: real;
      end;

  type
    cleftArray = array[1..6] of cleftParams;

  type
    complex = record
        re, im: real;
      end;

  type
    polar = record
        argu, modu: real;
      end;

  type
    points = record
        x, y: real
      end;

  type
    vector = array[-2..100] of real;

  type
    ivector = array[-10..50] of integer;

  type
    longVector = array[0..maxArray] of real;

  type
    fourierVec = array[0..250] of real;

  type
    matrix = array[0..25] of array[0..25] of real;

  type
    seasQuadratic = array[0..2] of extended;

  type
    seasVector = array[0..36] of extended;

  type
    seasMatrix = array[0..12] of array[0..12] of extended;

  type
    triIntVec = array[0..3] of integer;

  type
    triRealVec = array[0..3] of real;

  type
    triBooleanVec = array[0..3] of boolean;


  type
    pointsVector = array[0..maxArray] of points;

  type
    complexVector = array[-20..20] of complex;

  type
    polarVector = array[-20..20] of polar;

  type
    realRect = record
        top: real;
        left: real;
        bottom: real;
        right: real;
      end;

  type
    integerRect = record
        VTS: integer;
        HRS: integer;
        VTF: integer;
        HRF: integer;
      end;

  type
    IBOX = record
        X0: integer;  {the horizontal value of the graphics origin}
        Y0: integer;  {the vertical value of the graphics origin}
        X1: integer; {left of the graphics bounding box}
        Y1: integer; {top or bottom of the graphics bounding box}
        X2: integer; {right of the graphics bounding box}
        Y2: integer; {bottom or top of graphics the bounding box}
        XC: integer; {horizontal value of the centre of window}
        YC: integer;  {vertical value of the centre of window}
        BOXWDT: integer; {Width of the Bounding Box}
        BOXHGT: integer; {Height of the Bounding Box}
        xAxis: boolean;
        yAxis: boolean;
        xScale: boolean;
        yScale: boolean;
        doFrame: boolean;
        doMarks: boolean;
      end;

  type
    rBOX = record
        xMax: real;  {the maximum value of x in the dataVector}
        xMin: real;  {the minimum value of x in the dataVector}
        yMax: real;  {the maximum value of y in the dataVector}
        yMin: real;  {the minimum value of y in the dataVector}
        xMean: real; {the mean value of x in the dataVector}
        yMean: real; {the variance value of y in the dataVector}
        xVar: real; {the variance value of x in the dataVector}
        yVar: real; {the mean value of y in the dataVector}
        yUB: real;   {yUB >= yMax: an upper bound for y}
        yLB: real;   {yLB <= yMin: a lower bound for y}
        xLB: real;   {xLB <= xMin: a left (lower) bound for x}
        xRB: real;    {xRB >= xMax: a right (upper) bound for x}
        yRange: real; {yUB - yLB}
        xRange: real; {xMax - xMin;}
        NOPUNCT: integer; {number of data points}
        EXTRA: integer; {total number of extrapolated points}
        segLength: integer; {proposed length of sedments}
        numbOfSegs: integer; {proposed number of segments}
        segResidue: integer;  {NOPUNCT Mod numbOfSegs}
        DiffOrder: integer; {number of differences taken}
        dataChar: char; {q: quaterly, m: monthly. a: annual}
        dataFrequency: integer; {Annual, Quarterly, Monthly, Other}
        slopeDegrees: real; {DELETE?}
      end;

  type
    polyParameters = record
        alpha: vector; {parameters ofthe polynomial relative to the orthogonal basis}
        beta: vector;
        gamma: vector; {auxilliary parameters of the three-term recurrence}
        delta: vector; {auxilliary parameters of the three-term recurrence}
        polyDegree: integer;
        tStart: integer; {the intial index of the polynomial time trend}
      end;

  type
    filterRecord = record
        filterFamily: integer; {Butterworth, Hodrick-Prescott}
        filterType: integer;   {NB This is not the profile}
        filterSpan: integer; {the span of the binomial filter}
        filterOrder: integer;   {Order of Wiener-Komogorov Filter}
        cutoff: real; {cutOff point of the lowpass Butterworth Fiter}
        smoothingParameter: real; {parameter of the Hodrick-Prescott filter}
        profile: integer; {profile of transition band of Frequency Filter}
        oldProfile: integer; {comare with profile to detect a change}
        rho: real; {modulus of the poles}
        lambda: real; {smoothing parameter}
        zeta: real; {offset of the double seasonal filter}
        sPlus: integer; {order ofthe augmented filter}
        seasonality: integer; {Monthly Quarterly, for the seasonal adjustment filter}
        filterFactor: real; {factor for adjustiing filter gain}
        nPower: integer; {parameter of transitions profile}
        truncParam: real; {parameter of transitions profile}
        Mb: real; {start of transition for lowpass frequency filter}
        Mc: real; {end of transition for lowpass frequency filter}
      end;

    {Seasonal Filter Parameters}
  var
{the Cramer-Wold factors of the numerator and denominator}
    sigmaVec, sigmaVec1, sigmaVec2, rhoVec, fIRVec: seasVector;
    theta, phi, theta1, phi1, theta2, phi2: seasVector;
    zetaSub, zetaSup: vector;
    q: integer; {The order of the uni-directional smoothing filter}
    noModel, offset: boolean; {we could replace offset by a filterType integer}


  type
    dateRecord = record
        dataFrequency: integer;
        yearInt: integer;
        quartInt: integer;
        monthInt: integer;
        decimalStart: real;
      end;
  {GLOBAL Flags: Should GLOBAL flags end in G e.g. AllsDoneG?}
  var
    PSPict, TeXFormat, graphicsOn, stability, noDataFrequency: boolean;
    allsDone, noPageParameters: boolean;
    {--------------------------------------} {Flags for Data Components}
    thereIsData: boolean = false;
    enoughData: boolean = false;
    meanAdjustedData: boolean = false;
    logsTaken: boolean = false;
    badElements: boolean = false; {Check this within udatatransforms}
    discardFromStart: boolean = false;
    discardFromEnd: boolean = false;
    {--------------------------------------}  {Fags for trend estimation}
    weHavePolyResiduals: boolean = false;
    weHaveTrendCycleResiduals: boolean = false;
    dataAreTrended: boolean = false;
    dataExtrapolated: boolean = false;   {This includes tapering and logistic interpolation}
    weHaveTrendResiduals: boolean = false;
    weHaveATrendCycle: boolean = false;
    {--------------------------------------}  {Flags for cyclical component}
    weHaveACycle: boolean = false;
    {--------------------------------------} {Flags for filters}
    noFilter: boolean = false;
    noFilterSpec: boolean = false;
    noTimeDomainFilterSpec: boolean = false;
    noFrequencyFilterSpec: boolean = false;
    WeHaveFourierResiduals: boolean = false;
    noLowpassFreqSpec: boolean = true;
    noButterworthSpec: boolean = true;
    monthStopVisit: boolean = false;
    quarterStopVisit: boolean = false;
    doSmoothingBands: boolean = false;
    {--------------------------------------}  {Flags for seasonal adjustment}
    seasChange: boolean = false;
    doSeasonalAdjustment: boolean = false;
    weHaveSeasonalComponent: boolean = false;
    weHaveSeasonallyAdjustedData: boolean = false;
    weHaveAdjustedTrendResiduals: boolean = false;
    {--------------------------------------}


{polyDegree is in dataBOX}

{Graphics Parameters}
  var
    SCREENBOX, POSTBOX: IBOX;
    figNumber: integer;
    boxWidth, boxHeight:real;  {should these be within SCREENBOX ?}
    graphType: integer;
    legend: string;

    TVert, Tvert2: integer; {PROBLEMATIC PARAMETERS}
    Rotated: boolean;
    shadedBOX: integerRect;

    var
    sBandCentre, sBandWidth: triIntVec;
    filterBand: triBooleanVec;
    sProfile: integer;

{Data Parameters}     {periodBOX: rBOX;} {periodVeclongVector;}
  var
    seaCleft, seaFreq: cleftArray;
    dataBOX, residueBOX, trendBOX, adjustedBOX, seasonBOX, spectraBOX, periodBOX, cycleBOX, FourierResBOX, plotBOX: rBOX;
    dataVector, residueVec, trendVector, adjustedVec, spectraVec, seasonVec, cycleVec, plotVector, PolyWgts: longVector;
    polyParas: polyParameters;
    dataName, nameStore: string;
    startDate: dateRecord;


  {Filter Parameters: should all of these become part of FilterRecord?:}
  var
    filterSpec: FilterRecord;
    gamma, delta: complexVector; {Coefficient vectors of the filter}
    PUNCTSTORE: integer; {this is storinf dataBOX.NOPUNCT to overcome a blitch}

procedure ResetGlobalFlags;

procedure InitialiseDataBOX(var realBOX: rBOX);

procedure InitialiseIBOX(var SCREENBOX, POSTBOX: IBOX;
          var BOXwidth, BOXheight: real);

implementation

{_____________________________________________________________________________}

procedure ResetGlobalFlags;

begin
  discardFromStart := false;
  discardFromEnd := false;
  {--------------------------------------}  {Fags fortrend estimation}
  weHavePolyResiduals := false;
  weHaveTrendCycleResiduals:= false;
  {dataAreTrended := false;}
  dataExtrapolated := false;   {This includes tapering and logistic interpolation}
  weHaveTrendResiduals := false;
  weHaveATrendCycle := false;
  {--------------------------------------}  {Flags for cyclical component}
  weHaveACycle := false;
  {--------------------------------------} {Flags for filters}
  noFilter := true;
  noFilterSpec := true;
  noTimeDomainFilterSpec := true;
  noFrequencyFilterSpec := true;
  WeHaveFourierResiduals := false;
  noLowpassFreqSpec := true;
  noButterworthSpec := true;
  monthStopVisit := false;
  quarterStopVisit := false;
  doSmoothingBands := false;
  {--------------------------------------}  {Flags for seasonal adjustment}
  seasChange := false;
  doSeasonalAdjustment := false;
  weHaveSeasonalComponent := false;
  weHaveSeasonallyAdjustedData := false;
  weHaveAdjustedTrendResiduals := false;
  {--------------------------------------}
end; {RestGlobalFlags}

{_____________________________________________________________________________}

procedure InitialiseDataBOX(var realBOX: rBOX);

{This is required only for the Test Program}

begin
  realBOX.xMax := 160;
  realBOX.xMin := 0;

  realBOX.yMax := 345;
  realBOX.yMin := -57;

  realBOX.yRange:=  realBOX.xMax - realBOX.xMin;
  realBOX.yRange:=  realBOX.yMax - realBOX.yMin;

end; {InitialiseDataBOX}

{_____________________________________________________________________________}

procedure InitialiseIBOX(var SCREENBOX, POSTBOX: IBOX;
        var BOXwidth, BOXheight: real);

{BoxWidth, BoxHeight are global}

begin
  with SCREENBOX do
    begin
      X1 := XC - Round((BOXwidth * 36) / 2.54); {= HRS redundant}
      Y1 := YC - Round(BOXheight * 14.5); {= VTS redundant}
      X2 := XC + Round((BOXwidth * 36) / 2.54); {= HRF redundant}
      Y2 := YC + Round(BOXheight * 14.5); {= VTF redundant}
      BOXWDT := X2 - X1;
      BOXHGT := Y2 - Y1;

      doFrame :=  true;
      doMarks :=  true;
      yScale :=  true;
      xScale :=  true;
    end;

  with POSTBOX do
    begin
      doFrame :=  true;
      doMarks :=  true;
      yScale :=  true;
      xScale :=  true;
    end;

end;  {InitialiseIBOX}
{_____________________________________________________________________________}

end. {GLOBALS: Unit 1 of SEASCAPE.PAS}


