unit FREQFILT; {Unit of SEASCAPE.PAS}

interface

  uses
    GLOBALS, UTILS, MATHS, LEGENDS, DATASEG;

  procedure MakeCleftArray (var seaCleft: cleftArray;
                  var seaFreq: cleftArray;
                  var filterSpec: FilterRecord);

  procedure PlotTheResponse (var residueBOX, spectraBOX: rBOX;
                  var filterSpec: filterRecord;
                  var SCREENBOX, POSTBOX: IBOX;
                  var residueVec, spectraVec: longVector;
                  var legend: string);

  procedure DoNoTransitionCleft (j: integer;
                  var seaCleft: cleftArray;
                  var degree, ordinate: real);

  procedure NoTransitionsResponse (var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var spectraBOX: rBOX;
                  var spectraVec: longVector;
                  var SCREENBOX, POSTBOX: IBOX);

  procedure DoUpperCosineCleft (j: integer;
                  var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var degree, ordinate: real);

  procedure UpperCosineResponse (var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var spectraBOX: rBOX;
                  var spectraVec: longVector;
                  var SCREENBOX, POSTBOX: IBOX);

  procedure DoLowerCosineCleft (j: integer;
                  var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var degree, ordinate: real);

  procedure LowerCosineResponse (var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var spectraBOX: rBOX;
                  var spectraVec: longVector;
                  var SCREENBOX, POSTBOX: IBOX);

  procedure DoSigmoidCleft (j: integer;
                  var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var degree, ordinate: real);

  procedure SigmoidResponse (var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var spectraBOX: rBOX;
                  var spectraVec: longVector;
                  var SCREENBOX, POSTBOX: IBOX);

  procedure ScaleTheFourierOrdinates (var filterSpec: FilterRecord;
                  var residueBOX: rBOX;
                  var alpha: fourierVec;
                  var beta: fourierVec);

  procedure ScaleLowpassOrdinates (var filterSpec: FilterRecord;
                  var residueBOX: rBOX;
                  var alpha: fourierVec;
                  var beta: fourierVec);

  procedure DoLowSigmoidTransition (var Mb, Mc: real;
                  var nPower: integer;
                  var degree, ordinate: real);

  procedure LowpassSigmoidSpec (var filterSpec: FilterRecord;
                  var spectraBOX: rBOX;
                  var spectraVec: longVector;
                  var SCREENBOX, POSTBOX: IBOX);

  procedure IdealFilterSpec(var filterSpec: FilterRecord;
                  var spectraBOX: rBOX;
                  var spectraVec: longVector;
                  var SCREENBOX, POSTBOX: IBOX);

implementation

{_________________________________________________}

  procedure MakeCleftArray (var seaCleft: cleftArray;
                  var seaFreq: cleftArray;
                  var filterSpec: FilterRecord);
    var
      j, k: integer;
      pi, increment, seasHarmonic, radiansPerDegree: real;

 {Make CleftArray is called on activating Ustopbands and Uquadstop}
 {Therafter, the mapping from the widths of the bands,eg Lt, LS to}
 {the boundaries onthe frequency axis, eg Ma, Md, occur within those}
 {those units.}

  begin
    pi := 4.0 * ArcTan(1.0);
    radiansPerDegree := pi / 180.0;

    with filterSpec do
      begin {with filterSpec}

        if filterSpec.seasonality = Monthly then
          begin
            k := 6;
            increment := 30;
          end;

        if filterSpec.seasonality = Quarterly then
          begin
            k := 2;
            increment := 90;
          end;

        if (profile = noTransition) then
          begin {if}
            for j := 1 to k do
              begin {j}
                seaCleft[j].Lt := 0;
                seaCleft[j].Ls := 3;
                seaCleft[j].Us := 3;
                seaCleft[j].Ut := 0;
              end; {j}
          end; {if}

        if (profile = Sigmoid) and (seasonality = Quarterly) then
          begin {if}
            for j := 1 to k do
              begin {j}
                seaCleft[j].Lt := 15;
                seaCleft[j].Ls := 3;
                seaCleft[j].Us := 3;
                seaCleft[j].Ut := 15;
              end; {j}
            filterSpec.nPower :=3;
            filterSpec.truncParam := 0.5;
          end; {if}

        if (profile = Sigmoid) and (seasonality = Monthly) then
          begin {if}
            for j := 1 to k do
              begin {j}
                seaCleft[j].Lt := 12;
                seaCleft[j].Ls := 2;
                seaCleft[j].Us := 2;
                seaCleft[j].Ut := 12;
              end; {j}
            filterSpec.nPower :=3;
            filterSpec.truncParam := 0.5;
          end; {if}

        if (profile = upperHalfCosine) and (seasonality = Quarterly) then
          begin {if}
            for j := 1 to k do
              begin {j}
                seaCleft[j].Lt := 17;
                seaCleft[j].Ls := 3;
                seaCleft[j].Us := 3;
                seaCleft[j].Ut := 17;
              end; {j}
            filterSpec.nPower :=3;
            filterSpec.truncParam := 0.5;
          end; {if}

        if (profile = upperHalfCosine) and (seasonality = Monthly) then
          begin {if}
            for j := 1 to k do
              begin {j}
                 seaCleft[j].Lt := 12;
                seaCleft[j].Ls := 3;
                seaCleft[j].Us := 3;
                seaCleft[j].Ut := 12;
              end; {j}
            filterSpec.nPower :=3;
            filterSpec.truncParam := 0.5;
          end; {if}

        if (profile = lowerHalfCosine) and (seasonality = Quarterly) then
          begin {if}
            for j := 1 to k do
              begin {j}
                seaCleft[j].Lt := 7;
                seaCleft[j].Ls := 3;
                seaCleft[j].Us := 3;
                seaCleft[j].Ut := 7;
              end; {j}
            filterSpec.nPower :=3;
            filterSpec.truncParam := 0.5;
          end; {if}

        if (profile = lowerHalfCosine) and (seasonality = Monthly) then
          begin {if}
            for j := 1 to k do
              begin {j}
                seaCleft[j].Lt := 6;
                seaCleft[j].Ls := 2;
                seaCleft[j].Us := 2;
                seaCleft[j].Ut := 6;
              end; {j}
            filterSpec.nPower :=3;
            filterSpec.truncParam := 0.5;
          end; {if}


        for j := 1 to k do
          begin
            seasHarmonic := increment * j;
            seaCleft[j].Ma := seasHarmonic - seaCleft[j].Ls- seaCleft[j].Lt;
            seaCleft[j].Mb := seaCleft[j].Ma + seaCleft[j].Lt;
            seaCleft[j].Mc := seaCleft[j].Mb +  seaCleft[j].Ls + seaCleft[j].Us;
            seaCleft[j].Md := seaCleft[j].Mc + seaCleft[j].Ut;
          end;

       for j := 1 to k do
          begin
            seaFreq[j].Ma := seaCleft[j].Ma * radiansPerDegree;
            seaFreq[j].Mb := seaCleft[j].Mb * radiansPerDegree;
            seaFreq[j].Mc := seaCleft[j].Mc * radiansPerDegree;
            seaFreq[j].Md := seaCleft[j].Md * radiansPerDegree;
          end;

      end; {with FilterSpec}

  end; {MakeCleftArray}

{_________________________________________________}

  procedure PlotTheResponse (var residueBOX, spectraBOX: rBOX;
                  var filterSpec: filterRecord;
                  var SCREENBOX, POSTBOX: IBOX;
                  var residueVec, spectraVec: longVector;
                  var legend: string);

{spectraVec and spectaBOX contain the information  om frequendt reponse of the seasonal filter}
{Fifrst we need to diaplasy the peridogogram, This can be overalyes by the Response}

    var
      periodBOX: rBOX;
      alpha, beta: fourierVec;
      periogramVec: longVector;
      i, j, Ncap, Tcap: integer;

  begin
    Tcap := dataBOX.NOPUNCT;
    Ncap := Tcap div 2;

     if weHaveTrendResiduals then
      begin
        SlowFourier(residueBOX, residueVec, alpha, beta); {in DATASEG}

        MakeThePeriodogram(dataBOX, periodBOX, periogramVec, alpha, beta); {in DATASEG}

        periodBOX.NOPUNCT := Ncap + 1;
        MakeDataBox(periodBOX, periogramVec);
        periodBOX.yUB := periodBOX.ymax * 1.2;
      end;

    spectraBOX.NOPUNCT := SCREENBOX.BOXWDT;
    MakeDataBox(spectraBOX, spectraVec);

  end; {PlotTheResponse}

{_________________________________________________}

  procedure DoNoTransitionCleft (j: integer;
                  var seaCleft: cleftArray;
                  var degree, ordinate: real);

  begin
    {Here we must translate the clefts to loctions in [0, 180] }
    ordinate := 1.0;
    if (degree >= SeaCleft[j].Mb) and (degree <= SeaCleft[j].Mc) then
      ordinate := 0.0;

    {This is used only for thr PostSript plot}

  end;{DoNoTransitionCleft}

{_________________________________________________}

  procedure NoTransitionsResponse (var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var spectraBOX: rBOX;
                  var spectraVec: longVector;
                  var SCREENBOX, POSTBOX: IBOX);
    var
      i, j, k: integer;
      degree, ordinate: real;
      dataChar: char;
      {legend: string;}

  begin

    if filterSpec.seasonality = Monthly then
      k := 6;
    if filterSpec.seasonality = Quarterly then
      k := 2;

     if (monthStopVisit = false) and (filterSpec.seasonality = Monthly) then
       MakeCleftArray(seaCleft, seaFreq, filterSpec);

    for i := 0 to SCREENBOX.BOXWDT do
      begin {i}
        degree := (180.0 * i) / SCREENBOX.BOXWDT;
        ordinate := 1.0;
        for j := 1 to k do
          begin {j}
            if (degree >= seaCleft[j].Mb) and (degree <= seaCleft[j].Mc) then
              ordinate := 0.0;
          end; {j}
        spectraVec[i] := ordinate;
      end; {i}

    legend := SeasFreqFiltGain(filterSpec);

    spectraBOX.NOPUNCT := SCREENBOX.BOXWDT;
    MakeDataBox(spectraBOX, spectraVec);

    noFrequencyFilterSpec := false;

  end; {NoTransitionsResponse}

{_________________________________________________}

  procedure DoUpperCosineCleft (j: integer;
                  var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var degree, ordinate: real);

    {ordinate := ordinate(degree)}

    var
      num, denom, seasHarmonic, pi, r, x: real;
      Ma, Mb, Mc, Md, q: real;
      n : integer; {nPower?}

    begin
    q := filterSpec.truncParam;
    n := filterSpec.nPower;

    pi := 4.0 * ArcTan(1.0);
    Ma := seaCleft[j].Ma;
    Mb := seaCleft[j].Mb;
    Mc := seaCleft[j].Mc;
    Md := seaCleft[j].Md;

    r := Cos(Power(q, n) * pi / 2.0);
    if (degree >= Ma) and (degree < Mb) then
      begin
        num := q * (degree - Ma);
        denom := Mb - Ma;
        x := num / denom;
        ordinate := Cos(Power(x, n) * pi / 2.0) - r;
        ordinate := ordinate / (1 - r);
      end;

    if (degree >= Mb) and (degree <= Mc) then
      begin
        ordinate := 0.0;
      end;

    if (degree >= Mc) and (degree < Md) then
      begin
        num := q * (degree - Md);
        denom := Md - Mc;
        x := num / denom;
        ordinate := Cos(Power(x, n) * pi / 2.0) - r;
        ordinate := ordinate / (1 - r);
      end;

  end; {DoUpperCosineCleft}

{_________________________________________________}

  procedure UpperCosineResponse (var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var spectraBOX: rBOX;
                  var spectraVec: longVector;
                  var SCREENBOX, POSTBOX: IBOX);
    var
      i, j, k: integer;
      ordinate, degree: real;
      dataChar: char;

  begin
    if filterSpec.seasonality = Monthly then
      k := 6;
    if filterSpec.seasonality = Quarterly then
      k := 2;

     if (monthStopVisit = false) and (filterSpec.seasonality = Monthly) then
       MakeCleftArray(seaCleft, seaFreq, filterSpec);

    for i := 0 to SCREENBOX.BOXWDT do
      begin {i}
        degree := (180.0 * i) / SCREENBOX.BOXWDT;
        ordinate := 1.0;
        for j := 1 to k do
          begin
            if (degree >= seaCleft[j].Ma) and (degree <= seaCleft[j].Md) then
              DoUpperCosineCleft(j, seaCleft, filterSpec, degree, ordinate);
          end; {j}
        spectraVec[i] := ordinate;
      end; {i}

    spectraBOX.NOPUNCT := SCREENBOX.BOXWDT;
    MakeDataBox(spectraBOX, spectraVec);

   legend := SeasFreqFiltGain(filterSpec);

    noFrequencyFilterSpec := false;

  end; {UpperCosineResponse}

{_________________________________________________}

  procedure DoLowerCosineCleft (j: integer;
                  var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var degree, ordinate: real);
    var
      num, denom, pi, r, x: real;
      Ma, Mb, Mc, Md, q: real;
      n: integer;

  begin
    q := filterSpec.truncParam;
    n := filterSpec.nPower;

    pi := 4.0 * ArcTan(1.0);
    Ma := seaCleft[j].Ma;
    Mb := seaCleft[j].Mb;
    Mc := seaCleft[j].Mc;
    Md := seaCleft[j].Md;

    r := Cos(Power(q, n) * pi / 2.0);
    if (degree >= Ma) and (degree < Mb) then
      begin
        num := q * (degree - Mb);
        denom := Mb - Ma;
        x := num / denom;
        ordinate := 1 - Cos(Power(x, n) * pi / 2.0);
        ordinate := ordinate / (1 - r);
      end;

    if (degree >= Mb) and (degree <= Mc) then
      begin
        ordinate := 0.0;
      end;

    if (degree >= Mc) and (degree < Md) then
      begin
        num := q * (degree - Mc);
        denom := Md - Mc;
        x := num / denom;
        ordinate := 1 - Cos(Power(x, n) * pi / 2.0);
        ordinate := ordinate / (1 - r);
      end;

    noFrequencyFilterSpec := false;

  end; {DoLowerCosineCleft}

{_________________________________________________}

  procedure LowerCosineResponse (var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var spectraBOX: rBOX;
                  var spectraVec: longVector;
                  var SCREENBOX, POSTBOX: IBOX);

    var
      i, j, k, n: integer;
      q, ordinate, degree: real;
      dataChar: char;
      {legend: string; }

  begin

    if filterSpec.seasonality = Monthly then
      k := 6;
    if filterSpec.seasonality = Quarterly then
      k := 2;

     if (monthStopVisit = false) and (filterSpec.seasonality = Monthly) then
       MakeCleftArray(seaCleft, seaFreq, filterSpec);

    for i := 0 to SCREENBOX.BOXWDT do
      begin {i}
        degree := (180.0 * i) / SCREENBOX.BOXWDT;
        ordinate := 1.0;
        for j := 1 to k do
          begin
            if (degree >= seaCleft[j].Ma) and (degree <= seaCleft[j].Md) then
              DoLowerCosineCleft(j, seaCleft, filterSpec, degree, ordinate);
          end; {j}
        spectraVec[i] := ordinate;
      end; {i}

    legend := SeasFreqFiltGain(filterSpec);


    spectraBOX.NOPUNCT := SCREENBOX.BOXWDT;
    MakeDataBox(spectraBOX, spectraVec);

    noFrequencyFilterSpec := false;

  end; {LowerCosineResponse}

{_________________________________________________}

  procedure DoSigmoidCleft (j: integer;
                  var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var degree, ordinate: real);

    var
      denom,  piOver2, r, x, z: real;
      Ma, Mb, Mc, Md: real;
      n: integer;
      {pi: real}

  begin
    n := filterSpec.nPower;

    piOver2 := 2.0 * ArcTan(1.0);
    {piOver2 := pi/2.0;}

    Ma := seaCleft[j].Ma;
    Mb := seaCleft[j].Mb;
    Mc := seaCleft[j].Mc;
    Md := seaCleft[j].Md;

    if (degree >= Ma) and (degree < Mb) then
      begin {degree in [Ma, Mb)}
        denom := Mb - Ma;
        z := 2 * (degree - Ma) / denom;
        if (z >= 0) and (z <= 1) then
          begin
            x := z;
            ordinate := (Cos(piOver2 * Power(x, n)) + 1.0) / 2.0
          end;
        if (z >= 1) and (z <= 2) then
          begin
            x := 2 - z;
            ordinate := (1.0 - Cos(piOver2 * Power(x, n))) / 2.0
          end;
      end; {degree in [Ma, Mb)}

    if (degree >= Mb) and (degree <= Mc) then
      begin
        ordinate := 0.0;
      end;  {degree in [Mb, Mc]}

    if (degree > Mc) and (degree <= Md) then
      begin {degree in (Mc, Md]}
        denom := Md - Mc;
        z := 2 * (Md - degree) / denom;
        if (z >= 0) and (z <= 1) then
          begin
            x := z;
            ordinate := (Cos(piOver2 * Power(x, n)) + 1.0) / 2.0
          end;
        if (z >= 1) and (z <= 2) then
          begin
            x := 2 - z;
            ordinate := (1.0 - Cos(piOver2 * Power(x, n))) / 2.0
          end;
      end; {degree in [Mc, Md]}

  end;  {DoSigmoidCleft}

{_________________________________________________}

  procedure SigmoidResponse (var seaCleft: cleftArray;
                  var filterSpec: FilterRecord;
                  var spectraBOX: rBOX;
                  var spectraVec: longVector;
                  var SCREENBOX, POSTBOX: IBOX);

    var
      twoPi, degree, ordinate, omega: real;
      i, j, k, n: integer;
      dataChar: char;

  begin

    if filterSpec.seasonality = Monthly then
      k := 6;
    if filterSpec.seasonality = Quarterly then
      k := 2;

     {if (monthStopVisit = false) and (filterSpec.seasonality = Monthly) then}
       MakeCleftArray(seaCleft, seaFreq, filterSpec);

    for i := 0 to SCREENBOX.BOXWDT do
      begin {i}
        degree := (180.0 * i) / SCREENBOX.BOXWDT;
        ordinate := 1.0;
        for j := 1 to k do
          begin
            if (degree >= seaCleft[j].Ma) and (degree <= seaCleft[j].Md) then
              DoSigmoidCleft(j, seaCleft, filterSpec, degree, ordinate);
          end; {j}
        spectraVec[i] := ordinate;
      end; {i}

     legend := SeasFreqFiltGain(filterSpec);

     spectraBOX.NOPUNCT := SCREENBOX.BOXWDT;
     MakeDataBox(spectraBOX, spectraVec);

    noFrequencyFilterSpec := false;

  end; {SigmoidResponse}

{_________________________________________________}

  procedure ScaleTheFourierOrdinates (var filterSpec: FilterRecord;
                  var residueBOX: rBOX;
                  var alpha: fourierVec;
                  var beta: fourierVec);

    var
      i, j, k, Tcap, Ncap, nPower: integer;
      pi, fourierInc, omegaj, gain: real;

  begin
    Tcap := residueBOX.NOPUNCT;
    pi := 4.0 * ArcTan(1.0);
    fourierInc := 2.0 * pi / Tcap;
    Ncap := Tcap div 2;

    nPower := filterSpec.nPower;

    if filterSpec.seasonality = Monthly then
      k := 6;
    if filterSpec.seasonality = Quarterly then
      k := 2;

    for j := 1 to Ncap do {proceed along the frequency axis }
      begin {j:  Fourier ordinate}

        omegaj := fourierInc * j;

        for i := 1 to k do
          begin {i : cleft number}
            gain := 1.0;

            if (omegaj >= seaFreq[i].Ma) and (omegaj <= seaFreq[i].Md) then
              begin {within the ith clefy}

                if filterSpec.profile = noTransition then
                  DoNoTransitionCleft(i, seaFreq, omegaj, gain);

                if filterSpec.profile = Sigmoid then
                  DoSigmoidCleft(i, seaFreq, filterSpec, omegaj, gain);

                if filterSpec.profile = upperHalfCosine then
                  DoUpperCosineCleft(i, seaFreq, filterSpec, omegaj, gain);

                if filterSpec.profile = lowerHalfCosine then
                  DoLowerCosineCleft(i, seaFreq, filterSpec, omegaj, gain);

                if gain <> 1.0 then
                  begin
                    alpha[j] := alpha[j] * gain;
                    beta[j] := beta[j] * gain;
                  end;

              end;{within the ith cleft array}
          end;  {i  : cleft number}
      end; {j: Fourier ordinate}

  end; {ScaleTheFourierOrdinates;}

{_________________________________________________}

  procedure ScaleLowpassOrdinates (var filterSpec: FilterRecord;
                  var residueBOX: rBOX;
                  var alpha: fourierVec;
                  var beta: fourierVec);
    var
      i, j, k, Tcap, Ncap, nPower: integer;
      pi, fourierInc, omegaj, gain: real;
      radiansPerDegree, Mb, Mc: real;
      F: text;

  begin
    Tcap := residueBOX.NOPUNCT;
    pi := 4.0 * ArcTan(1.0);
    radiansPerDegree := pi / 180.0;
    fourierInc := 2.0 * pi / Tcap;
    Ncap := Tcap div 2;
    nPower := filterSpec.nPower;

    Mb := filterSpec.Mb * radiansPerDegree;
    Mc := filterSpec.Mc * radiansPerDegree;

    for j := 1 to Ncap do {proceed along the frequency axis }
      begin {j:  Fourier ordinate}
        omegaj := fourierInc * j;

        if (omegaj <= Mb) then
          gain := 1.0;
        if (omegaj >= Mb) and (omegaj <= Mc) then
          DoLowSigmoidTransition(Mb, Mc, nPower, omegaj, gain);
        if (omegaj >= Mc) then
          gain := 0.0;

        if gain <> 1.0 then
          begin
            alpha[j] := alpha[j] * gain;
            beta[j] := beta[j] * gain;
          end;

      end; {j}

  end; {ScaleLowpassOrdiantes}

{_________________________________________________}

  procedure DoLowSigmoidTransition (var Mb, Mc: real;
                  var nPower: integer;
                  var degree, ordinate: real);

    var
      piOver2, x, z: real;
      n: integer;

  begin
    n := nPower;
    piOver2 := 2.0 * ArcTan(1.0);

    ordinate := 1.0;
    z := 2 * (degree - Mb) / (Mc - Mb);
    if z < 0 then
      ordinate := 1.0;
    if (z >= 0) and (z <= 1) then
      begin
        x := z;
        ordinate := (Cos(piOver2 * Power(x, n)) + 1) / 2.0;
      end;
    if (z >= 1) and (z <= 2) then
      begin
        x := 2 - z;
        ordinate := (1.0 - Cos(piOver2 * Power(x, n))) / 2.0;
      end;
    if z > 2 then
      ordinate := 0.0;

  end; {DoLowSigmoidTransition}

{______________________________________________________________________________}

  procedure LowpassSigmoidSpec (var filterSpec: FilterRecord;
                  var spectraBOX: rBOX;
                  var spectraVec: longVector;
                  var SCREENBOX, POSTBOX: IBOX);
    var
      pi, piOver2, z, degree, ordinate, Mb, Mc: real;
      Tcap, t, nPower: integer;
      {legend: string;}

  begin
    filterSpec.filterfamily := LowSigmoid;
    Mb := filterSpec.Mb;
    Mc := filterSpec.Mc;
    nPower := filterSpec.nPower;
    filterSpec.seasonality := Quarterly;   {this is a default to be revised in thr light of datBOX.datafrequency}

    Tcap := SCREENBOX.BOXWDT;{NOPUNCT}


    {legend := SigmoidFilterGain(filterSpec); }

    for t := 0 to SCREENBOX.BOXWDT do
      begin
        degree := (180.0 * t) / SCREENBOX.BOXWDT;
        DoLowSigmoidTransition(Mb, Mc, nPower, degree, ordinate);
        spectraVec[t] := ordinate;
      end;

    spectraBOX.NOPUNCT := SCREENBOX.BOXWDT;
    MakeDataBox(spectraBOX, spectraVec);

    Tvert := Round(filterSpec.Mb * SCREENBOX.BOXWDT/180.0);
    Tvert2 := Round(filterSpec.Mc * SCREENBOX.BOXWDT/180.0);

    noLowpassFreqSpec := false;

  end; {LowpassSigmoidSpec}

{______________________________________________________________________________}

procedure IdealFilterSpec(var filterSpec: FilterRecord;
                  var spectraBOX: rBOX;
                  var spectraVec: longVector;
                  var SCREENBOX, POSTBOX: IBOX);

var
  degree, ordinate: real;
  Tcap, t: integer;

begin
    filterSpec.filterFamily := IdealLowpass;
     filterSpec.seasonality := Quarterly; {this is a default to be revised in thr light of datBOX.datafrequency}

     Tcap := SCREENBOX.BOXWDT;{NOPUNCT}


    legend := IdealLowpassGain(filterSpec);

    for t := 0 to SCREENBOX.BOXWDT do
      begin
        degree := (180.0 * t) / SCREENBOX.BOXWDT;
        if degree <= filterSpec.cutOff then
          ordinate := 1.0
        else ordinate := 0.0;
        spectraVec[t] := ordinate;
      end;

    spectraBOX.NOPUNCT := SCREENBOX.BOXWDT;
    MakeDataBox(spectraBOX, spectraVec);

end;  {IdealFilterSpec}

{______________________________________________________________________________}


end. {FREQFILT: Unit of SEASCAPE.PAS}



