unit Uwienerfilts;  {Unit of SEASCAPE}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  DATASEG, GLOBALS;

type

  { TFwienerfilts }

  TFwienerfilts = class(TForm)
    BtnRETURN: TButton;
    EditLambda: TEdit;
    EditCutOff: TEdit;
    EditOrder: TEdit;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    LblSmoothing: TLabel;
    LblFilterOrder: TLabel;
    LblCutOff: TLabel;
    LblDegrees: TLabel;
    ListBox: TListBox;
    RadioBtnButter: TRadioButton;
    RadioBtnLeser: TRadioButton;
    StaticText1: TStaticText;
    procedure BtnRETURNClick(Sender: TObject);
    procedure EditCutOffKeyPress(Sender: TObject; var Key: char);
    procedure EditLambdaKeyPress(Sender: TObject; var Key: char);
    procedure EditOrderKeyPress(Sender: TObject; var Key: char);
    procedure FormActivate(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
    procedure RadioBtnButterChange(Sender: TObject);
    procedure RadioBtnLeserChange(Sender: TObject);
  private

  public

  end;

procedure CheckButterworth(var EditCutOff, EditOrder: Tedit;
                   var CutOffSpecified, OrderSpecified: boolean);

procedure CheckHodrickPrescott(var EditLambda: TEdit;
                   var LambdaSpecified: boolean);

var
  Fwienerfilts: TFwienerfilts;
  CutOffSpecified, LambdaSpecified, OrderSpecified: boolean;
  alpha, beta: FourierVec;

implementation
  uses
    WIENER, legends, Uplotscreen;

{$R *.lfm}

{ TFwienerfilts }
 
{______________________________________________________________________________}

  procedure TFwienerfilts.FormActivate(Sender: TObject);
begin
  EditOrder.Enabled := false;
  EditCutOff.Enabled := false;
  EditLambda.Enabled := false;

  LblFilterOrder.Enabled := false;
  LblCutOff.Enabled := false;
  LblDegrees.Enabled := false;
  LblSmoothing.Enabled := false;
end;

{______________________________________________________________________________}

  procedure TFwienerfilts.RadioBtnButterChange(Sender: TObject);
  begin
    filterSpec.filterFamily := Butterworth;
    filterSpec.filterType := lowpass;

    EditOrder.Enabled := true;
    EditCutOff.Enabled := true;
    EditLambda.Enabled := false;

    EditOrder.text := '';
    EditCutOff.text := '';
    EditLambda.text := '';

    LblFilterOrder.Enabled := true;
    LblCutOff.Enabled := true;
    LblDegrees.Enabled := true;
    LblSmoothing.Enabled := false;

  end; {RadioBtnButterChange}
{______________________________________________________________________________}


  procedure TFwienerfilts.RadioBtnLeserChange(Sender: TObject);
  begin
    filterSpec.filterFamily := HodrickPrescott;
    filterSpec.filterType := lowpass;

     EditLambda.Enabled := true;
     EditOrder.Enabled := false;
     EditCutOff.Enabled := false;

    EditOrder.text := '';
    EditCutOff.text := '';
    EditLambda.text := '';

    LblFilterOrder.Enabled := false;
    LblCutOff.Enabled := false;
    LblDegrees.Enabled := false;
    LblSmoothing.Enabled := true;

  end;  {RadioBtnLeserChange}

{______________________________________________________________________________}

procedure TFwienerfilts.EditCutOffKeyPress(Sender: TObject; var Key: char);

begin
  if not (key in [#0, '0'..'9', '.',#8])  then
    begin
      ShowMessage('Enter numeric values only');
      key := #0;
    end;
end;  {EditCutOffKeyPress}
{______________________________________________________________________________}

procedure TFwienerfilts.EditLambdaKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', '.',#8])  then
   begin
     ShowMessage('Enter numeric values only');
     key := #0;
   end;
end;  {EditLambdaKeyPress}

{______________________________________________________________________________}

procedure TFwienerfilts.EditOrderKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8])  then
    begin
      ShowMessage('Enter integer values only');
      key := #0;
    end;
end;   {EditOrderKeyPress}

{______________________________________________________________________________}

procedure CheckButterworth(var EditCutOff, EditOrder: Tedit;
                   var CutOffSpecified, OrderSpecified: boolean);

begin
  CutOffSpecified := false;
  if  EditCutOff.text = '' then
    ShowMessage('No cutoff frequency has been specified')
  else
    begin {else}
      filterSpec.cutOff := StrToFloat(EditCutOff.text);

      if (filterSpec.cutOff >= 0) and (filterSpec.cutOff <= 180) then
          CutOffSpecified := true
      else
        begin
          ShowMessage('The cut-off value must be between 0 and 180');
          EditCutOff.text := '';
        end;
      end; {else}


  OrderSpecified := false;
  if EditOrder.text = '' then
    ShowMessage('No filter order has been specified')
  else
    begin {else}
      filterSpec.filterOrder := StrToInt(EditOrder.text);
      if (filterSpec.filterOrder >= 0) and (filterSpec.filterOrder <=15) then
        OrderSpecified := true
      else
        begin
          ShowMessage('The order must be between 1 and 15');
          EditOrder.text := '';
        end;
      end; {else}

end;   {CheckButterworth}

{______________________________________________________________________________}

procedure CheckHodrickPrescott(var EditLambda: TEdit;
                   var LambdaSpecified: boolean);

begin
  LambdaSpecified := false;
  if EditLambda.text = '' then
    ShowMessage('No smoothing parameter has been specified')
  else
    begin  {else}
       filterSpec.smoothingParameter := StrToFloat(EditLambda.text);
       if (filterSpec.smoothingParameter >= 0) and (filterSpec.smoothingParameter <= 20000) then
         LambdaSpecified := true
      else
        begin
          ShowMessage('The value must be greater than 0 and no greater than 20,000');
          EditLambda.text := '';
        end;
    end;  {else}

end;  {CheckHodrickPrescott}

{______________________________________________________________________________}

procedure TFwienerfilts.ListBoxClick(Sender: TObject);

  var index: integer;
      proceed: boolean;
      F: text; {TEMP}
      t: integer; {TEMP}

begin
    ListBox.Enabled := true;
    proceed := false;

    index := ListBox.itemIndex;

  {------------------------------}

  if filterSpec.filterFamily = Butterworth then
    begin
      CheckButterWorth(EditCutOff, EditOrder, CutOffSpecified, OrderSpecified);
      if OrderSpecified and CutOffSpecified then
         proceed := true
      else
        ShowMessage('The Butterworth parameters are not fully specified');
    end;

  {------------------------------}

  if filterSpec.filterFamily = HodrickPrescott then
    begin
      CheckHodrickPrescott(EditLambda, LambdaSpecified);
       if lambdaSpecified then
          proceed := true
      else
        ShowMessage('The Hodrick-Prescott parameter lambda has not been specified');
    end;

    {------------------------------}

    if (index = 1)  and proceed then
     begin  {Frequency Response}
       filterSpec.seasonality := dataBOX.dataFrequency;

      if filterSpec.filterFamily = Butterworth then
         legend :=  ButterworthGain (filterSpec);

      if filterSpec.filterFamily = HodrickPrescott then
         legend := HPFilterGain (filterSpec);  {IMPULSE RESPONSE!?}

      {GetFilterGainVector (filterSpec, plotBOX, SCREENBOX, plotVector);} {in FILTERS}

       if weHavePolyResiduals then     {plotVector for the periodogram, spectraVec for the response?}
         begin
           GetFilterGainVector (filterSpec, spectraBOX, SCREENBOX, spectraVec); {in FILTERS}
           SlowFourier (residueBOX, residueVec, alpha, beta);
           plotVector := residueVec;
           MakeThePeriodogram (residueBOX, plotBOX, plotVector, alpha, beta);
           {++++++++++++++++++++++++++++++++++++++++++++++}
           {AssignFile(F, 'PDgramIWIENEER.txt');
           ReWrite(F);
           WRITELN(F, ' plotBOX.NOPUNCT = ',plotBOX.NOPUNCT :4);
           for t := 0 to plotBOX.NOPUNCT-1 do
           WRITELN(F, plotVector[t]: 6:4);
           CloseFile(F);}
           {++++++++++++++++++++++++++++++++++++++++++++++}
             graphType :=  backgroundPlot;
           Fplotscreen := TFplotscreen.Create(Nil);
           Fplotscreen.ShowModal;
           FreeAndNil(Fplotscreen);
          end
       else
         begin
           GetFilterGainVector (filterSpec, plotBOX, SCREENBOX, plotVector); {in FILTERS}
           graphType :=  spectraGraph;
            plotBOX.yMin := 0.0;
           Fplotscreen := TFplotscreen.Create(Nil);
           Fplotscreen.ShowModal;
           FreeAndNil(Fplotscreen);
         end;
     end; {Frequency Response}

     {------------------------------}

    if (index = 3) and proceed  then
      begin
        graphType := dataOverPlotGraph;

        if filterSpec.filterFamily = Butterworth then
          begin
            MakeButterTrend (dataBOX, trendBOX, residueBOX, filterSpec, dataVector, trendVector, residueVec); {in WIENER}
            legend := ButterworthTrend (dataBOX, dataName, filterSpec);
            {weHaveSeasonalComponent := false;}
            {weHaveDeasonalisedData := false;}
          end;

          if filterSpec.filterFamily = HodrickPrescott then
            begin
              MakeHPTrend (dataBOX, trendBOX, residueBOX, filterSpec, dataVector, trendVector, residueVec);
              legend := HPtrend (dataBOX, filterSpec, dataName);
              {weHaveSeasonalComponent := false;}
              {weHaveDeasonalisedData := false;}
            end;

            Fplotscreen := TFplotscreen.Create(Nil);
            Fplotscreen.ShowModal;
            FreeAndNil(Fplotscreen);

            if filterSpec.filterFamily = Butterworth then
               legend := ButterworthResiduals (dataBOX, dataName,filterSpec);
            if filterSpec.filterFamily = HodrickPrescott then
               legend := HPresiduals (dataBOX, filterSpec,dataName);

            graphType := dataGraph;
            plotVector := residueVec;
            plotBOX :=residueBOX;
            Fplotscreen := TFplotscreen.Create(Nil);
            Fplotscreen.ShowModal;
            FreeAndNil(Fplotscreen);

            weHaveATrendCycle := true;
     end;  {Apply the Filter}

     {------------------------------}

end; {ListBoxClick}

{______________________________________________________________________________}

procedure TFwienerfilts.BtnRETURNClick(Sender: TObject);
begin
  Close;
end;

{______________________________________________________________________________}


end. {Uwienerfilters: Unit of SEASCAPE.PAS}

