unit Usegmentation;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  GLOBALS, UTILS;
type

  { TFsegmentation }

  TFsegmentation = class(TForm)
    BtnRETURN: TButton;
    EdDataLength: TEdit;
    EdtNoOfSegs: TEdit;
    EdtPointsNo: TEdit;
    EdtNoOfRes: TEdit;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    ListBox: TListBox;
    RadioBtnSegLength: TRadioButton;
    RadioBtnNoOfSegs: TRadioButton;
    RadioBtnRawData: TRadioButton;
    RadioBtnDeviations: TRadioButton;
    DescriptiveText: TStaticText;
    ResidualsText: TStaticText;
    StaticText1: TStaticText;
    procedure BtnRETURNClick(Sender: TObject);
    procedure EdDataLengthChange(Sender: TObject);
    procedure EdDataLengthKeyPress(Sender: TObject; var Key: char);
    procedure EdtNoOfSegsChange(Sender: TObject);
    procedure EdtNoOfSegsKeyPress(Sender: TObject; var Key: char);
    procedure FormActivate(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
    procedure RadioBtnSegLengthChange(Sender: TObject);
    procedure RadioBtnNoOfSegsChange(Sender: TObject);
    procedure RadioBtnRawDataChange(Sender: TObject);
    procedure RadioBtnDeviationsChange(Sender: TObject);
  private

  public

  end;

var
  Fsegmentation: TFsegmentation;
  lengthSpec, segmentSpec, plotTheData, plotTheDeviations: boolean;


implementation

uses
  UplotScreen;

{$R *.lfm}

{ TFsegmentation }
{______________________________________________________________________________}

procedure TFsegmentation.FormActivate(Sender: TObject);
begin
  EdtPointsNo.Text := IntToStr(dataBOX.NOPUNCT);
  EdDataLength.Enabled :=  false;
  EdDataLength.Text :=  '';
  EdtNoOfSegs.Enabled := true;
  EdtNoOfSegs.Text :=  '';

  EdDataLength.Font.Style := [fsBold];

  plotTheData :=true;
  plotTheDeviations := false;

  if weHavePolyResiduals then
    RadioBtnDeviations.Enabled := true
  else
    RadioBtnDeviations.Enabled := false;

end;  {FormActivate}

{______________________________________________________________________________}

procedure TFsegmentation.RadioBtnSegLengthChange(Sender: TObject);
begin
  EdDataLength.Enabled := true;
  EdtNoOfSegs.Enabled := false;
  EdtNoOfSegs.Text := '';
  ResidualsText.Caption := '';

  EdDataLength.Font.Style := [];
  EdtNoOfSegs.Font.Style := [fsBold];

end; {RadioBtnSegLengthChange}
{______________________________________________________________________________}

procedure TFsegmentation.RadioBtnNoOfSegsChange(Sender: TObject);
begin
  EdtNoOfSegs.Enabled := true;
  EdDataLength.Enabled := false;
  EdDataLength.Text := '';

  EdtNoOfSegs.Font.Style := [];
  EdDataLength.Font.Style := [fsBold];

end; {RadioBtnNoOfSegsChange}

{______________________________________________________________________________}

procedure TFsegmentation.RadioBtnRawDataChange(Sender: TObject);
begin
  plotBOX := dataBOX;
  plotVector := dataVector;
  plotTheData := true;
  plotTheDeviations := false;
end;  {RadioBtnRawDataChange}
{______________________________________________________________________________}

procedure TFsegmentation.RadioBtnDeviationsChange(Sender: TObject);
begin
   plotVector := residueVec;
   plotTheDeviations := true;
   plotTheData := false;
end;  {RadioBtnDeviationsChange}
{______________________________________________________________________________}

procedure TFsegmentation.EdDataLengthKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', '.',#8])then
  begin
    ShowMessage('Enter a real value in (0, 180)');
    key := #0;
  end;

end; {EdDataLengthKeyPress}
{______________________________________________________________________________}

procedure TFsegmentation.EdtNoOfSegsChange(Sender: TObject);

begin
    if EdtNoOfSegs.Enabled and (EdtNoOfSegs.text <> '')then
      begin
        dataBOX.numbOfSegs :=  StrToInt(EdtNoOfSegs.text);
        dataBOX.segLength := dataBOX.NOPUNCT div  dataBOX.numbOfSegs;
        EdDataLength.Text := IntToStr(dataBOX.segLength);
        dataBOX.segResidue := dataBOX.NOPUNCT mod dataBOX.numbOfSegs;
        EdtNoOfRes.Text :=  IntToStr(dataBOX.segResidue);
        ResidualsText.Caption := 'The residual data points' + #13#10 + 'will be shared amongst'  + #13#10 + 'the data segments';
        lengthSpec := false;
        segmentSpec := true;
      end;
 end; {EdtNoOfSegsChange}
{______________________________________________________________________________}

procedure TFsegmentation.EdtNoOfSegsKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9',#8])then
  begin
    ShowMessage('Enter an integer number)');
    key := #0;
  end;

end; {EdtNoOfSegsKeyPress}
{______________________________________________________________________________}

procedure TFsegmentation.EdDataLengthChange(Sender: TObject);
begin
  if EdDataLength.Enabled and (EdDataLength.Text <> '')then
    begin
      dataBOX.segLength := StrToInt(EdDataLength.text);
      dataBOX.numbOfSegs := dataBOX.NOPUNCT div  dataBOX.segLength;
      EdtNoOfSegs.Text := IntToStr(dataBOX.numbOfSegs);
      dataBOX.segResidue := dataBOX.NOPUNCT mod dataBOX.segLength;
      EdtNoOfRes.Text :=  IntToStr(dataBOX.segResidue);
      ResidualsText.Caption := 'The residual data points' + #13#10 + 'will be appended to the'  + #13#10 + 'final segment';
      lengthSpec := true;
      segmentSpec := false;
    end;
end;  {EdDataLengthChange}

{______________________________________________________________________________}

procedure TFsegmentation.BtnRETURNClick(Sender: TObject);
begin
  Close;
end;  {BtnRETURNClick}
{______________________________________________________________________________}

function SegmentCaption(plotNumber: integer): string;
 var
   addString: string;

   begin
      if  plotNumber = 1 then
        addstring := 'first ';
      if  plotNumber = 2 then
        addstring := 'second ';
      if  plotNumber = 3 then
        addstring := 'third ';
      if  plotNumber > 3 then
         addstring := IntToStr(plotNumber) +'th ';
      if plotNumber = dataBOX.numbOfSegs then
        addstring := 'final ';
      SegmentCaption := 'The '+ addstring +'segment of the data';
    end; {SegmentCaption}
{______________________________________________________________________________}

procedure SegmentedPlot (var dataBOX, plotBOX: rBOX;
              var dataVector, plotVector: longVector;
              var legend: string);

var
  plotNumber, residue, s, t: integer;

begin
  plotNumber := 1;
  s := 0;
  plotBOX.NOPUNCT := dataBOX.segLength;
  residue := dataBOX.segResidue;

  repeat {plotNumber = dataBOX.numbOfSegs;}

    if lengthSpec then
      begin  {lengthSpec}
        if (plotNumber < dataBOX.numbOfSegs) then
          begin
          plotBOX.NOPUNCT := dataBOX.segLength;
          {ShowMessage('This is LengthSpec and less than total numbofSegs');}
          end
      else
        begin
          plotBOX.NOPUNCT := dataBOX.segLength + dataBOX.segResidue;
          {ShowMessage('This is LengthSpec and the final segment');}
          {ShowMessage('plotBOX.NOPUNCT = ' + intToStr(plotBOX.NOPUNCT) + '  dataBOX.segResidue = ' + intToStr(dataBOX.segResidue));}
        end;
      end; {lengthSpec}

    if segmentSpec then
      begin  {segmentSpec}
        if (residue > 0) then
          begin
            plotBOX.NOPUNCT := dataBOX.segLength + 1;
	    residue := residue - 1;
          end
        else
	  plotBOX.NOPUNCT := dataBOX.segLength;
      end; {segmentSpec}

      for t := 0 to plotBOX.NOPUNCT - 1 do
        begin
          if plotTheData then
            plotVector[t] := dataVector[s + t];
          if plotTheDeviations then
            plotVector[t] := residueVec[s + t];
        end;

      MakeDataBox (plotBOX, plotVector);
      legend := SegmentCaption(plotNumber);
      graphType := dataGraph;

      Fplotscreen := TFplotscreen.Create(nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);

      plotNumber := plotNumber + 1;
      s := s + plotBOX.NOPUNCT;
    until plotNumber = dataBOX.numbOfSegs + 1;

end; {SegmentedPlot}

{______________________________________________________________________________}

procedure TFsegmentation.ListBoxClick(Sender: TObject);

var
  index: integer;

begin

  index := ListBOX.ItemIndex;
{++++++++++++++++++++++++++++++++++}
if index = 1 then
  begin
    legend := 'A plot of all of the data';
    {plotBOX := dataBOX;}

    if plotTheData then
      begin
      plotVector := dataVector;
      plotBOX := dataBOX
      end;
    if plotTheDeviations then
      begin
      plotVector := residueVec;
      plotBOX := residueBOX;
      end;

    graphType := dataGraph;
    Fplotscreen := TFplotscreen.Create(nil);
    Fplotscreen.ShowModal;
    FreeAndNil(Fplotscreen);
  end;  {Plot all the Data}
{++++++++++++++++++++++++++++++++++}
if index = 3 then
  begin
    if dataBOX.segLength < 50 then
      ShowMessage('The minimum length of a data segment is 50 points. Please respecify the length.')
    else
      begin
        SegmentedPlot (dataBOX, plotBOX, dataVector, plotVector, legend);
      end;
  end;  {Plot Successive Data Segments}
{++++++++++++++++++++++++++++++++++}

end; {ListBoxClick}

{______________________________________________________________________________}

end.

