unit Uplotscreen;  {unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls, lcltype;

type

  { TFplotScreen }

  TFplotScreen = class(TForm)
    BtnRETURN: TButton;
    SaveDialog: TSaveDialog;
    procedure BtnRETURNClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private

  public

  end;

var
  FplotScreen: TForm;

implementation
  uses
     GLOBALS, SCREEN, LEGENDS, POSTSCRIPT;

{$R *.lfm}

{ TFplotScreen }

{______________________________________________________________________________}

     procedure TFplotscreen.FormActivate(Sender: TObject);

     begin
       SCREENBOX.XC := Fplotscreen.Width div 2;
       SCREENBOX.YC := Fplotscreen.Height div 2;
       InitialiseIBOX(SCREENBOX, POSTBOX, BOXwidth, BOXheight);

     end;  {FormActivate}

{______________________________________________________________________________}

  procedure TFplotscreen.FormPaint(Sender: TObject);

  begin

    {-----------------------------------------------------------}

    if graphType = dataGraph then
      begin
        Canvas.Font.Name := 'Symbol';
        SCREENBOX.xScale := true;
        ScreenFrame (Fplotscreen, plotBOX, SCREENBOX);

        if  doSmoothingBands then
          HighLightRegions (Fplotscreen, sBandWidth, sBandCentre,SCREENBOX);

        if discardFromStart  then
          MakeDataLine (Fplotscreen, Tvert, SCREENBOX, dataBOX);
        if discardFromEnd then
          MakeDataLine (Fplotscreen, Tvert2, SCREENBOX, dataBOX);

        ScreenPlot (Fplotscreen, plotBOX, SCREENBOX, plotVector);
        Canvas.Font.Name := 'Courier New';
        Canvas.Font.Size := 12;
        ScreenCaption (Fplotscreen, SCREENBOX, legend);
      end;  {dataGraph}

    {-----------------------------------------------------------}

    if graphtype = PeriodoGraph then
      begin
        Canvas.Font.Name := 'Symbol';
        ScreenFrameLite (Fplotscreen,spectraBOX,SCREENBOX);

        {SCREENBOX.xScale := false;}
        {ScreenFrame (Fplotscreen, spectraBOX, SCREENBOX);}
        {SHOWMESSAGE('WE have completed  <ScreenFrameLite>');}

        if filterSpec.seasonality in [Quarterly, Annual] then
          ZeroPiAxis (Fplotscreen, SCREENBOX);
        if filterSpec.seasonality = Monthly then
          DoDecAxis (Fplotscreen, SCREENBOX);

        ScreenPlot(Fplotscreen,spectraBOX, SCREENBOX, spectraVec);
        Canvas.Font.Name := 'Courier New';
        Canvas.Font.Size := 12;
        ScreenCaption (Fplotscreen, SCREENBOX, legend);

        SCREENBOX.xScale := false;
      end;  {PeriodoGraph}

      {-----------------------------------------------------------}

     if graphtype = spectraGraph then
      begin
        Canvas.Font.Name := 'Symbol';
        plotBOX.yMin := 0.0;

        ScreenFrameLite (Fplotscreen, plotBOX, SCREENBOX);

        if filterSpec.seasonality in [Quarterly, Annual] then
          ZeroPiAxis (Fplotscreen, SCREENBOX);
        if filterSpec.seasonality = Monthly then
          DoDecAxis (Fplotscreen, SCREENBOX);

        ScreenPlot(Fplotscreen, plotBOX, SCREENBOX, plotVector);
        Canvas.Font.Name := 'Courier New';
        Canvas.Font.Size := 12;
        ScreenCaption (Fplotscreen, SCREENBOX, legend);
        SCREENBOX.xScale := true;

      end;  {spectraGraph}

     {-----------------------------------------------------------}

    if graphType = dataOverPlotGraph then
      begin
        Canvas.Font.Name := 'Symbol';
        ScreenFrame (Fplotscreen, dataBOX, SCREENBOX);
        ScreenPlot (Fplotscreen, dataBOX, SCREENBOX, dataVector);
        Canvas.Pen.Color := clRed;
        Canvas.Pen.Width :=  2;
        ScreenPlot (Fplotscreen, dataBOX, SCREENBOX, trendVector);
        Canvas.Pen.Color := clBlack;
        Canvas.Pen.Width :=  1;
        Canvas.Font.Name := 'Courier New';
        Canvas.Font.Size := 12;
        ScreenCaption (Fplotscreen, SCREENBOX, legend);
      end;   {dataOverPlotGraph}

    {-----------------------------------------------------------}
 
 if graphType = extensionsGraph then
   begin {extensionsGraph}
      Canvas.Font.Name := 'Symbol';
      {ShadedRectangle(Fplotscreen, shadedBOX);}
      ScreenFrame (Fplotscreen, cycleBOX, SCREENBOX);      {We could use adjustedVec, adjustedBOX}
      ScreenPlot (Fplotscreen, cycleBOX, SCREENBOX, cycleVec);
      MakeDataLine(Fplotscreen, Tvert, SCREENBOX, cycleBOX);
      if Rotated then
        MakeDataLine(Fplotscreen, Tvert2, SCREENBOX, cycleBOX);
      Canvas.Font.Name := 'Courier New';
      Canvas.Font.Size := 12;
      ScreenCaption (Fplotscreen, SCREENBOX, legend)
   end; {extensionsGraph}

    {-----------------------------------------------------------}

 if graphType = backgroundPlot then
   begin {backgroundPlot}
    Canvas.Font.Name := 'Symbol';
    ScreenFrameLite (Fplotscreen, spectraBOX, SCREENBOX);

    if filterSpec.seasonality = Quarterly then
      ZeroPiAxis (Fplotscreen, SCREENBOX);
    if filterSpec.seasonality = Monthly then
      DoDecAxis (Fplotscreen, SCREENBOX);

    if (filterSpec.filterfamily = LowSigmoid) and (not doSeasonalAdjustment) then
      begin
        Tvert := Round(filterSpec.Mb);
        Tvert2 := Round(filterSpec.Mc);
        MakeDottedLine(Fplotscreen, Tvert, SCREENBOX);
        MakeDottedLine(Fplotscreen, Tvert2, SCREENBOX);
      end;

     InvisibleFrame (plotBOX);  {Establish the parameters for plotting the periodogram}
     Canvas.Pen.Color := clRed;
     {Canvas.Pen.Width :=  2;}
     ScreenPlot (Fplotscreen, plotBOX, SCREENBOX, plotVector);  {Plot the peridogram}
     Canvas.Pen.Color := clBlack;
     Canvas.Pen.Width :=  1;
     ScreenPlot (Fplotscreen, spectraBOX, SCREENBOX, spectraVec);{Plot the frequency Response}
     Canvas.Font.Name := 'Courier New';
     Canvas.Font.Size := 12;

     ScreenCaption (Fplotscreen, SCREENBOX, legend);

   end; {backgroundPlot}

    {-----------------------------------------------------------}

    if graphType = cycleGraph then     {this could be overplot}
      begin {cycleGraph}
        Canvas.Font.Name := 'Symbol';
        ScreenFrame (Fplotscreen, residueBOX, SCREENBOX);
        ScreenPlot (Fplotscreen, residueBOX, SCREENBOX, residueVec);
        Canvas.Pen.Color := clRed;
        Canvas.Pen.Width :=  2;
        ScreenPlot (Fplotscreen, residueBOX, SCREENBOX, cycleVec);
        Canvas.Pen.Color := clBlack;
        Canvas.Pen.Width :=  1;
        Canvas.Font.Name := 'Courier New';
        Canvas.Font.Size := 12;
        ScreenCaption (Fplotscreen, SCREENBOX, legend);
      end; {cycleGraph}

    {-----------------------------------------------------------}

    if graphType = seasonsGraph  then
      begin
         Canvas.Font.Name := 'Symbol';
        ScreenFrame (Fplotscreen, dataBOX, SCREENBOX);
        ScreenPlot (Fplotscreen, dataBOX, SCREENBOX, dataVector);
        Canvas.Pen.Color := clRed;
        Canvas.Pen.Width :=  2;
        ScreenPlot (Fplotscreen, dataBOX, SCREENBOX, adjustedVec);
        Canvas.Pen.Color := clBlack;
        Canvas.Pen.Width :=  1;
        Canvas.Font.Name := 'Courier New';
        Canvas.Font.Size := 12;
        ScreenCaption (Fplotscreen, SCREENBOX, legend);
      end;  {seasonsGraph}

    {-----------------------------------------------------------}

  end;   {FormPaint}

{______________________________________________________________________________}

procedure TFplotscreen.BtnRETURNClick(Sender: TObject);

  var STR, postFileName: string;
      F: text;

  begin

    if PSPict then
      begin
        if TeXFormat then
          STR := 'You have chosen a Textures format. Do you wish to save the PostScript code of the graphic?'
        else
          STR := 'You have chosen an EPS format. Do you wish to save the PostScript code of the graphic?';
       if MessageDlg(STR, mtConfirmation, [mbYes, mbNo], 0) =  mrYes   then
         begin    {mrYes}
          SaveDialog.Execute;
          postFileName := SaveDialog.FileName;
          AssignFile(F, postFileName);
          ReWrite(F);

          case graphType of
          dataGraph:
            begin
              PostDataPlot(F, plotBOX, plotVector, POSTBOX, legend);
            end;

          periodoGraph:
            begin
              PostSpectraPlot(F, spectraBOX, spectraVec, POSTBOX, legend);
            end;

          spectraGraph:
            begin
              PostSpectraPlot(F, plotBOX, plotVector, POSTBOX, legend);
            end;

          dataOverPlotGraph:
          begin
            PostOverPlot(F, dataBox, dataVector, trendVector, POSTBOX, legend)
          end;

          backgroundPlot:
             begin
       {ShowMessage('We are attempting a background plot of the periodogram and the response');}
             PostHeader(F, POSTBOX, TeXFormat);
             PostFrameLite (F, spectraBOX, POSTBOX );

             if filterSpec.seasonality = Quarterly then
               PostZeroPiAxis (F, POSTBOX);
             if filterSpec.seasonality = Monthly then
               PostDoDecAxis (F, POSTBOX);

             if (filterSpec.filterfamily = LowSigmoid) and (not doSeasonalAdjustment) then
               begin
                 Tvert := Round(filterSpec.Mb);
                 Tvert2 := Round(filterSpec.Mc);
                 PostDashedLine(F, TVert, POSTBOX);
                 PostDashedLine(F, TVert2, POSTBOX);
               end;

             {InvisibleFrame (Fplotscreen, plotBOX, SCREENBOX);}  {Establish the parameters for plotting the periodogram}
             PostPlot (F, plotBOX, POSTBOX, plotVector);   {Plot the peridogram}
             PostPlotMod (F, spectraBOX, POSTBOX, spectraVec); {Plot the frequency Response}
             PostFooter(F, POSTBOX, legend, TexFormat);
             end;

            cycleGraph:
              begin
                PostOverPlot(F, residueBOX, residueVec, cycleVec, POSTBOX, legend)
              end;

            seasonsGraph:
              begin;
                 PostOverPlot(F, dataBox, dataVector, adjustedVec, POSTBOX, legend)
              end;


        end; {cases}

        CloseFile(F);
         end;  {mrYes}
      end; {PSPict}

  Close;
end;   {BtnRETURNClick}
{______________________________________________________________________________}


end.  {Uplotscreen: unit of SEASCAPE.PAS}

