unit Uplotdata;  {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TFplotdata }

  TFplotdata = class(TForm)
    BtnCLOSE: TButton;
    LblpageTitle: TLabel;
    LstSeriesPlot: TListBox;
    StaticText: TStaticText;
    procedure BtnCLOSEClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure LstSeriesPlotClick(Sender: TObject);
  private

  public

  end;

var
  Fplotdata: TFplotdata;
  dataItem, trendItem, cycleItem, residualsItem, seasonalItem, adjustedItem, adjustedResidualsItem: integer;

implementation

  uses
    LCLType, UplotScreen, GLOBALS, UTILS, DATASEG, LEGENDS;

{$R *.lfm}

{ TFplotdata }

{______________________________________________________________________________}

procedure TFplotdata.BtnCLOSEClick(Sender: TObject);
begin
  Close;
end;   {BtnCLOSEClick}
{______________________________________________________________________________}

procedure TFplotdata.FormActivate(Sender: TObject);

begin

  LstSeriesPlot.Items.Clear;
  dataItem := 99;
  cycleItem := 99;
  trendItem  := 99;
  residualsItem := 99;
  seasonalItem := 99;
  adjustedItem := 99;
  adjustedResidualsItem := 99;


  if thereIsData then
    begin
      LstSeriesPlot.Items.Add('d. Plot the data');
      LstSeriesPlot.Items.Add('');
      LstSeriesPlot.ItemIndex := 0;
      dataItem := LstSeriesPlot.ItemIndex;
    end;

   if weHavePolyResiduals then
    begin
      LstSeriesPlot.Items.Add('r. Plot the Polynomial Residuals');
      LstSeriesPlot.Items.Add('');
      LstSeriesPlot.ItemIndex := LstSeriesPlot.ItemIndex +2;
      residualsItem := LstSeriesPlot.ItemIndex;
    end
   else if weHaveATrendCycle then
    begin
      LstSeriesPlot.Items.Add('r. Plot the Trend-cycle Residuals');
      LstSeriesPlot.Items.Add('');
      LstSeriesPlot.ItemIndex := LstSeriesPlot.ItemIndex +2;
      residualsItem := LstSeriesPlot.ItemIndex;
    end;

   if weHaveACycle then
     begin
       LstSeriesPlot.Items.Add('c. Plot the Cycle');
       LstSeriesPlot.Items.Add('');
       LstSeriesPlot.ItemIndex := LstSeriesPlot.ItemIndex +2;
       cycleItem := LstSeriesPlot.ItemIndex;
    end;

   if weHaveATrendCycle then
     begin
       LstSeriesPlot.Items.Add('t. Plot the Trend Cycle');
       LstSeriesPlot.Items.Add('');
       LstSeriesPlot.ItemIndex := LstSeriesPlot.ItemIndex +2;
       trendItem := LstSeriesPlot.ItemIndex;
    end;

   if (weHaveSeasonalComponent = true) then
     begin
       LstSeriesPlot.Items.Add('s. Plot the Seasonal Component');
       LstSeriesPlot.Items.Add('');
       LstSeriesPlot.ItemIndex := LstSeriesPlot.ItemIndex +2;
       seasonalItem := LstSeriesPlot.ItemIndex;
     end;

   if (weHaveSeasonallyAdjustedData = true) then
     begin
       LstSeriesPlot.Items.Add('a. Plot the Seasonally Adjusted Data');
       LstSeriesPlot.Items.Add('');
       LstSeriesPlot.ItemIndex := LstSeriesPlot.ItemIndex +2;
       adjustedItem := LstSeriesPlot.ItemIndex;
     end;

   if weHaveSeasonallyAdjustedData and  weHaveATrendCycle then
     begin
       weHaveAdjustedTrendResiduals := true;
       LstSeriesPlot.Items.Add('e. Plot the Adjusted Trend Residuals');
       LstSeriesPlot.Items.Add('');
       LstSeriesPlot.ItemIndex := LstSeriesPlot.ItemIndex +2;
       adjustedResidualsItem := LstSeriesPlot.ItemIndex;
     end;

end;  {FormActivate}

{______________________________________________________________________________}

procedure TFplotdata.LstSeriesPlotClick(Sender: TObject);

var index: integer;

begin

  LstSeriesPlot := TListBox(Sender);
  index := LstSeriesPlot.ItemIndex;

  if (index = dataItem) then
    begin
      legend := DataLegend(dataBOX, dataName);
      graphType := dataGraph;
      plotBOX := dataBOX;
      plotVector := dataVector;
      Fplotscreen :=TFplotScreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
    end;

   if (index = residualsItem) then
    begin
      if weHavePolyResiduals then
        legend := PolynomialResiduals (polyParas, dataBOX, dataName)
      else if weHaveATrendCycle then
        legend := TrendCycleResidue (dataBOX,dataName);
      graphType := dataGraph;
      residueBox := dataBox;
      MakeDataBox(residueBOX, residueVec);
      plotBOX := residueBOX;
      plotVector := residueVec;
      Fplotscreen :=TFplotScreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
    end;

 if (index = trendItem) then  {trendCycle}
    begin
      legend := TrendAndCycle (dataBOX, dataName);
      graphType := dataGraph;
      plotBOX := dataBOX;
      plotVector := trendVector;
      Fplotscreen :=TFplotScreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
    end;

    if (index = cycleItem) then
    begin
      if (filterspec.filterFamily =  IdealLowpass) then
        legend := IdealLowPassCycle (filterSpec);
      if (filterspec.filterFamily = LowSigmoid) then
        legend := SigmoidLowPassCycle (filterSpec);
      graphType := dataGraph;
      plotBOX := cycleBOX;
      plotVector := cycleVec;
      Fplotscreen :=TFplotScreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
    end;

  if (index = seasonalItem) then
    begin
      legend := SeasonalComponent (dataBOX,dataName);
      graphType := dataGraph;
      plotBOX := seasonBOX;
      plotVector := seasonVec;
      Fplotscreen :=TFplotScreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
    end;

   if (index = adjustedItem) then
    begin
      legend := SeasonallyAdjustedData (dataBOX, dataName);
      graphType := dataGraph;
      plotBOX := dataBOX;
      plotVector := adjustedVec;
      Fplotscreen :=TFplotScreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
    end;

    if (index = adjustedResidualsItem) then
    begin
      legend := AdjustedTrendResiduals;
      graphType := dataGraph;
      plotBOX := dataBOX;
      SubtractComponent (dataBOX, plotBOX, adjustedVec, trendVector, plotVector);
      Fplotscreen :=TFplotScreen.Create(Nil);
      Fplotscreen.ShowModal;
      FreeAndNil(Fplotscreen);
    end;

end;  {LstSeriesPlotClick}


{______________________________________________________________________________}

end.  {Uplotdata: unit of SEASCAPE.PAS}


