unit Upageparams;  {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, GLOBALS;

type

  { TFpageparams }

  TFpageparams = class(TForm)
    BtnRETURN: TButton;
    CheckBxPostScript: TCheckBox;
    edHeight: TEdit;
    edWidth: TEdit;
    GroupBox1: TGroupBox;
    lblHeight: TLabel;
    lblPageParams: TLabel;
    lblWidth: TLabel;
    RadioGroup1: TRadioGroup;
    RadioBtnEPS: TRadioButton;
    RadioBtnTextures: TRadioButton;
    StaticText1: TStaticText;
    procedure BtnRETURNClick(Sender: TObject);
    procedure CheckBxPostScriptChange(Sender: TObject);
    procedure edHeightExit(Sender: TObject);
    procedure edWidthExit(Sender: TObject);
    procedure RadioBtnEPSChange(Sender: TObject);
    procedure RadioBtnTexturesChange(Sender: TObject);
  private

  public

  end;

var
  Fpageparams: TFpageparams;
  validWdt, validHgt: boolean;

implementation
 uses
   UTILS;

{$R *.lfm}

{ TFpageparams }
{______________________________________________________________________________}

procedure TFpageparams.BtnRETURNClick(Sender: TObject);

begin

  if (not validWdt) and (not validHgt) then
    ShowMessage('You must enter valid numbers for the width and the height!')
  else if (not validWdt) then
    ShowMessage('You must enter a valid number for the width!')
  else if (not validHgt) then
    ShowMessage('You must enter a valid numbers for the height!')
  else
    begin
      PageParameters (SCREENBOX, POSTBOX, boxWidth, boxHeight);  {in utils}
      noPageParameters := false;
      Close;
    end;
end;    {BtnRETURNClick}

{______________________________________________________________________________}

procedure TFpageparams.CheckBxPostScriptChange(Sender: TObject);
begin
  if  CheckBxPostScript.Checked then
   begin
   PSPict :=true;
   RadioBtnEPS.Enabled := true;
   RadioBtnTextures.Enabled := true;
   end
  else
    begin
    PSPict := false;
    RadioBtnEPS.Enabled := false;
    RadioBtnTextures.Enabled := false;
    end;

end;    {cbPostScriptChange}

{______________________________________________________________________________}

procedure TFpageparams.edHeightExit(Sender: TObject);

   var
    numeric : boolean;    {BOXheight, determined here, is GLOBAL}

begin
  validHgt := true;
  numeric := DecimalString(edHeight.text);
  if numeric = false then
    begin
      edHeight.Font.Color := clRed;
      validHgt := false;
    end
  else
    begin
      edHeight.Font.Color :=  clBlack;
      boxHeight := StrToFloat(edHeight.text);
      if boxHeight > 12.0 then
        boxHeight :=12.0;
      if boxHeight < 3.75 then
        boxHeight :=3.75;
    end;

end;   {edHeightExit}

 {______________________________________________________________________________}

procedure TFpageparams.edWidthExit(Sender: TObject);

  var
   numeric : boolean;  {BOXwidth, determined here, is GLOBAL}

begin
  validWdt := true;
  numeric := DecimalString(edWidth.text);
  if numeric = false then
    begin
      edWidth.Font.Color := clRed;
      validWdt := false;
    end
  else
    begin
      edWidth.Font.Color :=  clBlack;
      boxWidth := StrToFloat(edWidth.text);
      if boxWidth > 18.0 then
        boxWidth :=18.0;
      if boxWidth < 6 then
        boxWidth := 6;
      end;

end;   {edWidthExit}
{______________________________________________________________________________}

procedure TFpageparams.RadioBtnEPSChange(Sender: TObject);
begin
   TeXFormat := false;
   {implies EPS format is true}
end;   {RadioBtnEPSChange}
{______________________________________________________________________________}

procedure TFpageparams.RadioBtnTexturesChange(Sender: TObject);
begin
   TeXFormat := true;
   {implies EPS format is false}
end;  {RadioBtnTexturesChange}

{______________________________________________________________________________}

end.  {Upageparameters: Unit of SEASCAPE.PAS}

