unit Umainpage;  {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  GLOBALS;

type

  { TFmainpage }

  TFmainpage = class(TForm)
    BtnRETURN: TButton;
    Label1: TLabel;
    ListMain: TListBox;
    StaticText: TStaticText;
    procedure BtnRETURNClick(Sender: TObject);
    procedure ListMainClick(Sender: TObject);
  private

  public

  end;

var
  Fmainpage: TFmainpage;

implementation

 uses
   Upageparams, Ugetdata, Udetrend, Uplotdata, Uperiodgram, Ufreqfiltspec, UtimeseaFilt, Usaveandexit;

{$R *.lfm}

{ TFmainpage }
{________________________________________________________}

procedure DataAlert(var dataBOX: rBOX;
                    var YesOrNo: integer);

 var STR, STR1, STR2, STR3,STR4: string;
   extraMonths, extraQuarters: integer;

begin

  extraMonths := 0;
  extraQuarters :=0;
  YesOrNo := mrYes;

 if (dataBOX.dataFrequency = Monthly) then
   begin {Monthly}
     extraMonths := dataBOX.NOPUNCT mod 12;
     STR1 := ' The number of monthly observations is ' + IntToStr(dataBOX.NOPUNCT);
     STR2 := ', which is not divisible by 12. It is advised that, before seasonally';
     if  extraMonths = 1 then
       STR3 := ' adjusting the data, you should discard one point.'
     else
       STR3 := ' adjusting the data, you should discard ' + IntToStr(extraMonths) + ' points.';
     STR4 := ' Do you wish to proceed?';
   end; {Monthly}

  if (dataBOX.dataFrequency = Quarterly) then
    begin {Quarterly}
      extraQuarters := dataBOX.NOPUNCT mod 4;
      STR1 := ' The number of quarterly observations is ' + IntToStr(dataBOX.NOPUNCT);
      STR2 := ', which is not divisible by 4. It is advised that, before seasonally';
      if  extraQuarters = 1 then
         STR3 := ' adjusting the data, you should discard one point.'
      else
        STR3 := ' adjusting the data, you should discard ' + IntToStr(extraQuarters) + ' points.';
      STR4 := ' Do you wish to proceed?';
    end; {Quarterly}

    if (extraMonths <> 0) or (extraQuarters <> 0) then
      begin
        STR := STR1 + STR2 + STR3 + Chr(13) + STR4;
        YesOrNo := MessageDlg(STR, mtWarning, [mbYes, mbNo], 0);
      end;

end; {DataAlert}

{________________________________________________________}

procedure TFmainpage.BtnRETURNClick(Sender: TObject);
begin
  Close;
end; {BtnRETURNClick}

{________________________________________________________}

procedure TFmainpage.ListMainClick(Sender: TObject);

  var
    index,YesOrNo: integer;

begin
  index := ListMain.itemIndex;

 {----------------------------------}

  if index = 0 then
    begin
      Fpageparams := TFpageparams.Create(nil);
      Fpageparams.ShowModal;
      FreeAndNil(Fpageparams);
    end;  {PageParameters}

{----------------------------------}

  if index = 2 then
    begin
      Fgetdata := TFgetdata.Create(nil);
      Fgetdata.ShowModal;
      FreeAndNil(Fgetdata);
    end;  {GetData}

{----------------------------------}

  if index = 4 then
    begin
      if noPageParameters then
        ShowMessage('There are no page parameters')
      else if (thereIsData = false) then
        ShowMessage('No data have yet been read')
      else
        begin
          Fdetrend := TFdetrend.Create(nil);
          Fdetrend.ShowModal;
          FreeAndNil(Fdetrend);
        end;
    end;  {Detrend}

  {----------------------------------}

  if index = 6 then
    begin
      if noPageParameters then
        ShowMessage('There are no page parameters')
      else if (thereIsData = false) then
        ShowMessage('No data have yet been read')
      else
        begin
          Fplotdata := TFplotdata.Create(nil);
          Fplotdata.ShowModal;
          FreeAndNil(Fplotdata);
        end;
    end;  {PlotData}

  {----------------------------------}

  if index = 8 then
    begin
      if noPageParameters then
        ShowMessage('There are no page parameters')
      else if (thereIsData = false) then
        ShowMessage('No data have yet been read')
      else
        begin
          filterSpec.seasonality := dataBOX.dataFrequency;
          {SlowFourier (dataBOX, dataVector, alpha, beta);}
          {MakeThePeriodogram (dataBOX, spectraBOX, spectraVec, alpha, beta);}
          Fperiodgram := TFperiodgram.Create(nil);
          Fperiodgram.ShowModal;
          FreeAndNil(Fperiodgram);
      end;
    end;   {Periodogram}

  {----------------------------------}

  if index = 10 then
    begin
      if noPageParameters then
        ShowMessage('There are no page parameters')
      else if (thereIsData = false) then
        ShowMessage('No data have yet been read')
      else if dataBOX.dataFrequency in [Annual, Other] then
        ShowMessage('The data frequency must be Monthly of Quarterly')
      else if (not weHavePolyResiduals) and (not weHaveATrendCycle)  then
          ShowMessage('The data have yet to be detrended')
      else
        begin
          DataAlert(dataBOX, yesOrNo);
          if yesOrNo = mrYes then
            begin {Yes}
              Ftimeseafilt := TFtimeseafilt.Create(nil);
              Ftimeseafilt.ShowModal;
              FreeAndNil(Ftimeseafilt);
            end; {Yes}
        end;
    end;   {Do Time-Domain Seasonal Adjustment}

  {----------------------------------}

  if index = 12 then
    begin
      if noPageParameters then
        ShowMessage('There are no page parameters')
      else if (thereIsData = false) then
        ShowMessage('No data have yet been read')
      else if dataBOX.dataFrequency in [Annual, Other] then
        ShowMessage('The data frequency must be Monthly of Quarterly')
      else if (not weHavePolyResiduals) and (not weHaveATrendCycle)  then
        ShowMessage('The data have yet to be detrended')
      else
        begin
          DataAlert(dataBOX, yesOrNo);
          if yesOrNo = mrYes then
            begin {Yes}
              DoSeasonalAdjustment := true;
              Ffreqfiltspec := TFfreqfiltspec.Create(nil);
              Ffreqfiltspec.ShowModal;
              FreeAndNil(Ffreqfiltspec);
            end; {Yes}
        end;
    end;    {Do Frequency-Domain Seasonal Adjustment}

  {----------------------------------}

  if index = 14 then
    begin
      Fsaveandexit := TFsaveandexit.Create(nil);
      Fsaveandexit.ShowModal;
      FreeAndNil(Fsaveandexit);
    end;  {SaveAndExit}

  {----------------------------------}

end; {ListMainClick}
{________________________________________________________}

end.  {Umainpage: Unit of SEASCAPE.PAS}

