unit Ulowfreqfilts; {unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  GLOBALS, UTILS, Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,TAPER, DATASEG;

type

  { TFlowfreqfilts }

  TFlowfreqfilts = class(TForm)
    BtnRETURN: TButton;
    EdtPower: TEdit;
    EdtCutOff: TEdit;
    EdtLowerBnd: TEdit;
    EdtUpperBnd: TEdit;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    TitleLabel: TLabel;
    LblCutOff: TLabel;
    LblLowBound: TLabel;
    LblUpBound: TLabel;
    ListBox: TListBox;
    RadioBtnIdealS: TRadioButton;
    RadioBtnSigmoid: TRadioButton;
    StaticText: TStaticText;
    procedure BtnRETURNClick(Sender: TObject);
    procedure EdtCutOffChange(Sender: TObject);
    procedure EdtCutOffKeyPress(Sender: TObject; var Key: char);
    procedure EdtLowerBndChange(Sender: TObject);
    procedure EdtLowerBndKeyPress(Sender: TObject; var Key: char);
    procedure EdtPowerChange(Sender: TObject);
    procedure EdtPowerKeyPress(Sender: TObject; var Key: char);
    procedure EdtUpperBndChange(Sender: TObject);
    procedure EdtUpperBndKeyPress(Sender: TObject; var Key: char);
    procedure FormActivate(Sender: TObject);
    procedure LblCutOffClick(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
    procedure RadioBtnIdealSChange(Sender: TObject);
    procedure RadioBtnSigmoidChange(Sender: TObject);
  private

  public

  end;

  function InRange (var x: real): boolean;

procedure CheckIdealFilter(var EdtCutOff: TEdit;
                      var filterSpec: filterRecord;
                      var proceed: boolean);

procedure CheckTheSigmoidFilter(var EdtLowerBnd, EdtUpperBnd: TEdit;
                      var filterSpec: filterRecord;
                      var proceed: boolean);

procedure  CheckThePowerParameter(var EdtPower: TEdit;
                      var filterSpec: filterRecord;
                      var proceed: boolean);

procedure BackgroundPeriodigram(var dataBOX, plotBOX: rBOX;
                      var SCREENBOX, POSTBOX: IBOX;
                      var dataVector : longVector;
                      var plotVector: longVector;
                      var alpha, beta: FourierVec);

procedure PrepareForIdealFilter (var filterSpec: FilterRecord;
                      var fourierInc: real;
                      var lowerCutInt, upperCutInt: integer);

procedure DiscardExtrapolations(var residueBOX, cycleBOX: rBOX);

var
  Flowfreqfilts: TFlowfreqfilts;
  proceed: boolean;
  alpha, beta: FourierVec;
  fourierInc: real;
  lowerCutInt, upperCutInt: integer;

implementation
  uses
    FREQFILT, LEGENDS, UplotScreen;

{$R *.lfm}

{ TFlowfreqfilts }
{______________________________________________________________________________}

procedure TFlowfreqfilts.FormActivate(Sender: TObject);
begin
   EdtLowerBnd.Enabled := false;
   EdtCutOff.Enabled := false;
   EdtUpperBnd.Enabled := false;
   EdtPower.Enabled := false;

   EdtCutOff.text := '';
   EdtLowerBnd.text := '';
   EdtUpperBnd.text := '';
   EdtPower.text := '';

   BackgroundPeriodigram(residueBOX, plotBOX, SCREENBOX, POSTBOX, residueVec, plotVector, alpha, beta);

end;  {FormActivate}

{______________________________________________________________________________}

procedure TFlowfreqfilts.LblCutOffClick(Sender: TObject);
  var
    proceed: boolean;
begin
  CheckTheSigmoidFilter(EdtLowerBnd, EdtUpperBnd, filterSpec, proceed);
  if proceed then
    begin
      EdtCutOff.Enabled := true;
      EdtCutOff.text :=  FloatToStr(filterSpec.CutOff);
    end;

end;   {LblCutOffClick}

{______________________________________________________________________________}

procedure TFlowfreqfilts.RadioBtnIdealSChange(Sender: TObject);
begin
  filterSpec.filterFamily := IdealLowpass;
  EdtLowerBnd.Enabled := false;
  EdtCutOff.Enabled := true;
  EdtUpperBnd.Enabled := false;
  EdtPower.Enabled := false;
  LblCutoff.Caption  := 'Cut off';

  EdtPower.text := '' ;
  EdtLowerBnd.text := '';
  EdtUpperBnd.text := '';

end;  {RadioBtnIdealSChange}
{______________________________________________________________________________}

procedure TFlowfreqfilts.RadioBtnSigmoidChange(Sender: TObject);
begin
   filterSpec.filterFamily := lowSigmoid;
   EdtLowerBnd.Enabled := true;
   EdtCutOff.Enabled := false;
   EdtUpperBnd.Enabled := true;
   EdtPower.Enabled := true;
   LblCutoff.Caption  := 'Mid point';
   EdtPower.text := '3' ;
   filterSpec.nPower := 3;
   EdtCutOff.text := '';

end;   {RadioBtnSigmoidChange}
{______________________________________________________________________________}

procedure TFlowfreqfilts.EdtCutOffKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', '.',#8])then
  begin
    ShowMessage('Enter a real value in (0, 180)');
    key := #0;
  end;

end;   {EdtCutOffKeyPress}

{______________________________________________________________________________}

procedure TFlowfreqfilts.EdtLowerBndKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', '.',#8])then
  begin
    ShowMessage('Enter a real value in (0, 180)');
    key := #0;
  end;
  EdtCutOff.Enabled := false;
  EdtCutOff.text := ''

end;  {EdtLowerBndKeyPress}

{______________________________________________________________________________}

procedure TFlowfreqfilts.EdtPowerKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9',#8])then
  begin
    ShowMessage('Enter an integer value in [1, 6]');
    key := #0;
  end;

end;  {EdtPowerKeyPress}

{______________________________________________________________________________}

procedure TFlowfreqfilts.EdtUpperBndKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', '.',#8])then
  begin
    ShowMessage('Enter a real value in (0, 180)');
    key := #0;
  end;
  EdtCutOff.Enabled := false;
  EdtCutOff.text := ''

end; {EdtUpperBndKeyPress}

{______________________________________________________________________________}

procedure TFlowfreqfilts.EdtCutOffChange(Sender: TObject);
begin
  if not (EdtCutOff.text = '') then
    filterSpec.cutOff := StrToFloat(EdtCutOff.text);

end;   {EdtCutOffChange}
{______________________________________________________________________________}

procedure TFlowfreqfilts.EdtLowerBndChange(Sender: TObject);
begin
  if not (EdtLowerBnd.text = '') then
    filterSpec.Mb := StrToFloat(EdtLowerBnd.text);

end;  {EdtLowerBndChange}

{______________________________________________________________________________}

procedure TFlowfreqfilts.EdtUpperBndChange(Sender: TObject);
begin
  if not (EdtUpperBnd.text = '') then
    filterSpec.Mc := StrToFloat(EdtUpperBnd.text);

end;   {EdtUpperBndChange}

{______________________________________________________________________________}

procedure TFlowfreqfilts.EdtPowerChange(Sender: TObject);
begin
   if not (EdtPower.text = '') then
    filterSpec.nPower := StrToInt(EdtPower.text);

end;  {EdtPowerChange}

{______________________________________________________________________________}

function InRange (var x: real): boolean;
  begin
    InRange := false;
    if (x >= 0.0) and (x <= 180) then
      InRange := true;
  end; {InRange}
{______________________________________________________________________________}

 procedure CheckIdealFilter(var EdtCutOff: TEdit;
                      var filterSpec: filterRecord;
                      var proceed: boolean);
 begin
   proceed := false;

   if EdtCutOff.text = '' then
     ShowMessage('You have yet to specify the cut-off frequency')
   else
     if not InRange(filterSpec.cutOff) then
       ShowMessage('The cut-off point must lie in the interval (0, 180]')
   else
     proceed := true;
 end;  {CheckIdealFilter}

{______________________________________________________________________________}

 procedure CheckTheSigmoidFilter(var EdtLowerBnd, EdtUpperBnd: TEdit;
                      var filterSpec: filterRecord;
                      var proceed: boolean);
 begin
   proceed := false;

   If EdtLowerBnd.text = '' then
     ShowMessage('You have yet to specify the lower bound of the transition band')
   else
   if EdtUpperBnd.text = '' then
     ShowMessage('You have yet to specify the lower bound of the transition band')
   else
    if not InRange(filterSpec.Mb) then
     ShowMessage('The lower bound must lie in the interval (0, 180]')
   else
    if not InRange(filterSpec.Mc) then
     ShowMessage('The lower bound must lie in the interval (0, 180]')
    else
     if not (filterSpec.Mb <= filterSpec.Mc) then
     ShowMessage('The lower bound must lie below the upperbound')
    else
    begin
      proceed := true;
      filterSpec.cutOff := (filterSpec.Mb + filterSpec.Mc)/2.0;
    end;

   end;  {CheckTheSigmoidFilter}

{______________________________________________________________________________}

procedure CheckThePowerParameter(var EdtPower: TEdit;
                    var filterSpec: filterRecord;
                    var proceed: boolean);

begin
  proceed := true;

  if EdtPower.text = '' then
    begin
      ShowMessage('The power parameter has not been specified');
      proceed := false;
    end
  else
    filterSpec.nPower := StrToInt(EdtPower.text);

  if  (filterSpec.nPower < 1)  or (filterSpec.nPower > 6) then
    begin
      ShowMessage('The power parameter must be an integer in the inte;rval [1, 6]');
      proceed := false;
     end;

 end; {CheckThePowerParameter}

{______________________________________________________________________________}

procedure BackgroundPeriodigram(var dataBOX, plotBOX: rBOX;
                      var SCREENBOX, POSTBOX: IBOX;
                      var dataVector : longVector;
                      var plotVector: longVector;
                       var alpha, beta: FourierVec);

{Should  SlowFourior be include in Make the Perodoggam?}
{no decause we need alpha and beta elsewhere}

begin
  SlowFourier (dataBOX, dataVector, alpha, beta);
  MakeThePeriodogram (dataBOX, plotBOX, plotVector, alpha, beta);
  {plotBOX willl contain sufficient information for plotting via backgroundPlot}

end;  {backgroundPeriodigram}

{______________________________________________________________________________}

 procedure PrepareForIdealFilter (var filterSpec: FilterRecord;
                              var fourierInc: real;
                              var lowerCutInt, upperCutInt: integer);
 var
   pi: real;

  begin
    pi := 4 * ArcTan(1.0);

    fourierInc := 2 * pi / (residueBOX.NOPUNCT); {This a local variable}
    lowerCutInt := 0;
    upperCutInt := Round((residueBOX.NOPUNCT * filterSpec.cutoff)/360);

  end; {PrepareForIdealFilter }

{______________________________________________________________________________}

procedure DiscardExtrapolations(var residueBOX, cycleBOX: rBOX);

  begin
{SHOWMESSAGE('Entering discards: residueBOX.NOPUNCT = ' + IntToStr(residueBOX.NOPUNCT)  + ' residueBOX.EXTRA = ' + IntToStr(residueBOX.EXTRA));}

    residueBOX.NOPUNCT := residueBOX.NOPUNCT - residueBOX.EXTRA;
    cycleBOX.NOPUNCT := cycleBOX.NOPUNCT - cycleBOX.EXTRA;
    MakeDataBox (residueBOX, residueVec);
    dataBOX.xMax := residueBOX.xMax;
    dataBOX.xMax :=  residueBOX.xMax;
    residueBOX.EXTRA := 0;
    cycleBOX.EXTRA := 0;
    dataExtrapolated := false;

{SHOWMESSAGE('Leaving discards: residueBOX.NOPUNCT = ' + IntToStr(residueBOX.NOPUNCT)  + ' residueBOX.EXTRA = ' + IntToStr(residueBOX.EXTRA));}

  end; {DiscardExtrapolations}
{______________________________________________________________________________}

 procedure TFlowfreqfilts.ListBoxClick(Sender: TObject);

 var
   index: integer;
   proceed: boolean;

 begin
   proceed := false;

   if filterSpec.filterFamily = IdealLowpass then
     begin
       CheckIdealFilter(EdtCutOff, filterSpec, proceed);
       IdealFilterSpec (filterSpec, spectraBOX, spectraVec, SCREENBOX, POSTBOX);
     end;

   if filterSpec.filterFamily = LowSigmoid then
     begin
       CheckTheSigmoidFilter(EdtLowerBnd, EdtUpperBnd, filterSpec, proceed);
       CheckThePowerParameter(EdtPower, filterSpec, proceed);
       LowpassSigmoidSpec (filterSpec, spectraBOX, spectraVec, SCREENBOX, POSTBOX);
     end;

   index := ListBox.ItemIndex;

   {--------------------------------------------------}
   if (index = 1)  and proceed then
     begin

       if filterSpec.filterFamily = lowSigmoid then
         legend := LowpassSigmoidGain(filterSpec);
       if filterSpec.filterFamily = IdealLowpass then
         legend := IdealLowpassGain(filterSpec);

         {for the periodogram we use plotBOX and plotVector}
        {for the frequency response functions, we use spectraBOX and spectraVec}

        graphType :=  backgroundPlot;
        Fplotscreen := TFplotscreen.Create(Nil);
        Fplotscreen.ShowModal;
        FreeAndNil(Fplotscreen);

     end; {Frequency Response}
   {--------------------------------------------------}
   if (index = 3)  and proceed then
     begin

     if weHaveACycle then
       ShowMessage('You have already extracted the cycle')
     else if filterSpec.filterFamily = LowSigmoid then
       begin
         ScaleLowpassOrdinates (filterSpec, residueBOX, alpha, beta);  {is residueBOX appropriate?}
         cycleBOX := residueBOX;
         FourierSynthesis (cycleBOX, cycleVec, alpha, beta);   {dataBOX --> residueBOX ?}
         legend := SigmoidLowPassCycle (filterSpec);
         {weHaveACycle := true;}
       end
     else if filterSpec.filterFamily = IdealLowpass then
       begin
         PrepareForIdealFilter (filterSpec, fourierInc, lowerCutInt, upperCutInt);
         BandPassCoefficients (residueBOX, residueVec, fourierInc, lowerCutInt, upperCutInt, alpha, beta);
         cycleBOX := residueBOX;
         BandPassSynthesis (cycleBOX, cycleVec, fourierInc, lowerCutInt, upperCutInt, alpha, beta);
         legend := IdealLowPassCycle (filterSpec);
         {weHaveACycle := true;}
       end;

      if dataExtrapolated then
      begin
{SHOWMESSAGE('1. Before discards: residueBOX.NOPUNCT = ' + IntToStr(residueBOX.NOPUNCT)  + ' residueBOX.EXTRA = ' + IntToStr( residueBOX.EXTRA));}

       DiscardExtrapolations(residueBOX, cycleBOX);  {in this UNIT}

{SHOWMESSAGE('2. After discards: residueBOX.NOPUNCT = ' + IntToStr(residueBOX.NOPUNCT)  + ' residueBOX.EXTRA = ' + IntToStr(residueBOX.EXTRA));}
{SHOWMESSAGE(' dataBOX.EXTRA = ' + IntToStr(dataBOX.EXTRA)  + ' trendBOX.EXTRA = ' + IntToStr( trendBOX.EXTRA)  + ' residueBOX.EXTRA = ' + IntToStr( residueBOX.EXTRA));}
      end;

     if (weHaveACycle = false) then
       begin
         graphType :=  cycleGraph;
{SHOWMESSAGE('3. cycleGraph: residueBOX.NOPUNCT = ' + IntToStr(residueBOX.NOPUNCT));}
         Fplotscreen := TFplotscreen.Create(Nil);
         Fplotscreen.ShowModal;
         FreeAndNil(Fplotscreen);
           {Closure within UplotScreen on clicking [RETURN]}

{SHOWMESSAGE('4. After Discard residueBOX.NOPUNCT = ' + IntToStr(residueBOX.NOPUNCT)+ ' residueBOX.EXTRA = ' + IntToStr(residueBOX.EXTRA));}

           cycleBOX.NOPUNCT := dataBOX.NOPUNCT;
           residueBOX.NOPUNCT := dataBOX.NOPUNCT;
           trendBOX.NOPUNCT := dataBOX.NOPUNCT;

         TrendCycleComponent(polyParas, trendBOX, cycleBOX, residueBOX, trendVector, cycleVec, residueVec);  {in DATASEGS}
     {in DATASEG, where we should revise the residuals residue : dataVec - trendVec}

{SHOWMESSAGE('5. dataBOX.NOPUNCT = ' + IntToStr(dataBOX.NOPUNCT)  + ' trendBOX.NOPUNCT = ' + IntToStr( trendBOX.NOPUNCT));}
{SHOWMESSAGE('6. cycleBOX.NOPUNCT = ' + IntToStr(cycleBOX.NOPUNCT)  + ' residue.NOPUNCT = ' + IntToStr( residueBOX.NOPUNCT));}

         legend := TrendAndCycle (dataBOX, dataName);
         graphType :=  dataOverPlotGraph;
         Fplotscreen := TFplotscreen.Create(Nil);
         Fplotscreen.ShowModal;
         FreeAndNil(Fplotscreen);
     {Closure within UplotScreen on clicking [RETURN]}
         weHaveACycle := true;
         weHaveATrendCycle := true;
       end;

     end;  {Apply the Filter}
   {--------------------------------------------------}

 end; {ListBoxClick}
 {______________________________________________________________________________}

procedure TFlowfreqfilts.BtnRETURNClick(Sender: TObject);

begin
  Close;
end;
{______________________________________________________________________________}

end.  {Ulowfreqfilts: unit of SEASCAPE.PAS}

