unit Ufreqfiltspec;   {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  GLOBALS;

type

  { TFfreqfiltspec }

  TFfreqfiltspec = class(TForm)
    BtnCLOSE: TButton;
    BtnPROCEED: TButton;
    EditPower: TEdit;
    EditTrunc: TEdit;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    LblPower: TLabel;
    LblTrunc: TLabel;
    BtnMonthly: TRadioButton;
    BtnQuarterly: TRadioButton;
    StaticText2: TStaticText;
    StaticText3: TStaticText;
    TitleLabel: TLabel;
    BtnNoTrans: TRadioButton;
    BtnSigmoid: TRadioButton;
    BtnUpperCos: TRadioButton;
    BtnLowerCos: TRadioButton;
    StaticText1: TStaticText;
    procedure BtnCLOSEClick(Sender: TObject);
    procedure BtnLowerCosChange(Sender: TObject);
    procedure BtnMonthlyChange(Sender: TObject);
    procedure BtnNoTransChange(Sender: TObject);
    procedure BtnPROCEEDClick(Sender: TObject);
    procedure BtnQuarterlyChange(Sender: TObject);
    procedure BtnSigmoidChange(Sender: TObject);
    procedure BtnUpperCosChange(Sender: TObject);
    procedure EditPowerKeyPress(Sender: TObject; var Key: char);
    procedure EditTruncKeyPress(Sender: TObject; var Key: char);
    procedure FormActivate(Sender: TObject);
  private

  public

  end;

procedure CheckFrequencyParameters(var EditTrunc, EditPower: TEdit;
                        var filterSpec: filterRecord;
                        var proceed: boolean);
var
  Ffreqfiltspec: TFfreqfiltspec;
  {alpha, beta: FourierVec;}
  proceed: boolean;

implementation
  uses
    Ustopbands, Uquadstop;

{$R *.lfm}

{ TFfreqfiltspec }

{______________________________________________________________________________}

procedure TFfreqfiltspec.FormActivate(Sender: TObject);
begin
  proceed := true;
  if dataBOX.dataFrequency  = Quarterly then
    begin
      BtnQuarterly.Checked := true;
    end;

   if dataBOX.dataFrequency  = Monthly then
     begin
       BtnMonthly.Checked := true;
     end;

   if doSeasonalAdjustment then
     begin
       if filterSpec.profile = noTransition then
         BtnNoTrans.Checked := true;
       if filterSpec.profile = Sigmoid  then
         BtnSigmoid.Checked := true;
       if filterSpec.profile = upperHalfCosine then
         BtnUpperCos.Checked := true;
       if filterSpec.profile = lowerHalfCosine then
         BtnLowerCos .Checked := true;
     end;

end;  {FormActivate}

{______________________________________________________________________________}

procedure TFfreqfiltspec.BtnCLOSEClick(Sender: TObject);
begin
  Close;
end;   {BtnCLOSEClick}

{______________________________________________________________________________}

procedure TFfreqfiltspec.BtnNoTransChange(Sender: TObject);
begin
  filterSpec.profile := noTransition;
    if  filterSpec.profile <> filterSpec.oldProfile  then
    seasChange := true;
  filterSpec.Oldprofile := filterSpec.profile;
  EditTrunc.Enabled := false;
  EditPower.Enabled := false;
  EditTrunc.text := '';
  EditPower.text := '';

end; {BtnNoTransChange}

{--------------------------------}

procedure TFfreqfiltspec.BtnSigmoidChange(Sender: TObject);
begin
  filterSpec.profile := Sigmoid;
    if  filterSpec.profile <> filterSpec.Oldprofile  then
    seasChange := true;
  filterSpec.Oldprofile := filterSpec.profile;
  EditTrunc.Enabled := true;
  EditPower.Enabled := true;

end;  {BtnSigmoidChange}

{--------------------------------}

procedure TFfreqfiltspec.BtnUpperCosChange(Sender: TObject);
begin
  filterSpec.profile := upperHalfCosine;
  if  filterSpec.profile <> filterSpec.Oldprofile  then
    seasChange := true;
  filterSpec.Oldprofile := filterSpec.profile;
  EditTrunc.Enabled := true;
  EditPower.Enabled := true;
end;  {BtnUpperCosChange}

{--------------------------------}

procedure TFfreqfiltspec.BtnLowerCosChange(Sender: TObject);
begin
  filterSpec.profile := lowerHalfCosine;
    if  filterSpec.profile <> filterSpec.Oldprofile  then
    seasChange := true;
  filterSpec.Oldprofile := filterSpec.profile;
  EditTrunc.Enabled := true;
  EditPower.Enabled := true;

end;  {BtnUpperCosChange}

{______________________________________________________________________________}

procedure TFfreqfiltspec.BtnMonthlyChange(Sender: TObject);
begin
 filterSpec.seasonality := Monthly;
end;

{______________________________________________________________________________}

procedure TFfreqfiltspec.BtnQuarterlyChange(Sender: TObject);
begin
  filterSpec.seasonality := Quarterly;
end;

{______________________________________________________________________________}

procedure TFfreqfiltspec.EditTruncKeyPress(Sender: TObject; var Key: char);
begin
 if not (key in [#0, '0'..'9', '.',#8])then
 begin
   ShowMessage('Enter an real value in [0.25, 1.0]');
   key := #0;
 end;
end;   {EditTruncKeyPress}

{______________________________________________________________________________}

procedure TFfreqfiltspec.EditPowerKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9', #8])  then
 begin
   ShowMessage('Enter an integer value in [0, 6]');
   key := #0;
 end;
end;   {EditPowerKeyPress}

{______________________________________________________________________________}

procedure CheckFrequencyParameters(var EditTrunc, EditPower: TEdit;
                        var filterSpec: filterRecord;
                        var proceed: boolean);
begin
  proceed := true;

{--------------------------------}

  if  not (filterSpec.profile in [6..10]) then
     begin
      ShowMessage('A filter profile must be chosen');
      proceed := false;
    end;

 {--------------------------------}

  if not (FilterSpec.profile = noTransition) then
  begin
 {--------------------------------}
  if EditPower.text = '' then
    begin
      ShowMessage('The power parameter has not been specified');
      proceed := false;
    end
  else
    filterSpec.nPower := StrToInt(EditPower.text);

  if  (filterSpec.nPower < 1)  or (filterSpec.nPower > 6) then
    begin
      ShowMessage('The power parameter must be an integer in the inte;rval [1, 6]');
      proceed := false;
     end;

 {--------------------------------}

   if EditTrunc.text = '' then
     begin
       ShowMessage('The truncation parameter has not been specified');
       proceed := false;
     end
   else
    filterSpec.truncParam := StrToFloat(EditTrunc.text);

  if  (filterSpec.truncParam < 0.25)  or (filterSpec.truncParam > 1.0) then
    begin
      ShowMessage('The truncation parameter must be an number in the interval [0.25, 1.0]');
      proceed := false;
    end;

  {--------------------------------}
  end; {Not noTransition}

  if not (filterSpec.seasonality in [Monthly, Quarterly]) then
    begin
      ShowMessage('Either a monthly or quarterly seasonality must be specified');
      proceed := false;
    end;

end; {CheckFrquencyParameters}

{______________________________________________________________________________}

procedure TFfreqfiltspec.BtnPROCEEDClick(Sender: TObject);

begin
  CheckFrequencyParameters(EditTrunc, EditPower, filterSpec, proceed);
  if proceed and (filterSpec.seasonality  = Monthly) then
    begin
     Fstopbands := TFstopbands.Create(nil);
     Fstopbands.ShowModal;
     FreeAndNil(Fstopbands);
    end
  else if proceed and (filterSpec.seasonality = Quarterly) then
    begin
     Fquadstop := TFquadstop.Create(nil);
     Fquadstop.ShowModal;
     FreeAndNil(Fquadstop);
    end;

  {Hre we should superimpose the peridogram, or should we do it within Udtopbans ans UquadStop?}

end; {BtnPROCEEDClick}

{______________________________________________________________________________}

end. {Ufreqfiltspec: Unit of SEASCAPE.PAS}
