unit Udeletedata;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, GLOBALS, UTILS;

type

  { TFdeletedata }

  TFdeletedata = class(TForm)
    BtnRETURN: TButton;
    EdtPointsStart: TEdit;
    EdtPercentStart: TEdit;
    EdtPercentEnd: TEdit;
    EdtPointsEnd: TEdit;
    EdtPointsNo: TEdit;
    GroupBoxStart: TGroupBox;
    GroupBoxEnd: TGroupBox;
    Label1: TLabel;
    Label8: TLabel;
    ListBox: TListBox;
    RadioBtnPointsStart: TRadioButton;
    RadioBtnPercentStart: TRadioButton;
    RadioBtnPointsEnd: TRadioButton;
    RadioBtnPercentEnd: TRadioButton;
    StaticText1: TStaticText;
    procedure BtnRETURNClick(Sender: TObject);
    procedure EdtPercentEndChange(Sender: TObject);
    procedure EdtPercentStartChange(Sender: TObject);
    procedure EdtPointsEndChange(Sender: TObject);
    procedure EdtPointsEndKeyPress(Sender: TObject; var Key: char);
    procedure EdtPercentStartKeyPress(Sender: TObject; var Key: char);
    procedure EdtPercentEndKeyPress(Sender: TObject; var Key: char);
    procedure EdtPointsStartChange(Sender: TObject);
    procedure EdtPointsStartKeyPress(Sender: TObject; var Key: char);
    procedure FormActivate(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
    procedure RadioBtnPointsEndChange(Sender: TObject);
    procedure RadioBtnPercentStartChange(Sender: TObject);
    procedure RadioBtnPercentEndChange(Sender: TObject);
    procedure RadioBtnPointsStartChange(Sender: TObject);
  private

  public

  end;

var
  Fdeletedata: TFdeletedata;
  pointsFromStart, pointsFromEnd, percentFromStart, percentFromEnd, endPointIndex: integer;
  proceed: boolean;
  {pointsFromStart and   are GLOBAL}

implementation

uses
  UplotScreen;

{$R *.lfm}

{ TFdeletedata }
{______________________________________________________________________________}

procedure TFdeletedata.FormActivate(Sender: TObject);

begin
  EdtPointsNo.Text := IntToStr(dataBOX.NOPUNCT);

  EdtPointsStart.Enabled := true;
  EdtPercentStart.Enabled := false;

  EdtPointsEnd.Enabled := true;
  EdtPercentEnd.Enabled := false;

  EdtPointsStart.Text := '';
  EdtPercentStart.Text := '';

  EdtPercentEnd.Text := '';
  EdtPointsEnd.Text := '';


  pointsFromStart := 0;
  pointsFromEnd  := 0;

  percentFromStart := 0;
  percentFromEnd := 0;

  discardFromStart := false; {GLOBAL}
  discardFromEnd := false;   {GLOBAL}

  proceed := true;

  EdtPercentStart.Font.Style := [fsBold];
  EdtPercentEnd.Font.Style := [fsBold];

end; {FormActivate}
{______________________________________________________________________________}

procedure TFdeletedata.RadioBtnPointsStartChange(Sender: TObject);
begin

  EdtPointsStart.Enabled := true;
  EdtPercentStart.Enabled := false;
  {EdtPercentStart.ReadOnly := true;}
  EdtPointsStart.Text := '';
  EdtPercentStart.Text := '';
  EdtPointsStart.Font.Style := [];
  EdtPercentStart.Font.Style := [fsBold];

end;  {RadioBtnPointsStartChange}
{______________________________________________________________________________}

procedure TFdeletedata.RadioBtnPercentStartChange(Sender: TObject);
begin

 EdtPercentStart.Enabled := true;
 EdtPointsStart.Enabled := false;
 {EdtPointsStart.ReadOnly := true;}
 EdtPointsStart.Text := '';
 EdtPercentStart.Text := '';
 EdtPercentStart.Font.Style := [];
 EdtPointsStart.Font.Style := [fsBold];


end; {RadioBtnPercentStartChange}
{______________________________________________________________________________}

procedure TFdeletedata.RadioBtnPointsEndChange(Sender: TObject);
begin

 EdtPointsEnd.Enabled := true;
 EdtPercentEnd.Enabled := false;
 {EdtPercentEnd.ReadOnly := true;}
 EdtPercentEnd.Text := '';
 EdtPointsEnd.Text := '';
 EdtPointsEnd.Font.Style := [];
 EdtPercentEnd.Font.Style := [fsBold];

end; {RadioBtnPercentEndChange}
{______________________________________________________________________________}

procedure TFdeletedata.RadioBtnPercentEndChange(Sender: TObject);
begin

 EdtPercentEnd.Enabled := true;
 EdtPointsEnd.Enabled := false;
 {EdtPointsEnd.ReadOnly := true;}
 EdtPercentEnd.Text := '';
 EdtPointsEnd.Text := '';
 EdtPercentEnd.Font.Style := [];
 EdtPointsEnd.Font.Style := [fsBold];


end;  {RadioBtnPointsEndChange}
{______________________________________________________________________________}


procedure TFdeletedata.EdtPointsStartKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9',#8])then
  begin
    ShowMessage('Enter an integer number)');
    key := #0;
  end;
  EdtPercentStart.Text := '';
end;  {EdtPointsStartKeyPress}
{______________________________________________________________________________}

procedure TFdeletedata.EdtPercentStartKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9',#8])then
  begin
    ShowMessage('Enter an integer number)');
    key := #0;
  end;
  {EdtPointsStart.Text := '';}
end; {EdtPercentStartKeyPress}
{______________________________________________________________________________}

procedure TFdeletedata.EdtPercentEndKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9',#8])then
  begin
    ShowMessage('Enter an integer number)');
    key := #0;
  end;
  {EdtPercentEnd.Text := ''; }
end; {EdtPointsEndKeyPress}
{______________________________________________________________________________}

procedure TFdeletedata.EdtPointsEndKeyPress(Sender: TObject; var Key: char);
begin
  if not (key in [#0, '0'..'9',#8])then
  begin
    ShowMessage('Enter an integer number)');
    key := #0;
  end;
  {EdtPointsEnd.Text := ''; }
end; {EditPointsEndKeyPress}
{______________________________________________________________________________}

procedure TFdeletedata.EdtPointsStartChange(Sender: TObject);

begin
  if (EdtPointsStart.Text <> '') and EdtPointsStart.Enabled then
    begin
      pointsFromStart := StrToInt(EdtPointsStart.Text);
      percentFromStart :=  Round(pointsFromStart *(100/dataBOX.NOPUNCT));
      EdtPercentStart.Text := IntToStr(percentFromStart);
      {ShowMessage('percent from start = '+ EdtPercentStart.Text);}
      if pointsFromStart > 0 then
        discardFromStart := true;
    end;
end;   {EdtPointsStartChange}
{______________________________________________________________________________}

procedure TFdeletedata.EdtPercentStartChange(Sender: TObject);
begin
  if (EdtPercentStart.Text <> '') and EdtPercentStart.Enabled then
    begin
      percentFromStart := StrToInt(EdtPercentStart.Text);
      pointsFromStart := Round(dataBOX.NOPUNCT*(percentFromStart/100));
      EdtPointsStart.Text := IntToStr(pointsFromStart);
      if pointsFromStart > 0 then
        discardFromStart := true;
    end;
end;  {EdtPercentStartChange}
{______________________________________________________________________________}

procedure TFdeletedata.EdtPointsEndChange(Sender: TObject);
begin
  if  (EdtPointsEnd.Text <> '') and EdtPointsEnd.Enabled then
    begin
      pointsFromEnd := StrToInt(EdtPointsEnd.Text);
      percentFromEnd :=  Round(pointsFromEnd *(100/dataBOX.NOPUNCT));
      EdtPercentEnd.Text := IntToStr(percentFromEnd);
      if pointsFromEnd > 0 then
        discardFromEnd := true;
    end;
end;  {EdtPointsEndChange}
{______________________________________________________________________________}

procedure TFdeletedata.EdtPercentEndChange(Sender: TObject);

begin
  if (EdtPercentEnd.Text <> '') and EdtPercentEnd.Enabled then
    begin
      percentFromEnd := StrToInt(EdtPercentEnd.Text);
      pointsFromEnd := Round(dataBOX.NOPUNCT*(percentFromEnd/100));
      EdtPointsEnd.Text := IntToStr(pointsFromEnd);
      if pointsFromEnd > 0 then
        discardFromEnd := true;
    end;
end;  {EdtPercentEndChange}
{______________________________________________________________________________}

procedure TFdeletedata.BtnRETURNClick(Sender: TObject);
begin
  Close;
end;  {BtnRETURNClick}
{______________________________________________________________________________}

procedure CheckTheDeletions(var pointsFromStart, pointsFromEnd: integer;
                            var proceed: boolean);
begin
  if (pointsFromStart + pointsFromEnd) >= dataBOX.NOPUNCT  then
    begin
      ShowMessage('You are proposing to delete more than the available number of points. Please respecify');
      proceed := false;
    end;

end; {CheckTheDeletions}
{______________________________________________________________________________}

procedure ShortenTheData (var pointsFromStart, pointsFromEnd: integer;
                  var dataBOX: rBOX;
                  var dataVector: longVector);
var
  t, discard: integer;

begin
  discard:= pointsFromStart + pointsFromEnd;
  dataBOX.NOPUNCT := dataBOX.NOPUNCT - discard;
  for t := 0 to dataBOX.NOPUNCT - 1 do
    dataVector[t] := dataVector[t + pointsfromStart];
  MakeDataBox (dataBOX, dataVector);

end;   {ShortenTheData}

{______________________________________________________________________________}


procedure TFdeletedata.ListBoxClick(Sender: TObject);

var
  index, t: integer;
  {F: text;} {TEMP}
begin

  index := ListBox.ItemIndex;

{+++++++++++++++++++++++++++++++++}

  if index = 1 then
    begin   {show the data}
      if discardFromStart then
        TVert:= pointsFromStart;
      if discardFromEnd then
        Tvert2 := dataBOX.NOPUNCT - 1- pointsFromEnd;

      if  discardFromStart or discardFromEnd then
        legend :='The full data set with the segments to be deleted bounded by the dotted lines.'
      else
        legend := 'The current set of available data points.';

      plotBOX := dataBOX;
      plotVector := dataVector;
      graphType := dataGraph;
      Fplotscreen := TFplotscreen.Create(nil);
      Fplotscreen.ShowModal;

      FreeAndNil(Fplotscreen);
      {AssignFile(F, 'TESTFILE.txt');}
      {ReWrite(F);
      Writeln(F, 'PlotBOX.NOPUNCT = ',PLOTBOX.NOPUNCT:4);
      Writeln(F, 'TVert = ',TVert :4);
      Writeln(F, 'TVert2 = ',TVert2 :4);
      Writeln(F, 'SCREENBOX.X1 = ',SCREENBOX.X1 :4);
      Writeln(F, 'SCREENBOX.X2 = ',SCREENBOX.X2 :4);
      Writeln(F, 'SCREENBOX.Y1 = ',SCREENBOX.Y1 :4);
      Writeln(F, 'SCREENBOX.Y2 = ',SCREENBOX.Y2 :4);
      CloseFile(F);}
    end;  {Show The data}

{+++++++++++++++++++++++++++++++++}

  if index = 3 then
    begin  {delete the data}
    CheckTheDeletions(pointsFromStart, pointsFromEnd, proceed);
    if proceed then
      begin
        ShortenTheData (pointsFromStart, pointsFromEnd, dataBOX, dataVector);
        discardFromStart:= false;
        discardFromEnd := false;
        percentFromStart := 0;
        percentFromEnd := 0;
        pointsFromStart := 0;
        pointsFromEnd := 0;
        ResetGlobalFlags;

        EdtPointsStart.Text := '';
        EdtPercentStart.Text := '';
        EdtPercentEnd.Text := '';
        EdtPointsEnd.Text := '';
        EdtPointsNo.Text := IntToStr(dataBOX.NOPUNCT);
      end;  {delete the data}
    end;
{+++++++++++++++++++++++++++++++++}


end; {ListBoxClick}

{______________________________________________________________________________}



end.

