unit Udatatransforms;  {Unit of SEASCAPE.PAS}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TFdatatransforms }

  TFdatatransforms = class(TForm)
    AdviceLabel: TLabel;
    BtnRETURN: TButton;
    TitleLabel: TLabel;
    TransformList: TListBox;
    procedure BtnRETURNClick(Sender: TObject);
    procedure TransformListClick(Sender: TObject);
  private

  public

  end;

var
  Fdatatransforms: TFdatatransforms;
  tempName: string;

implementation
  uses globals, dataseg, LEGENDS;

{$R *.lfm}

{ TFdatatransforms }

{______________________________________________________________________________}

procedure TFdatatransforms.BtnRETURNClick(Sender: TObject);
begin
  Close;
end; {BtnRETURNClick}
{______________________________________________________________________________}

procedure TFdatatransforms.TransformListClick(Sender: TObject);

var index: integer;
  STR1, STR2, legend: string;

begin
  tempName := dataName;
  index := TransformList.ItemIndex;
  {------------------------------}
  if index = 0  then
   begin  {Mean Adjustment}
     if thereIsData = false then
       ShowMessage(' There are no data')
     else if
       meanAdjustedData = true then
       ShowMessage('you have already mean-adjusted the data')
     else
      begin
        MeanAdjustment(dataBOX, dataVector);
        meanAdjustedData := true; {This should occur within the procedure}
        ShowMessage('The data are now mean-adjusted');
      end;
     weHavePolyResiduals := false;
     {weHaveEstimatedATrend := false;}
    end;  {Mean Adjustment}
{------------------------------}
  if index = 2  then
   begin   {Take Difference}
     if thereIsData = false then
       ShowMessage(' There are no data')
     else if (dataBOX.diffOrder = 0) then
        begin
          DiffOfVector(dataBOX, dataVector);
          ShowMessage('You have taken first differences of the data');
          dataName := Concat('the first differences of ', nameStore);
        end
     else if (dataBOX.diffOrder = 1) then
        begin
          STR1 := 'You have already taken first differences of the data,';
          STR2 := ' Do you wish to take second differences?';
          if MessageDlg(STR1 + STR2, mtConfirmation, [mbYes, mbNo], 0) = mrYes then
            begin
              DiffOfVector(dataBOX, dataVector);
              dataName := Concat('the second differences of ', nameStore);
            end;
        end
     else if (dataBOX.diffOrder = 2) then
        ShowMessage('You have already taken second differences of the data');
     weHavePolyResiduals := false;
     {weHaveEstimatedATrend := false;}
   end;   {Take Difference}
  {------------------------------}
  if index = 4  then
   begin {Take Naural Logs}
     if thereIsData = false then
       ShowMessage(' There are no data')
     else if logsTaken then
       ShowMessage('You have already taken logarithms of the data')
     else
       LogOfVector (dataBOX, dataVector);

     if badElements then
       begin
         STR1 := 'The data contains elements with values which are zero or negative.';
         STR2 :=' The operation of taking logarithms of the data has been aborted';
         ShowMessage(STR1 + STR2);
       end
     else
       begin
       ShowMessage('The original data have been replaced by their logrithms');
       dataName := Concat('the logarithms of ', dataName);
       nameStore := dataName;
       end;
     weHavePolyResiduals := false;
     {weHaveEstimatedATrend := false;}
   end;  {Take Naural Logs}
  {------------------------------}
  if index = 6  then
   begin {Take Anti-logs}
     if thereIsData = false then
       ShowMessage(' There are no data')
     else
     begin
      AntiLogOfVector (dataBOX, dataVector);
      ShowMessage('The anti-logarithms of the data have been taken');
      if  logsTaken then
       begin
        legend := DataLegend (dataBOX, dataName);
        logsTaken := false
       end;
     end;
     weHavePolyResiduals := false;
     {weHaveEstimatedATrend := false;}
   end; {Take Anti-logs}
  {------------------------------}

 end;   {TransformListClick}
{______________________________________________________________________________}

end.   {Udatatransforms: Unit of SEASCAPE.PAS}

